/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.record;

import com.ibm.record.IFixedLengthType;
import com.ibm.record.IRecord;
import com.ibm.record.RecordArrayBaseTypeNotValidException;
import com.ibm.record.RecordConversionFailureException;
import com.ibm.record.RecordConversionUnsupportedException;
import com.ibm.record.RowMajorArrayType;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.math.BigDecimal;

public class ColumnMajorArrayType
extends RowMajorArrayType
implements Serializable {
    private static String copyright = "(c) Copyright IBM Corporation 1998, 1999.";
    static final long serialVersionUID = 2581190547907247196L;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;

    protected ColumnMajorArrayType() {
    }

    public ColumnMajorArrayType(int[] dimensions) {
        super(dimensions);
    }

    public ColumnMajorArrayType(int[] dimensions, int packingHint) {
        super(dimensions, packingHint);
    }

    public ColumnMajorArrayType(int[] dimensions, int packingHint, IFixedLengthType baseType) throws RecordArrayBaseTypeNotValidException {
        super(dimensions, packingHint, baseType);
    }

    public ColumnMajorArrayType(int[] dimensions, IFixedLengthType baseType) throws RecordArrayBaseTypeNotValidException {
        super(dimensions, baseType);
    }

    public boolean checkConstantValue(IRecord record, int fieldOffset, Object constantValue) {
        int dim = 0;
        int baseSize = this.baseType_.getSize();
        int[] constValDims = this.calculateArrayDimensions(constantValue);
        Object[] objArray = (Object[])constantValue;
        int arraySize = constValDims[dim];
        if (constValDims.length > this.dimensions_.length) {
            return false;
        }
        int i = 0;
        while (i < constValDims.length) {
            if (constValDims[i] > this.dimensions_[i]) {
                return false;
            }
            ++i;
        }
        i = 0;
        while (i < arraySize) {
            int offset;
            if (dim + 1 < this.dimensions_.length ? !this.checkConstantValue(record, fieldOffset + i * baseSize, objArray[i], dim + 1, baseSize, constValDims) : !this.baseType_.checkConstantValue(record, offset = fieldOffset + i * baseSize, objArray[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean checkConstantValue(IRecord record, int fieldOffset, Object constantValue, int dim, int baseSize, int[] constValDims) {
        int arraySize = constValDims[dim];
        Object[] objArray = (Object[])constantValue;
        int totalSize = 1;
        int i = 0;
        while (i < dim) {
            totalSize *= this.dimensions_[i];
            ++i;
        }
        i = 0;
        while (i < arraySize) {
            if (dim + 1 < this.dimensions_.length ? !this.checkConstantValue(record, fieldOffset + i * totalSize * baseSize, objArray[i], dim + 1, baseSize, constValDims) : !this.baseType_.checkConstantValue(record, fieldOffset += i * totalSize * baseSize, objArray[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public Object clone() {
        ColumnMajorArrayType newType = (ColumnMajorArrayType)super.clone();
        return newType;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ColumnMajorArrayType)) {
            return false;
        }
        return super.equals(obj);
    }

    private Object getArray(IRecord record, int fieldOffset, int dim, int baseSize, Class componentType, int componentFlag) throws RecordConversionUnsupportedException, RecordConversionFailureException {
        int[] dimParm = new int[this.dimensions_.length - dim];
        int k = dim;
        while (k < this.dimensions_.length) {
            dimParm[k - dim] = this.dimensions_[dim];
            ++k;
        }
        Object objArray = Array.newInstance(componentType, dimParm);
        int arraySize = this.dimensions_[dim];
        int totalSize = 1;
        int i = 0;
        while (i < dim) {
            totalSize *= this.dimensions_[i];
            ++i;
        }
        i = 0;
        while (i < arraySize) {
            if (dim + 1 < this.dimensions_.length) {
                Array.set(objArray, i, this.getArray(record, fieldOffset + i * totalSize * baseSize, dim + 1, baseSize, componentType, componentFlag));
            } else {
                int offset = fieldOffset + i * totalSize * baseSize;
                switch (componentFlag) {
                    case 0: {
                        Array.set(objArray, i, this.baseType_.getObject(record, offset));
                        break;
                    }
                    case 1: {
                        Array.setBoolean(objArray, i, this.baseType_.getBoolean(record, offset));
                        break;
                    }
                    case 2: {
                        Array.setByte(objArray, i, this.baseType_.getByte(record, offset));
                        break;
                    }
                    case 3: {
                        Array.setChar(objArray, i, this.baseType_.getChar(record, offset));
                        break;
                    }
                    case 4: {
                        Array.setDouble(objArray, i, this.baseType_.getDouble(record, offset));
                        break;
                    }
                    case 5: {
                        Array.setFloat(objArray, i, this.baseType_.getFloat(record, offset));
                        break;
                    }
                    case 6: {
                        Array.setInt(objArray, i, this.baseType_.getInt(record, offset));
                        break;
                    }
                    case 7: {
                        Array.setLong(objArray, i, this.baseType_.getLong(record, offset));
                        break;
                    }
                    case 8: {
                        Array.setShort(objArray, i, this.baseType_.getShort(record, offset));
                        break;
                    }
                    case 9: {
                        Array.set(objArray, i, this.baseType_.getString(record, offset));
                        break;
                    }
                    case 10: {
                        Array.set(objArray, i, this.baseType_.getBigDecimal(record, offset));
                    }
                }
            }
            ++i;
        }
        return objArray;
    }

    public Object getArray(IRecord record, int fieldOffset, Class componentType) throws RecordConversionUnsupportedException, RecordConversionFailureException {
        int dim = 0;
        int baseSize = this.baseType_.getSize();
        Object objArray = Array.newInstance(componentType, this.dimensions_);
        int arrayType = 0;
        if (componentType == Boolean.TYPE) {
            arrayType = 1;
        } else if (componentType == Byte.TYPE) {
            arrayType = 2;
        } else if (componentType == Character.TYPE) {
            arrayType = 3;
        } else if (componentType == Double.TYPE) {
            arrayType = 4;
        } else if (componentType == Float.TYPE) {
            arrayType = 5;
        } else if (componentType == Integer.TYPE) {
            arrayType = 6;
        } else if (componentType == Long.TYPE) {
            arrayType = 7;
        } else if (componentType == Short.TYPE) {
            arrayType = 8;
        } else {
            Class<?> clazz = class$8;
            if (clazz == null) {
                try {
                    clazz = class$8 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (componentType == clazz) {
                arrayType = 9;
            } else {
                Class<?> clazz2 = class$9;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$9 = Class.forName("java.math.BigDecimal");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                arrayType = componentType == clazz2 ? 10 : 0;
            }
        }
        int i = 0;
        while (i < this.dimensions_[dim]) {
            if (dim + 1 < this.dimensions_.length) {
                Array.set(objArray, i, this.getArray(record, fieldOffset + i * baseSize, dim + 1, baseSize, componentType, arrayType));
            } else {
                int offset = fieldOffset + i * baseSize;
                switch (arrayType) {
                    case 0: {
                        Array.set(objArray, i, this.baseType_.getObject(record, offset));
                        break;
                    }
                    case 1: {
                        Array.setBoolean(objArray, i, this.baseType_.getBoolean(record, offset));
                        break;
                    }
                    case 2: {
                        Array.setByte(objArray, i, this.baseType_.getByte(record, offset));
                        break;
                    }
                    case 3: {
                        Array.setChar(objArray, i, this.baseType_.getChar(record, offset));
                        break;
                    }
                    case 4: {
                        Array.setDouble(objArray, i, this.baseType_.getDouble(record, offset));
                        break;
                    }
                    case 5: {
                        Array.setFloat(objArray, i, this.baseType_.getFloat(record, offset));
                        break;
                    }
                    case 6: {
                        Array.setInt(objArray, i, this.baseType_.getInt(record, offset));
                        break;
                    }
                    case 7: {
                        Array.setLong(objArray, i, this.baseType_.getLong(record, offset));
                        break;
                    }
                    case 8: {
                        Array.setShort(objArray, i, this.baseType_.getShort(record, offset));
                        break;
                    }
                    case 9: {
                        Array.set(objArray, i, this.baseType_.getString(record, offset));
                        break;
                    }
                    case 10: {
                        Array.set(objArray, i, this.baseType_.getBigDecimal(record, offset));
                    }
                }
            }
            ++i;
        }
        return objArray;
    }

    public int getElementOffset(int[] index) throws ArrayIndexOutOfBoundsException {
        return ColumnMajorArrayType.getElementOffset(index, this.getDimensions(), this.getElementSize());
    }

    public static int getElementOffset(int[] index, int[] arrayDimensions, int elementSize) throws ArrayIndexOutOfBoundsException {
        if (arrayDimensions.length != index.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int offset = 0;
        int i = 0;
        while (i < arrayDimensions.length) {
            if (index[i] < 0 || index[i] >= arrayDimensions[i]) {
                throw new ArrayIndexOutOfBoundsException(index[i]);
            }
            int allocationValue = 1;
            int j = 0;
            while (j < i) {
                allocationValue *= arrayDimensions[j];
                ++j;
            }
            offset += index[i] * allocationValue;
            ++i;
        }
        return offset * elementSize;
    }

    public Object getObject(IRecord record, int fieldOffset) throws RecordConversionUnsupportedException, RecordConversionFailureException {
        int dim = 0;
        Class<?> clazz = class$10;
        if (clazz == null) {
            try {
                clazz = class$10 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Object objArray = Array.newInstance(clazz, this.dimensions_);
        int baseSize = this.baseType_.getSize();
        int i = 0;
        while (i < this.dimensions_[dim]) {
            if (dim + 1 < this.dimensions_.length) {
                Array.set(objArray, i, this.getObject(record, fieldOffset + i * baseSize, dim + 1, baseSize));
            } else {
                int offset = fieldOffset + i * baseSize;
                Array.set(objArray, i, this.baseType_.getObject(record, offset));
            }
            ++i;
        }
        return objArray;
    }

    private Object getObject(IRecord record, int fieldOffset, int dim, int baseSize) throws RecordConversionUnsupportedException, RecordConversionFailureException {
        int[] dimParm = new int[this.dimensions_.length - dim];
        int k = dim;
        while (k < this.dimensions_.length) {
            dimParm[k - dim] = this.dimensions_[dim];
            ++k;
        }
        Class<?> clazz = class$10;
        if (clazz == null) {
            try {
                clazz = class$10 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Object[] objArray = (Object[])Array.newInstance(clazz, dimParm);
        int arraySize = this.dimensions_[dim];
        int totalSize = 1;
        int i = 0;
        while (i < dim) {
            totalSize *= this.dimensions_[i];
            ++i;
        }
        i = 0;
        while (i < arraySize) {
            objArray[i] = dim + 1 < this.dimensions_.length ? this.getObject(record, fieldOffset + i * totalSize * baseSize, dim + 1, baseSize) : this.baseType_.getObject(record, fieldOffset += i * totalSize * baseSize);
            ++i;
        }
        return objArray;
    }

    private void setArray(IRecord record, int fieldOffset, Object value, int dim, int baseSize, int arrayType) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        int arraySize = this.dimensions_[dim];
        if (arraySize != Array.getLength(value)) {
            throw new RecordConversionUnsupportedException();
        }
        int totalSize = 1;
        int i = 0;
        while (i < dim) {
            totalSize *= this.dimensions_[i];
            ++i;
        }
        i = 0;
        while (i < arraySize) {
            if (dim + 1 < this.dimensions_.length) {
                this.setArray(record, fieldOffset + i * totalSize * baseSize, Array.get(value, i), dim + 1, baseSize, arrayType);
            } else {
                int offset = fieldOffset + i * totalSize * baseSize;
                switch (arrayType) {
                    case 0: {
                        this.baseType_.setObject(record, offset, Array.get(value, i));
                        break;
                    }
                    case 1: {
                        this.baseType_.setBoolean(record, offset, Array.getBoolean(value, i));
                        break;
                    }
                    case 2: {
                        this.baseType_.setByte(record, offset, Array.getByte(value, i));
                        break;
                    }
                    case 3: {
                        this.baseType_.setChar(record, offset, Array.getChar(value, i));
                        break;
                    }
                    case 4: {
                        this.baseType_.setDouble(record, offset, Array.getDouble(value, i));
                        break;
                    }
                    case 5: {
                        this.baseType_.setFloat(record, offset, Array.getFloat(value, i));
                        break;
                    }
                    case 6: {
                        this.baseType_.setInt(record, offset, Array.getInt(value, i));
                        break;
                    }
                    case 7: {
                        this.baseType_.setLong(record, offset, Array.getLong(value, i));
                        break;
                    }
                    case 8: {
                        this.baseType_.setShort(record, offset, Array.getShort(value, i));
                        break;
                    }
                    case 9: {
                        this.baseType_.setString(record, offset, (String)Array.get(value, i));
                        break;
                    }
                    case 10: {
                        this.baseType_.setBigDecimal(record, offset, (BigDecimal)Array.get(value, i));
                    }
                }
            }
            ++i;
        }
    }

    public void setArray(IRecord record, int fieldOffset, Object value, Class componentType) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        if (!value.getClass().isArray()) {
            throw new RecordConversionUnsupportedException();
        }
        int dim = 0;
        int baseSize = this.baseType_.getSize();
        int arraySize = this.dimensions_[dim];
        if (arraySize != Array.getLength(value)) {
            throw new RecordConversionUnsupportedException();
        }
        int arrayType = 0;
        if (componentType == Boolean.TYPE) {
            arrayType = 1;
        } else if (componentType == Byte.TYPE) {
            arrayType = 2;
        } else if (componentType == Character.TYPE) {
            arrayType = 3;
        } else if (componentType == Double.TYPE) {
            arrayType = 4;
        } else if (componentType == Float.TYPE) {
            arrayType = 5;
        } else if (componentType == Integer.TYPE) {
            arrayType = 6;
        } else if (componentType == Long.TYPE) {
            arrayType = 7;
        } else if (componentType == Short.TYPE) {
            arrayType = 8;
        } else {
            Class<?> clazz = class$8;
            if (clazz == null) {
                try {
                    clazz = class$8 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (componentType == clazz) {
                arrayType = 9;
            } else {
                Class<?> clazz2 = class$9;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$9 = Class.forName("java.math.BigDecimal");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                arrayType = componentType == clazz2 ? 10 : 0;
            }
        }
        int i = 0;
        while (i < arraySize) {
            if (dim + 1 < this.dimensions_.length) {
                this.setArray(record, fieldOffset + i * baseSize, Array.get(value, i), dim + 1, baseSize, arrayType);
            } else {
                int offset = fieldOffset + i * baseSize;
                switch (arrayType) {
                    case 0: {
                        this.baseType_.setObject(record, offset, Array.get(value, i));
                        break;
                    }
                    case 1: {
                        this.baseType_.setBoolean(record, offset, Array.getBoolean(value, i));
                        break;
                    }
                    case 2: {
                        this.baseType_.setByte(record, offset, Array.getByte(value, i));
                        break;
                    }
                    case 3: {
                        this.baseType_.setChar(record, offset, Array.getChar(value, i));
                        break;
                    }
                    case 4: {
                        this.baseType_.setDouble(record, offset, Array.getDouble(value, i));
                        break;
                    }
                    case 5: {
                        this.baseType_.setFloat(record, offset, Array.getFloat(value, i));
                        break;
                    }
                    case 6: {
                        this.baseType_.setInt(record, offset, Array.getInt(value, i));
                        break;
                    }
                    case 7: {
                        this.baseType_.setLong(record, offset, Array.getLong(value, i));
                        break;
                    }
                    case 8: {
                        this.baseType_.setShort(record, offset, Array.getShort(value, i));
                        break;
                    }
                    case 9: {
                        this.baseType_.setString(record, offset, (String)Array.get(value, i));
                        break;
                    }
                    case 10: {
                        this.baseType_.setBigDecimal(record, offset, (BigDecimal)Array.get(value, i));
                    }
                }
            }
            ++i;
        }
    }

    public void setInitialValue(IRecord record, int fieldOffset, Object initialValue) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        if (!initialValue.getClass().isArray()) {
            throw new RecordConversionUnsupportedException();
        }
        int dim = 0;
        int baseSize = this.baseType_.getSize();
        int[] initValDims = this.calculateArrayDimensions(initialValue);
        Object[] objArray = (Object[])initialValue;
        int arraySize = initValDims[dim];
        if (initValDims.length > this.dimensions_.length) {
            throw new RecordConversionUnsupportedException();
        }
        int i = 0;
        while (i < initValDims.length) {
            if (initValDims[i] > this.dimensions_[i]) {
                throw new RecordConversionUnsupportedException();
            }
            ++i;
        }
        i = 0;
        while (i < arraySize) {
            if (dim + 1 < this.dimensions_.length) {
                this.setInitialValue(record, fieldOffset + i * baseSize, objArray[i], dim + 1, baseSize, initValDims);
            } else {
                int offset = fieldOffset + i * baseSize;
                this.baseType_.setInitialValue(record, offset, objArray[i]);
            }
            ++i;
        }
    }

    private void setInitialValue(IRecord record, int fieldOffset, Object initialValue, int dim, int baseSize, int[] initValDims) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        int arraySize = initValDims[dim];
        Object[] objArray = (Object[])initialValue;
        int totalSize = 1;
        int i = 0;
        while (i < dim) {
            totalSize *= this.dimensions_[i];
            ++i;
        }
        i = 0;
        while (i < arraySize) {
            if (dim + 1 < this.dimensions_.length) {
                this.setInitialValue(record, fieldOffset + i * totalSize * baseSize, objArray[i], dim + 1, baseSize, initValDims);
            } else {
                this.baseType_.setInitialValue(record, fieldOffset += i * totalSize * baseSize, objArray[i]);
            }
            ++i;
        }
    }

    public void setObject(IRecord record, int fieldOffset, Object value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        if (!value.getClass().isArray()) {
            throw new RecordConversionUnsupportedException();
        }
        int dim = 0;
        int baseSize = this.baseType_.getSize();
        int arraySize = this.dimensions_[dim];
        Object[] objArray = (Object[])value;
        if (arraySize != objArray.length) {
            throw new RecordConversionUnsupportedException();
        }
        int i = 0;
        while (i < arraySize) {
            if (dim + 1 < this.dimensions_.length) {
                this.setObject(record, fieldOffset + i * baseSize, objArray[i], dim + 1, baseSize);
            } else {
                int offset = fieldOffset + i * baseSize;
                this.baseType_.setObject(record, offset, objArray[i]);
            }
            ++i;
        }
    }

    private void setObject(IRecord record, int fieldOffset, Object value, int dim, int baseSize) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        int arraySize = this.dimensions_[dim];
        Object[] objArray = (Object[])value;
        if (arraySize != objArray.length) {
            throw new RecordConversionUnsupportedException();
        }
        int totalSize = 1;
        int i = 0;
        while (i < dim) {
            totalSize *= this.dimensions_[i];
            ++i;
        }
        i = 0;
        while (i < arraySize) {
            if (dim + 1 < this.dimensions_.length) {
                this.setObject(record, fieldOffset + i * totalSize * baseSize, objArray[i], dim + 1, baseSize);
            } else {
                this.baseType_.setObject(record, fieldOffset += i * totalSize * baseSize, objArray[i]);
            }
            ++i;
        }
    }
}

