/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.record;

import com.ibm.record.IRangeObject;

public class ByteRange
implements IRangeObject {
    private static String copyright = "(c) Copyright IBM Corporation 1999.";
    static final long serialVersionUID = -1979628129376064778L;
    protected byte lowerRange_;
    protected byte upperRange_;

    public ByteRange() {
        this.lowerRange_ = 0;
        this.upperRange_ = 0;
    }

    public ByteRange(byte lowerRange, byte upperRange) throws IllegalArgumentException {
        if (upperRange < lowerRange) {
            throw new IllegalArgumentException(Byte.toString(upperRange));
        }
        this.lowerRange_ = lowerRange;
        this.upperRange_ = upperRange;
    }

    public Object clone() {
        try {
            ByteRange newType = (ByteRange)super.clone();
            return newType;
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError(ex.getMessage());
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ByteRange)) {
            return false;
        }
        ByteRange tmpRange = (ByteRange)obj;
        if (this.lowerRange_ != tmpRange.lowerRange_) {
            return false;
        }
        return this.upperRange_ == tmpRange.upperRange_;
    }

    public Object getLowerRange() {
        return new Byte(this.lowerRange_);
    }

    public Object getUpperRange() {
        return new Byte(this.upperRange_);
    }

    public static boolean isInRange(byte lowerRange, byte upperRange, byte value) throws IllegalArgumentException {
        if (upperRange < lowerRange) {
            throw new IllegalArgumentException(Byte.toString(upperRange));
        }
        return value >= lowerRange && value <= upperRange;
    }

    public boolean isInRange(Object value) {
        if (!(value instanceof Byte)) {
            return false;
        }
        byte byteVal = (Byte)value;
        return ByteRange.isInRange(this.lowerRange_, this.upperRange_, byteVal);
    }

    public void setLowerRange(Object value) throws IllegalArgumentException {
        if (!(value instanceof Byte)) {
            throw new IllegalArgumentException(value.toString());
        }
        this.lowerRange_ = (Byte)value;
    }

    public void setUpperRange(Object value) throws IllegalArgumentException {
        if (!(value instanceof Byte)) {
            throw new IllegalArgumentException(value.toString());
        }
        this.upperRange_ = (Byte)value;
    }
}

