/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.record;

import com.ibm.record.IBidiAttributesObject;
import com.ibm.record.util.bidi.BidiFlag;
import com.ibm.record.util.bidi.BidiFlagSet;
import java.io.Serializable;

public class BidiAttributesObject
implements IBidiAttributesObject,
Serializable {
    private static String copyright = "(c) Copyright IBM Corporation 2000.";
    static final long serialVersionUID = -4950385801922539923L;
    private int TypeOfText;
    private int Orientation;
    private int SymmetricSwapping;
    private int NumeralShapes;
    private int TextShapes;
    private BidiFlagSet associatedBidiFlagSet = new BidiFlagSet();

    public BidiAttributesObject() {
        this.setTypeOfText(0);
        this.setOrientation(0);
        this.setSymmetricSwapping(0);
        this.setNumeralShapes(0);
        this.setTextShapes(0);
    }

    public BidiAttributesObject(int type, int orientation, int swap, int numerals, int text) {
        this();
        this.setTypeOfText(type);
        this.setOrientation(orientation);
        this.setSymmetricSwapping(swap);
        this.setNumeralShapes(numerals);
        this.setTextShapes(text);
    }

    public Object clone() {
        try {
            BidiAttributesObject newBidiObject = (BidiAttributesObject)super.clone();
            if (this.associatedBidiFlagSet != null) {
                newBidiObject.associatedBidiFlagSet = (BidiFlagSet)this.associatedBidiFlagSet.clone();
            }
            return newBidiObject;
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError(ex.getMessage());
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BidiAttributesObject)) {
            return false;
        }
        BidiAttributesObject tmpType = (BidiAttributesObject)obj;
        if (this.TypeOfText != tmpType.TypeOfText) {
            return false;
        }
        if (this.Orientation != tmpType.Orientation) {
            return false;
        }
        if (this.SymmetricSwapping != tmpType.SymmetricSwapping) {
            return false;
        }
        if (this.NumeralShapes != tmpType.NumeralShapes) {
            return false;
        }
        return this.TextShapes == tmpType.TextShapes;
    }

    public BidiFlagSet getBidiFlagSet() {
        return this.associatedBidiFlagSet;
    }

    public int getNumeralShapes() {
        return this.NumeralShapes;
    }

    private BidiFlag getNumeralShapesFlag() {
        switch (this.getNumeralShapes()) {
            case 0: {
                return BidiFlag.NUMERALS_NOMINAL;
            }
            case 1: {
                return BidiFlag.NUMERALS_NATIONAL;
            }
            case 2: {
                return BidiFlag.NUMERALS_CONTEXTUAL;
            }
        }
        return null;
    }

    public int getOrientation() {
        return this.Orientation;
    }

    private BidiFlag getOrientationFlag() {
        switch (this.getOrientation()) {
            case 0: {
                return BidiFlag.ORIENTATION_LTR;
            }
            case 1: {
                return BidiFlag.ORIENTATION_RTL;
            }
            case 2: {
                return BidiFlag.ORIENTATION_CONTEXT_LTR;
            }
            case 3: {
                return BidiFlag.ORIENTATION_CONTEXT_RTL;
            }
        }
        return null;
    }

    public int getSymmetricSwapping() {
        return this.SymmetricSwapping;
    }

    private BidiFlag getSymmetricSwappingFlag() {
        switch (this.getSymmetricSwapping()) {
            case 0: {
                return BidiFlag.SWAP_YES;
            }
            case 1: {
                return BidiFlag.SWAP_NO;
            }
        }
        return null;
    }

    public int getTextShapes() {
        return this.TextShapes;
    }

    private BidiFlag getTextShapesFlag() {
        switch (this.getTextShapes()) {
            case 0: {
                return BidiFlag.TEXT_NOMINAL;
            }
            case 1: {
                return BidiFlag.TEXT_SHAPED;
            }
            case 2: {
                return BidiFlag.TEXT_INITIAL;
            }
            case 3: {
                return BidiFlag.TEXT_MIDDLE;
            }
            case 4: {
                return BidiFlag.TEXT_FINAL;
            }
            case 5: {
                return BidiFlag.TEXT_ISOLATED;
            }
        }
        return null;
    }

    public int getTypeOfText() {
        return this.TypeOfText;
    }

    private BidiFlag getTypeOfTextFlag() {
        switch (this.getTypeOfText()) {
            case 0: {
                return BidiFlag.TYPE_IMPLICIT;
            }
            case 1: {
                return BidiFlag.TYPE_VISUAL;
            }
        }
        return null;
    }

    public void setNumeralShapes(int numeral_shape) {
        int oldsetting = this.NumeralShapes;
        this.NumeralShapes = numeral_shape;
        BidiFlag f = this.getNumeralShapesFlag();
        if (f == null) {
            this.setNumeralShapes(oldsetting);
        } else {
            this.getBidiFlagSet().setOneFlag(f);
        }
    }

    public void setOrientation(int orient) {
        int oldsetting = this.Orientation;
        this.Orientation = orient;
        BidiFlag f = this.getOrientationFlag();
        if (f == null) {
            this.setOrientation(oldsetting);
        } else {
            this.getBidiFlagSet().setOneFlag(f);
        }
    }

    public void setSymmetricSwapping(int swap) {
        int oldsetting = this.SymmetricSwapping;
        this.SymmetricSwapping = swap;
        BidiFlag f = this.getSymmetricSwappingFlag();
        if (f == null) {
            this.setSymmetricSwapping(oldsetting);
        } else {
            this.getBidiFlagSet().setOneFlag(f);
        }
    }

    public void setTextShapes(int text_shape) {
        int oldsetting = this.TextShapes;
        this.TextShapes = text_shape;
        BidiFlag f = this.getTextShapesFlag();
        if (f == null) {
            this.setTextShapes(oldsetting);
        } else {
            this.getBidiFlagSet().setOneFlag(f);
        }
    }

    public void setTypeOfText(int type) {
        int oldsetting = this.TypeOfText;
        this.TypeOfText = type;
        BidiFlag f = this.getTypeOfTextFlag();
        if (f == null) {
            this.setTypeOfText(oldsetting);
        } else {
            this.getBidiFlagSet().setOneFlag(f);
        }
    }

    public String toString() {
        return this.getBidiFlagSet().toString();
    }
}

