/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.record;

import com.ibm.record.AnyField;
import com.ibm.record.IAnyDynamicRecordType;
import com.ibm.record.IAnyField;
import com.ibm.record.IAnyType;
import com.ibm.record.IArrayField;
import com.ibm.record.IArrayType;
import com.ibm.record.IFieldEnumeration;
import com.ibm.record.IFixedLengthType;
import com.ibm.record.INestedRecordField;
import com.ibm.record.IOverlayField;
import com.ibm.record.IRecord;
import com.ibm.record.IVariableSizeArrayDimensionField;
import com.ibm.record.RecordConversionFailureException;
import com.ibm.record.RecordConversionUnsupportedException;
import com.ibm.record.RecordFieldTypeNotValidException;
import com.ibm.record.TypeData;
import java.io.Serializable;
import java.math.BigDecimal;

public class ArrayField
extends AnyField
implements IArrayField,
Serializable {
    private static String copyright = "(c) Copyright IBM Corporation 1998, 1999.";
    static final long serialVersionUID = 4816946408372132578L;
    protected IAnyType fieldType_;

    private ArrayField() {
        this.fieldType_ = null;
        this.setFieldKind(0);
    }

    public ArrayField(IArrayType type) {
        this.fieldType_ = type;
        this.setFieldKind(0);
    }

    public ArrayField(IArrayType type, String name) {
        super(name);
        this.fieldType_ = type;
        this.setFieldKind(0);
    }

    public ArrayField(IArrayType type, String name, Object initialValue) {
        super(name, initialValue);
        this.fieldType_ = type;
        this.setFieldKind(0);
        this.setInitialValue(initialValue);
    }

    public ArrayField(IArrayType type, String name, Object initialValue, boolean readOnly) {
        super(name, initialValue, readOnly);
        this.fieldType_ = type;
        this.setFieldKind(0);
        this.setInitialValue(initialValue);
    }

    public ArrayField(IArrayType type, String name, boolean readOnly) {
        super(name, readOnly);
        this.fieldType_ = type;
        this.setFieldKind(0);
    }

    public ArrayField(IArrayType type, boolean readOnly) {
        super(readOnly);
        this.fieldType_ = type;
        this.setFieldKind(0);
    }

    public Object clone() {
        ArrayField newType = (ArrayField)super.clone();
        if (this.fieldType_ != null) {
            newType.fieldType_ = (IAnyType)this.fieldType_.clone();
        }
        return newType;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ArrayField)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ArrayField tmpField = (ArrayField)obj;
        if (this.fieldType_ == null ^ tmpField.fieldType_ == null) {
            return false;
        }
        if (this.fieldType_ == null) {
            return true;
        }
        return this.fieldType_.equals(tmpField.fieldType_);
    }

    public Object getArray(IRecord record, int parentOffset, Class componentType) throws RecordConversionUnsupportedException, RecordConversionFailureException {
        int offset = record.getStartingOffset() + parentOffset + this.relativeOffset_;
        return ((IArrayType)this.fieldType_).getArray(record, offset, componentType);
    }

    public BigDecimal getBigDecimal(IRecord record, int parentOffset, int[] index) throws RecordConversionFailureException, RecordConversionUnsupportedException, ArrayIndexOutOfBoundsException {
        int offset = record.getStartingOffset() + parentOffset + this.relativeOffset_;
        return ((IArrayType)this.fieldType_).getBigDecimal(record, offset, index);
    }

    public BigDecimal getBigDecimal(IRecord record, int parentOffset, int index) throws RecordConversionFailureException, RecordConversionUnsupportedException, ArrayIndexOutOfBoundsException {
        int offset = record.getStartingOffset() + parentOffset + this.relativeOffset_;
        return ((IArrayType)this.fieldType_).getBigDecimal(record, offset, index);
    }

    public boolean getBoolean(IRecord record, int parentOffset, int[] index) throws RecordConversionFailureException, RecordConversionUnsupportedException, ArrayIndexOutOfBoundsException {
        int offset = record.getStartingOffset() + parentOffset + this.relativeOffset_;
        return ((IArrayType)this.fieldType_).getBoolean(record, offset, index);
    }

    public boolean getBoolean(IRecord record, int parentOffset, int index) throws RecordConversionFailureException, RecordConversionUnsupportedException, ArrayIndexOutOfBoundsException {
        int offset = record.getStartingOffset() + parentOffset + this.relativeOffset_;
        return ((IArrayType)this.fieldType_).getBoolean(record, offset, index);
    }

    public byte getByte(IRecord record, int parentOffset, int[] index) throws RecordConversionFailureException, RecordConversionUnsupportedException, ArrayIndexOutOfBoundsException {
        int offset = record.getStartingOffset() + parentOffset + this.relativeOffset_;
        return ((IArrayType)this.fieldType_).getByte(record, offset, index);
    }

    public byte getByte(IRecord record, int parentOffset, int index) throws RecordConversionFailureException, RecordConversionUnsupportedException, ArrayIndexOutOfBoundsException {
        int offset = record.getStartingOffset() + parentOffset + this.relativeOffset_;
        return ((IArrayType)this.fieldType_).getByte(record, offset, index);
    }

    public char getChar(IRecord record, int parentOffset, int[] index) throws RecordConversionFailureException, RecordConversionUnsupportedException, ArrayIndexOutOfBoundsException {
        int offset = record.getStartingOffset() + parentOffset + this.relativeOffset_;
        return ((IArrayType)this.fieldType_).getChar(record, offset, index);
    }

    public char getChar(IRecord record, int parentOffset, int index) throws RecordConversionFailureException, RecordConversionUnsupportedException, ArrayIndexOutOfBoundsException {
        int offset = record.getStartingOffset() + parentOffset + this.relativeOffset_;
        return ((IArrayType)this.fieldType_).getChar(record, offset, index);
    }

    public double getDouble(IRecord record, int parentOffset, int[] index) throws RecordConversionFailureException, RecordConversionUnsupportedException, ArrayIndexOutOfBoundsException {
        int offset = record.getStartingOffset() + parentOffset + this.relativeOffset_;
        return ((IArrayType)this.fieldType_).getDouble(record, offset, index);
    }

    public double getDouble(IRecord record, int parentOffset, int index) throws RecordConversionFailureException, RecordConversionUnsupportedException, ArrayIndexOutOfBoundsException {
        int offset = record.getStartingOffset() + parentOffset + this.relativeOffset_;
        return ((IArrayType)this.fieldType_).getDouble(record, offset, index);
    }

    public float getFloat(IRecord record, int parentOffset, int[] index) throws RecordConversionFailureException, RecordConversionUnsupportedException, ArrayIndexOutOfBoundsException {
        int offset = record.getStartingOffset() + parentOffset + this.relativeOffset_;
        return ((IArrayType)this.fieldType_).getFloat(record, offset, index);
    }

    public float getFloat(IRecord record, int parentOffset, int index) throws RecordConversionFailureException, RecordConversionUnsupportedException, ArrayIndexOutOfBoundsException {
        int offset = record.getStartingOffset() + parentOffset + this.relativeOffset_;
        return ((IArrayType)this.fieldType_).getFloat(record, offset, index);
    }

    public int getInt(IRecord record, int parentOffset, int[] index) throws RecordConversionFailureException, RecordConversionUnsupportedException, ArrayIndexOutOfBoundsException {
        int offset = record.getStartingOffset() + parentOffset + this.relativeOffset_;
        return ((IArrayType)this.fieldType_).getInt(record, offset, index);
    }

    public int getInt(IRecord record, int parentOffset, int index) throws RecordConversionFailureException, RecordConversionUnsupportedException, ArrayIndexOutOfBoundsException {
        int offset = record.getStartingOffset() + parentOffset + this.relativeOffset_;
        return ((IArrayType)this.fieldType_).getInt(record, offset, index);
    }

    public long getLong(IRecord record, int parentOffset, int[] index) throws RecordConversionFailureException, RecordConversionUnsupportedException, ArrayIndexOutOfBoundsException {
        int offset = record.getStartingOffset() + parentOffset + this.relativeOffset_;
        return ((IArrayType)this.fieldType_).getLong(record, offset, index);
    }

    public long getLong(IRecord record, int parentOffset, int index) throws RecordConversionFailureException, RecordConversionUnsupportedException, ArrayIndexOutOfBoundsException {
        int offset = record.getStartingOffset() + parentOffset + this.relativeOffset_;
        return ((IArrayType)this.fieldType_).getLong(record, offset, index);
    }

    public Object getObject(IRecord record, int parentOffset) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        int offset = record.getStartingOffset() + parentOffset + this.relativeOffset_;
        return ((IArrayType)this.fieldType_).getObject(record, offset);
    }

    public Object getObject(IRecord record, int parentOffset, int[] index) throws RecordConversionFailureException, RecordConversionUnsupportedException, ArrayIndexOutOfBoundsException {
        int offset = record.getStartingOffset() + parentOffset + this.relativeOffset_;
        return ((IArrayType)this.fieldType_).getObject(record, offset, index);
    }

    public Object getObject(IRecord record, int parentOffset, int index) throws RecordConversionFailureException, RecordConversionUnsupportedException, ArrayIndexOutOfBoundsException {
        int offset = record.getStartingOffset() + parentOffset + this.relativeOffset_;
        return ((IArrayType)this.fieldType_).getObject(record, offset, index);
    }

    public short getShort(IRecord record, int parentOffset, int[] index) throws RecordConversionFailureException, RecordConversionUnsupportedException, ArrayIndexOutOfBoundsException {
        int offset = record.getStartingOffset() + parentOffset + this.relativeOffset_;
        return ((IArrayType)this.fieldType_).getShort(record, offset, index);
    }

    public short getShort(IRecord record, int parentOffset, int index) throws RecordConversionFailureException, RecordConversionUnsupportedException, ArrayIndexOutOfBoundsException {
        int offset = record.getStartingOffset() + parentOffset + this.relativeOffset_;
        return ((IArrayType)this.fieldType_).getShort(record, offset, index);
    }

    public int getSize() {
        return this.fieldType_.getSize();
    }

    public String getString(IRecord record, int parentOffset, int[] index) throws RecordConversionFailureException, RecordConversionUnsupportedException, ArrayIndexOutOfBoundsException {
        int offset = record.getStartingOffset() + parentOffset + this.relativeOffset_;
        return ((IArrayType)this.fieldType_).getString(record, offset, index);
    }

    public String getString(IRecord record, int parentOffset, int index) throws RecordConversionFailureException, RecordConversionUnsupportedException, ArrayIndexOutOfBoundsException {
        int offset = record.getStartingOffset() + parentOffset + this.relativeOffset_;
        return ((IArrayType)this.fieldType_).getString(record, offset, index);
    }

    public IAnyType getType() {
        return this.fieldType_;
    }

    private void initVarSizeArrayFields(IRecord record, int parentOffset, IAnyDynamicRecordType recType) {
        IFieldEnumeration cursor = recType.fields();
        while (cursor.hasMoreFields()) {
            IAnyField field = cursor.nextField();
            if (field instanceof IVariableSizeArrayDimensionField) {
                field.setInitialValue(record, parentOffset);
                continue;
            }
            if (field instanceof IArrayField) {
                IArrayType arrayType = (IArrayType)field.getType();
                IFixedLengthType baseType = arrayType.getBaseType();
                if (!(baseType instanceof IAnyDynamicRecordType)) continue;
                this.initVarSizeArrayFields(record, parentOffset + field.getRelativeOffset(), (IAnyDynamicRecordType)((Object)baseType));
                continue;
            }
            if (!(field instanceof INestedRecordField) && !(field instanceof IOverlayField)) continue;
            this.initVarSizeArrayFields(record, parentOffset + field.getRelativeOffset(), (IAnyDynamicRecordType)field.getType());
        }
    }

    public void setArray(IRecord record, int parentOffset, Object value, Class componentType) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        if (this.isReadOnly()) {
            throw new RecordConversionUnsupportedException();
        }
        int offset = record.getStartingOffset() + parentOffset + this.relativeOffset_;
        ((IArrayType)this.fieldType_).setArray(record, offset, value, componentType);
    }

    public void setBigDecimal(IRecord record, int parentOffset, int[] index, BigDecimal value) throws RecordConversionFailureException, RecordConversionUnsupportedException, ArrayIndexOutOfBoundsException {
        if (this.isReadOnly()) {
            throw new RecordConversionUnsupportedException();
        }
        int offset = record.getStartingOffset() + parentOffset + this.relativeOffset_;
        ((IArrayType)this.fieldType_).setBigDecimal(record, offset, index, value);
    }

    public void setBigDecimal(IRecord record, int parentOffset, int index, BigDecimal value) throws RecordConversionFailureException, RecordConversionUnsupportedException, ArrayIndexOutOfBoundsException {
        if (this.isReadOnly()) {
            throw new RecordConversionUnsupportedException();
        }
        int offset = record.getStartingOffset() + parentOffset + this.relativeOffset_;
        ((IArrayType)this.fieldType_).setBigDecimal(record, offset, index, value);
    }

    public void setBoolean(IRecord record, int parentOffset, int[] index, boolean value) throws RecordConversionFailureException, RecordConversionUnsupportedException, ArrayIndexOutOfBoundsException {
        if (this.isReadOnly()) {
            throw new RecordConversionUnsupportedException();
        }
        int offset = record.getStartingOffset() + parentOffset + this.relativeOffset_;
        ((IArrayType)this.fieldType_).setBoolean(record, offset, index, value);
    }

    public void setBoolean(IRecord record, int parentOffset, int index, boolean value) throws RecordConversionFailureException, RecordConversionUnsupportedException, ArrayIndexOutOfBoundsException {
        if (this.isReadOnly()) {
            throw new RecordConversionUnsupportedException();
        }
        int offset = record.getStartingOffset() + parentOffset + this.relativeOffset_;
        ((IArrayType)this.fieldType_).setBoolean(record, offset, index, value);
    }

    public void setByte(IRecord record, int parentOffset, int[] index, byte value) throws RecordConversionFailureException, RecordConversionUnsupportedException, ArrayIndexOutOfBoundsException {
        if (this.isReadOnly()) {
            throw new RecordConversionUnsupportedException();
        }
        int offset = record.getStartingOffset() + parentOffset + this.relativeOffset_;
        ((IArrayType)this.fieldType_).setByte(record, offset, index, value);
    }

    public void setByte(IRecord record, int parentOffset, int index, byte value) throws RecordConversionFailureException, RecordConversionUnsupportedException, ArrayIndexOutOfBoundsException {
        if (this.isReadOnly()) {
            throw new RecordConversionUnsupportedException();
        }
        int offset = record.getStartingOffset() + parentOffset + this.relativeOffset_;
        ((IArrayType)this.fieldType_).setByte(record, offset, index, value);
    }

    public int setBytes(IRecord record, byte[] byteArray, int currentOffset) {
        int offset = currentOffset;
        int numBytesUsed = 0;
        switch (record.getRecordKind()) {
            case 0: 
            case 1: {
                numBytesUsed = this.getSize();
                break;
            }
            case 2: {
                TypeData data = this.getType().retrieveBytes(record, byteArray, currentOffset);
                numBytesUsed = data.numBytesUsed_;
                offset = 0;
                IFieldEnumeration cursor = ((IAnyDynamicRecordType)this.getType()).fields();
                while (cursor.hasMoreFields()) {
                    IAnyField field = cursor.nextField();
                    if (this.getFieldKind() == 0) {
                        offset += field.setBytes(record, data.bytes_, field.getRelativeOffset());
                        continue;
                    }
                    offset += field.setBytes(record, data.bytes_, offset);
                }
                break;
            }
            case 3: {
                numBytesUsed = this.getSize();
                TypeData data = this.getType().retrieveBytes(record, byteArray, currentOffset);
                offset = 0;
                IFieldEnumeration cursor = ((IAnyDynamicRecordType)this.getType()).fields();
                while (cursor.hasMoreFields()) {
                    IAnyField field = cursor.nextField();
                    if (this.fieldKind_ != 0 || field instanceof INestedRecordField) {
                        offset += field.setBytes(record, data.bytes_, offset);
                        continue;
                    }
                    offset += field.getSize();
                }
                break;
            }
        }
        return numBytesUsed;
    }

    public void setChar(IRecord record, int parentOffset, int[] index, char value) throws RecordConversionFailureException, RecordConversionUnsupportedException, ArrayIndexOutOfBoundsException {
        if (this.isReadOnly()) {
            throw new RecordConversionUnsupportedException();
        }
        int offset = record.getStartingOffset() + parentOffset + this.relativeOffset_;
        ((IArrayType)this.fieldType_).setChar(record, offset, index, value);
    }

    public void setChar(IRecord record, int parentOffset, int index, char value) throws RecordConversionFailureException, RecordConversionUnsupportedException, ArrayIndexOutOfBoundsException {
        if (this.isReadOnly()) {
            throw new RecordConversionUnsupportedException();
        }
        int offset = record.getStartingOffset() + parentOffset + this.relativeOffset_;
        ((IArrayType)this.fieldType_).setChar(record, offset, index, value);
    }

    public void setDouble(IRecord record, int parentOffset, int[] index, double value) throws RecordConversionFailureException, RecordConversionUnsupportedException, ArrayIndexOutOfBoundsException {
        if (this.isReadOnly()) {
            throw new RecordConversionUnsupportedException();
        }
        int offset = record.getStartingOffset() + parentOffset + this.relativeOffset_;
        ((IArrayType)this.fieldType_).setDouble(record, offset, index, value);
    }

    public void setDouble(IRecord record, int parentOffset, int index, double value) throws RecordConversionFailureException, RecordConversionUnsupportedException, ArrayIndexOutOfBoundsException {
        if (this.isReadOnly()) {
            throw new RecordConversionUnsupportedException();
        }
        int offset = record.getStartingOffset() + parentOffset + this.relativeOffset_;
        ((IArrayType)this.fieldType_).setDouble(record, offset, index, value);
    }

    public void setFloat(IRecord record, int parentOffset, int[] index, float value) throws RecordConversionFailureException, RecordConversionUnsupportedException, ArrayIndexOutOfBoundsException {
        if (this.isReadOnly()) {
            throw new RecordConversionUnsupportedException();
        }
        int offset = record.getStartingOffset() + parentOffset + this.relativeOffset_;
        ((IArrayType)this.fieldType_).setFloat(record, offset, index, value);
    }

    public void setFloat(IRecord record, int parentOffset, int index, float value) throws RecordConversionFailureException, RecordConversionUnsupportedException, ArrayIndexOutOfBoundsException {
        if (this.isReadOnly()) {
            throw new RecordConversionUnsupportedException();
        }
        int offset = record.getStartingOffset() + parentOffset + this.relativeOffset_;
        ((IArrayType)this.fieldType_).setFloat(record, offset, index, value);
    }

    public void setInitialValue(IRecord record, int parentOffset) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        super.setInitialValue(record, parentOffset);
        IFixedLengthType baseType = ((IArrayType)this.fieldType_).getBaseType();
        if (baseType instanceof IAnyDynamicRecordType) {
            IAnyDynamicRecordType complexType = (IAnyDynamicRecordType)((Object)baseType);
            this.initVarSizeArrayFields(record, parentOffset, complexType);
        }
    }

    public void setInt(IRecord record, int parentOffset, int[] index, int value) throws RecordConversionFailureException, RecordConversionUnsupportedException, ArrayIndexOutOfBoundsException {
        if (this.isReadOnly()) {
            throw new RecordConversionUnsupportedException();
        }
        int offset = record.getStartingOffset() + parentOffset + this.relativeOffset_;
        ((IArrayType)this.fieldType_).setInt(record, offset, index, value);
    }

    public void setInt(IRecord record, int parentOffset, int index, int value) throws RecordConversionFailureException, RecordConversionUnsupportedException, ArrayIndexOutOfBoundsException {
        if (this.isReadOnly()) {
            throw new RecordConversionUnsupportedException();
        }
        int offset = record.getStartingOffset() + parentOffset + this.relativeOffset_;
        ((IArrayType)this.fieldType_).setInt(record, offset, index, value);
    }

    public void setLong(IRecord record, int parentOffset, int[] index, long value) throws RecordConversionFailureException, RecordConversionUnsupportedException, ArrayIndexOutOfBoundsException {
        if (this.isReadOnly()) {
            throw new RecordConversionUnsupportedException();
        }
        int offset = record.getStartingOffset() + parentOffset + this.relativeOffset_;
        ((IArrayType)this.fieldType_).setLong(record, offset, index, value);
    }

    public void setLong(IRecord record, int parentOffset, int index, long value) throws RecordConversionFailureException, RecordConversionUnsupportedException, ArrayIndexOutOfBoundsException {
        if (this.isReadOnly()) {
            throw new RecordConversionUnsupportedException();
        }
        int offset = record.getStartingOffset() + parentOffset + this.relativeOffset_;
        ((IArrayType)this.fieldType_).setLong(record, offset, index, value);
    }

    public void setObject(IRecord record, int parentOffset, int[] index, Object value) throws RecordConversionFailureException, RecordConversionUnsupportedException, ArrayIndexOutOfBoundsException {
        if (this.isReadOnly()) {
            throw new RecordConversionUnsupportedException();
        }
        int offset = record.getStartingOffset() + parentOffset + this.relativeOffset_;
        ((IArrayType)this.fieldType_).setObject(record, offset, index, value);
    }

    public void setObject(IRecord record, int parentOffset, int index, Object value) throws RecordConversionFailureException, RecordConversionUnsupportedException, ArrayIndexOutOfBoundsException {
        if (this.isReadOnly()) {
            throw new RecordConversionUnsupportedException();
        }
        int offset = record.getStartingOffset() + parentOffset + this.relativeOffset_;
        ((IArrayType)this.fieldType_).setObject(record, offset, index, value);
    }

    public void setObject(IRecord record, int parentOffset, Object value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        if (this.isReadOnly()) {
            throw new RecordConversionUnsupportedException();
        }
        int offset = record.getStartingOffset() + parentOffset + this.relativeOffset_;
        ((IArrayType)this.fieldType_).setObject(record, offset, value);
    }

    public void setShort(IRecord record, int parentOffset, int[] index, short value) throws RecordConversionFailureException, RecordConversionUnsupportedException, ArrayIndexOutOfBoundsException {
        if (this.isReadOnly()) {
            throw new RecordConversionUnsupportedException();
        }
        int offset = record.getStartingOffset() + parentOffset + this.relativeOffset_;
        ((IArrayType)this.fieldType_).setShort(record, offset, index, value);
    }

    public void setShort(IRecord record, int parentOffset, int index, short value) throws RecordConversionFailureException, RecordConversionUnsupportedException, ArrayIndexOutOfBoundsException {
        if (this.isReadOnly()) {
            throw new RecordConversionUnsupportedException();
        }
        int offset = record.getStartingOffset() + parentOffset + this.relativeOffset_;
        ((IArrayType)this.fieldType_).setShort(record, offset, index, value);
    }

    public void setString(IRecord record, int parentOffset, int[] index, String value) throws RecordConversionFailureException, RecordConversionUnsupportedException, ArrayIndexOutOfBoundsException {
        if (this.isReadOnly()) {
            throw new RecordConversionUnsupportedException();
        }
        int offset = record.getStartingOffset() + parentOffset + this.relativeOffset_;
        ((IArrayType)this.fieldType_).setString(record, offset, index, value);
    }

    public void setString(IRecord record, int parentOffset, int index, String value) throws RecordConversionFailureException, RecordConversionUnsupportedException, ArrayIndexOutOfBoundsException {
        if (this.isReadOnly()) {
            throw new RecordConversionUnsupportedException();
        }
        int offset = record.getStartingOffset() + parentOffset + this.relativeOffset_;
        ((IArrayType)this.fieldType_).setString(record, offset, index, value);
    }

    public void setType(IAnyType type) throws RecordFieldTypeNotValidException {
        if (!(type instanceof IArrayType)) {
            throw new RecordFieldTypeNotValidException(type.getClass().getName());
        }
        this.fieldType_ = type;
        this.setFieldKind(0);
        this.setInitialValue(null);
        this.setConstantValue(null);
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("type", null, this.fieldType_);
        }
    }
}

