/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.record;

import com.ibm.record.IAnyField;
import com.ibm.record.IAnyType;
import com.ibm.record.IBidiAttributesObject;
import com.ibm.record.IFixedLengthType;
import com.ibm.record.IRangeObject;
import com.ibm.record.IRecord;
import com.ibm.record.RecordConversionFailureException;
import com.ibm.record.RecordConversionUnsupportedException;
import com.ibm.record.RecordFieldTypeNotValidException;
import com.ibm.record.RecordPossibleValueKeyNotFoundException;
import com.ibm.record.TypeData;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.Enumeration;
import java.util.Hashtable;

public abstract class AnyField
implements IAnyField,
Serializable {
    private static String copyright = "(c) Copyright IBM Corporation 1999, 2000.";
    static final long serialVersionUID = -1765370837890816588L;
    protected int relativeOffset_ = 0;
    protected String fieldName_;
    protected Object initialValue_;
    protected Object constantValue_;
    protected byte[] byteCache_;
    protected boolean readOnly_;
    protected int fieldKind_;
    protected boolean generateAccessor_;
    protected transient PropertyChangeSupport changes_;
    private static byte[] resourceLock_ = new byte[1];
    protected Hashtable possibleValues_;
    protected IBidiAttributesObject bidiAttributes_;

    protected AnyField() {
        this.fieldName_ = null;
        this.initialValue_ = null;
        this.byteCache_ = null;
        this.readOnly_ = false;
        this.generateAccessor_ = true;
        this.constantValue_ = null;
        this.fieldKind_ = 0;
        this.changes_ = null;
        this.possibleValues_ = null;
    }

    public AnyField(String name) {
        this.fieldName_ = new String(name);
        this.initialValue_ = null;
        this.byteCache_ = null;
        this.readOnly_ = false;
        this.generateAccessor_ = true;
        this.constantValue_ = null;
        this.fieldKind_ = 0;
        this.changes_ = null;
        this.possibleValues_ = null;
    }

    public AnyField(String name, Object initialValue) {
        this.fieldName_ = new String(name);
        this.initialValue_ = initialValue;
        this.byteCache_ = null;
        this.readOnly_ = false;
        this.generateAccessor_ = true;
        this.constantValue_ = null;
        this.fieldKind_ = 0;
        this.changes_ = null;
        this.possibleValues_ = null;
    }

    public AnyField(String name, Object initialValue, Object constantValue, boolean readOnly) {
        this.fieldName_ = new String(name);
        this.initialValue_ = initialValue;
        this.byteCache_ = null;
        this.readOnly_ = readOnly;
        this.generateAccessor_ = true;
        this.constantValue_ = constantValue;
        this.fieldKind_ = 0;
        this.changes_ = null;
        this.possibleValues_ = null;
    }

    public AnyField(String name, Object initialValue, Object constantValue, boolean readOnly, boolean generateAccessor) {
        this.fieldName_ = new String(name);
        this.initialValue_ = initialValue;
        this.byteCache_ = null;
        this.readOnly_ = readOnly;
        this.constantValue_ = constantValue;
        this.fieldKind_ = 0;
        this.changes_ = null;
        this.possibleValues_ = null;
        this.generateAccessor_ = generateAccessor;
    }

    public AnyField(String name, Object initialValue, boolean readOnly) {
        this.fieldName_ = new String(name);
        this.initialValue_ = initialValue;
        this.byteCache_ = null;
        this.readOnly_ = readOnly;
        this.generateAccessor_ = true;
        this.constantValue_ = null;
        this.fieldKind_ = 0;
        this.changes_ = null;
        this.possibleValues_ = null;
    }

    public AnyField(String name, boolean readOnly) {
        this.fieldName_ = new String(name);
        this.initialValue_ = null;
        this.byteCache_ = null;
        this.readOnly_ = readOnly;
        this.generateAccessor_ = true;
        this.constantValue_ = null;
        this.fieldKind_ = 0;
        this.changes_ = null;
        this.possibleValues_ = null;
    }

    protected AnyField(boolean readOnly) {
        this.fieldName_ = null;
        this.initialValue_ = null;
        this.byteCache_ = null;
        this.readOnly_ = readOnly;
        this.generateAccessor_ = true;
        this.constantValue_ = null;
        this.fieldKind_ = 0;
        this.changes_ = null;
        this.possibleValues_ = null;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        byte[] byArray = resourceLock_;
        synchronized (resourceLock_) {
            if (this.changes_ == null) {
                this.changes_ = new PropertyChangeSupport(this);
            }
            this.changes_.addPropertyChangeListener(listener);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    protected boolean cacheValues(IRecord record) {
        if (this.getFieldKind() == 1) {
            return true;
        }
        return record.getRecordKind() == 2;
    }

    public boolean checkConstantValue(IRecord record, int parentOffset) {
        if (!this.hasConstantValue()) {
            return true;
        }
        boolean constVal = true;
        if (this.cacheValues(record)) {
            constVal = this.getType().checkConstantValue(record, this.getByteCache(), this.constantValue_);
        } else {
            int offset = this.relativeOffset_ + parentOffset + record.getStartingOffset();
            constVal = ((IFixedLengthType)this.getType()).checkConstantValue(record, offset, this.constantValue_);
        }
        return constVal;
    }

    public Object clone() {
        try {
            Method meth;
            AnyField newType = (AnyField)super.clone();
            newType.changes_ = null;
            if (this.byteCache_ != null) {
                newType.byteCache_ = new byte[this.byteCache_.length];
                System.arraycopy(this.byteCache_, 0, newType.byteCache_, 0, this.byteCache_.length);
            }
            if (this.initialValue_ != null && this.initialValue_ instanceof Cloneable) {
                try {
                    meth = this.initialValue_.getClass().getMethod("clone", new Class[0]);
                    newType.initialValue_ = meth.invoke(this.initialValue_, new Object[0]);
                }
                catch (Exception exception) {}
            }
            if (this.constantValue_ != null && this.constantValue_ instanceof Cloneable) {
                try {
                    meth = this.constantValue_.getClass().getMethod("clone", new Class[0]);
                    newType.constantValue_ = meth.invoke(this.constantValue_, new Object[0]);
                }
                catch (Exception exception) {}
            }
            if (this.possibleValues_ != null) {
                newType.possibleValues_ = (Hashtable)this.possibleValues_.clone();
            }
            return newType;
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError(ex.getMessage());
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AnyField)) {
            return false;
        }
        AnyField tmpField = (AnyField)obj;
        if (this.relativeOffset_ != tmpField.relativeOffset_) {
            return false;
        }
        if (this.fieldKind_ != tmpField.fieldKind_) {
            return false;
        }
        if (this.readOnly_ != tmpField.readOnly_) {
            return false;
        }
        if (this.fieldName_ == null ^ tmpField.fieldName_ == null) {
            return false;
        }
        if (this.fieldName_ != null && !this.fieldName_.equals(tmpField.fieldName_)) {
            return false;
        }
        if (this.initialValue_ == null ^ tmpField.initialValue_ == null) {
            return false;
        }
        if (this.initialValue_ != null && !this.initialValue_.equals(tmpField.initialValue_)) {
            return false;
        }
        if (this.constantValue_ == null ^ tmpField.constantValue_ == null) {
            return false;
        }
        if (this.constantValue_ != null && !this.constantValue_.equals(tmpField.constantValue_)) {
            return false;
        }
        if (this.bidiAttributes_ == null ^ tmpField.bidiAttributes_ == null) {
            return false;
        }
        return this.bidiAttributes_ == null || this.bidiAttributes_.equals(tmpField.bidiAttributes_);
    }

    public IBidiAttributesObject getBidiAttributes() {
        return this.bidiAttributes_;
    }

    public BigDecimal getBigDecimal(IRecord record, int parentOffset) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        throw new RecordConversionUnsupportedException();
    }

    public boolean getBoolean(IRecord record, int parentOffset) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        throw new RecordConversionUnsupportedException();
    }

    public byte getByte(IRecord record, int parentOffset) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        throw new RecordConversionUnsupportedException();
    }

    public byte[] getByteCache() {
        return this.byteCache_;
    }

    public byte[] getBytes(IRecord record) {
        if (this.byteCache_ == null) {
            return null;
        }
        return this.getType().packageBytes(record, this.byteCache_);
    }

    public char getChar(IRecord record, int parentOffset) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        throw new RecordConversionUnsupportedException();
    }

    public Object getConstantValue() {
        return this.constantValue_;
    }

    public double getDouble(IRecord record, int parentOffset) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        throw new RecordConversionUnsupportedException();
    }

    public int getFieldKind() {
        return this.fieldKind_;
    }

    public float getFloat(IRecord record, int parentOffset) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        throw new RecordConversionUnsupportedException();
    }

    public Object getInitialValue() {
        return this.initialValue_;
    }

    public int getInt(IRecord record, int parentOffset) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        throw new RecordConversionUnsupportedException();
    }

    public long getLong(IRecord record, int parentOffset) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        throw new RecordConversionUnsupportedException();
    }

    public String getName() {
        return this.fieldName_;
    }

    public Object getObject(IRecord record, int parentOffset) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        throw new RecordConversionUnsupportedException();
    }

    public Object[] getPossibleValue(String key) {
        if (this.possibleValues_ == null) {
            return null;
        }
        Object[] values = (Object[])this.possibleValues_.get(key);
        return values;
    }

    public int getRelativeOffset() {
        return this.relativeOffset_;
    }

    public short getShort(IRecord record, int parentOffset) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        throw new RecordConversionUnsupportedException();
    }

    public abstract int getSize();

    public String getString(IRecord record, int parentOffset) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        throw new RecordConversionUnsupportedException();
    }

    public abstract IAnyType getType();

    public boolean hasConstantValue() {
        return this.constantValue_ != null;
    }

    public boolean hasInitialValue() {
        return this.initialValue_ != null;
    }

    public boolean hasPossibleValue() {
        return this.possibleValues_ != null;
    }

    public boolean isGenerateAccessor() {
        return this.generateAccessor_;
    }

    public boolean isPossibleValue(String key, Object value) throws RecordPossibleValueKeyNotFoundException {
        if (this.possibleValues_ == null) {
            return false;
        }
        Object[] possibleValues = (Object[])this.possibleValues_.get(key);
        if (possibleValues == null) {
            throw new RecordPossibleValueKeyNotFoundException(key);
        }
        int i = 0;
        while (i < possibleValues.length) {
            if (possibleValues[i] instanceof IRangeObject ? ((IRangeObject)possibleValues[i]).isInRange(value) : possibleValues[i].equals(value)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isReadOnly() {
        return this.readOnly_;
    }

    public Enumeration possibleValueKeys() {
        if (this.possibleValues_ == null) {
            return null;
        }
        return this.possibleValues_.keys();
    }

    public Object[] putPossibleValue(String key, Object[] value) {
        if (this.possibleValues_ == null) {
            this.possibleValues_ = new Hashtable();
        }
        Object[] oldValue = null;
        oldValue = this.possibleValues_.put(key, value);
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("possibleValues", oldValue, value);
        }
        return oldValue;
    }

    public Object[] removePossibleValue(String key) {
        if (this.possibleValues_ == null) {
            return null;
        }
        Object[] oldValue = null;
        oldValue = (Object[])this.possibleValues_.remove(key);
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("possibleValues", oldValue, null);
        }
        return oldValue;
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        byte[] byArray = resourceLock_;
        synchronized (resourceLock_) {
            if (this.changes_ == null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            this.changes_.removePropertyChangeListener(listener);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void setBidiAttributes(IBidiAttributesObject bidiAttributes) {
        IBidiAttributesObject oldBidiAttributes = this.bidiAttributes_;
        this.bidiAttributes_ = bidiAttributes;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("bidiAttributes", oldBidiAttributes, this.bidiAttributes_);
        }
    }

    public void setBigDecimal(IRecord record, int parentOffset, BigDecimal value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        throw new RecordConversionUnsupportedException();
    }

    public void setBoolean(IRecord record, int parentOffset, boolean value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        throw new RecordConversionUnsupportedException();
    }

    public void setByte(IRecord record, int parentOffset, byte value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        throw new RecordConversionUnsupportedException();
    }

    public void setByteCache(byte[] byteArray) {
        this.byteCache_ = byteArray;
    }

    public int setBytes(IRecord record, byte[] byteArray, int currentOffset) {
        TypeData data = this.getType().retrieveBytes(record, byteArray, currentOffset);
        this.byteCache_ = data.bytes_;
        return data.numBytesUsed_;
    }

    public void setChar(IRecord record, int parentOffset, char value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        throw new RecordConversionUnsupportedException();
    }

    public void setConstantValue(Object constantValue) {
        Object oldConstValue = this.constantValue_;
        this.constantValue_ = constantValue;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("constantValue", oldConstValue, this.constantValue_);
        }
    }

    public void setDouble(IRecord record, int parentOffset, double value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        throw new RecordConversionUnsupportedException();
    }

    public void setFieldKind(int fieldKind) throws IllegalArgumentException {
        switch (fieldKind) {
            case 0: 
            case 1: 
            case 2: {
                this.fieldKind_ = fieldKind;
                break;
            }
            default: {
                throw new IllegalArgumentException(Integer.toString(fieldKind));
            }
        }
    }

    public void setFloat(IRecord record, int parentOffset, float value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        throw new RecordConversionUnsupportedException();
    }

    public void setGenerateAccessor(boolean generateAccessor) {
        boolean oldGenerateAccessor = this.generateAccessor_;
        this.generateAccessor_ = generateAccessor;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("generateAccessor", new Boolean(oldGenerateAccessor), new Boolean(this.generateAccessor_));
        }
    }

    public void setInitialValue(IRecord record, int parentOffset) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        if (!this.hasInitialValue()) {
            return;
        }
        if (this.cacheValues(record)) {
            this.setByteCache(this.getType().setInitialValue(record, this.initialValue_));
        } else {
            int offset = this.relativeOffset_ + parentOffset + record.getStartingOffset();
            ((IFixedLengthType)this.getType()).setInitialValue(record, offset, this.initialValue_);
        }
    }

    public void setInitialValue(Object initialValue) {
        Object oldInitValue = this.initialValue_;
        this.initialValue_ = initialValue;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("initialValue", oldInitValue, this.initialValue_);
        }
    }

    public void setInt(IRecord record, int parentOffset, int value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        throw new RecordConversionUnsupportedException();
    }

    public void setLong(IRecord record, int parentOffset, long value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        throw new RecordConversionUnsupportedException();
    }

    public void setName(String name) {
        String oldName = this.fieldName_;
        this.fieldName_ = new String(name);
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("name", oldName, this.fieldName_);
        }
    }

    public void setObject(IRecord record, int parentOffset, Object value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        throw new RecordConversionUnsupportedException();
    }

    public void setReadOnly(boolean readOnly) {
        boolean oldReadOnly = this.readOnly_;
        this.readOnly_ = readOnly;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("readOnly", new Boolean(oldReadOnly), new Boolean(this.readOnly_));
        }
    }

    public void setRelativeOffset(int offset) {
        this.relativeOffset_ = offset;
    }

    public void setShort(IRecord record, int parentOffset, short value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        throw new RecordConversionUnsupportedException();
    }

    public void setString(IRecord record, int parentOffset, String value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        throw new RecordConversionUnsupportedException();
    }

    public abstract void setType(IAnyType var1) throws RecordFieldTypeNotValidException;
}

