/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.ejbpersistence;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;

public class PMCacheInvalidationRequest
implements Serializable {
    private static final long serialVersionUID = -3982450765858374774L;
    public static final int INVALIDATE_ONE_BEAN = 0;
    public static final int INVALIDATE_BEAN_COLLECTION = 1;
    public static final int INVALIDATE_ALL = 2;
    private int invalidationType;
    private String beanHomeJNDIName;
    private byte[] keyAsByteArray;

    public PMCacheInvalidationRequest(String string, Object object) throws IOException {
        this.invalidationType = 0;
        this.beanHomeJNDIName = string;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(object);
        objectOutputStream.close();
        this.keyAsByteArray = byteArrayOutputStream.toByteArray();
    }

    public PMCacheInvalidationRequest(String string, Collection collection) throws IOException {
        this.invalidationType = 1;
        this.beanHomeJNDIName = string;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            objectOutputStream.writeObject(e);
        }
        objectOutputStream.close();
        this.keyAsByteArray = byteArrayOutputStream.toByteArray();
    }

    public PMCacheInvalidationRequest(String string) {
        this.invalidationType = 2;
        this.beanHomeJNDIName = string;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.beanHomeJNDIName = objectInputStream.readUTF();
        this.invalidationType = objectInputStream.readInt();
        switch (this.invalidationType) {
            case 0: 
            case 1: {
                this.keyAsByteArray = (byte[])objectInputStream.readObject();
            }
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeUTF(this.beanHomeJNDIName);
        objectOutputStream.writeInt(this.invalidationType);
        switch (this.invalidationType) {
            case 0: 
            case 1: {
                objectOutputStream.writeObject(this.keyAsByteArray);
            }
        }
    }

    public String toString() {
        return "  type= " + this.invalidationType + ", beanHomeJNDIName= " + this.beanHomeJNDIName + ", keyAsByteArray= " + this.keyAsByteArray;
    }

    public int getInvalidationType() {
        return this.invalidationType;
    }

    public String getBeanHomeJNDIName() {
        return this.beanHomeJNDIName;
    }

    public byte[] getKeyAsByteArray() {
        return this.keyAsByteArray;
    }
}

