/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.rsadapter;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.appprofile.accessintent.AccessIntent;
import com.ibm.websphere.ce.cm.DuplicateKeyException;
import com.ibm.websphere.ce.cm.StaleConnectionException;
import com.ibm.websphere.rsadapter.GenericDataStoreHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.rsadapter.DSConfigurationHelper;
import com.ibm.ws.rsadapter.exceptions.DataStoreAdapterException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Properties;
import javax.resource.ResourceException;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;

public class MSSQLDataStoreHelper
extends GenericDataStoreHelper {
    private static final TraceComponent tc = Tr.register((Class)MSSQLDataStoreHelper.class, (String)"RRA", (String)"IBMDataStoreAdapterNLS");
    private HashMap sqlErrorMap = new HashMap(5);
    private static final int HASHSIZE = 5;
    public static final String[] RESOURCE_TYPES = new String[]{"undefined", "NULL", "Database", "File", "Index", "Table", "Page", "Key", "Extent", "Row Id", "Application"};
    public static final String[] LOCK_REQUEST_STATUSES = new String[]{"undefined", "Granted", "Converting", "Waiting"};
    public static final String[] LOCK_OWNER_TPYES = new String[]{"undefined", "Transaction", "Cursor", "Session", "ExSession"};
    public static final String[] LOCK_REQUEST_MODES = new String[]{"NULL", "Sch-S (Schema Stability)", "Sch-M (Schema modification)", "S (Shared)", "U (Update)", "X (Exclusive)", "IS (Intent Shared)", "IU (Intent Update)", "IX (Intent Exclusive)", "SIU (Shared Intent Update)", "SIX (Shared Intent Exclusive)", "UIX (Update Intent Exclusive)", "BU", "RangeS_S (Shared Key-Range and Shared Resource lock)", "RangeS_U (Shared Key-Range and Update Resource lock)", "RangeI_N (Insert Key-Range and Null Resource lock)", "RangeI_S", "RangeI_U", "RangeI_X", "RangeX_S", "RangeX_U", "RangeX_X"};

    public MSSQLDataStoreHelper(Properties properties) {
        super(null);
        this.addInitialMaps();
        this.dshMd.setHelperType(10);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"done constructing MSSQLDataStoreHelper: ", (Object)this);
        }
    }

    private void addInitialMaps() {
        this.sqlErrorMap.put(new Integer(230), StaleConnectionException.class);
        this.sqlErrorMap.put(new Integer(2627), DuplicateKeyException.class);
    }

    public final Class findMappingClass(SQLException sQLException) {
        Object var2_2 = null;
        String string = null;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("findMappingClass for: " + sQLException));
        }
        if (sQLException != null) {
            var2_2 = this.sqlErrorMap.get(new Integer(sQLException.getErrorCode()));
            if (var2_2 != null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"findMappingClass return ", var2_2);
                }
                return var2_2;
            }
            string = sQLException.getSQLState();
            if (string != null) {
                var2_2 = this.sqlErrorMap.get(string);
            }
            if (var2_2 == null) {
                SQLException sQLException2 = sQLException.getNextException();
                if (sQLException2 != null) {
                    return this.findMappingClass(sQLException2);
                }
                return super.findMappingClass(sQLException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"findMappingClass: return ", var2_2);
        }
        return var2_2;
    }

    public int getIsolationLevel(AccessIntent accessIntent) throws ResourceException {
        throw new DataStoreAdapterException("INVALID_METHOD_CALL", "This method must be called from DatadirectDataStoreHelper", this.getClass());
    }

    public int getResultSetType(AccessIntent accessIntent) throws ResourceException {
        throw new DataStoreAdapterException("INVALID_METHOD_CALL", "This method must be called from DatadirectDataStoreHelper", this.getClass());
    }

    public int getResultSetConcurrency(AccessIntent accessIntent) throws ResourceException {
        throw new DataStoreAdapterException("INVALID_METHOD_CALL", "This method must be called from DatadirectDataStoreHelper, returning -1 as an invalid value.", this.getClass());
    }

    public final String showLockInfo(Properties properties) throws Exception {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"showLockInfo: ", (Object)properties);
        }
        if (properties == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"showLockInfo: must specify connection properties ", (Object)properties);
            }
            return null;
        }
        ConnectionPoolDataSource connectionPoolDataSource = null;
        String string = properties.getProperty("user", "sa");
        String string2 = properties.getProperty("password", "");
        String string3 = "com.ibm.websphere.jdbcx.sqlserver.SQLServerDataSource";
        properties.remove("driverType");
        properties.remove("user");
        properties.remove("password");
        properties.setProperty("selectMethod", "cursor");
        properties.setProperty("databaseName", "master");
        Object object = null;
        try {
            object = DSConfigurationHelper.createDataSource((Object)string3);
            DSConfigurationHelper.setDataSourceProperties((Object)object, (Properties)properties);
            connectionPoolDataSource = (ConnectionPoolDataSource)object;
        }
        catch (ResourceException resourceException) {
            FFDCFilter.processException((Throwable)resourceException, (String)"com.ibm.websphere.rsadapter.MSSQLDataStoreHelper.showLockInfo", (String)"318", (Object)this);
            Exception exception = resourceException.getLinkedException();
            if (exception == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"failed during establishing a connection -- linked exception is null, current exception is:", (Object)exception);
                }
                throw resourceException;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"failed during establishing a connection -- datasource creation exception is:", (Object)exception);
            }
            throw exception;
        }
        PooledConnection pooledConnection = connectionPoolDataSource.getPooledConnection(string, string2);
        Connection connection = pooledConnection.getConnection();
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("select * from syslockinfo");
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (resultSet.next()) {
            stringBuffer.append(EOLN + "----------------------------------------");
            stringBuffer.append(EOLN + "Lock Resource Text   (rsc_text) : ");
            stringBuffer.append(resultSet.getString("rsc_text"));
            stringBuffer.append(EOLN + "Resource Database Id (rsc_dbid) : ");
            stringBuffer.append(resultSet.getInt("rsc_dbid"));
            stringBuffer.append(EOLN + "Resource Index Id    (rsc_indid) : ");
            stringBuffer.append(resultSet.getInt("rsc_indid"));
            stringBuffer.append(EOLN + "Resource Object Id   (rsc_objid) : ");
            stringBuffer.append(resultSet.getInt("rsc_objid"));
            stringBuffer.append(EOLN + "Resource Type        (rsc_type) : ");
            stringBuffer.append(RESOURCE_TYPES[resultSet.getInt("rsc_type")]);
            stringBuffer.append(EOLN + "Resource Flags       (rsc_flag) : ");
            stringBuffer.append(resultSet.getInt("rsc_flag"));
            stringBuffer.append(EOLN + "Lock Request Mode    (req_mode) : ");
            stringBuffer.append(LOCK_REQUEST_MODES[resultSet.getInt("req_mode")]);
            stringBuffer.append(EOLN + "Lock Request Status  (req_status) : ");
            stringBuffer.append(LOCK_REQUEST_STATUSES[resultSet.getInt("req_status")]);
            stringBuffer.append(EOLN + "Lock Reference Count (req_refcnt) : ");
            stringBuffer.append(resultSet.getInt("req_refcnt"));
            stringBuffer.append(EOLN + "Process ID           (req_spid) : ");
            stringBuffer.append(resultSet.getInt("req_spid"));
            stringBuffer.append(EOLN + "Execution Context ID (req_ecid) : ");
            stringBuffer.append(resultSet.getInt("req_ecid"));
            stringBuffer.append(EOLN + "Lock Owner Type      (req_ownertype) : ");
            stringBuffer.append(LOCK_OWNER_TPYES[resultSet.getInt("req_ownertype")]);
            stringBuffer.append(EOLN + "Transaction ID       (req_transactionID) : ");
            stringBuffer.append(resultSet.getInt("req_transactionID"));
            ++n;
        }
        stringBuffer.append(EOLN + "===> " + n + " MSSqlServer locks found" + EOLN + EOLN + EOLN);
        try {
            resultSet.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            statement.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            connection.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            pooledConnection.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return stringBuffer.toString();
    }
}

