/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.rsadapter;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.appprofile.accessintent.AccessIntent;
import com.ibm.websphere.ce.cm.StaleConnectionException;
import com.ibm.websphere.rsadapter.DataStoreHelper;
import com.ibm.websphere.rsadapter.GenericDataStoreHelper;
import com.ibm.websphere.rsadapter.MSSQLDataStoreHelper;
import com.ibm.ws.rsadapter.AdapterUtil;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.resource.ResourceException;

public class DataDirectDataStoreHelper
extends GenericDataStoreHelper {
    private static final TraceComponent tc = Tr.register((Class)DataDirectDataStoreHelper.class, (String)"RRA", (String)"IBMDataStoreAdapterNLS");
    private static final TraceComponent sqlserverTc = Tr.register((String)"com.ibm.ws.sqlserver.logwriter", (String)"WAS.database", null);
    private HashMap dataDirectErrorMap = new HashMap(11);
    private HashMap userNewMap = null;
    private static final int HASHSIZE = 11;
    private static final int SQLSERVER = 2;
    private DataStoreHelper dsHelper = null;
    private final int helperKind = 2;

    public DataDirectDataStoreHelper(Properties properties) {
        super(properties);
        this.addInitialMaps();
        this.dshMd.setHelperType(6);
        this.dshMd.setDatabaseDefaultIsolationLevel(4, this.customDefinedWasDefaultIsoLevel);
        this.dsHelper = new MSSQLDataStoreHelper(properties);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"done constructing DataDirectDSHelper", (Object)this);
        }
    }

    private void addInitialMaps() {
        this.dataDirectErrorMap.put(new Integer(2217), StaleConnectionException.class);
        this.dataDirectErrorMap.put(new Integer(2251), StaleConnectionException.class);
        this.dataDirectErrorMap.put(new Integer(2306), StaleConnectionException.class);
        this.dataDirectErrorMap.put(new Integer(2310), StaleConnectionException.class);
        this.dataDirectErrorMap.put(new Integer(2311), StaleConnectionException.class);
        this.dataDirectErrorMap.put("08000", StaleConnectionException.class);
        this.dataDirectErrorMap.put("08002", StaleConnectionException.class);
        this.dataDirectErrorMap.put("08004", StaleConnectionException.class);
        this.dataDirectErrorMap.put("08007", StaleConnectionException.class);
        this.dataDirectErrorMap.put("40003", Void.class);
        this.dataDirectErrorMap.put("S1000", Void.class);
    }

    public int getResultSetConcurrency(AccessIntent accessIntent) throws ResourceException {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getResultSetConcurrency", (Object)accessIntent);
        }
        int n2 = n = accessIntent != null && accessIntent.getAccessType() == 1 && accessIntent.getConcurrencyControl() == 1 && (accessIntent.getPessimisticUpdateLockHint() == 4 || accessIntent.getPessimisticUpdateLockHint() == 3) ? 1008 : 1007;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getResultSetConcurrency", (Object)AdapterUtil.getConcurrencyModeString((int)n));
        }
        return n;
    }

    protected boolean isDataDirectExp(SQLException sQLException) {
        String string = sQLException.getMessage();
        int n = string.indexOf(91, 2);
        if ((n = string.indexOf("][", n + 10)) != -1) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The exception is NOT a DataDirect exceptoin ");
            }
            return false;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"the exception is a DataDirect exception  ");
        }
        return true;
    }

    public final Class findMappingClass(SQLException sQLException) {
        Class<Object> clazz = null;
        String string = null;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"findMappingClass for :", (Object)sQLException);
        }
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"the DataStoreHelper is: ", (Object)this);
        }
        if (sQLException != null) {
            if (this.userNewMap != null) {
                clazz = (Class<Object>)this.userNewMap.get(new Integer(sQLException.getErrorCode()));
                if (clazz != null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"findMappingClass return: ", clazz);
                    }
                    return clazz;
                }
                string = sQLException.getSQLState();
                if (string != null && (clazz = (Class)this.userNewMap.get(string)) != null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"findMappingClass return: ", (Object)clazz);
                    }
                    return clazz;
                }
            }
            if (this.isDataDirectExp(sQLException)) {
                clazz = (Class<Object>)this.dataDirectErrorMap.get(new Integer(sQLException.getErrorCode()));
                if (clazz != null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"findMappingClass, return ", (Object)clazz);
                    }
                    return clazz;
                }
                string = sQLException.getSQLState();
                if (string != null) {
                    clazz = this.dataDirectErrorMap.get(string);
                }
                if (clazz == null) {
                    SQLException sQLException2 = sQLException.getNextException();
                    if (sQLException2 != null) {
                        return this.findMappingClass(sQLException2);
                    }
                    return super.findMappingClass(sQLException);
                }
            } else {
                return ((MSSQLDataStoreHelper)this.dsHelper).findMappingClass(sQLException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"findMappingClass: return ", clazz);
        }
        return clazz;
    }

    public int getIsolationLevel(AccessIntent accessIntent) throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getIsolationLevel, intent: ", (Object)accessIntent);
        }
        int n = this.dshMd.getDatabaseDefaultIsolationLevel();
        if (accessIntent != null) {
            if (accessIntent.getConcurrencyControl() == 2) {
                n = 2;
            } else if (accessIntent.getAccessType() == 2) {
                n = 4;
            } else {
                int n2 = accessIntent.getPessimisticUpdateLockHint();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"The hint_value is: ", (Object)new Integer(n2));
                }
                switch (n2) {
                    case 2: 
                    case 3: {
                        n = 4;
                        break;
                    }
                    case 1: {
                        n = 2;
                        break;
                    }
                    case 4: {
                        n = 8;
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getIsolationLevel, return:", (Object)AdapterUtil.getIsolationLevelString((int)n));
        }
        return n;
    }

    public void doConnectionSetup(Connection connection) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"doConnectionSetup: calling the doConnection method on the contained helper");
        }
        this.dsHelper.doConnectionSetup(connection);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"doConnectionSetup");
        }
    }

    public final void setUserDefinedMap(Map map) {
        this.userNewMap = new HashMap(map);
    }

    public PrintWriter getPrintWriter() {
        return null;
    }

    public final String showLockInfo(Properties properties) throws Exception {
        return ((MSSQLDataStoreHelper)this.dsHelper).showLockInfo(properties);
    }
}

