/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport.tcp;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.lang.reflect.InvocationTargetException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.rmi.RemoteException;
import java.rmi.server.ExportException;
import java.rmi.server.LogStream;
import java.rmi.server.RMIFailureHandler;
import java.rmi.server.RMISocketFactory;
import java.rmi.server.ServerNotActiveException;
import java.rmi.server.UID;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Vector;
import java.util.WeakHashMap;
import sun.rmi.runtime.Log;
import sun.rmi.runtime.NewThreadAction;
import sun.rmi.transport.Channel;
import sun.rmi.transport.Connection;
import sun.rmi.transport.DGCAckHandler;
import sun.rmi.transport.Endpoint;
import sun.rmi.transport.StreamRemoteCall;
import sun.rmi.transport.Target;
import sun.rmi.transport.Transport;
import sun.rmi.transport.proxy.HttpReceiveSocket;
import sun.rmi.transport.tcp.ConnectionMultiplexer;
import sun.rmi.transport.tcp.TCPChannel;
import sun.rmi.transport.tcp.TCPConnection;
import sun.rmi.transport.tcp.TCPEndpoint;
import sun.security.action.GetIntegerAction;
import sun.security.action.GetPropertyAction;

public class TCPTransport
extends Transport
implements Runnable {
    static final int logLevel = LogStream.parseLevel(TCPTransport.getLogLevel());
    static String threadPooling = (String)AccessController.doPrivileged(new GetPropertyAction("sun.rmi.transport.tcp.connectionPool"));
    static final Log tcpLog = Log.getLog("sun.rmi.transport.tcp", "tcp", logLevel);
    private static int threadNum = 0;
    private static final ThreadLocal threadConnectionHandler = new ThreadLocal();
    private final LinkedList epList;
    private ServerSocket server = null;
    private final Map channelTable = new HashMap(11);
    private Vector pool = new Vector();
    private static int startThreadNum = 0;
    static final RMISocketFactory defaultSocketFactory = RMISocketFactory.getDefaultSocketFactory();
    private static final int connectionReadTimeout = (Integer)AccessController.doPrivileged(new GetIntegerAction("sun.rmi.transport.tcp.readTimeout", 0x6DDD00));
    private transient long acceptFailureTime = 0L;
    private transient int acceptFailureCount;

    private static String getLogLevel() {
        return (String)AccessController.doPrivileged(new GetPropertyAction("sun.rmi.transport.tcp.logLevel"));
    }

    TCPTransport(LinkedList linkedList) {
        this.epList = linkedList;
        if (tcpLog.isLoggable(Log.BRIEF)) {
            tcpLog.log(Log.BRIEF, "Version = 2, ep = " + this.getEndpoint());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shedConnectionCaches() {
        int n;
        TCPChannel[] tCPChannelArray;
        Map map = this.channelTable;
        synchronized (map) {
            tCPChannelArray = new TCPChannel[this.channelTable.size()];
            Iterator iterator = this.channelTable.values().iterator();
            n = 0;
            while (iterator.hasNext()) {
                tCPChannelArray[n] = (TCPChannel)iterator.next();
                ++n;
            }
        }
        while (--n >= 0) {
            tCPChannelArray[n].shedCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Channel getChannel(Endpoint endpoint) {
        Channel channel = null;
        if (endpoint instanceof TCPEndpoint) {
            Map map = this.channelTable;
            synchronized (map) {
                channel = (Channel)this.channelTable.get(endpoint);
                if (channel == null) {
                    channel = new TCPChannel(this, (TCPEndpoint)endpoint);
                    this.channelTable.put(endpoint, channel);
                }
            }
        }
        return channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void free(Endpoint endpoint) {
        if (endpoint instanceof TCPEndpoint) {
            Map map = this.channelTable;
            synchronized (map) {
                TCPChannel tCPChannel = (TCPChannel)this.channelTable.remove(endpoint);
                if (tCPChannel != null) {
                    tCPChannel.shedCache();
                }
            }
        }
    }

    public void exportObject(Target target) throws RemoteException {
        this.listen();
        target.setExportedTransport(this);
        super.exportObject(target);
    }

    protected void checkAcceptPermission(AccessControlContext accessControlContext) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            return;
        }
        ConnectionHandler connectionHandler = (ConnectionHandler)threadConnectionHandler.get();
        if (connectionHandler == null) {
            throw new Error("checkAcceptPermission not in ConnectionHandler thread");
        }
        connectionHandler.checkAcceptPermission(securityManager, accessControlContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TCPEndpoint getEndpoint() {
        LinkedList linkedList = this.epList;
        synchronized (linkedList) {
            return (TCPEndpoint)this.epList.getLast();
        }
    }

    private synchronized void listen() throws RemoteException {
        TCPEndpoint tCPEndpoint = this.getEndpoint();
        int n = tCPEndpoint.getPort();
        if (this.server == null) {
            if (tcpLog.isLoggable(Log.BRIEF)) {
                tcpLog.log(Log.BRIEF, "(port " + n + ") create server socket");
            }
            try {
                this.server = tCPEndpoint.newServerSocket();
                Thread thread = (Thread)AccessController.doPrivileged(new NewThreadAction(this, "TCP Accept-" + n, true));
                thread.start();
            }
            catch (BindException bindException) {
                throw new ExportException("Port already in use: " + n, bindException);
            }
            catch (IOException iOException) {
                throw new ExportException("Listen failed on port: " + n, iOException);
            }
        } else {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkListen(n);
            }
        }
    }

    private synchronized boolean continueAfterAcceptFailure(Throwable throwable) {
        boolean bl;
        RMIFailureHandler rMIFailureHandler = RMISocketFactory.getFailureHandler();
        if (rMIFailureHandler != null) {
            bl = throwable instanceof Exception ? rMIFailureHandler.failure((Exception)throwable) : rMIFailureHandler.failure(new InvocationTargetException(throwable));
        } else {
            long l = System.currentTimeMillis();
            if (this.acceptFailureTime == 0L || l - this.acceptFailureTime > 5000L) {
                this.acceptFailureTime = l;
                this.acceptFailureCount = 0;
            } else {
                ++this.acceptFailureCount;
                if (this.acceptFailureCount >= 10) {
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run() {
        if (tcpLog.isLoggable(Log.BRIEF)) {
            tcpLog.log(Log.BRIEF, "listening on port " + this.getEndpoint().getPort());
        }
        ServerSocket serverSocket;
        while ((serverSocket = this.server) != null) {
            Object var8_14;
            Throwable throwable = null;
            try {
                block31: {
                    String string;
                    Socket socket = serverSocket.accept();
                    InetAddress inetAddress = socket.getInetAddress();
                    String string2 = string = inetAddress != null ? inetAddress.getHostAddress() : "0.0.0.0";
                    if (threadPooling == null) {
                        Thread thread = (Thread)AccessController.doPrivileged(new NewThreadAction(new ConnectionHandler(socket, string), "TCP Connection(" + ++threadNum + ")-" + string, true, true));
                        thread.start();
                        break block31;
                    }
                    this.handleConnection(socket, string);
                }
                var8_14 = null;
                if (throwable == null) continue;
            }
            catch (Throwable throwable2) {
                var8_14 = null;
                if (throwable == null) throw throwable2;
                if (!(throwable instanceof SecurityException)) {
                    try {
                        TCPEndpoint.shedConnectionCaches();
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (throwable instanceof IOException || throwable instanceof OutOfMemoryError || throwable instanceof NoClassDefFoundError || throwable instanceof MissingResourceException || throwable instanceof SecurityException) {
                    if (this.continueAfterAcceptFailure(throwable)) throw throwable2;
                    return;
                }
                if (!(throwable instanceof RuntimeException)) throw (Error)throwable;
                throw (RuntimeException)throwable;
            }
            if (!(throwable instanceof SecurityException)) {
                try {
                    TCPEndpoint.shedConnectionCaches();
                }
                catch (OutOfMemoryError outOfMemoryError) {
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (throwable instanceof IOException || throwable instanceof OutOfMemoryError || throwable instanceof NoClassDefFoundError || throwable instanceof MissingResourceException || throwable instanceof SecurityException) {
                if (this.continueAfterAcceptFailure(throwable)) continue;
                return;
            }
            if (!(throwable instanceof RuntimeException)) throw (Error)throwable;
            throw (RuntimeException)throwable;
            {
                catch (IOException iOException) {
                    IOException iOException2 = iOException;
                    var8_14 = null;
                    if (iOException2 == null) continue;
                    if (!(iOException2 instanceof SecurityException)) {
                        try {
                            TCPEndpoint.shedConnectionCaches();
                        }
                        catch (OutOfMemoryError outOfMemoryError) {
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (iOException2 instanceof IOException || iOException2 instanceof OutOfMemoryError || iOException2 instanceof NoClassDefFoundError || iOException2 instanceof MissingResourceException || iOException2 instanceof SecurityException) {
                        if (this.continueAfterAcceptFailure(iOException2)) continue;
                        return;
                    }
                    if (!(iOException2 instanceof RuntimeException)) throw (Error)((Object)iOException2);
                    throw (RuntimeException)((Object)iOException2);
                }
                catch (RuntimeException runtimeException) {
                    RuntimeException runtimeException2 = runtimeException;
                    var8_14 = null;
                    if (runtimeException2 == null) continue;
                    if (!(runtimeException2 instanceof SecurityException)) {
                        try {
                            TCPEndpoint.shedConnectionCaches();
                        }
                        catch (OutOfMemoryError outOfMemoryError) {
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (runtimeException2 instanceof IOException || runtimeException2 instanceof OutOfMemoryError || runtimeException2 instanceof NoClassDefFoundError || runtimeException2 instanceof MissingResourceException || runtimeException2 instanceof SecurityException) {
                        if (this.continueAfterAcceptFailure(runtimeException2)) continue;
                        return;
                    }
                    if (!(runtimeException2 instanceof RuntimeException)) throw (Error)((Object)runtimeException2);
                    throw runtimeException2;
                }
                catch (Error error) {
                    Error error2 = error;
                    var8_14 = null;
                    if (error2 == null) continue;
                    if (!(error2 instanceof SecurityException)) {
                        try {
                            TCPEndpoint.shedConnectionCaches();
                        }
                        catch (OutOfMemoryError outOfMemoryError) {
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (error2 instanceof IOException || error2 instanceof OutOfMemoryError || error2 instanceof NoClassDefFoundError || error2 instanceof MissingResourceException || error2 instanceof SecurityException) {
                        if (!this.continueAfterAcceptFailure(error2)) return;
                        continue;
                    }
                    if (!(error2 instanceof RuntimeException)) throw error2;
                    throw (RuntimeException)((Object)error2);
                }
            }
            break;
        }
        return;
    }

    private static void closeSocket(Socket socket) {
        try {
            socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleMessages(Connection connection, boolean bl) {
        int n = this.getEndpoint().getPort();
        try {
            DataInputStream dataInputStream = new DataInputStream(connection.getInputStream());
            block19: do {
                int n2;
                if ((n2 = dataInputStream.read()) == -1) {
                    if (tcpLog.isLoggable(Log.BRIEF)) {
                        tcpLog.log(Log.BRIEF, "(port " + n + ") connection closed");
                    }
                    break;
                }
                if (tcpLog.isLoggable(Log.BRIEF)) {
                    tcpLog.log(Log.BRIEF, "(port " + n + ") op = " + n2);
                }
                switch (n2) {
                    case 80: {
                        StreamRemoteCall streamRemoteCall = new StreamRemoteCall(connection);
                        if (this.serviceCall(streamRemoteCall)) continue block19;
                        return;
                    }
                    case 82: {
                        DataOutputStream dataOutputStream = new DataOutputStream(connection.getOutputStream());
                        dataOutputStream.writeByte(83);
                        connection.releaseOutputStream();
                        break;
                    }
                    case 84: {
                        DGCAckHandler.received(UID.read(dataInputStream));
                        break;
                    }
                    default: {
                        throw new IOException("unknown transport op " + n2);
                    }
                }
            } while (bl);
        }
        catch (IOException iOException) {
            if (tcpLog.isLoggable(Log.BRIEF)) {
                tcpLog.log(Log.BRIEF, "(port " + n + ") exception: ", iOException);
            }
        }
        finally {
            try {
                connection.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static String getClientHost() throws ServerNotActiveException {
        ConnectionHandler connectionHandler = (ConnectionHandler)threadConnectionHandler.get();
        if (connectionHandler != null) {
            return connectionHandler.getClientHost();
        }
        throw new ServerNotActiveException("not in a remote call");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ConnectionHandler getHandler() {
        TCPEndpoint tCPEndpoint = this.getEndpoint();
        ConnectionHandler connectionHandler = null;
        Object object = this.pool;
        synchronized (object) {
            if (this.pool.size() > 0) {
                connectionHandler = (ConnectionHandler)this.pool.lastElement();
                this.pool.removeElementAt(this.pool.size() - 1);
            }
        }
        if (connectionHandler == null) {
            if (logLevel >= 10) {
                LogStream.log("tcp").println("TCPTransport(" + tCPEndpoint.getPort() + ").run: creating a new connection thread");
            }
            connectionHandler = new ConnectionHandler();
            object = (Thread)AccessController.doPrivileged(new NewThreadAction(connectionHandler, String.valueOf(++startThreadNum), true, true));
            ((Thread)object).start();
            Object object2 = object;
            synchronized (object2) {
                while (!connectionHandler.threadStarted) {
                    try {
                        object.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        } else if (logLevel >= 10) {
            LogStream.log("tcp").println("TCPTransport(" + tCPEndpoint.getPort() + ").run: reusing a connection thread from pool");
        }
        return connectionHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleConnection(Socket socket, String string) {
        ConnectionHandler connectionHandler;
        ConnectionHandler connectionHandler2 = connectionHandler = this.getHandler();
        synchronized (connectionHandler2) {
            connectionHandler.initThread(socket, string);
            connectionHandler.notify();
        }
    }

    static /* synthetic */ TCPEndpoint access$200(TCPTransport tCPTransport) {
        return tCPTransport.getEndpoint();
    }

    static /* synthetic */ ThreadLocal access$300() {
        return threadConnectionHandler;
    }

    static /* synthetic */ int access$400() {
        return connectionReadTimeout;
    }

    static /* synthetic */ void access$500(Socket socket) {
        TCPTransport.closeSocket(socket);
    }

    static /* synthetic */ Map access$600(TCPTransport tCPTransport) {
        return tCPTransport.channelTable;
    }

    static /* synthetic */ Vector access$700(TCPTransport tCPTransport) {
        return tCPTransport.pool;
    }

    private class ConnectionHandler
    implements Runnable {
        private static final int POST = 1347375956;
        private AccessControlContext okContext;
        private WeakHashMap authCache;
        private SecurityManager cacheSecurityManager = null;
        private Socket socket;
        private String remoteHost;
        private boolean threadStarted = false;
        String name;

        ConnectionHandler(Socket socket, String string) {
            this.socket = socket;
            this.remoteHost = string;
        }

        ConnectionHandler() {
        }

        void initThread(Socket socket, String string) {
            this.socket = socket;
            this.remoteHost = string;
            this.name = "TCP Connection(" + ++threadNum + ")-" + string;
        }

        String getClientHost() {
            return this.remoteHost;
        }

        void checkAcceptPermission(SecurityManager securityManager, AccessControlContext accessControlContext) {
            if (securityManager != this.cacheSecurityManager) {
                this.okContext = null;
                this.authCache = new WeakHashMap();
                this.cacheSecurityManager = securityManager;
            }
            if (accessControlContext.equals(this.okContext) || this.authCache.containsKey(accessControlContext)) {
                return;
            }
            InetAddress inetAddress = this.socket.getInetAddress();
            String string = inetAddress != null ? inetAddress.getHostAddress() : "*";
            securityManager.checkAccept(string, this.socket.getPort());
            this.authCache.put(accessControlContext, new SoftReference(accessControlContext));
            this.okContext = accessControlContext;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void handleRequest() {
            block33: {
                block32: {
                    var1_1 = TCPTransport.access$200(TCPTransport.this);
                    var2_2 = var1_1.getPort();
                    TCPTransport.access$300().set(this);
                    try {
                        this.socket.setTcpNoDelay(true);
                    }
                    catch (Exception var3_3) {
                        // empty catch block
                    }
                    try {
                        if (TCPTransport.access$400() > 0) {
                            this.socket.setSoTimeout(TCPTransport.access$400());
                        }
                    }
                    catch (Exception var3_4) {
                        // empty catch block
                    }
                    try {
                        try {
                            var3_5 = this.socket.getInputStream();
                            var4_7 = var3_5.markSupported() != false ? var3_5 : new BufferedInputStream(var3_5);
                            var4_7.mark(4);
                            var5_8 = new DataInputStream(var4_7);
                            var6_9 = var5_8.readInt();
                            if (var6_9 == 1347375956) {
                                TCPTransport.tcpLog.log(Log.BRIEF, "decoding HTTP-wrapped call");
                                var4_7.reset();
                                try {
                                    this.socket = new HttpReceiveSocket(this.socket, var4_7, null);
                                    this.remoteHost = "0.0.0.0";
                                    var3_5 = this.socket.getInputStream();
                                    var4_7 = new BufferedInputStream(var3_5);
                                    var5_8 = new DataInputStream(var4_7);
                                    var6_9 = var5_8.readInt();
                                }
                                catch (IOException var7_10) {
                                    throw new RemoteException("Error HTTP-unwrapping call", var7_10);
                                }
                            }
                            var7_11 = var5_8.readShort();
                            if (var6_9 != 1246907721 || var7_11 != 2) {
                                TCPTransport.access$500(this.socket);
                                var22_12 = null;
                                break block32;
                            }
                            var8_20 = this.socket.getOutputStream();
                            var9_21 = new BufferedOutputStream(var8_20);
                            var10_22 = new DataOutputStream(var9_21);
                            var11_23 = this.socket.getPort();
                            if (TCPTransport.tcpLog.isLoggable(Log.BRIEF)) {
                                TCPTransport.tcpLog.log(Log.BRIEF, "accepted socket from [" + this.remoteHost + ":" + var11_23 + "]");
                            }
                            var15_24 = var5_8.readByte();
                            switch (var15_24) {
                                case 76: {
                                    var12_25 = new TCPEndpoint(this.remoteHost, this.socket.getLocalPort(), var1_1.getClientSocketFactory(), var1_1.getServerSocketFactory());
                                    var13_28 = new TCPChannel(TCPTransport.this, var12_25);
                                    var14_31 = new TCPConnection(var13_28, this.socket, var4_7, var9_21);
                                    TCPTransport.this.handleMessages(var14_31, false);
                                    ** break;
                                }
                                case 75: {
                                    var10_22.writeByte(78);
                                    if (TCPTransport.tcpLog.isLoggable(Log.VERBOSE)) {
                                        TCPTransport.tcpLog.log(Log.VERBOSE, "(port " + var2_2 + ") " + "suggesting " + this.remoteHost + ":" + var11_23);
                                    }
                                    var10_22.writeUTF(this.remoteHost);
                                    var10_22.writeInt(var11_23);
                                    var10_22.flush();
                                    var16_33 = var5_8.readUTF();
                                    var17_34 = var5_8.readInt();
                                    if (TCPTransport.tcpLog.isLoggable(Log.VERBOSE)) {
                                        TCPTransport.tcpLog.log(Log.VERBOSE, "(port " + var2_2 + ") client using " + var16_33 + ":" + var17_34);
                                    }
                                    var12_26 = new TCPEndpoint(this.remoteHost, this.socket.getLocalPort(), var1_1.getClientSocketFactory(), var1_1.getServerSocketFactory());
                                    var13_29 = new TCPChannel(TCPTransport.this, var12_26);
                                    var14_32 = new TCPConnection(var13_29, this.socket, var4_7, var9_21);
                                    TCPTransport.this.handleMessages(var14_32, true);
                                    ** break;
                                }
                                case 77: {
                                    if (TCPTransport.tcpLog.isLoggable(Log.VERBOSE)) {
                                        TCPTransport.tcpLog.log(Log.VERBOSE, "(port " + var2_2 + ") accepting multiplex protocol");
                                    }
                                    var10_22.writeByte(78);
                                    if (TCPTransport.tcpLog.isLoggable(Log.VERBOSE)) {
                                        TCPTransport.tcpLog.log(Log.VERBOSE, "(port " + var2_2 + ") suggesting " + this.remoteHost + ":" + var11_23);
                                    }
                                    var10_22.writeUTF(this.remoteHost);
                                    var10_22.writeInt(var11_23);
                                    var10_22.flush();
                                    var12_27 = new TCPEndpoint(var5_8.readUTF(), var5_8.readInt(), var1_1.getClientSocketFactory(), var1_1.getServerSocketFactory());
                                    if (TCPTransport.tcpLog.isLoggable(Log.VERBOSE)) {
                                        TCPTransport.tcpLog.log(Log.VERBOSE, "(port " + var2_2 + ") client using " + var12_27.getHost() + ":" + var12_27.getPort());
                                    }
                                    var19_35 = TCPTransport.access$600(TCPTransport.this);
                                    synchronized (var19_35) {
                                        var13_30 = (TCPChannel)TCPTransport.this.getChannel(var12_27);
                                        var18_36 = new ConnectionMultiplexer(var13_30, var4_7, var8_20, false);
                                        var13_30.useMultiplexer(var18_36);
                                    }
                                    var18_36.run();
                                    ** break;
                                }
                            }
                            var10_22.writeByte(79);
                            var10_22.flush();
                            break block33;
                        }
                        catch (IOException var3_6) {
                            TCPTransport.tcpLog.log(Log.BRIEF, "terminated with exception:", var3_6);
                            var22_14 = null;
                            TCPTransport.access$500(this.socket);
                            if (TCPTransport.threadPooling == null) return;
                            this.socket = null;
                            TCPTransport.access$300().set(null);
                            var23_18 = TCPTransport.access$700(TCPTransport.this);
                            synchronized (var23_18) {
                                TCPTransport.access$700(TCPTransport.this).addElement(this);
                                return;
                            }
                        }
                    }
                    catch (Throwable var21_37) {
                        var22_15 = null;
                        TCPTransport.access$500(this.socket);
                        if (TCPTransport.threadPooling == null) throw var21_37;
                        this.socket = null;
                        TCPTransport.access$300().set(null);
                        var23_19 = TCPTransport.access$700(TCPTransport.this);
                        synchronized (var23_19) {
                            TCPTransport.access$700(TCPTransport.this).addElement(this);
                            throw var21_37;
                        }
                    }
                }
                TCPTransport.access$500(this.socket);
                if (TCPTransport.threadPooling == null) return;
                this.socket = null;
                TCPTransport.access$300().set(null);
                var23_16 = TCPTransport.access$700(TCPTransport.this);
                synchronized (var23_16) {
                    TCPTransport.access$700(TCPTransport.this).addElement(this);
                    return;
                }
            }
            var22_13 = null;
            TCPTransport.access$500(this.socket);
            if (TCPTransport.threadPooling == null) return;
            this.socket = null;
            TCPTransport.access$300().set(null);
            var23_17 = TCPTransport.access$700(TCPTransport.this);
            synchronized (var23_17) {
                TCPTransport.access$700(TCPTransport.this).addElement(this);
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (threadPooling != null) {
                Thread thread;
                Runnable runnable = thread = Thread.currentThread();
                synchronized (runnable) {
                    this.threadStarted = true;
                    thread.notify();
                }
                while (true) {
                    runnable = this;
                    synchronized (runnable) {
                        while (this.socket == null) {
                            try {
                                this.wait();
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        thread.setName(this.name);
                    }
                    this.handleRequest();
                }
            }
            this.handleRequest();
        }
    }
}

