/*
 * Decompiled with CFR 0.152.
 */
package sun.reflect;

import java.lang.reflect.Modifier;

public class Reflection {
    public static native Class getCallerClass(int var0);

    private static native int getClassAccessFlags(Class var0);

    public static boolean quickCheckMemberAccess(Class clazz, int n) {
        return Modifier.isPublic(Reflection.getClassAccessFlags(clazz) & n);
    }

    public static void ensureMemberAccess(Class clazz, Class clazz2, Object object, int n) throws IllegalAccessException {
        if (clazz == null || clazz2 == null) {
            throw new InternalError();
        }
        if (!Reflection.verifyMemberAccess(clazz, clazz2, object, n)) {
            throw new IllegalAccessException("Class " + clazz.getName() + " can not access a member of class " + clazz2.getName() + " with modifiers \"" + Modifier.toString(n) + "\"");
        }
    }

    public static boolean verifyMemberAccess(Class clazz, Class clazz2, Object object, int n) {
        boolean bl = false;
        boolean bl2 = false;
        if (clazz == clazz2) {
            return true;
        }
        if (!Modifier.isPublic(Reflection.getClassAccessFlags(clazz2))) {
            bl2 = Reflection.isSameClassPackage(clazz, clazz2);
            bl = true;
            if (!bl2) {
                return false;
            }
        }
        if (Modifier.isPublic(n)) {
            return true;
        }
        boolean bl3 = false;
        if (Modifier.isProtected(n) && Reflection.isSubclassOf(clazz, clazz2)) {
            bl3 = true;
        }
        if (!bl3 && !Modifier.isPrivate(n)) {
            if (!bl) {
                bl2 = Reflection.isSameClassPackage(clazz, clazz2);
                bl = true;
            }
            if (bl2) {
                bl3 = true;
            }
        }
        if (!bl3) {
            return false;
        }
        if (Modifier.isProtected(n)) {
            Class clazz3;
            Class clazz4 = clazz3 = object == null ? clazz2 : object.getClass();
            if (clazz3 != clazz) {
                if (!bl) {
                    bl2 = Reflection.isSameClassPackage(clazz, clazz2);
                    bl = true;
                }
                if (!bl2 && !Reflection.isSubclassOf(clazz3, clazz)) {
                    return false;
                }
            }
        }
        return true;
    }

    private static boolean isSameClassPackage(Class clazz, Class clazz2) {
        return Reflection.isSameClassPackage(clazz.getClassLoader(), clazz.getName(), clazz2.getClassLoader(), clazz2.getName());
    }

    private static boolean isSameClassPackage(ClassLoader classLoader, String string, ClassLoader classLoader2, String string2) {
        int n;
        int n2;
        if (classLoader != classLoader2) {
            return false;
        }
        int n3 = string.lastIndexOf(46);
        int n4 = string2.lastIndexOf(46);
        if (n3 == -1 || n4 == -1) {
            return n3 == n4;
        }
        int n5 = 0;
        int n6 = 0;
        if (string.charAt(n5) == '[') {
            while (string.charAt(++n5) == '[') {
            }
            if (string.charAt(n5) != 'L') {
                throw new InternalError("Illegal class name " + string);
            }
        }
        if (string2.charAt(n6) == '[') {
            while (string2.charAt(++n6) == '[') {
            }
            if (string2.charAt(n6) != 'L') {
                throw new InternalError("Illegal class name " + string2);
            }
        }
        if ((n2 = n3 - n5) != (n = n4 - n6)) {
            return false;
        }
        return string.regionMatches(false, n5, string2, n6, n2);
    }

    static boolean isSubclassOf(Class clazz, Class clazz2) {
        while (clazz != null) {
            if (clazz == clazz2) {
                return true;
            }
            clazz = clazz.getSuperclass();
        }
        return false;
    }
}

