/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import com.ibm.nio.Debug;
import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.Selector;
import java.nio.channels.spi.SelectorProvider;
import java.security.AccessController;
import java.util.Iterator;
import sun.nio.ch.AbstractPollSelectorImpl;
import sun.nio.ch.FileDispatcher;
import sun.nio.ch.IOUtil;
import sun.nio.ch.PollArrayWrapper;
import sun.nio.ch.SelectionKeyImpl;
import sun.security.action.GetIntegerAction;

class PollSelectorImpl
extends AbstractPollSelectorImpl {
    private int fd0;
    private int fd1;
    private Object interruptLock = new Object();
    private boolean interruptTriggered = false;
    private static final boolean debugKeys;
    private static final int noKeysUpdatedLoopThreshold;
    private int noKeysUpdatedLoopCounter = 0;

    PollSelectorImpl(SelectorProvider selectorProvider) {
        super(selectorProvider, 1, 1);
        int[] nArray = new int[2];
        IOUtil.initPipe(nArray, false);
        this.fd0 = nArray[0];
        this.fd1 = nArray[1];
        this.pollWrapper = new PollArrayWrapper(10);
        this.pollWrapper.initInterrupt(this.fd0, this.fd1);
        this.channelArray = new SelectionKeyImpl[10];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doSelect(long l) throws IOException {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (this.channelArray == null) {
            throw new ClosedSelectorException();
        }
        this.processDeregisterQueue();
        if (this.totalChannels == 0) {
            if (debugKeys) {
                ++this.noKeysUpdatedLoopCounter;
                debug.println("entered select with no channels!");
            }
            return 0;
        }
        if (debugKeys) {
            n2 = this.selectedKeys.size();
        }
        try {
            this.begin();
            n3 = this.pollWrapper.poll(this.interestingChannels, 0, l);
        }
        finally {
            this.end();
        }
        this.processDeregisterQueue();
        n = this.updateSelectedKeys();
        if (debugPollArray) {
            debug.println("poll() for this operation returned " + n3);
        }
        if (debugKeys) {
            this.noKeysUpdatedLoopCounter = n == 0 ? ++this.noKeysUpdatedLoopCounter : 0;
            if (this.noKeysUpdatedLoopCounter >= noKeysUpdatedLoopThreshold) {
                debug.println("Possible loop detected. No keys were updated for the previous " + this.noKeysUpdatedLoopCounter + " select operations.");
                if (this.pollWrapper.getReventOps(0) != 0) {
                    debug.println("This select was woken up, wakeup pipe has Revents " + this.pollWrapper.getReventOps(0));
                }
                debug.println("poll() for this operation returned " + n3 + ". There were " + n2 + " selected keys at the beginning of this operation.");
                int n4 = this.selectedKeys.size();
                debug.println("Selected key set " + (n4 == 0 ? "is empty" : "has " + n4 + " elements:"));
                if (n4 > 0) {
                    Iterator iterator = this.selectedKeys.iterator();
                    while (iterator.hasNext()) {
                        SelectionKeyImpl selectionKeyImpl = (SelectionKeyImpl)iterator.next();
                        StringBuffer stringBuffer = new StringBuffer("  ");
                        stringBuffer.append(selectionKeyImpl.channel());
                        stringBuffer.append(" fd ");
                        stringBuffer.append(selectionKeyImpl.channel.getFDVal());
                        try {
                            int n5 = selectionKeyImpl.readyOps();
                            stringBuffer.append(" with readyOps ");
                            stringBuffer.append(n5);
                        }
                        catch (CancelledKeyException cancelledKeyException) {
                            stringBuffer.append(" is cancelled");
                        }
                        debug.println(stringBuffer.toString());
                    }
                }
            }
        }
        if (this.pollWrapper.getReventOps(0) != 0) {
            this.pollWrapper.putReventOps(0, 0);
            Object object = this.interruptLock;
            synchronized (object) {
                IOUtil.drain(this.fd0);
                this.interruptTriggered = false;
            }
        }
        return n;
    }

    protected void implCloseInterrupt() throws IOException {
        FileDispatcher.closeIntFD(this.fd0);
        FileDispatcher.closeIntFD(this.fd1);
        this.fd0 = -1;
        this.fd1 = -1;
        this.pollWrapper.release(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Selector wakeup() {
        Object object = this.interruptLock;
        synchronized (object) {
            if (!this.interruptTriggered) {
                this.pollWrapper.interrupt();
                this.interruptTriggered = true;
            }
        }
        return this;
    }

    /*
     * Unable to fully structure code
     */
    static {
        if (PollSelectorImpl.debug == null) ** GOTO lbl-1000
        if (Debug.isOn("selectornoupdatedkeys")) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        PollSelectorImpl.debugKeys = v0;
        PollSelectorImpl.noKeysUpdatedLoopThreshold = (Integer)AccessController.doPrivileged(new GetIntegerAction("java.nio.debug.consecutiveNoUpdatedKeysThreshold", 300));
    }
}

