/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import sun.nio.ch.AbstractPollArrayWrapper;
import sun.nio.ch.AllocatedNativeObject;
import sun.nio.ch.IOUtil;
import sun.nio.ch.SelChImpl;

class PollArrayWrapper
extends AbstractPollArrayWrapper {
    static final short POLLCONN = 4;
    int interruptFD;

    PollArrayWrapper(int n) {
        n = (n + 1) * 8;
        this.pollArray = new AllocatedNativeObject(n, false);
        this.pollArrayAddress = this.pollArray.address();
        this.totalChannels = 1;
    }

    void initInterrupt(int n, int n2) {
        this.interruptFD = n2;
        this.putDescriptor(0, n);
        this.putEventOps(0, 1);
        this.putReventOps(0, 0);
    }

    void release(int n) {
    }

    void free() {
        this.pollArray.free();
    }

    void addEntry(SelChImpl selChImpl) {
        this.putDescriptor(this.totalChannels, IOUtil.fdVal(selChImpl.getFD()));
        this.putEventOps(this.totalChannels, 0);
        this.putReventOps(this.totalChannels, 0);
        ++this.totalChannels;
    }

    static void replaceEntry(PollArrayWrapper pollArrayWrapper, int n, PollArrayWrapper pollArrayWrapper2, int n2) {
        pollArrayWrapper2.putDescriptor(n2, pollArrayWrapper.getDescriptor(n));
        pollArrayWrapper2.putEventOps(n2, pollArrayWrapper.getEventOps(n));
        pollArrayWrapper2.putReventOps(n2, pollArrayWrapper.getReventOps(n));
    }

    static void swapEntry(PollArrayWrapper pollArrayWrapper, int n, PollArrayWrapper pollArrayWrapper2, int n2) {
        int n3 = pollArrayWrapper2.getDescriptor(n2);
        int n4 = pollArrayWrapper2.getEventOps(n2);
        int n5 = pollArrayWrapper2.getReventOps(n2);
        pollArrayWrapper2.putDescriptor(n2, pollArrayWrapper.getDescriptor(n));
        pollArrayWrapper2.putEventOps(n2, pollArrayWrapper.getEventOps(n));
        pollArrayWrapper2.putReventOps(n2, pollArrayWrapper.getReventOps(n));
        pollArrayWrapper.putDescriptor(n, n3);
        pollArrayWrapper.putEventOps(n, n4);
        pollArrayWrapper.putReventOps(n, n5);
    }

    void grow(int n) {
        PollArrayWrapper pollArrayWrapper = new PollArrayWrapper(n);
        for (int i = 0; i < this.totalChannels; ++i) {
            PollArrayWrapper.replaceEntry(this, i, pollArrayWrapper, i);
        }
        this.pollArray.free();
        this.pollArray = pollArrayWrapper.pollArray;
        this.pollArrayAddress = this.pollArray.address();
    }

    int poll(int n, int n2, long l) {
        return this.poll0(this.pollArrayAddress + (long)(n2 * 8), n, l);
    }

    public void interrupt() {
        PollArrayWrapper.interrupt(this.interruptFD);
    }

    private native int poll0(long var1, int var3, long var4);

    private static native void interrupt(int var0);
}

