/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import com.ibm.nio.Debug;
import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.channels.spi.SelectorProvider;
import sun.nio.ch.PollArrayWrapper;
import sun.nio.ch.SelChImpl;
import sun.nio.ch.SelectionKeyImpl;
import sun.nio.ch.SelectorImpl;
import sun.nio.ch.Util;

abstract class AbstractPollSelectorImpl
extends SelectorImpl {
    PollArrayWrapper pollWrapper;
    protected final int INIT_CAP = 10;
    protected SelectionKeyImpl[] channelArray;
    protected int channelOffset = 0;
    protected int totalChannels;
    protected int interestingChannels;
    private boolean closed = false;
    protected static final Debug debug = Debug.getInstance("selector");
    private static final boolean debugChannelArray;
    protected static final boolean debugPollArray;

    AbstractPollSelectorImpl(SelectorProvider selectorProvider, int n, int n2) {
        super(selectorProvider);
        this.totalChannels = n;
        this.interestingChannels = n;
        this.channelOffset = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void putEventOps(SelectionKeyImpl selectionKeyImpl, int n) {
        SelectionKeyImpl selectionKeyImpl2 = selectionKeyImpl;
        synchronized (selectionKeyImpl2) {
            this.pollWrapper.putEventOps(selectionKeyImpl.getIndex(), n);
            this.adjustInteresting(selectionKeyImpl, n);
        }
    }

    public Selector wakeup() {
        this.pollWrapper.interrupt();
        return this;
    }

    protected abstract int doSelect(long var1) throws IOException;

    protected void implClose() throws IOException {
        if (!this.closed) {
            this.closed = true;
            for (int i = this.channelOffset; i < this.totalChannels; ++i) {
                this.channelArray[i].setIndex(-1);
                this.deregister(this.channelArray[i]);
                SelectableChannel selectableChannel = this.channelArray[i].channel();
                if (selectableChannel.isOpen() || selectableChannel.isRegistered()) continue;
                ((SelChImpl)((Object)selectableChannel)).kill();
            }
            this.implCloseInterrupt();
            this.pollWrapper.free();
            this.pollWrapper = null;
            this.selectedKeys = null;
            this.channelArray = null;
            this.totalChannels = 0;
            this.interestingChannels = 0;
        }
    }

    protected abstract void implCloseInterrupt() throws IOException;

    protected int updateSelectedKeys() {
        int n;
        int n2 = 0;
        if (debugPollArray) {
            StringBuffer stringBuffer = null;
            stringBuffer = new StringBuffer("polled on {");
            for (n = 0; n < this.interestingChannels; ++n) {
                stringBuffer.append(' ');
                stringBuffer.append(this.pollWrapper.getDescriptor(n));
                stringBuffer.append('(');
                stringBuffer.append(this.pollWrapper.getEventOps(n));
                stringBuffer.append(',');
                stringBuffer.append(this.pollWrapper.getReventOps(n));
                stringBuffer.append(')');
                if (n == this.interestingChannels - 1) {
                    stringBuffer.append(" }");
                    debug.println(stringBuffer.toString());
                    continue;
                }
                stringBuffer.append(',');
            }
        }
        for (int i = this.channelOffset; i < this.interestingChannels; ++i) {
            try {
                n = this.pollWrapper.getReventOps(i);
                if (n == 0) continue;
                SelectionKeyImpl selectionKeyImpl = this.channelArray[i];
                this.pollWrapper.putReventOps(i, 0);
                if (this.selectedKeys.contains(selectionKeyImpl)) {
                    int n3 = selectionKeyImpl.readyOps();
                    selectionKeyImpl.channel.translateAndSetReadyOps(n, selectionKeyImpl);
                    if (selectionKeyImpl.readyOps() == n3) continue;
                    ++n2;
                    continue;
                }
                selectionKeyImpl.channel.translateAndSetReadyOps(n, selectionKeyImpl);
                if ((selectionKeyImpl.readyOps() & selectionKeyImpl.interestOps()) == 0) continue;
                this.selectedKeys.add(selectionKeyImpl);
                ++n2;
                continue;
            }
            catch (CancelledKeyException cancelledKeyException) {
                // empty catch block
            }
        }
        return n2;
    }

    private void checkChannelArrayAndPollWrapper() {
        if (debug == null) {
            return;
        }
        if (this.channelArray[0] != null) {
            debug.println("channelArray[0] should be null.");
        }
        for (int i = 1; i < this.totalChannels; ++i) {
            if (this.channelArray[i].getIndex() != i) {
                debug.println("selector error: i=" + i + ", channelArray[i].getIndex()=" + this.channelArray[i].getIndex());
            }
            if (this.pollWrapper.getDescriptor(i) == this.channelArray[i].channel.getFDVal()) continue;
            debug.println("selector error: pollWrapper.getDescriptor(i)=" + this.pollWrapper.getDescriptor(i) + "channelArray[i].channel.getFDVal()=" + this.channelArray[i].channel.getFDVal());
        }
    }

    private void outputChannelArray() {
        int n;
        if (debug == null) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 1; n < this.totalChannels; ++n) {
            char c = (char)(this.channelArray[n].channel.getFDVal() % 94 + 33);
            stringBuffer.append(c);
        }
        debug.println(stringBuffer.toString());
        stringBuffer = new StringBuffer();
        for (n = 1; n < this.totalChannels; ++n) {
            try {
                char c = this.channelArray[n].interestOps() == 0 ? (char)'0' : '1';
                stringBuffer.append(c);
                continue;
            }
            catch (CancelledKeyException cancelledKeyException) {
                stringBuffer.append('c');
            }
        }
        debug.println(stringBuffer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void swapChannels(int n, int n2) {
        if (0 > n || n >= this.totalChannels || 0 > n2 || n2 >= this.totalChannels) {
            throw new RuntimeException("Internal Selector problem, cannot swap channels " + n + " and " + n2);
        }
        if (n == n2) {
            return;
        }
        if (debugChannelArray) {
            this.checkChannelArrayAndPollWrapper();
            debug.println("Channel array, before adjusting:");
            this.outputChannelArray();
        }
        SelectionKeyImpl selectionKeyImpl = this.channelArray[n];
        SelectionKeyImpl selectionKeyImpl2 = this.channelArray[n2];
        SelectionKeyImpl selectionKeyImpl3 = selectionKeyImpl;
        synchronized (selectionKeyImpl3) {
            SelectionKeyImpl selectionKeyImpl4 = selectionKeyImpl2;
            synchronized (selectionKeyImpl4) {
                this.channelArray[n] = selectionKeyImpl2;
                this.channelArray[n2] = selectionKeyImpl;
                selectionKeyImpl.setIndex(n2);
                selectionKeyImpl2.setIndex(n);
                PollArrayWrapper.swapEntry(this.pollWrapper, n, this.pollWrapper, n2);
            }
        }
        if (debugChannelArray) {
            debug.println("Channel array, after adjusting:");
            this.outputChannelArray();
            this.checkChannelArrayAndPollWrapper();
        }
    }

    private void adjustInteresting(SelectionKeyImpl selectionKeyImpl, int n) {
        if (this.totalChannels <= 1 || this.interestingChannels < 1) {
            throw new RuntimeException("Internal Selector problem, cannot adjust. totalChannels=" + this.totalChannels + ", interestingChannels=" + this.interestingChannels);
        }
        if (selectionKeyImpl.getIndex() < this.interestingChannels) {
            if (n == 0) {
                int n2 = this.interestingChannels - 1;
                this.swapChannels(selectionKeyImpl.getIndex(), n2);
                --this.interestingChannels;
            }
        } else if (n != 0) {
            int n3 = this.interestingChannels++;
            this.swapChannels(selectionKeyImpl.getIndex(), n3);
        }
    }

    protected void implRegister(SelectionKeyImpl selectionKeyImpl) {
        if (this.channelArray.length == this.totalChannels) {
            int n = this.pollWrapper.totalChannels * 2;
            SelectionKeyImpl[] selectionKeyImplArray = new SelectionKeyImpl[n];
            for (int i = this.channelOffset; i < this.totalChannels; ++i) {
                selectionKeyImplArray[i] = this.channelArray[i];
            }
            this.channelArray = selectionKeyImplArray;
            this.pollWrapper.grow(n);
        }
        this.channelArray[this.totalChannels] = selectionKeyImpl;
        selectionKeyImpl.setIndex(this.totalChannels);
        this.pollWrapper.addEntry(selectionKeyImpl.channel);
        ++this.totalChannels;
        this.keys.add(selectionKeyImpl);
        try {
            this.adjustInteresting(selectionKeyImpl, selectionKeyImpl.interestOps());
        }
        catch (CancelledKeyException cancelledKeyException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void implDereg(SelectionKeyImpl selectionKeyImpl) throws IOException {
        SelectionKeyImpl selectionKeyImpl2 = selectionKeyImpl;
        synchronized (selectionKeyImpl2) {
            Object object;
            int n = selectionKeyImpl.getIndex();
            if (n >= this.totalChannels || n < 0) {
                throw new IOException("Internal Selector problem, trying to deregister key not in selector(totalChannels=" + this.totalChannels + ").");
            }
            if (this.channelArray[n] == selectionKeyImpl) {
                object = this.channelArray[this.totalChannels - 1];
                if (n != this.totalChannels - 1) {
                    Object object2 = object;
                    synchronized (object2) {
                        this.channelArray[n] = object;
                        ((SelectionKeyImpl)object).setIndex(n);
                        this.pollWrapper.release(n);
                        PollArrayWrapper.replaceEntry(this.pollWrapper, this.totalChannels - 1, this.pollWrapper, n);
                    }
                } else {
                    this.pollWrapper.release(n);
                }
                this.channelArray[this.totalChannels - 1] = null;
                --this.totalChannels;
                --this.pollWrapper.totalChannels;
                if (this.interestingChannels > this.totalChannels) {
                    this.interestingChannels = this.totalChannels;
                }
                try {
                    this.adjustInteresting((SelectionKeyImpl)object, ((SelectionKeyImpl)object).interestOps());
                }
                catch (CancelledKeyException cancelledKeyException) {
                    // empty catch block
                }
                selectionKeyImpl.setIndex(-1);
                this.keys.remove(selectionKeyImpl);
                this.selectedKeys.remove(selectionKeyImpl);
                this.deregister(selectionKeyImpl);
            }
            if (!((AbstractInterruptibleChannel)(object = selectionKeyImpl.channel())).isOpen() && !((SelectableChannel)object).isRegistered()) {
                ((SelChImpl)object).kill();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    static {
        if (AbstractPollSelectorImpl.debug == null) ** GOTO lbl-1000
        if (Debug.isOn("selectorchannelarray")) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = AbstractPollSelectorImpl.debugChannelArray = false;
        }
        if (AbstractPollSelectorImpl.debug == null) ** GOTO lbl-1000
        if (Debug.isOn("selectornative")) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        AbstractPollSelectorImpl.debugPollArray = v1;
        Util.load();
    }
}

