/*
 * Decompiled with CFR 0.152.
 */
package javax.naming.spi;

import javax.naming.CannotProceedException;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.spi.ContinuationContext;
import javax.naming.spi.DirContextNamePair;
import javax.naming.spi.DirContextStringPair;
import javax.naming.spi.NamingManager;
import javax.naming.spi.ResolveResult;
import javax.naming.spi.Resolver;

class ContinuationDirContext
extends ContinuationContext
implements DirContext {
    ContinuationDirContext(CannotProceedException cannotProceedException) {
        super(cannotProceedException);
    }

    protected DirContextNamePair getTargetContext(Name name) throws NamingException {
        if (this.cpe.getResolvedObj() == null) {
            throw (NamingException)this.cpe.fillInStackTrace();
        }
        Context context = NamingManager.getContext(this.cpe.getResolvedObj(), this.cpe.getAltName(), this.cpe.getAltNameCtx(), this.cpe.getEnvironment());
        if (context == null) {
            throw (NamingException)this.cpe.fillInStackTrace();
        }
        if (context instanceof DirContext) {
            return new DirContextNamePair((DirContext)context, name);
        }
        if (context instanceof Resolver) {
            Resolver resolver = (Resolver)((Object)context);
            ResolveResult resolveResult = resolver.resolveToClass(name, DirContext.class);
            DirContext dirContext = (DirContext)resolveResult.getResolvedObj();
            return new DirContextNamePair(dirContext, resolveResult.getRemainingName());
        }
        Object object = context.lookup(name);
        if (object instanceof DirContext) {
            return new DirContextNamePair((DirContext)object, new CompositeName());
        }
        throw (NamingException)this.cpe.fillInStackTrace();
    }

    protected DirContextStringPair getTargetContext(String string) throws NamingException {
        if (this.cpe.getResolvedObj() == null) {
            throw (NamingException)this.cpe.fillInStackTrace();
        }
        Context context = NamingManager.getContext(this.cpe.getResolvedObj(), this.cpe.getAltName(), this.cpe.getAltNameCtx(), this.cpe.getEnvironment());
        if (context instanceof DirContext) {
            return new DirContextStringPair((DirContext)context, string);
        }
        if (context instanceof Resolver) {
            Resolver resolver = (Resolver)((Object)context);
            ResolveResult resolveResult = resolver.resolveToClass(string, DirContext.class);
            DirContext dirContext = (DirContext)resolveResult.getResolvedObj();
            Name name = resolveResult.getRemainingName();
            String string2 = name != null ? name.toString() : "";
            return new DirContextStringPair(dirContext, string2);
        }
        Object object = context.lookup(string);
        if (object instanceof DirContext) {
            return new DirContextStringPair((DirContext)object, "");
        }
        throw (NamingException)this.cpe.fillInStackTrace();
    }

    public Attributes getAttributes(String string) throws NamingException {
        DirContextStringPair dirContextStringPair = this.getTargetContext(string);
        return dirContextStringPair.getDirContext().getAttributes(dirContextStringPair.getString());
    }

    public Attributes getAttributes(String string, String[] stringArray) throws NamingException {
        DirContextStringPair dirContextStringPair = this.getTargetContext(string);
        return dirContextStringPair.getDirContext().getAttributes(dirContextStringPair.getString(), stringArray);
    }

    public Attributes getAttributes(Name name) throws NamingException {
        DirContextNamePair dirContextNamePair = this.getTargetContext(name);
        return dirContextNamePair.getDirContext().getAttributes(dirContextNamePair.getName());
    }

    public Attributes getAttributes(Name name, String[] stringArray) throws NamingException {
        DirContextNamePair dirContextNamePair = this.getTargetContext(name);
        return dirContextNamePair.getDirContext().getAttributes(dirContextNamePair.getName(), stringArray);
    }

    public void modifyAttributes(Name name, int n, Attributes attributes) throws NamingException {
        DirContextNamePair dirContextNamePair = this.getTargetContext(name);
        dirContextNamePair.getDirContext().modifyAttributes(dirContextNamePair.getName(), n, attributes);
    }

    public void modifyAttributes(String string, int n, Attributes attributes) throws NamingException {
        DirContextStringPair dirContextStringPair = this.getTargetContext(string);
        dirContextStringPair.getDirContext().modifyAttributes(dirContextStringPair.getString(), n, attributes);
    }

    public void modifyAttributes(Name name, ModificationItem[] modificationItemArray) throws NamingException {
        DirContextNamePair dirContextNamePair = this.getTargetContext(name);
        dirContextNamePair.getDirContext().modifyAttributes(dirContextNamePair.getName(), modificationItemArray);
    }

    public void modifyAttributes(String string, ModificationItem[] modificationItemArray) throws NamingException {
        DirContextStringPair dirContextStringPair = this.getTargetContext(string);
        dirContextStringPair.getDirContext().modifyAttributes(dirContextStringPair.getString(), modificationItemArray);
    }

    public void bind(Name name, Object object, Attributes attributes) throws NamingException {
        DirContextNamePair dirContextNamePair = this.getTargetContext(name);
        dirContextNamePair.getDirContext().bind(dirContextNamePair.getName(), object, attributes);
    }

    public void bind(String string, Object object, Attributes attributes) throws NamingException {
        DirContextStringPair dirContextStringPair = this.getTargetContext(string);
        dirContextStringPair.getDirContext().bind(dirContextStringPair.getString(), object, attributes);
    }

    public void rebind(Name name, Object object, Attributes attributes) throws NamingException {
        DirContextNamePair dirContextNamePair = this.getTargetContext(name);
        dirContextNamePair.getDirContext().rebind(dirContextNamePair.getName(), object, attributes);
    }

    public void rebind(String string, Object object, Attributes attributes) throws NamingException {
        DirContextStringPair dirContextStringPair = this.getTargetContext(string);
        dirContextStringPair.getDirContext().rebind(dirContextStringPair.getString(), object, attributes);
    }

    public DirContext createSubcontext(Name name, Attributes attributes) throws NamingException {
        DirContextNamePair dirContextNamePair = this.getTargetContext(name);
        return dirContextNamePair.getDirContext().createSubcontext(dirContextNamePair.getName(), attributes);
    }

    public DirContext createSubcontext(String string, Attributes attributes) throws NamingException {
        DirContextStringPair dirContextStringPair = this.getTargetContext(string);
        return dirContextStringPair.getDirContext().createSubcontext(dirContextStringPair.getString(), attributes);
    }

    public NamingEnumeration search(Name name, Attributes attributes, String[] stringArray) throws NamingException {
        DirContextNamePair dirContextNamePair = this.getTargetContext(name);
        return dirContextNamePair.getDirContext().search(dirContextNamePair.getName(), attributes, stringArray);
    }

    public NamingEnumeration search(String string, Attributes attributes, String[] stringArray) throws NamingException {
        DirContextStringPair dirContextStringPair = this.getTargetContext(string);
        return dirContextStringPair.getDirContext().search(dirContextStringPair.getString(), attributes, stringArray);
    }

    public NamingEnumeration search(Name name, Attributes attributes) throws NamingException {
        DirContextNamePair dirContextNamePair = this.getTargetContext(name);
        return dirContextNamePair.getDirContext().search(dirContextNamePair.getName(), attributes);
    }

    public NamingEnumeration search(String string, Attributes attributes) throws NamingException {
        DirContextStringPair dirContextStringPair = this.getTargetContext(string);
        return dirContextStringPair.getDirContext().search(dirContextStringPair.getString(), attributes);
    }

    public NamingEnumeration search(Name name, String string, SearchControls searchControls) throws NamingException {
        DirContextNamePair dirContextNamePair = this.getTargetContext(name);
        return dirContextNamePair.getDirContext().search(dirContextNamePair.getName(), string, searchControls);
    }

    public NamingEnumeration search(String string, String string2, SearchControls searchControls) throws NamingException {
        DirContextStringPair dirContextStringPair = this.getTargetContext(string);
        return dirContextStringPair.getDirContext().search(dirContextStringPair.getString(), string2, searchControls);
    }

    public NamingEnumeration search(Name name, String string, Object[] objectArray, SearchControls searchControls) throws NamingException {
        DirContextNamePair dirContextNamePair = this.getTargetContext(name);
        return dirContextNamePair.getDirContext().search(dirContextNamePair.getName(), string, objectArray, searchControls);
    }

    public NamingEnumeration search(String string, String string2, Object[] objectArray, SearchControls searchControls) throws NamingException {
        DirContextStringPair dirContextStringPair = this.getTargetContext(string);
        return dirContextStringPair.getDirContext().search(dirContextStringPair.getString(), string2, objectArray, searchControls);
    }

    public DirContext getSchema(String string) throws NamingException {
        DirContextStringPair dirContextStringPair = this.getTargetContext(string);
        return dirContextStringPair.getDirContext().getSchema(dirContextStringPair.getString());
    }

    public DirContext getSchema(Name name) throws NamingException {
        DirContextNamePair dirContextNamePair = this.getTargetContext(name);
        return dirContextNamePair.getDirContext().getSchema(dirContextNamePair.getName());
    }

    public DirContext getSchemaClassDefinition(String string) throws NamingException {
        DirContextStringPair dirContextStringPair = this.getTargetContext(string);
        return dirContextStringPair.getDirContext().getSchemaClassDefinition(dirContextStringPair.getString());
    }

    public DirContext getSchemaClassDefinition(Name name) throws NamingException {
        DirContextNamePair dirContextNamePair = this.getTargetContext(name);
        return dirContextNamePair.getDirContext().getSchemaClassDefinition(dirContextNamePair.getName());
    }
}

