/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public class GZIPInputStream
extends InflaterInputStream {
    protected CRC32 crc = new CRC32();
    protected boolean eos;
    private boolean closed = false;
    public static final int GZIP_MAGIC = 35615;
    private static final int FTEXT = 1;
    private static final int FHCRC = 2;
    private static final int FEXTRA = 4;
    private static final int FNAME = 8;
    private static final int FCOMMENT = 16;
    private byte[] tmpbuf = new byte[128];

    private void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
    }

    public GZIPInputStream(InputStream inputStream, int n) throws IOException {
        super(inputStream, new Inflater(true), n);
        this.usesDefaultInflater = true;
        this.readHeader();
        this.crc.reset();
    }

    public GZIPInputStream(InputStream inputStream) throws IOException {
        this(inputStream, 512);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.ensureOpen();
        if (this.eos) {
            return -1;
        }
        if ((n2 = super.read(byArray, n, n2)) == -1) {
            this.readTrailer();
            this.eos = true;
        } else {
            this.crc.update(byArray, n, n2);
        }
        return n2;
    }

    public void close() throws IOException {
        if (!this.closed) {
            super.close();
            this.eos = true;
            this.closed = true;
        }
    }

    private void readHeader() throws IOException {
        CheckedInputStream checkedInputStream = new CheckedInputStream(this.in, this.crc);
        this.crc.reset();
        if (this.readUShort(checkedInputStream) != 35615) {
            throw new IOException("Not in GZIP format");
        }
        if (this.readUByte(checkedInputStream) != 8) {
            throw new IOException("Unsupported compression method");
        }
        int n = this.readUByte(checkedInputStream);
        this.skipBytes(checkedInputStream, 6);
        if ((n & 4) == 4) {
            this.skipBytes(checkedInputStream, this.readUShort(checkedInputStream));
        }
        if ((n & 8) == 8) {
            while (this.readUByte(checkedInputStream) != 0) {
            }
        }
        if ((n & 0x10) == 16) {
            while (this.readUByte(checkedInputStream) != 0) {
            }
        }
        if ((n & 2) == 2) {
            int n2 = (int)this.crc.getValue() & 0xFFFF;
            if (this.readUShort(checkedInputStream) != n2) {
                throw new IOException("Corrupt GZIP header");
            }
        }
    }

    private void readTrailer() throws IOException {
        InputStream inputStream = this.in;
        int n = this.inf.getRemaining();
        if (n > 0) {
            inputStream = new SequenceInputStream(new ByteArrayInputStream(this.buf, this.len - n, n), inputStream);
        }
        long l = this.crc.getValue();
        if (this.readUInt(inputStream) != l || this.readUInt(inputStream) != ((long)this.inf.getTotalOut() & 0xFFFFFFFFL)) {
            throw new IOException("Corrupt GZIP trailer");
        }
    }

    private long readUInt(InputStream inputStream) throws IOException {
        long l = this.readUShort(inputStream);
        return (long)this.readUShort(inputStream) << 16 | l;
    }

    private int readUShort(InputStream inputStream) throws IOException {
        int n = this.readUByte(inputStream);
        return this.readUByte(inputStream) << 8 | n;
    }

    private int readUByte(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        if (n == -1) {
            throw new EOFException();
        }
        return n;
    }

    private void skipBytes(InputStream inputStream, int n) throws IOException {
        while (n > 0) {
            int n2 = inputStream.read(this.tmpbuf, 0, n < this.tmpbuf.length ? n : this.tmpbuf.length);
            if (n2 == -1) {
                throw new EOFException();
            }
            n -= n2;
        }
    }
}

