/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import com.ibm.jvm.ExtendedSystem;
import java.util.TimerTask;

class TaskQueue {
    private TimerTask[] queue = new TimerTask[128];
    private int size = 0;

    TaskQueue() {
    }

    void add(TimerTask timerTask) {
        if (++this.size == this.queue.length) {
            this.queue = (TimerTask[])ExtendedSystem.resizeArray(2 * this.queue.length, this.queue, 0, this.size);
        }
        this.queue[this.size] = timerTask;
        this.fixUp(this.size);
    }

    TimerTask getMin() {
        return this.queue[1];
    }

    void removeMin() {
        this.queue[1] = this.queue[this.size];
        this.queue[this.size--] = null;
        this.fixDown(1);
    }

    void rescheduleMin(long l) {
        this.queue[1].nextExecutionTime = l;
        this.fixDown(1);
    }

    boolean isEmpty() {
        return this.size == 0;
    }

    void clear() {
        for (int i = 1; i <= this.size; ++i) {
            this.queue[i] = null;
        }
        this.size = 0;
    }

    private void fixUp(int n) {
        while (n > 1) {
            int n2 = n >> 1;
            if (this.queue[n2].nextExecutionTime <= this.queue[n].nextExecutionTime) break;
            TimerTask timerTask = this.queue[n2];
            this.queue[n2] = this.queue[n];
            this.queue[n] = timerTask;
            n = n2;
        }
    }

    private void fixDown(int n) {
        int n2;
        while ((n2 = n << 1) <= this.size) {
            if (n2 < this.size && this.queue[n2].nextExecutionTime > this.queue[n2 + 1].nextExecutionTime) {
                ++n2;
            }
            if (this.queue[n].nextExecutionTime <= this.queue[n2].nextExecutionTime) break;
            TimerTask timerTask = this.queue[n2];
            this.queue[n2] = this.queue[n];
            this.queue[n] = timerTask;
            n = n2;
        }
    }
}

