/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.CharacterIterator;
import java.text.EntryPair;
import java.text.RBCollationTables;
import java.text.RuleBasedCollator;
import java.util.Vector;
import sun.text.Normalizer;
import sun.text.NormalizerUtilities;

public final class CollationElementIterator {
    public static final int NULLORDER = -1;
    static final int UNMAPPEDCHARVALUE = 0x7FFF0000;
    private Normalizer text = null;
    private int[] buffer = null;
    private int[] ownBuffer = new int[2];
    private int expIndex = 0;
    private StringBuffer key = new StringBuffer(5);
    private int swapOrder = 0;
    private RBCollationTables ordering;
    private RuleBasedCollator owner;

    CollationElementIterator(String string, RuleBasedCollator ruleBasedCollator) {
        this.owner = ruleBasedCollator;
        this.ordering = ruleBasedCollator.getTables();
        if (string.length() != 0) {
            Normalizer.Mode mode = NormalizerUtilities.toNormalizerMode(ruleBasedCollator.getDecomposition());
            this.text = new Normalizer(string, mode);
        }
    }

    CollationElementIterator(CharacterIterator characterIterator, RuleBasedCollator ruleBasedCollator) {
        this.owner = ruleBasedCollator;
        this.ordering = ruleBasedCollator.getTables();
        Normalizer.Mode mode = NormalizerUtilities.toNormalizerMode(ruleBasedCollator.getDecomposition());
        this.text = new Normalizer(characterIterator, mode);
    }

    public void reset() {
        if (this.text != null) {
            this.text.reset();
            Normalizer.Mode mode = NormalizerUtilities.toNormalizerMode(this.owner.getDecomposition());
            this.text.setMode(mode);
        }
        this.buffer = null;
        this.expIndex = 0;
    }

    public int next() {
        char c;
        Normalizer.Mode mode;
        if (this.text == null) {
            return -1;
        }
        Normalizer.Mode mode2 = this.text.getMode();
        if (mode2 != (mode = NormalizerUtilities.toNormalizerMode(this.owner.getDecomposition()))) {
            this.text.setMode(mode);
        }
        if (this.buffer != null) {
            if (this.expIndex < this.buffer.length) {
                return this.strengthOrder(this.buffer[this.expIndex++]);
            }
            this.buffer = null;
        }
        if ((c = this.text.next()) == '\uffff') {
            return -1;
        }
        int n = this.ordering.getUnicodeOrder(c);
        if (n == -1) {
            this.ownBuffer[0] = 0x7FFF0000;
            this.ownBuffer[1] = c << 16;
            this.buffer = this.ownBuffer;
        } else if (n >= 0x7F000000) {
            n = this.nextContractChar(c);
        }
        if (n >= 0x7E000000) {
            this.buffer = this.ordering.getExpandValueList(n);
        }
        if (this.ordering.isSEAsianSwapping()) {
            char c2;
            if (CollationElementIterator.isThaiPreVowel(c)) {
                c2 = this.text.next();
                if (c2 == '\uffff') {
                    return -1;
                }
                if (CollationElementIterator.isThaiBaseConsonant(c2)) {
                    this.buffer = this.makeReorderedBuffer(c2, n, this.buffer, true);
                } else {
                    this.text.previous();
                }
            }
            if (CollationElementIterator.isLaoPreVowel(c)) {
                c2 = this.text.next();
                if (c2 == '\uffff') {
                    return -1;
                }
                if (CollationElementIterator.isLaoBaseConsonant(c2)) {
                    this.buffer = this.makeReorderedBuffer(c2, n, this.buffer, true);
                } else {
                    this.text.previous();
                }
            }
        }
        if (this.buffer != null) {
            this.expIndex = 1;
            n = this.buffer[0];
        }
        return this.strengthOrder(n);
    }

    public int previous() {
        char c;
        Normalizer.Mode mode;
        if (this.text == null) {
            return -1;
        }
        Normalizer.Mode mode2 = this.text.getMode();
        if (mode2 != (mode = NormalizerUtilities.toNormalizerMode(this.owner.getDecomposition()))) {
            this.text.setMode(mode);
        }
        if (this.buffer != null) {
            if (this.expIndex > 0) {
                return this.strengthOrder(this.buffer[--this.expIndex]);
            }
            this.buffer = null;
        }
        if ((c = this.text.previous()) == '\uffff') {
            return -1;
        }
        int n = this.ordering.getUnicodeOrder(c);
        if (n == -1) {
            this.ownBuffer[0] = 0x7FFF0000;
            this.ownBuffer[1] = c << 16;
            this.buffer = this.ownBuffer;
        } else {
            if (n >= 0x7F000000) {
                n = this.prevContractChar(c);
            }
            if (n >= 0x7E000000) {
                this.buffer = this.ordering.getExpandValueList(n);
            }
            if (this.ordering.isSEAsianSwapping()) {
                char c2 = this.text.previous();
                if (CollationElementIterator.isThaiBaseConsonant(c)) {
                    if (CollationElementIterator.isThaiPreVowel(c2)) {
                        this.buffer = this.makeReorderedBuffer(c2, n, this.buffer, false);
                    } else {
                        this.text.next();
                    }
                }
                if (CollationElementIterator.isLaoBaseConsonant(c)) {
                    c2 = this.text.previous();
                    if (CollationElementIterator.isLaoPreVowel(c2)) {
                        this.buffer = this.makeReorderedBuffer(c2, n, this.buffer, false);
                        this.expIndex = this.buffer.length - 1;
                        n = this.buffer[this.expIndex];
                    } else {
                        this.text.next();
                    }
                }
            }
        }
        if (this.buffer != null) {
            this.expIndex = this.buffer.length - 1;
            n = this.buffer[this.expIndex];
        }
        return this.strengthOrder(n);
    }

    public static final int primaryOrder(int n) {
        return (n &= 0xFFFF0000) >>> 16;
    }

    public static final short secondaryOrder(int n) {
        return (short)((n &= 0xFF00) >> 8);
    }

    public static final short tertiaryOrder(int n) {
        return (short)(n &= 0xFF);
    }

    final int strengthOrder(int n) {
        int n2 = this.owner.getStrength();
        if (n2 == 0) {
            n &= 0xFFFF0000;
        } else if (n2 == 1) {
            n &= 0xFFFFFF00;
        }
        return n;
    }

    public void setOffset(int n) {
        if (this.text != null) {
            if (n < this.text.getBeginIndex() || n >= this.text.getEndIndex()) {
                this.text.setIndexOnly(n);
            } else {
                char c = this.text.setIndex(n);
                if (this.ordering.usedInContractSeq(c)) {
                    while (this.ordering.usedInContractSeq(c)) {
                        c = this.text.previous();
                    }
                    int n2 = this.text.getIndex();
                    while (this.text.getIndex() <= n) {
                        n2 = this.text.getIndex();
                        this.next();
                    }
                    this.text.setIndexOnly(n2);
                }
            }
        }
        this.buffer = null;
        this.expIndex = 0;
        this.swapOrder = 0;
    }

    public int getOffset() {
        return this.text != null ? this.text.getIndex() : 0;
    }

    public int getMaxExpansion(int n) {
        return this.ordering.getMaxExpansion(n);
    }

    public void setText(String string) {
        this.buffer = null;
        Normalizer.Mode mode = NormalizerUtilities.toNormalizerMode(this.owner.getDecomposition());
        if (this.text == null) {
            this.text = new Normalizer(string, mode);
        } else {
            this.text.setMode(mode);
            this.text.setText(string);
        }
    }

    public void setText(CharacterIterator characterIterator) {
        this.buffer = null;
        Normalizer.Mode mode = NormalizerUtilities.toNormalizerMode(this.owner.getDecomposition());
        if (this.text == null) {
            this.text = new Normalizer(characterIterator, mode);
        } else {
            this.text.setMode(mode);
            this.text.setText(characterIterator);
        }
    }

    private static final boolean isThaiPreVowel(char c) {
        return c >= '\u0e40' && c <= '\u0e44';
    }

    private static final boolean isThaiBaseConsonant(char c) {
        return c >= '\u0e01' && c <= '\u0e2e';
    }

    private static final boolean isLaoPreVowel(char c) {
        return c >= '\u0ec0' && c <= '\u0ec4';
    }

    private static final boolean isLaoBaseConsonant(char c) {
        return c >= '\u0e81' && c <= '\u0eae';
    }

    private int[] makeReorderedBuffer(char c, int n, int[] nArray, boolean bl) {
        int[] nArray2;
        int n2;
        int n3 = this.ordering.getUnicodeOrder(c);
        if (n3 >= 0x7F000000) {
            n3 = bl ? this.nextContractChar(c) : this.prevContractChar(c);
        }
        int[] nArray3 = null;
        if (n3 >= 0x7E000000) {
            nArray3 = this.ordering.getExpandValueList(n3);
        }
        if (!bl) {
            n2 = n3;
            n3 = n;
            n = n2;
            int[] nArray4 = nArray3;
            nArray3 = nArray;
            nArray = nArray4;
        }
        if (nArray3 == null && nArray == null) {
            nArray2 = new int[]{n3, n};
        } else {
            n2 = nArray3 == null ? 1 : nArray3.length;
            int n4 = nArray == null ? 1 : nArray.length;
            nArray2 = new int[n2 + n4];
            if (nArray3 == null) {
                nArray2[0] = n3;
            } else {
                System.arraycopy(nArray3, 0, nArray2, 0, n2);
            }
            if (nArray == null) {
                nArray2[n2] = n;
            } else {
                System.arraycopy(nArray, 0, nArray2, n2, n4);
            }
        }
        return nArray2;
    }

    static final boolean isIgnorable(int n) {
        return CollationElementIterator.primaryOrder(n) == 0;
    }

    private int nextContractChar(char c) {
        int n;
        Vector vector = this.ordering.getContractValues(c);
        EntryPair entryPair = (EntryPair)vector.firstElement();
        int n2 = entryPair.value;
        entryPair = (EntryPair)vector.lastElement();
        Normalizer normalizer = (Normalizer)this.text.clone();
        normalizer.previous();
        this.key.setLength(0);
        char c2 = normalizer.next();
        for (n = entryPair.entryName.length(); n > 0 && c2 != '\uffff'; --n) {
            this.key.append(c2);
            c2 = normalizer.next();
        }
        String string = this.key.toString();
        n = 1;
        for (int i = vector.size() - 1; i > 0; --i) {
            entryPair = (EntryPair)vector.elementAt(i);
            if (!entryPair.fwd || !string.startsWith(entryPair.entryName) || entryPair.entryName.length() <= n) continue;
            n = entryPair.entryName.length();
            n2 = entryPair.value;
        }
        while (n > 1) {
            this.text.next();
            --n;
        }
        return n2;
    }

    private int prevContractChar(char c) {
        int n;
        Vector vector = this.ordering.getContractValues(c);
        EntryPair entryPair = (EntryPair)vector.firstElement();
        int n2 = entryPair.value;
        entryPair = (EntryPair)vector.lastElement();
        Normalizer normalizer = (Normalizer)this.text.clone();
        normalizer.next();
        this.key.setLength(0);
        char c2 = normalizer.previous();
        for (n = entryPair.entryName.length(); n > 0 && c2 != '\uffff'; --n) {
            this.key.append(c2);
            c2 = normalizer.previous();
        }
        String string = this.key.toString();
        n = 1;
        for (int i = vector.size() - 1; i > 0; --i) {
            entryPair = (EntryPair)vector.elementAt(i);
            if (entryPair.fwd || !string.startsWith(entryPair.entryName) || entryPair.entryName.length() <= n) continue;
            n = entryPair.entryName.length();
            n2 = entryPair.value;
        }
        while (n > 1) {
            this.text.previous();
            --n;
        }
        return n2;
    }
}

