/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import com.ibm.jvm.ClassLoaderDiagnosticsHelper;
import com.ibm.jvm.ExtendedSystem;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.FactoryURLClassLoader;
import java.net.JarURLConnection;
import java.net.SocketPermission;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandlerFactory;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.SecureClassLoader;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import sun.misc.Launcher;
import sun.misc.Resource;
import sun.misc.URLClassPath;
import sun.net.www.ParseUtil;

public class URLClassLoader
extends SecureClassLoader {
    private URLClassPath ucp;
    private URL[] cachedURLs;
    private URLStreamHandlerFactory cachedFactory;
    private AccessControlContext acc;
    private ClassFinder loader = new ClassFinder();
    private static Vector showClassLoadingFor = null;
    private static boolean showLoadingMessages = false;
    private static final String showClassLoadingProperty = "ibm.cl.verbose";
    private static URLClassLoader extLoader;
    private static boolean attemptedExtLoader;

    public URLClassLoader(URL[] uRLArray, ClassLoader classLoader) {
        super(classLoader);
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkCreateClassLoader();
        }
        if (uRLArray.length >= 0) {
            this.cachedURLs = uRLArray;
        }
        this.acc = AccessController.getContext();
        this.loader.classloader = this;
    }

    public URLClassLoader(URL[] uRLArray) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkCreateClassLoader();
        }
        if (uRLArray.length >= 0) {
            this.cachedURLs = uRLArray;
        }
        this.acc = AccessController.getContext();
        this.loader.classloader = this;
    }

    public URLClassLoader(URL[] uRLArray, ClassLoader classLoader, URLStreamHandlerFactory uRLStreamHandlerFactory) {
        super(classLoader);
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkCreateClassLoader();
        }
        if (uRLArray.length >= 0) {
            this.cachedURLs = uRLArray;
        }
        this.cachedFactory = uRLStreamHandlerFactory;
        this.acc = AccessController.getContext();
        this.loader.classloader = this;
    }

    protected void addURL(URL uRL) {
        this.getUCP().addURL(uRL);
    }

    public URL[] getURLs() {
        return this.getUCP().getURLs();
    }

    private URLClassPath getUCP() {
        if (this.ucp == null) {
            this.ucp = this.cachedFactory != null ? new URLClassPath(this.cachedURLs, this.cachedFactory) : new URLClassPath(this.cachedURLs);
        }
        return this.ucp;
    }

    private static final String ibmJVMGetExcludedFields() {
        return new String("extloader");
    }

    private boolean showClassLoading(String string) {
        if (showLoadingMessages) {
            Enumeration enumeration = showClassLoadingFor.elements();
            while (enumeration.hasMoreElements()) {
                Pattern pattern = (Pattern)enumeration.nextElement();
                Matcher matcher = pattern.matcher(string);
                if (!matcher.matches()) continue;
                return true;
            }
        }
        return false;
    }

    protected Class findClass(String string) throws ClassNotFoundException {
        try {
            Class clazz;
            this.loader.name = string;
            boolean bl = this.showClassLoading(string);
            if (bl) {
                ClassLoaderDiagnosticsHelper.attemptingToLoadClass(this, string);
            }
            if ((clazz = (Class)AccessController.doPrivileged(this.loader, this.acc)) == null) {
                if (bl) {
                    ClassLoaderDiagnosticsHelper.failedToLoadClass(this, string);
                }
                throw new ClassNotFoundException(string);
            }
            if (bl) {
                ClassLoaderDiagnosticsHelper.loadedClass(this, string);
            }
            return clazz;
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (ClassNotFoundException)privilegedActionException.getException();
        }
    }

    private Class defineClass(String string, Resource resource) throws IOException {
        Object object;
        Certificate[] certificateArray;
        Object object2;
        int n = string.lastIndexOf(46);
        URL uRL = resource.getCodeSourceURL();
        if (n != -1) {
            object2 = string.substring(0, n);
            certificateArray = this.getPackage((String)object2);
            object = resource.getManifest();
            if (certificateArray != null) {
                if (certificateArray.isSealed()) {
                    if (!certificateArray.isSealed(uRL)) {
                        throw new SecurityException("sealing violation: package " + (String)object2 + " is sealed");
                    }
                } else if (object != null && this.isSealed((String)object2, (Manifest)object)) {
                    throw new SecurityException("sealing violation: can't seal package " + (String)object2 + ": already loaded");
                }
            } else {
                if (this == URLClassLoader.getStandardExtensionClassLoader()) {
                    Object object3;
                    Object object4;
                    String string2 = null;
                    if (null != object && null == (string2 = ((Attributes)(object4 = ((Manifest)object).getMainAttributes())).getValue(ExtendedSystem.EXTENSION_COMPATIBLE))) {
                        object3 = ((Manifest)object).getEntries();
                        Set set = object3.keySet();
                        Iterator iterator = set.iterator();
                        while (iterator.hasNext() && null == string2) {
                            object4 = ((Manifest)object).getAttributes((String)iterator.next());
                            string2 = ((Attributes)object4).getValue(ExtendedSystem.EXTENSION_COMPATIBLE);
                        }
                    }
                    if (null == string2) {
                        object4 = new File(uRL.getFile());
                        object3 = ((File)object4).getCanonicalPath();
                        ExtendedSystem.setJVMUnresettableConditionally(65556, new String("Unchecked extension loading class: " + string + " from path " + (String)object3));
                    }
                }
                if (object != null) {
                    this.definePackage((String)object2, (Manifest)object, uRL);
                } else {
                    this.definePackage((String)object2, null, null, null, null, null, null, null);
                }
            }
        }
        object2 = resource.getBytes();
        certificateArray = resource.getCertificates();
        object = new CodeSource(uRL, certificateArray);
        return this.defineClass(string, (byte[])object2, 0, ((byte[])object2).length, (CodeSource)object);
    }

    private static ClassLoader getStandardExtensionClassLoader() {
        if (!attemptedExtLoader) {
            attemptedExtLoader = true;
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        Launcher launcher = Launcher.getLauncher();
                        Class clazz = launcher.getClass();
                        Field field = clazz.getDeclaredField("extLoader");
                        field.setAccessible(true);
                        extLoader = (URLClassLoader)field.get(launcher);
                        field.setAccessible(false);
                        return Boolean.TRUE;
                    }
                    catch (Exception exception) {
                        throw new InternalError(exception.toString());
                    }
                }
            });
        }
        return extLoader;
    }

    private static File[] getCheckedExtDirs() {
        File[] fileArray;
        String string = System.getProperty("java.checked.ext.dirs");
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
            int n = stringTokenizer.countTokens();
            fileArray = new File[n];
            for (int i = 0; i < n; ++i) {
                fileArray[i] = new File(stringTokenizer.nextToken());
            }
        } else {
            fileArray = new File[]{};
        }
        return fileArray;
    }

    private static Vector getCheckedExtURLs(File[] fileArray) throws IOException {
        Vector vector = new Vector();
        for (int i = 0; i < fileArray.length; ++i) {
            String[] stringArray = fileArray[i].list();
            if (stringArray == null) continue;
            for (int j = 0; j < stringArray.length; ++j) {
                File file = new File(fileArray[i], stringArray[j]);
                vector.add(file.getCanonicalPath());
            }
        }
        return vector;
    }

    protected Package definePackage(String string, Manifest manifest, URL uRL) throws IllegalArgumentException {
        String string2 = string.replace('.', '/').concat("/");
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        URL uRL2 = null;
        Attributes attributes = manifest.getAttributes(string2);
        if (attributes != null) {
            string3 = attributes.getValue(Attributes.Name.SPECIFICATION_TITLE);
            string4 = attributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
            string5 = attributes.getValue(Attributes.Name.SPECIFICATION_VENDOR);
            string6 = attributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            string7 = attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            string8 = attributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            string9 = attributes.getValue(Attributes.Name.SEALED);
        }
        if ((attributes = manifest.getMainAttributes()) != null) {
            if (string3 == null) {
                string3 = attributes.getValue(Attributes.Name.SPECIFICATION_TITLE);
            }
            if (string4 == null) {
                string4 = attributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
            }
            if (string5 == null) {
                string5 = attributes.getValue(Attributes.Name.SPECIFICATION_VENDOR);
            }
            if (string6 == null) {
                string6 = attributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            }
            if (string7 == null) {
                string7 = attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            }
            if (string8 == null) {
                string8 = attributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            }
            if (string9 == null) {
                string9 = attributes.getValue(Attributes.Name.SEALED);
            }
        }
        if ("true".equalsIgnoreCase(string9)) {
            uRL2 = uRL;
        }
        return this.definePackage(string, string3, string4, string5, string6, string7, string8, uRL2);
    }

    private boolean isSealed(String string, Manifest manifest) {
        String string2 = string.replace('.', '/').concat("/");
        Attributes attributes = manifest.getAttributes(string2);
        String string3 = null;
        if (attributes != null) {
            string3 = attributes.getValue(Attributes.Name.SEALED);
        }
        if (string3 == null && (attributes = manifest.getMainAttributes()) != null) {
            string3 = attributes.getValue(Attributes.Name.SEALED);
        }
        return "true".equalsIgnoreCase(string3);
    }

    public URL findResource(String string) {
        if (null == string) {
            return null;
        }
        final String string2 = new String(string);
        URL uRL = (URL)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return URLClassLoader.this.getUCP().findResource(string2, true);
            }
        }, this.acc);
        return uRL != null ? this.getUCP().checkURL(uRL) : null;
    }

    public Enumeration findResources(String string) throws IOException {
        final Enumeration enumeration = this.getUCP().findResources(string, true);
        return new Enumeration(){
            private URL url = null;

            private boolean next() {
                URL uRL;
                if (this.url != null) {
                    return true;
                }
                while ((uRL = (URL)AccessController.doPrivileged(new PrivilegedAction(this){
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public Object run() {
                        if (!3.access$200(this.this$1).hasMoreElements()) {
                            return null;
                        }
                        return 3.access$200(this.this$1).nextElement();
                    }
                }, URLClassLoader.this.acc)) != null) {
                    this.url = URLClassLoader.this.getUCP().checkURL(uRL);
                    if (this.url == null) continue;
                }
                return this.url != null;
            }

            public Object nextElement() {
                if (!this.next()) {
                    throw new NoSuchElementException();
                }
                URL uRL = this.url;
                this.url = null;
                return uRL;
            }

            public boolean hasMoreElements() {
                return this.next();
            }

            static /* synthetic */ Enumeration access$200(3 var0) {
                return var0.enumeration;
            }
        };
    }

    protected PermissionCollection getPermissions(CodeSource codeSource) {
        Object object;
        Object object2;
        Permission permission;
        URLConnection uRLConnection;
        PermissionCollection permissionCollection = super.getPermissions(codeSource);
        URL uRL = codeSource.getLocation();
        try {
            uRLConnection = uRL.openConnection();
            permission = uRLConnection.getPermission();
        }
        catch (IOException iOException) {
            permission = null;
            uRLConnection = null;
        }
        if (permission instanceof FilePermission) {
            object2 = permission.getName();
            if (((String)object2).endsWith(File.separator)) {
                object2 = (String)object2 + "-";
                permission = new FilePermission((String)object2, "read");
            }
        } else if (permission == null && uRL.getProtocol().equals("file")) {
            object2 = uRL.getFile().replace('/', File.separatorChar);
            if (((String)(object2 = ParseUtil.decode((String)object2))).endsWith(File.separator)) {
                object2 = (String)object2 + "-";
            }
            permission = new FilePermission((String)object2, "read");
        } else {
            object2 = uRL;
            if (uRLConnection instanceof JarURLConnection) {
                object2 = ((JarURLConnection)uRLConnection).getJarFileURL();
            }
            if ((object = ((URL)object2).getHost()) == null) {
                object = "localhost";
            }
            permission = new SocketPermission((String)object, "connect,accept");
        }
        if (permission != null) {
            object2 = System.getSecurityManager();
            if (object2 != null) {
                object = permission;
                AccessController.doPrivileged(new PrivilegedAction((SecurityManager)object2, (Permission)object){
                    private final /* synthetic */ SecurityManager val$sm;
                    private final /* synthetic */ Permission val$fp;
                    {
                        this.val$sm = securityManager;
                        this.val$fp = permission;
                    }

                    public Object run() throws SecurityException {
                        this.val$sm.checkPermission(this.val$fp);
                        return null;
                    }
                }, this.acc);
            }
            permissionCollection.add(permission);
        }
        return permissionCollection;
    }

    public static URLClassLoader newInstance(final URL[] uRLArray, final ClassLoader classLoader) {
        AccessControlContext accessControlContext = AccessController.getContext();
        URLClassLoader uRLClassLoader = (URLClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new FactoryURLClassLoader(uRLArray, classLoader);
            }
        });
        uRLClassLoader.acc = accessControlContext;
        return uRLClassLoader;
    }

    public static URLClassLoader newInstance(final URL[] uRLArray) {
        AccessControlContext accessControlContext = AccessController.getContext();
        URLClassLoader uRLClassLoader = (URLClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new FactoryURLClassLoader(uRLArray);
            }
        });
        uRLClassLoader.acc = accessControlContext;
        return uRLClassLoader;
    }

    static {
        Vector vector = new Vector();
        String string = System.getProperty(showClassLoadingProperty);
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                String string3 = string2.replaceAll("\\.", "\\.");
                string3 = string3.replaceAll("\\*", ".*");
                try {
                    Pattern pattern = Pattern.compile(string3);
                    vector.addElement(pattern);
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    System.err.println("Illegal class matching expression \"" + string2 + "\" supplied by property " + showClassLoadingProperty);
                }
            }
        }
        if (!vector.isEmpty()) {
            showLoadingMessages = true;
        }
        showClassLoadingFor = vector;
        extLoader = null;
        attemptedExtLoader = false;
    }

    final class ClassFinder
    implements PrivilegedExceptionAction {
        String name;
        ClassLoader classloader;

        ClassFinder() {
        }

        public Object run() throws ClassNotFoundException {
            String string = this.name;
            String string2 = string.replace('.', '/').concat(".class");
            try {
                Resource resource = URLClassLoader.this.getUCP().getResource(string2, false, this.classloader, URLClassLoader.this.showClassLoading(string));
                if (resource != null) {
                    return URLClassLoader.this.defineClass(string, resource);
                }
            }
            catch (IOException iOException) {
                throw new ClassNotFoundException(string, iOException);
            }
            return null;
        }
    }
}

