/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import com.ibm.jvm.ExtendedSystem;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;

public class ThreadLocal {
    private final int threadLocalHashCode = ThreadLocal.nextHashCode();
    private static int nextHashCode = 0;
    private static final int HASH_INCREMENT = 1640531527;
    private static Hashtable threadLocalMapCache = new Hashtable();

    private static synchronized int nextHashCode() {
        int n = nextHashCode;
        nextHashCode = n + 1640531527;
        return n;
    }

    protected Object initialValue() {
        return null;
    }

    public Object get() {
        Thread thread = Thread.currentThread();
        ThreadLocalMap threadLocalMap = this.getMap(thread);
        if (threadLocalMap != null) {
            if (ExtendedSystem.isResettableJVM()) {
                threadLocalMapCache.put(this, threadLocalMap);
            }
            return threadLocalMap.get(this);
        }
        Object object = this.initialValue();
        this.createMap(thread, object);
        if (ExtendedSystem.isResettableJVM() && thread.threadLocals != null) {
            threadLocalMapCache.put(this, thread.threadLocals);
        }
        return object;
    }

    public void set(Object object) {
        Thread thread = Thread.currentThread();
        ThreadLocalMap threadLocalMap = this.getMap(thread);
        if (threadLocalMap != null) {
            threadLocalMap.set(this, object);
        } else {
            this.createMap(thread, object);
        }
        if (ExtendedSystem.isResettableJVM() && thread.threadLocals != null) {
            threadLocalMapCache.put(this, thread.threadLocals);
        }
    }

    ThreadLocalMap getMap(Thread thread) {
        return thread.threadLocals;
    }

    void createMap(Thread thread, Object object) {
        thread.threadLocals = new ThreadLocalMap(this, object);
    }

    static ThreadLocalMap createInheritedMap(ThreadLocalMap threadLocalMap) {
        return new ThreadLocalMap(threadLocalMap);
    }

    Object childValue(Object object) {
        throw new UnsupportedOperationException();
    }

    private static boolean ibmJVMTidyUp() {
        try {
            Collection collection = threadLocalMapCache.values();
            Iterator iterator = collection.iterator();
            boolean bl = true;
            while (iterator.hasNext()) {
                bl = false;
                ThreadLocalMap threadLocalMap = (ThreadLocalMap)iterator.next();
                threadLocalMap.cleanUpTable();
            }
            if (!bl) {
                iterator.remove();
            }
            threadLocalMapCache.clear();
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    static class ThreadLocalMap {
        private static final int INITIAL_CAPACITY = 16;
        private Entry[] table;
        private int size = 0;
        private int threshold;

        private void setThreshold(int n) {
            this.threshold = n * 2 / 3;
        }

        private static int nextIndex(int n, int n2) {
            return n + 1 < n2 ? n + 1 : 0;
        }

        private static int prevIndex(int n, int n2) {
            return n - 1 >= 0 ? n - 1 : n2 - 1;
        }

        ThreadLocalMap(ThreadLocal threadLocal, Object object) {
            this.table = new Entry[16];
            int n = threadLocal.threadLocalHashCode & 0xF;
            this.table[n] = new Entry(threadLocal, object);
            this.size = 1;
            this.setThreshold(16);
        }

        private ThreadLocalMap(ThreadLocalMap threadLocalMap) {
            Entry[] entryArray = threadLocalMap.table;
            int n = entryArray.length;
            this.setThreshold(n);
            this.table = new Entry[n];
            for (int i = 0; i < n; ++i) {
                Object object;
                Entry entry = entryArray[i];
                if (entry == null || (object = entry.get()) == null) continue;
                ThreadLocal threadLocal = (ThreadLocal)object;
                Object object2 = threadLocal.childValue(entry.value);
                Entry entry2 = new Entry(threadLocal, object2);
                int n2 = threadLocal.threadLocalHashCode & n - 1;
                while (this.table[n2] != null) {
                    n2 = ThreadLocalMap.nextIndex(n2, n);
                }
                this.table[n2] = entry2;
                ++this.size;
            }
        }

        private Object get(ThreadLocal threadLocal) {
            int n = threadLocal.threadLocalHashCode & this.table.length - 1;
            Entry entry = this.table[n];
            if (entry != null && entry.get() == threadLocal) {
                return entry.value;
            }
            return this.getAfterMiss(threadLocal, n, entry);
        }

        private Object getAfterMiss(ThreadLocal threadLocal, int n, Entry entry) {
            Object object;
            Entry[] entryArray = this.table;
            int n2 = entryArray.length;
            while (entry != null) {
                object = entry.get();
                if (object == threadLocal) {
                    return entry.value;
                }
                if (object == null) {
                    return this.replaceStaleEntry(threadLocal, null, n, true);
                }
                n = ThreadLocalMap.nextIndex(n, n2);
                entry = entryArray[n];
            }
            object = threadLocal.initialValue();
            entryArray[n] = new Entry(threadLocal, object);
            if (++this.size >= this.threshold) {
                this.rehash();
            }
            return object;
        }

        private void set(ThreadLocal threadLocal, Object object) {
            Entry[] entryArray = this.table;
            int n = entryArray.length;
            int n2 = threadLocal.threadLocalHashCode & n - 1;
            Entry entry = entryArray[n2];
            while (entry != null) {
                Object object2 = entry.get();
                if (object2 == threadLocal) {
                    entry.value = object;
                    return;
                }
                if (object2 == null) {
                    this.replaceStaleEntry(threadLocal, object, n2, false);
                    return;
                }
                n2 = ThreadLocalMap.nextIndex(n2, n);
                entry = entryArray[n2];
            }
            entryArray[n2] = new Entry(threadLocal, object);
            if (++this.size >= this.threshold) {
                this.rehash();
            }
        }

        private Object replaceStaleEntry(ThreadLocal threadLocal, Object object, int n, boolean bl) {
            Entry entry;
            Entry[] entryArray = this.table;
            int n2 = entryArray.length;
            int n3 = n;
            int n4 = ThreadLocalMap.prevIndex(n, n2);
            while ((entry = entryArray[n4]) != null) {
                if (entry.get() == null) {
                    n3 = n4;
                }
                n4 = ThreadLocalMap.prevIndex(n4, n2);
            }
            n4 = ThreadLocalMap.nextIndex(n, n2);
            while ((entry = entryArray[n4]) != null) {
                Object object2 = entry.get();
                if (object2 == threadLocal) {
                    if (bl) {
                        object = entry.value;
                    } else {
                        entry.value = object;
                    }
                    entryArray[n4] = entryArray[n];
                    entryArray[n] = entry;
                    if (n3 == n) {
                        n3 = n4;
                    }
                    this.expungeStaleEntry(n3);
                    return object;
                }
                if (object2 == null && n3 == n) {
                    n3 = n4;
                }
                n4 = ThreadLocalMap.nextIndex(n4, n2);
            }
            if (bl) {
                object = threadLocal.initialValue();
            }
            entryArray[n].value = null;
            entryArray[n] = new Entry(threadLocal, object);
            if (n3 != n) {
                this.expungeStaleEntry(n3);
            }
            return object;
        }

        private void expungeStaleEntry(int n) {
            Entry entry;
            Entry[] entryArray = this.table;
            int n2 = entryArray.length;
            entryArray[n].value = null;
            entryArray[n] = null;
            --this.size;
            int n3 = ThreadLocalMap.nextIndex(n, n2);
            while ((entry = entryArray[n3]) != null) {
                Object object = entry.get();
                if (object == null) {
                    entry.value = null;
                    entryArray[n3] = null;
                    --this.size;
                } else {
                    ThreadLocal threadLocal = (ThreadLocal)object;
                    int n4 = threadLocal.threadLocalHashCode & n2 - 1;
                    if (n4 != n3) {
                        entryArray[n3] = null;
                        while (entryArray[n4] != null) {
                            n4 = ThreadLocalMap.nextIndex(n4, n2);
                        }
                        entryArray[n4] = entry;
                    }
                }
                n3 = ThreadLocalMap.nextIndex(n3, n2);
            }
        }

        private void rehash() {
            this.expungeStaleEntries();
            if (this.size >= this.threshold - this.threshold / 4) {
                this.resize();
            }
        }

        private void resize() {
            Entry[] entryArray = this.table;
            int n = entryArray.length;
            int n2 = n * 2;
            Entry[] entryArray2 = new Entry[n2];
            int n3 = 0;
            for (int i = 0; i < n; ++i) {
                Entry entry = entryArray[i];
                entryArray[i] = null;
                if (entry == null) continue;
                Object object = entry.get();
                if (object == null) {
                    entry.value = null;
                    continue;
                }
                ThreadLocal threadLocal = (ThreadLocal)object;
                int n4 = threadLocal.threadLocalHashCode & n2 - 1;
                while (entryArray2[n4] != null) {
                    n4 = ThreadLocalMap.nextIndex(n4, n2);
                }
                entryArray2[n4] = entry;
                ++n3;
            }
            this.setThreshold(n2);
            this.size = n3;
            this.table = entryArray2;
        }

        private void expungeStaleEntries() {
            Entry[] entryArray = this.table;
            int n = entryArray.length;
            for (int i = 0; i < n; ++i) {
                Entry entry = entryArray[i];
                if (entry == null || entry.get() != null) continue;
                this.expungeStaleEntry(i);
            }
        }

        private void cleanUpTable() {
            for (int i = 0; i < this.table.length; ++i) {
                Entry entry = this.table[i];
                if (entry == null) continue;
                entry.value = null;
                entry.clear();
                this.expungeStaleEntry(i);
                this.table[i] = null;
            }
        }

        private static class Entry
        extends WeakReference {
            private Object value;

            private Entry(ThreadLocal threadLocal, Object object) {
                super(threadLocal);
                this.value = object;
            }
        }
    }
}

