/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class Integer
extends Number
implements Comparable {
    public static final int MIN_VALUE = -2147483648;
    public static final int MAX_VALUE = 0x7FFFFFFF;
    public static final Class TYPE = Class.getPrimitiveClass("int");
    static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    static final char[] DigitTens = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9'};
    static final char[] DigitOnes = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    private static ThreadLocal perThreadBuffer = new ThreadLocal(){

        protected synchronized Object initialValue() {
            return new char[11];
        }
    };
    private int value;
    private static final long serialVersionUID = 1360826667806852920L;

    public static String toString(int n, int n2) {
        if (n2 < 2 || n2 > 36) {
            n2 = 10;
        }
        if (n2 == 10) {
            return Integer.toString(n);
        }
        char[] cArray = new char[33];
        boolean bl = n < 0;
        int n3 = 32;
        if (!bl) {
            n = -n;
        }
        while (n <= -n2) {
            cArray[n3--] = digits[-(n % n2)];
            n /= n2;
        }
        cArray[n3] = digits[-n];
        if (bl) {
            cArray[--n3] = 45;
        }
        return new String(cArray, n3, 33 - n3);
    }

    public static String toHexString(int n) {
        return Integer.toUnsignedString(n, 4);
    }

    public static String toOctalString(int n) {
        return Integer.toUnsignedString(n, 3);
    }

    public static String toBinaryString(int n) {
        return Integer.toUnsignedString(n, 1);
    }

    private static String toUnsignedString(int n, int n2) {
        char[] cArray = new char[32];
        int n3 = 32;
        int n4 = 1 << n2;
        int n5 = n4 - 1;
        do {
            cArray[--n3] = digits[n & n5];
        } while ((n >>>= n2) != 0);
        return new String(cArray, n3, 32 - n3);
    }

    public static String toString(int n) {
        switch (n) {
            case -2147483648: {
                return "-2147483648";
            }
            case -3: {
                return "-3";
            }
            case -2: {
                return "-2";
            }
            case -1: {
                return "-1";
            }
            case 0: {
                return "0";
            }
            case 1: {
                return "1";
            }
            case 2: {
                return "2";
            }
            case 3: {
                return "3";
            }
            case 4: {
                return "4";
            }
            case 5: {
                return "5";
            }
            case 6: {
                return "6";
            }
            case 7: {
                return "7";
            }
            case 8: {
                return "8";
            }
            case 9: {
                return "9";
            }
            case 10: {
                return "10";
            }
        }
        char[] cArray = (char[])perThreadBuffer.get();
        int n2 = Integer.getChars(n, cArray);
        return new String(cArray, n2, 11 - n2);
    }

    private static int getChars(int n, char[] cArray) {
        int n2;
        int n3;
        int n4 = 11;
        int n5 = 0;
        if (n < 0) {
            n5 = 45;
            n = -n;
        }
        while (n >= 65536) {
            n3 = n / 100;
            n2 = n - n3 * 100;
            n = n3;
            cArray[--n4] = DigitOnes[n2];
            cArray[--n4] = DigitTens[n2];
        }
        while (n >= 100) {
            n3 = n * 52429 >>> 19;
            n2 = n - ((n3 << 3) + (n3 << 1));
            cArray[--n4] = digits[n2];
            n = n3;
        }
        if (n >= 10) {
            cArray[--n4] = DigitOnes[n];
            cArray[--n4] = DigitTens[n];
        } else {
            cArray[--n4] = DigitOnes[n];
        }
        if (n5 != 0) {
            cArray[--n4] = n5;
        }
        return n4;
    }

    static void appendTo(int n, StringBuffer stringBuffer) {
        switch (n) {
            case -2147483648: {
                stringBuffer.append("-2147483648");
                return;
            }
            case -3: {
                stringBuffer.append("-3");
                return;
            }
            case -2: {
                stringBuffer.append("-2");
                return;
            }
            case -1: {
                stringBuffer.append("-1");
                return;
            }
            case 0: {
                stringBuffer.append("0");
                return;
            }
            case 1: {
                stringBuffer.append("1");
                return;
            }
            case 2: {
                stringBuffer.append("2");
                return;
            }
            case 3: {
                stringBuffer.append("3");
                return;
            }
            case 4: {
                stringBuffer.append("4");
                return;
            }
            case 5: {
                stringBuffer.append("5");
                return;
            }
            case 6: {
                stringBuffer.append("6");
                return;
            }
            case 7: {
                stringBuffer.append("7");
                return;
            }
            case 8: {
                stringBuffer.append("8");
                return;
            }
            case 9: {
                stringBuffer.append("9");
                return;
            }
            case 10: {
                stringBuffer.append("10");
                return;
            }
        }
        char[] cArray = (char[])perThreadBuffer.get();
        int n2 = Integer.getChars(n, cArray);
        stringBuffer.append(cArray, n2, 11 - n2);
    }

    public static int parseInt(String string, int n) throws NumberFormatException {
        if (string == null) {
            throw new NumberFormatException("null");
        }
        if (n < 2) {
            throw new NumberFormatException("radix " + n + " less than Character.MIN_RADIX");
        }
        if (n > 36) {
            throw new NumberFormatException("radix " + n + " greater than Character.MAX_RADIX");
        }
        int n2 = 0;
        boolean bl = false;
        int n3 = 0;
        int n4 = string.length();
        if (n4 > 0) {
            int n5;
            int n6;
            if (string.charAt(0) == '-') {
                bl = true;
                n6 = Integer.MIN_VALUE;
                ++n3;
            } else {
                n6 = -2147483647;
            }
            int n7 = n6 / n;
            if (n3 < n4) {
                if ((n5 = Character.digit(string.charAt(n3++), n)) < 0) {
                    throw NumberFormatException.forInputString(string);
                }
                n2 = -n5;
            }
            while (n3 < n4) {
                if ((n5 = Character.digit(string.charAt(n3++), n)) < 0) {
                    throw NumberFormatException.forInputString(string);
                }
                if (n2 < n7) {
                    throw NumberFormatException.forInputString(string);
                }
                if ((n2 *= n) < n6 + n5) {
                    throw NumberFormatException.forInputString(string);
                }
                n2 -= n5;
            }
        } else {
            throw NumberFormatException.forInputString(string);
        }
        if (bl) {
            if (n3 > 1) {
                return n2;
            }
            throw NumberFormatException.forInputString(string);
        }
        return -n2;
    }

    public static int parseInt(String string) throws NumberFormatException {
        return Integer.parseInt(string, 10);
    }

    public static Integer valueOf(String string, int n) throws NumberFormatException {
        return new Integer(Integer.parseInt(string, n));
    }

    public static Integer valueOf(String string) throws NumberFormatException {
        return new Integer(Integer.parseInt(string, 10));
    }

    public Integer(int n) {
        this.value = n;
    }

    public Integer(String string) throws NumberFormatException {
        this.value = Integer.parseInt(string, 10);
    }

    public byte byteValue() {
        return (byte)this.value;
    }

    public short shortValue() {
        return (short)this.value;
    }

    public int intValue() {
        return this.value;
    }

    public long longValue() {
        return this.value;
    }

    public float floatValue() {
        return this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object object) {
        if (object instanceof Integer) {
            return this.value == (Integer)object;
        }
        return false;
    }

    public static Integer getInteger(String string) {
        return Integer.getInteger(string, null);
    }

    public static Integer getInteger(String string, int n) {
        Integer n2 = Integer.getInteger(string, null);
        return n2 == null ? new Integer(n) : n2;
    }

    public static Integer getInteger(String string, Integer n) {
        String string2 = null;
        try {
            string2 = System.getProperty(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (string2 != null) {
            try {
                return Integer.decode(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n;
    }

    public static Integer decode(String string) throws NumberFormatException {
        Integer n;
        int n2 = 10;
        int n3 = 0;
        boolean bl = false;
        if (string.startsWith("-")) {
            bl = true;
            ++n3;
        }
        if (string.startsWith("0x", n3) || string.startsWith("0X", n3)) {
            n3 += 2;
            n2 = 16;
        } else if (string.startsWith("#", n3)) {
            ++n3;
            n2 = 16;
        } else if (string.startsWith("0", n3) && string.length() > 1 + n3) {
            ++n3;
            n2 = 8;
        }
        if (string.startsWith("-", n3)) {
            throw new NumberFormatException("Negative sign in wrong position");
        }
        try {
            n = Integer.valueOf(string.substring(n3), n2);
            n = bl ? new Integer(-n.intValue()) : n;
        }
        catch (NumberFormatException numberFormatException) {
            String string2 = bl ? new String("-" + string.substring(n3)) : string.substring(n3);
            n = Integer.valueOf(string2, n2);
        }
        return n;
    }

    public int compareTo(Integer n) {
        int n2 = this.value;
        int n3 = n.value;
        return n2 < n3 ? -1 : (n2 == n3 ? 0 : 1);
    }

    public int compareTo(Object object) {
        return this.compareTo((Integer)object);
    }
}

