/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import com.ibm.jvm.AllocationPolicy;
import com.ibm.jvm.ExtendedSystem;
import com.ibm.jvm.InvalidClassLoaderParentException;
import com.ibm.jvm.ShareableClassLoaderSetAssertException;
import com.ibm.jvm.classloader.Middleware;
import com.ibm.jvm.classloader.Shareable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import sun.misc.ClassFileTransformer;
import sun.misc.CompoundEnumeration;
import sun.misc.Launcher;
import sun.misc.Resource;
import sun.misc.URLClassPath;
import sun.reflect.Reflection;
import sun.security.util.SecurityConstants;

public abstract class ClassLoader {
    private long loaderCachePointer = 0L;
    private boolean isTrusted;
    private boolean isShared;
    private Finalizer finalizer;
    private boolean initialized = false;
    private ClassLoader parent;
    private Hashtable package2certs = new Hashtable(11);
    private Hashtable codesource2buffer = new Hashtable(11);
    Certificate[] nocerts;
    private Vector classes;
    private String namespace;
    private boolean deleted = false;
    private static Field launcherExtLoader;
    private static int check_path_len;
    static int special_err;
    static int count;
    static UnsatisfiedLinkError[] old;
    static int path_size;
    private static Field packageSealBase;
    private AllocationPolicy allocationPolicy = null;
    private HashMap packages = new HashMap();
    private static URLClassPath bootstrapClassPath;
    private static ClassLoader scl;
    private static boolean sclSet;
    private static RuntimePermission getClassLoaderPerm;
    private ProtectionDomain defaultDomain = null;
    private static PermissionCollection defaultPermissions;
    private static Vector loadedLibraryNames;
    private static Vector systemNativeLibraries;
    private Vector nativeLibraries = new Vector();
    private static Stack nativeLibraryContext;
    private static String[] usr_paths;
    private static String[] sys_paths;
    private boolean defaultAssertionStatus = false;
    private Map packageAssertionStatus = null;
    Map classAssertionStatus = null;

    private static native void registerNatives();

    private void registerAllocationPolicy(AllocationPolicy allocationPolicy) {
        this.allocationPolicy = allocationPolicy;
    }

    int addClass(Class clazz) {
        this.classes.addElement(clazz);
        if (this.allocationPolicy == null) {
            return 0;
        }
        return this.allocationPolicy.getAllocationPolicy(this, clazz);
    }

    protected ClassLoader(ClassLoader classLoader) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkCreateClassLoader();
        }
        this.setParent(classLoader);
        this.initialize();
    }

    protected ClassLoader() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkCreateClassLoader();
        }
        this.setParent(ClassLoader.getSystemClassLoader());
        this.initialize();
    }

    private void initialize() {
        this.classes = ExtendedSystem.isResettableJVM() ? new Vector(100) : new Vector();
        this.initialize0();
        this.finalizer = new Finalizer(this);
        if (!(this instanceof Shareable)) {
            this.initialized = true;
        }
    }

    native void initialize0();

    private void setParent(ClassLoader classLoader) {
        if (this instanceof Shareable && !(classLoader instanceof Shareable) && null != classLoader) {
            throw new InvalidClassLoaderParentException("Parent not shareable class loader: " + classLoader);
        }
        if (this instanceof Middleware && !(classLoader instanceof Middleware) && null != classLoader && ClassLoader.getExtClassLoader() != classLoader) {
            throw new InvalidClassLoaderParentException("Parent not middleware class loader: " + classLoader);
        }
        this.parent = classLoader;
    }

    private static ClassLoader getExtClassLoader() {
        try {
            Launcher launcher = Launcher.getLauncher();
            if (null == launcherExtLoader) {
                launcherExtLoader = ClassLoader.getPrivateField(launcher.getClass(), "extLoader");
            }
            return (ClassLoader)launcherExtLoader.get(launcher);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new InternalError(illegalAccessException.toString());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InternalError(illegalArgumentException.toString());
        }
        catch (SecurityException securityException) {
            throw new InternalError(securityException.toString());
        }
    }

    private static Field getPrivateField(final Class clazz, final String string) {
        Field field = (Field)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Field field = null;
                try {
                    field = clazz.getDeclaredField(string);
                    if (null != field) {
                        field.setAccessible(true);
                    }
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    throw new InternalError(noSuchFieldException.toString());
                }
                return field;
            }
        });
        return field;
    }

    public Class loadClass(String string) throws ClassNotFoundException {
        return this.loadClass(string, false);
    }

    private static void checkPackageAccess(final String string, ProtectionDomain protectionDomain) {
        final SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    securityManager.checkPackageAccess(string);
                    return null;
                }
            }, new AccessControlContext(new ProtectionDomain[]{protectionDomain}));
        }
    }

    protected synchronized Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class clazz = this.findLoadedClass(string);
        if (clazz == null) {
            try {
                clazz = this.parent != null ? this.parent.loadClass(string, false) : this.findBootstrapClass0(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (clazz == null) {
                clazz = this.findClass(string);
            }
        }
        if (bl) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    private synchronized Class loadClassInternal(String string) throws ClassNotFoundException {
        return this.loadClass(string);
    }

    protected Class findClass(String string) throws ClassNotFoundException {
        throw new ClassNotFoundException(string);
    }

    protected final Class defineClass(byte[] byArray, int n, int n2) throws ClassFormatError {
        return this.defineClass(null, byArray, n, n2, null);
    }

    protected final Class defineClass(String string, byte[] byArray, int n, int n2) throws ClassFormatError {
        return this.defineClass(string, byArray, n, n2, null);
    }

    protected final Class defineClass(String string, byte[] byArray, int n, int n2, ProtectionDomain protectionDomain) throws ClassFormatError {
        Class clazz;
        Object[] objectArray;
        block11: {
            this.check();
            if (string != null && string.startsWith("java.")) {
                throw new SecurityException("Prohibited package name: " + string.substring(0, string.lastIndexOf(46)));
            }
            if (protectionDomain == null) {
                protectionDomain = this.getDefaultDomain();
            }
            CodeSource codeSource = protectionDomain.getCodeSource();
            objectArray = null;
            byte[] byArray2 = null;
            if (codeSource != null) {
                objectArray = codeSource.getCertificates();
                if (this.isShared) {
                    byArray2 = this.resolveSharedCodeSource(codeSource);
                }
            }
            if (string != null) {
                this.checkCerts(string, codeSource);
            }
            clazz = null;
            try {
                clazz = this.defineClass0(string, byArray, n, n2, protectionDomain, (Certificate[])objectArray, byArray2);
            }
            catch (ClassFormatError classFormatError) {
                Object[] objectArray2 = ClassFileTransformer.getTransformers();
                for (int i = 0; objectArray2 != null && i < objectArray2.length; ++i) {
                    try {
                        byte[] byArray3 = ((ClassFileTransformer)objectArray2[i]).transform(byArray, n, n2);
                        clazz = this.defineClass0(string, byArray3, 0, byArray3.length, protectionDomain, (Certificate[])objectArray, byArray2);
                        break;
                    }
                    catch (ClassFormatError classFormatError2) {
                        continue;
                    }
                }
                if (clazz != null) break block11;
                throw classFormatError;
            }
        }
        if (objectArray != null) {
            this.setSigners(clazz, objectArray);
        }
        return clazz;
    }

    private byte[] resolveSharedCodeSource(CodeSource codeSource) {
        ExtendedSystem.getGlobalLock();
        byte[] byArray = (byte[])this.codesource2buffer.get(codeSource);
        if (byArray == null) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                objectOutputStream.writeObject(codeSource);
                byArray = byteArrayOutputStream.toByteArray();
                byArray = this.getSystemHeapArray(byArray);
                this.codesource2buffer.put(codeSource, byArray);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        ExtendedSystem.releaseGlobalLock();
        return byArray;
    }

    private native byte[] getSystemHeapArray(byte[] var1);

    private synchronized void checkCerts(String string, CodeSource codeSource) {
        int n = string.lastIndexOf(46);
        String string2 = n == -1 ? "" : string.substring(0, n);
        Certificate[] certificateArray = (Certificate[])this.package2certs.get(string2);
        if (certificateArray == null) {
            if (codeSource != null) {
                certificateArray = codeSource.getCertificates();
            }
            if (certificateArray == null) {
                if (this.nocerts == null) {
                    this.nocerts = new Certificate[0];
                }
                certificateArray = this.nocerts;
            }
            this.package2certs.put(string2, certificateArray);
        } else {
            Certificate[] certificateArray2 = null;
            if (codeSource != null) {
                certificateArray2 = codeSource.getCertificates();
            }
            if (!this.compareCerts(certificateArray, certificateArray2)) {
                throw new SecurityException("class \"" + string + "\"'s signer information does not match signer information of other classes in the same package");
            }
        }
    }

    private boolean compareCerts(Certificate[] certificateArray, Certificate[] certificateArray2) {
        int n;
        boolean bl;
        int n2;
        if (certificateArray2 == null || certificateArray2.length == 0) {
            return certificateArray.length == 0;
        }
        if (certificateArray2.length != certificateArray.length) {
            return false;
        }
        for (n2 = 0; n2 < certificateArray2.length; ++n2) {
            bl = false;
            for (n = 0; n < certificateArray.length; ++n) {
                if (!certificateArray2[n2].equals(certificateArray[n])) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        for (n2 = 0; n2 < certificateArray.length; ++n2) {
            bl = false;
            for (n = 0; n < certificateArray2.length; ++n) {
                if (!certificateArray[n2].equals(certificateArray2[n])) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    protected final void resolveClass(Class clazz) {
        this.check();
        this.resolveClass0(clazz);
    }

    protected final Class findSystemClass(String string) throws ClassNotFoundException {
        this.check();
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        if (classLoader == null) {
            return this.findBootstrapClass(string);
        }
        return classLoader.loadClass(string);
    }

    public final ClassLoader getParent() {
        ClassLoader classLoader;
        if (this.parent == null) {
            return null;
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && (classLoader = ClassLoader.getCallerClassLoader()) != null && !this.isAncestor(classLoader)) {
            securityManager.checkPermission(SecurityConstants.GET_CLASSLOADER_PERMISSION);
        }
        return this.parent;
    }

    protected final void setSigners(Class clazz, Object[] objectArray) {
        this.check();
        clazz.setSigners(objectArray);
    }

    private Class findBootstrapClass0(String string) throws ClassNotFoundException {
        this.check();
        return this.findBootstrapClass(string);
    }

    private native Class defineClass0(String var1, byte[] var2, int var3, int var4, ProtectionDomain var5, Certificate[] var6, byte[] var7);

    private native void resolveClass0(Class var1);

    private native Class findBootstrapClass(String var1) throws ClassNotFoundException;

    private void check() {
        if (!this.initialized) {
            if (this.deleted) {
                ExtendedSystem.setJVMUnresettableConditionally(65555, new String("Application class loader retained across reset"));
            }
            if (!(this instanceof Shareable)) {
                throw new SecurityException("ClassLoader object not initialized");
            }
            throw new SecurityException("ClassLoader object not registered: " + this);
        }
    }

    protected final native Class findLoadedClass(String var1);

    public URL getResource(String string) {
        URL uRL = this.parent != null ? this.parent.getResource(string) : ClassLoader.getBootstrapResource(string);
        if (uRL == null) {
            uRL = this.findResource(string);
        }
        return uRL;
    }

    public final Enumeration getResources(String string) throws IOException {
        Enumeration[] enumerationArray = new Enumeration[]{this.parent != null ? this.parent.getResources(string) : ClassLoader.getBootstrapResources(string), this.findResources(string)};
        return new CompoundEnumeration(enumerationArray);
    }

    protected Enumeration findResources(String string) throws IOException {
        return new CompoundEnumeration(new Enumeration[0]);
    }

    protected URL findResource(String string) {
        return null;
    }

    public static URL getSystemResource(String string) {
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        if (classLoader == null) {
            return ClassLoader.getBootstrapResource(string);
        }
        return classLoader.getResource(string);
    }

    private static URL getBootstrapResource(String string) {
        URLClassPath uRLClassPath = ClassLoader.getBootstrapClassPath();
        Resource resource = uRLClassPath.getResource(string);
        return resource != null ? resource.getURL() : null;
    }

    public static Enumeration getSystemResources(String string) throws IOException {
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        if (classLoader == null) {
            return ClassLoader.getBootstrapResources(string);
        }
        return classLoader.getResources(string);
    }

    private static Enumeration getBootstrapResources(String string) throws IOException {
        final Enumeration enumeration = ClassLoader.getBootstrapClassPath().getResources(string);
        return new Enumeration(){

            public Object nextElement() {
                return ((Resource)enumeration.nextElement()).getURL();
            }

            public boolean hasMoreElements() {
                return enumeration.hasMoreElements();
            }
        };
    }

    static URLClassPath getBootstrapClassPath() {
        if (bootstrapClassPath == null) {
            bootstrapClassPath = Launcher.getBootstrapClassPath();
        }
        return bootstrapClassPath;
    }

    public InputStream getResourceAsStream(String string) {
        URL uRL = this.getResource(string);
        try {
            return uRL != null ? uRL.openStream() : null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static InputStream getSystemResourceAsStream(String string) {
        URL uRL = ClassLoader.getSystemResource(string);
        try {
            return uRL != null ? uRL.openStream() : null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static ClassLoader getSystemClassLoader() {
        ClassLoader classLoader;
        ClassLoader.initSystemClassLoader();
        if (scl == null) {
            return null;
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && (classLoader = ClassLoader.getCallerClassLoader()) != null && classLoader != scl && !scl.isAncestor(classLoader)) {
            securityManager.checkPermission(SecurityConstants.GET_CLASSLOADER_PERMISSION);
        }
        return scl;
    }

    private static synchronized void initSystemClassLoader() {
        if (!sclSet) {
            if (scl != null) {
                throw new IllegalStateException("recursive call");
            }
            Launcher launcher = Launcher.getLauncher();
            if (launcher != null) {
                Throwable throwable;
                block7: {
                    throwable = null;
                    scl = launcher.getClassLoader();
                    try {
                        SystemClassLoaderAction systemClassLoaderAction = new SystemClassLoaderAction(scl);
                        scl = (ClassLoader)AccessController.doPrivileged(systemClassLoaderAction);
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        throwable = privilegedActionException.getCause();
                        if (!(throwable instanceof InvocationTargetException)) break block7;
                        throwable = throwable.getCause();
                    }
                }
                if (throwable != null) {
                    if (throwable instanceof Error) {
                        throw (Error)throwable;
                    }
                    throw new Error(throwable);
                }
            }
            sclSet = true;
        }
    }

    private static void removeSystemClassLoader() {
        scl = null;
        sclSet = false;
    }

    private void copyFrom(ClassLoader classLoader) {
        this.package2certs = classLoader.package2certs;
        this.nocerts = classLoader.nocerts;
        this.packages = classLoader.packages;
        this.nativeLibraries = classLoader.nativeLibraries;
        this.defaultDomain = classLoader.defaultDomain;
        this.codesource2buffer = classLoader.codesource2buffer;
        classLoader.package2certs = null;
        classLoader.nocerts = null;
        classLoader.packages = null;
        classLoader.nativeLibraries = null;
        classLoader.defaultDomain = null;
        classLoader.codesource2buffer = null;
    }

    boolean isAncestor(ClassLoader classLoader) {
        ClassLoader classLoader2 = this;
        do {
            if (classLoader != (classLoader2 = classLoader2.parent)) continue;
            return true;
        } while (classLoader2 != null);
        return false;
    }

    static ClassLoader getCallerClassLoader() {
        Class clazz = Reflection.getCallerClass(3);
        if (clazz == null) {
            return null;
        }
        return clazz.getClassLoader0();
    }

    static RuntimePermission getGetClassLoaderPerm() {
        if (getClassLoaderPerm == null) {
            getClassLoaderPerm = new RuntimePermission("getClassLoader");
        }
        return getClassLoaderPerm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Package definePackage(String string, String string2, String string3, String string4, String string5, String string6, String string7, URL uRL) throws IllegalArgumentException {
        HashMap hashMap = this.packages;
        synchronized (hashMap) {
            Package package_ = this.getPackage(string);
            if (package_ != null) {
                if (this.isShared) {
                    if (package_.isLocallyDefined()) {
                        throw new IllegalArgumentException(string);
                    }
                    package_.setLocallyDefined(true);
                    return package_;
                }
                throw new IllegalArgumentException(string);
            }
            package_ = new Package(string, string2, string3, string4, string5, string6, string7, uRL);
            this.packages.put(string, package_);
            if (this.isShared) {
                try {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                    objectOutputStream.writeObject(package_.getName());
                    objectOutputStream.writeObject(package_.getSpecificationTitle());
                    objectOutputStream.writeObject(package_.getSpecificationVersion());
                    objectOutputStream.writeObject(package_.getSpecificationVendor());
                    objectOutputStream.writeObject(package_.getImplementationTitle());
                    objectOutputStream.writeObject(package_.getImplementationVersion());
                    objectOutputStream.writeObject(package_.getImplementationVendor());
                    if (null == packageSealBase) {
                        packageSealBase = ClassLoader.getPrivateField(package_.getClass(), "sealBase");
                    }
                    objectOutputStream.writeObject(packageSealBase.get(package_));
                    byte[] byArray = byteArrayOutputStream.toByteArray();
                    this.addNameSpacePackage(string.intern(), byArray);
                }
                catch (IOException iOException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
            return package_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Package getPackage(String string) {
        HashMap hashMap = this.packages;
        synchronized (hashMap) {
            byte[] byArray;
            Package package_ = (Package)this.packages.get(string);
            if (package_ == null && this.isShared && (byArray = this.getNameSpacePackage(string = string.intern())) != null) {
                try {
                    ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byArray));
                    String string2 = (String)objectInputStream.readObject();
                    String string3 = (String)objectInputStream.readObject();
                    String string4 = (String)objectInputStream.readObject();
                    String string5 = (String)objectInputStream.readObject();
                    String string6 = (String)objectInputStream.readObject();
                    String string7 = (String)objectInputStream.readObject();
                    String string8 = (String)objectInputStream.readObject();
                    URL uRL = (URL)objectInputStream.readObject();
                    package_ = new Package(string2, string3, string4, string5, string6, string7, string8, uRL);
                    package_.setLocallyDefined(false);
                    this.packages.put(string, package_);
                }
                catch (IOException iOException) {
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            if (package_ == null && (package_ = this.parent != null ? this.parent.getPackage(string) : Package.getSystemPackage(string)) != null) {
                this.packages.put(string, package_);
            }
            return package_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Package[] getPackages() {
        Package[] packageArray = this.packages;
        synchronized (this.packages) {
            if (this.isShared) {
                String[] stringArray = this.getNameSpacePackageNames();
                for (int i = 0; i < stringArray.length; ++i) {
                    String string = stringArray[i];
                    if (string == null || this.packages.get(string) != null) continue;
                    try {
                        byte[] byArray = this.getNameSpacePackage(string);
                        ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byArray));
                        String string2 = (String)objectInputStream.readObject();
                        String string3 = (String)objectInputStream.readObject();
                        String string4 = (String)objectInputStream.readObject();
                        String string5 = (String)objectInputStream.readObject();
                        String string6 = (String)objectInputStream.readObject();
                        String string7 = (String)objectInputStream.readObject();
                        String string8 = (String)objectInputStream.readObject();
                        URL uRL = (URL)objectInputStream.readObject();
                        Package package_ = new Package(string2, string3, string4, string5, string6, string7, string8, uRL);
                        package_.setLocallyDefined(false);
                        this.packages.put(string, package_);
                        continue;
                    }
                    catch (IOException iOException) {
                        continue;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
            }
            Map map = (Map)this.packages.clone();
            // ** MonitorExit[var2_1] (shouldn't be in output)
            packageArray = this.parent != null ? this.parent.getPackages() : Package.getSystemPackages();
            if (packageArray != null) {
                for (int i = 0; i < packageArray.length; ++i) {
                    String string = packageArray[i].getName();
                    if (map.get(string) != null) continue;
                    map.put(string, packageArray[i]);
                }
            }
            return (Package[])map.values().toArray(new Package[map.size()]);
        }
    }

    private native void addNameSpacePackage(String var1, byte[] var2);

    private native byte[] getNameSpacePackage(String var1);

    private native String[] getNameSpacePackageNames();

    protected String findLibrary(String string) {
        return null;
    }

    private synchronized ProtectionDomain getDefaultDomain() {
        if (this.defaultDomain == null) {
            CodeSource codeSource = new CodeSource(null, null);
            this.defaultDomain = new ProtectionDomain(codeSource, null, this, null);
        }
        return this.defaultDomain;
    }

    private static String[] initializePath(String string) {
        String string2 = System.getProperty(string, "");
        String string3 = File.pathSeparator;
        int n = string2.length();
        int n2 = string2.indexOf(string3);
        int n3 = 0;
        while (n2 >= 0) {
            ++n3;
            n2 = string2.indexOf(string3, n2 + 1);
        }
        String[] stringArray = new String[n3 + 1];
        n2 = 0;
        n3 = 0;
        int n4 = string2.indexOf(string3);
        while (n4 >= 0) {
            if (n4 - n2 > 0) {
                stringArray[n3++] = string2.substring(n2, n4);
            } else if (n4 - n2 == 0) {
                stringArray[n3++] = ".";
            }
            n2 = n4 + 1;
            n4 = string2.indexOf(string3, n2);
        }
        stringArray[n3] = string2.substring(n2, n);
        return stringArray;
    }

    static void loadLibrary(Class clazz, String string, boolean bl) {
        String string2;
        Object object;
        ClassLoader classLoader;
        ClassLoader classLoader2 = classLoader = clazz == null ? null : clazz.getClassLoader();
        if (sys_paths == null) {
            usr_paths = ClassLoader.initializePath("java.library.path");
            sys_paths = ClassLoader.initializePath("sun.boot.library.path");
        }
        if (System.getProperty("os.name").equals("AIX")) {
            object = new StringTokenizer(string, "(");
            string2 = ((StringTokenizer)object).nextToken();
        } else {
            string2 = string;
        }
        if (bl) {
            if (ClassLoader.loadLibrary0(clazz, new File(string2), string)) {
                return;
            }
            throw new UnsatisfiedLinkError("Can't load library: " + string2);
        }
        if (classLoader != null && (object = classLoader.findLibrary(string2)) != null) {
            File file = new File((String)object);
            if (!file.isAbsolute()) {
                throw new UnsatisfiedLinkError("ClassLoader.findLibrary failed to return an absolute path: " + (String)object);
            }
            if (ClassLoader.loadLibrary0(clazz, file, string)) {
                return;
            }
            throw new UnsatisfiedLinkError("Can't load " + (String)object);
        }
        object = System.mapLibraryName(string2);
        String string3 = new String((String)object);
        String string4 = System.getProperty("java.execsuffix", "");
        for (int i = 0; i < 2; ++i) {
            File file;
            int n;
            for (n = 0; n < sys_paths.length; ++n) {
                file = new File(sys_paths[n], (String)object);
                if (!ClassLoader.loadLibrary0(clazz, file, string)) continue;
                if (i == 1) {
                    System.err.println("Warning: Loaded " + (String)object + " instead of " + string3);
                }
                return;
            }
            old = new UnsatisfiedLinkError[256];
            path_size = usr_paths.length - 1;
            if (classLoader != null) {
                n = 0;
                while (n < usr_paths.length) {
                    file = new File(usr_paths[n], (String)object);
                    check_path_len = n++;
                    if (!ClassLoader.loadLibrary0(clazz, file, string)) continue;
                    if (i == 1) {
                        System.err.println("Warning: Loaded " + (String)object + " instead of " + string3);
                    }
                    return;
                }
            }
            if (string4 == "" || ((String)object).lastIndexOf(string4) < 0) break;
            object = string3.substring(0, string3.lastIndexOf(string4)) + string3.substring(string3.lastIndexOf(string4) + string4.length());
        }
        throw new UnsatisfiedLinkError("Can't find library " + string2 + "  (" + string3 + (System.getProperty("os.name").equals("AIX") ? " or .so" : "") + (string4 != "" ? ", or " + (String)object + (System.getProperty("os.name").equals("AIX") ? " or .so" : "") : "") + ") in sun.boot.library.path" + (classLoader != null ? " or java.library.path" : "") + "\nsun.boot.library.path=" + System.getProperty("sun.boot.library.path") + (classLoader != null ? "\njava.library.path=" + System.getProperty("java.library.path") : ""));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean loadLibrary0(Class clazz, final File file, String string) {
        Vector vector;
        String string2;
        try {
            string2 = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            return false;
        }
        ClassLoader classLoader = clazz == null ? null : clazz.getClassLoader();
        Vector vector2 = vector = classLoader != null ? classLoader.nativeLibraries : systemNativeLibraries;
        synchronized (vector2) {
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                NativeLibrary nativeLibrary = (NativeLibrary)vector.elementAt(i);
                if (!string2.equals(nativeLibrary.name)) continue;
                return true;
            }
            Vector vector3 = loadedLibraryNames;
            synchronized (vector3) {
                if (loadedLibraryNames.contains(string2)) {
                    throw new UnsatisfiedLinkError("Native Library " + string2 + " already loaded in another classloader");
                }
                int n2 = nativeLibraryContext.size();
                for (int i = 0; i < n2; ++i) {
                    NativeLibrary nativeLibrary = (NativeLibrary)nativeLibraryContext.elementAt(i);
                    if (!string2.equals(nativeLibrary.name)) continue;
                    if (classLoader == nativeLibrary.fromClass.getClassLoader()) {
                        return true;
                    }
                    throw new UnsatisfiedLinkError("Native Library " + string2 + " is being loaded in another classloader");
                }
                NativeLibrary nativeLibrary = new NativeLibrary(clazz, string2);
                nativeLibraryContext.push(nativeLibrary);
                try {
                    nativeLibrary.load(string2, string);
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    Boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            return new Boolean(file.exists());
                        }
                    });
                    if (special_err == 1 && !bl.booleanValue()) {
                        boolean bl2 = false;
                        return bl2;
                    }
                    special_err = 0;
                    ClassLoader.old[ClassLoader.count++] = unsatisfiedLinkError;
                    if (check_path_len < path_size) {
                        boolean bl3 = false;
                        return bl3;
                    }
                    throw old[0];
                }
                finally {
                    nativeLibraryContext.pop();
                }
                if (nativeLibrary.handle != 0L) {
                    loadedLibraryNames.addElement(string2);
                    vector.addElement(nativeLibrary);
                    return true;
                }
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long findNative(ClassLoader classLoader, String string) {
        Vector vector;
        Vector vector2 = vector = classLoader != null ? classLoader.nativeLibraries : systemNativeLibraries;
        synchronized (vector2) {
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                NativeLibrary nativeLibrary = (NativeLibrary)vector.elementAt(i);
                long l = nativeLibrary.find(string);
                if (l == 0L) continue;
                return l;
            }
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isNativeTagged(ClassLoader classLoader, String string) {
        Vector vector;
        Vector vector2 = vector = classLoader != null ? classLoader.nativeLibraries : systemNativeLibraries;
        synchronized (vector2) {
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                NativeLibrary nativeLibrary = (NativeLibrary)vector.elementAt(i);
                long l = nativeLibrary.find(string);
                if (l == 0L) continue;
                return nativeLibrary.JVM_Tagged;
            }
        }
        return false;
    }

    public synchronized void setDefaultAssertionStatus(boolean bl) {
        if (this.isShared) {
            throw new ShareableClassLoaderSetAssertException("Cannot set default assertion status in a shared class loader");
        }
        if (this.classAssertionStatus == null) {
            this.initializeJavaAssertionMaps();
        }
        this.defaultAssertionStatus = bl;
    }

    public synchronized void setPackageAssertionStatus(String string, boolean bl) {
        if (this.isShared) {
            throw new ShareableClassLoaderSetAssertException("Cannot set package assertion status in a shared class loader");
        }
        if (this.packageAssertionStatus == null) {
            this.initializeJavaAssertionMaps();
        }
        this.packageAssertionStatus.put(string, bl);
    }

    public synchronized void setClassAssertionStatus(String string, boolean bl) {
        if (this.isShared) {
            throw new ShareableClassLoaderSetAssertException("Cannot set class assertion status in a shared class loader");
        }
        if (this.classAssertionStatus == null) {
            this.initializeJavaAssertionMaps();
        }
        this.classAssertionStatus.put(string, bl);
    }

    public synchronized void clearAssertionStatus() {
        if (this.isShared) {
            throw new ShareableClassLoaderSetAssertException("Cannot clear assertion status in a shareable class loader");
        }
        this.classAssertionStatus = new HashMap();
        this.packageAssertionStatus = new HashMap();
        this.defaultAssertionStatus = false;
    }

    synchronized boolean desiredAssertionStatus(String string) {
        Boolean bl = (Boolean)this.classAssertionStatus.get(string);
        if (bl != null) {
            return bl;
        }
        int n = string.lastIndexOf(".");
        if (n < 0 && (bl = (Boolean)this.packageAssertionStatus.get(null)) != null) {
            return bl;
        }
        while (n > 0) {
            bl = (Boolean)this.packageAssertionStatus.get(string = string.substring(0, n));
            if (bl != null) {
                return bl;
            }
            n = string.lastIndexOf(".", n - 1);
        }
        return this.defaultAssertionStatus;
    }

    private void initializeJavaAssertionMaps() {
        int n;
        this.classAssertionStatus = new HashMap();
        this.packageAssertionStatus = new HashMap();
        AssertionStatusDirectives assertionStatusDirectives = ClassLoader.retrieveDirectives();
        for (n = 0; n < assertionStatusDirectives.classes.length; ++n) {
            this.classAssertionStatus.put(assertionStatusDirectives.classes[n], assertionStatusDirectives.classEnabled[n]);
        }
        for (n = 0; n < assertionStatusDirectives.packages.length; ++n) {
            this.packageAssertionStatus.put(assertionStatusDirectives.packages[n], assertionStatusDirectives.packageEnabled[n]);
        }
        this.defaultAssertionStatus = assertionStatusDirectives.deflt;
    }

    private static native AssertionStatusDirectives retrieveDirectives();

    static {
        ClassLoader.registerNatives();
        launcherExtLoader = null;
        check_path_len = 0;
        special_err = 1;
        count = 0;
        path_size = 0;
        packageSealBase = null;
        getClassLoaderPerm = null;
        defaultPermissions = null;
        loadedLibraryNames = new Vector();
        systemNativeLibraries = new Vector();
        nativeLibraryContext = new Stack();
    }

    static class NativeLibrary {
        long handle;
        private int jniVersion;
        private Class fromClass;
        String actualName;
        String name;
        boolean JVM_Tagged;

        native void load(String var1, String var2);

        native long find(String var1);

        native void unload();

        public NativeLibrary(Class clazz, String string) {
            this.name = string;
            this.fromClass = clazz;
        }

        public NativeLibrary(Class clazz, String string, String string2) {
            this.actualName = string2;
            this.name = string;
            this.fromClass = clazz;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() {
            Vector vector = loadedLibraryNames;
            synchronized (vector) {
                if (this.fromClass.getClassLoader() != null && this.handle != 0L) {
                    int n = loadedLibraryNames.size();
                    for (int i = 0; i < n; ++i) {
                        if (!this.name.equals(loadedLibraryNames.elementAt(i))) continue;
                        loadedLibraryNames.removeElementAt(i);
                        break;
                    }
                    nativeLibraryContext.push(this);
                    try {
                        this.unload();
                    }
                    finally {
                        nativeLibraryContext.pop();
                    }
                }
            }
        }

        static Class getFromClass() {
            return ((NativeLibrary)nativeLibraryContext.peek()).fromClass;
        }
    }

    static class Finalizer {
        private ClassLoader loader;

        Finalizer(ClassLoader classLoader) {
            this.loader = classLoader;
        }

        native void finalize0(ClassLoader var1);

        protected void finalize() {
            this.finalize0(this.loader);
        }
    }
}

