/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.beans.ExceptionListener;
import java.beans.NameGenerator;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ListIterator;

public class Statement {
    private static Object[] emptyArray = new Object[0];
    private static HashMap methodCache = null;
    static ExceptionListener defaultExceptionListener = new ExceptionListener(){

        public void exceptionThrown(Exception exception) {
            System.err.println(exception);
            System.err.println("Continuing ...");
        }
    };
    Object target;
    String methodName;
    Object[] arguments;

    public Statement(Object object, String string, Object[] objectArray) {
        this.target = object;
        this.methodName = string;
        this.arguments = objectArray == null ? emptyArray : objectArray;
    }

    public Object getTarget() {
        return this.target;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    public void execute() throws Exception {
        this.invoke();
    }

    static Class typeToClass(Class clazz) {
        return clazz.isPrimitive() ? Statement.typeNameToClass(clazz.getName()) : clazz;
    }

    static Class typeNameToClass(String string) {
        if ((string = string.intern()) == "boolean") {
            return Boolean.class;
        }
        if (string == "byte") {
            return Byte.class;
        }
        if (string == "char") {
            return Character.class;
        }
        if (string == "short") {
            return Short.class;
        }
        if (string == "int") {
            return Integer.class;
        }
        if (string == "long") {
            return Long.class;
        }
        if (string == "float") {
            return Float.class;
        }
        if (string == "double") {
            return Double.class;
        }
        if (string == "void") {
            return Void.class;
        }
        return null;
    }

    private static Class typeNameToPrimitiveClass(String string) {
        if ((string = string.intern()) == "boolean") {
            return Boolean.TYPE;
        }
        if (string == "byte") {
            return Byte.TYPE;
        }
        if (string == "char") {
            return Character.TYPE;
        }
        if (string == "short") {
            return Short.TYPE;
        }
        if (string == "int") {
            return Integer.TYPE;
        }
        if (string == "long") {
            return Long.TYPE;
        }
        if (string == "float") {
            return Float.TYPE;
        }
        if (string == "double") {
            return Double.TYPE;
        }
        if (string == "void") {
            return Void.TYPE;
        }
        return null;
    }

    static Class primitiveTypeFor(Class clazz) {
        if (clazz == Boolean.class) {
            return Boolean.TYPE;
        }
        if (clazz == Byte.class) {
            return Byte.TYPE;
        }
        if (clazz == Character.class) {
            return Character.TYPE;
        }
        if (clazz == Short.class) {
            return Short.TYPE;
        }
        if (clazz == Integer.class) {
            return Integer.TYPE;
        }
        if (clazz == Long.class) {
            return Long.TYPE;
        }
        if (clazz == Float.class) {
            return Float.TYPE;
        }
        if (clazz == Double.class) {
            return Double.TYPE;
        }
        if (clazz == Void.class) {
            return Void.TYPE;
        }
        return null;
    }

    static Class classForName(String string) throws ClassNotFoundException {
        Class clazz = Statement.typeNameToPrimitiveClass(string);
        if (clazz != null) {
            return clazz;
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return classLoader.loadClass(string);
    }

    private static boolean matchArguments(Class[] classArray, Class[] classArray2) {
        boolean bl = classArray.length == classArray2.length;
        for (int i = 0; i < classArray.length && bl; ++i) {
            Class clazz = classArray2[i];
            if (clazz.isPrimitive()) {
                clazz = Statement.typeToClass(clazz);
            }
            if (classArray[i] == null || clazz.isAssignableFrom(classArray[i])) continue;
            bl = false;
        }
        return bl;
    }

    private static boolean matchExplicitArguments(Class[] classArray, Class[] classArray2) {
        boolean bl = classArray.length == classArray2.length;
        for (int i = 0; i < classArray.length && bl; ++i) {
            Class clazz = classArray2[i];
            if (clazz.isPrimitive()) {
                clazz = Statement.typeToClass(clazz);
            }
            if (classArray[i] == clazz) continue;
            bl = false;
        }
        return bl;
    }

    private static Method findPublicMethod(Class clazz, String string, Class[] classArray) {
        Method method;
        if (classArray.length == 0) {
            try {
                return clazz.getMethod(string, classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return null;
            }
        }
        Method[] methodArray = clazz.getMethods();
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < methodArray.length; ++i) {
            method = methodArray[i];
            if (!method.getName().equals(string) || !Statement.matchArguments(classArray, method.getParameterTypes())) continue;
            arrayList.add(method);
        }
        if (arrayList.size() > 0) {
            if (arrayList.size() == 1) {
                return (Method)arrayList.get(0);
            }
            ListIterator listIterator = arrayList.listIterator();
            while (listIterator.hasNext()) {
                method = (Method)listIterator.next();
                if (!Statement.matchExplicitArguments(classArray, method.getParameterTypes())) continue;
                return method;
            }
            return (Method)arrayList.get(0);
        }
        return null;
    }

    private static Method findMethod(Class clazz, String string, Class[] classArray) {
        Method method = Statement.findPublicMethod(clazz, string, classArray);
        if (method != null && Modifier.isPublic(method.getDeclaringClass().getModifiers())) {
            return method;
        }
        for (Class clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            Class[] classArray2 = clazz2.getInterfaces();
            for (int i = 0; i < classArray2.length; ++i) {
                method = Statement.findPublicMethod(classArray2[i], string, classArray);
                if (method == null) continue;
                return method;
            }
        }
        return null;
    }

    static Method getMethod(Class clazz, String string, Class[] classArray) {
        if (!Statement.isCaching()) {
            return Statement.findMethod(clazz, string, classArray);
        }
        Signature signature = new Signature(clazz, string, classArray);
        Method method = (Method)methodCache.get(signature);
        if (method != null) {
            return method;
        }
        method = Statement.findMethod(clazz, string, classArray);
        if (method != null) {
            methodCache.put(signature, method);
        }
        return method;
    }

    static void setCaching(boolean bl) {
        methodCache = bl ? new HashMap() : null;
    }

    private static boolean isCaching() {
        return methodCache != null;
    }

    Object invoke() throws Exception {
        Object object;
        Object object2 = this.getTarget();
        String string = this.getMethodName();
        SecurityManager securityManager = System.getSecurityManager();
        if (object2 == null || string == null) {
            throw new NullPointerException((object2 == null ? "target" : "methodName") + " should not be null");
        }
        Object[] objectArray = this.getArguments();
        if (object2 == Class.class && string == "forName") {
            return Statement.classForName((String)objectArray[0]);
        }
        Class[] classArray = new Class[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            classArray[i] = objectArray[i] == null ? null : objectArray[i].getClass();
        }
        AccessibleObject accessibleObject = null;
        if (object2 instanceof Class) {
            if (string == "new") {
                string = "newInstance";
            }
            if (string == "newInstance" && ((Class)object2).isArray()) {
                Object object3 = Array.newInstance(((Class)object2).getComponentType(), objectArray.length);
                for (int i = 0; i < objectArray.length; ++i) {
                    Array.set(object3, i, objectArray[i]);
                }
                return object3;
            }
            if (string == "newInstance" && objectArray.length != 0) {
                String string2;
                int n;
                if (object2 == Character.class && objectArray.length == 1 && classArray[0] == String.class) {
                    return new Character(((String)objectArray[0]).charAt(0));
                }
                object = ((Class)object2).getConstructors();
                for (int i = 0; i < ((Constructor[])object).length; ++i) {
                    Constructor constructor = object[i];
                    if (!Statement.matchArguments(classArray, constructor.getParameterTypes())) continue;
                    accessibleObject = constructor;
                }
                if (accessibleObject != null && securityManager != null && (n = (string2 = ((Class)object2).getName()).lastIndexOf(46)) != -1) {
                    securityManager.checkPackageAccess(string2.substring(0, n));
                }
            }
            if (accessibleObject == null && object2 != Class.class) {
                accessibleObject = Statement.getMethod((Class)object2, string, classArray);
            }
            if (accessibleObject == null && (accessibleObject = Statement.getMethod(Class.class, string, classArray)) != null && securityManager != null) {
                int n;
                if (string.equals("forName")) {
                    return Statement.classForName((String)objectArray[0]);
                }
                if ((string.equals("newInstance") || string.equals("getClasses") || string.startsWith("getConstructor") || string.startsWith("getField") || string.startsWith("getMethod")) && (n = ((String)(object = ((Class)object2).getName())).lastIndexOf(46)) != -1) {
                    securityManager.checkPackageAccess(((String)object).substring(0, n));
                }
                if (string.startsWith("getDeclared")) {
                    throw new Exception("Statement cannot invoke: " + string + " on " + object2.getClass());
                }
            }
        } else {
            if (object2.getClass().isArray() && (string == "set" || string == "get")) {
                int n = (Integer)objectArray[0];
                if (string == "get") {
                    return Array.get(object2, n);
                }
                Array.set(object2, n, objectArray[1]);
                return null;
            }
            accessibleObject = Statement.getMethod(object2.getClass(), string, classArray);
        }
        if (accessibleObject != null) {
            try {
                if (accessibleObject instanceof Method) {
                    if (securityManager != null) {
                        if (object2 instanceof Method && string.equals("invoke")) {
                            throw new Exception("Statement cannot invoke: " + string + " on " + object2.getClass());
                        }
                        if (ClassLoader.class.isAssignableFrom((Class)(object = accessibleObject.getReturnType()))) {
                            throw new Exception("Statement cannot invoke: " + string + " on " + object2.getClass());
                        }
                    }
                    return accessibleObject.invoke(object2, objectArray);
                }
                return ((Constructor)accessibleObject).newInstance(objectArray);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IllegalAccessException(this.toString());
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof Exception) {
                    throw (Exception)throwable;
                }
                throw invocationTargetException;
            }
        }
        throw new NoSuchMethodException(this.toString());
    }

    String instanceName(Object object) {
        return object != null && object.getClass() == String.class ? "\"" + (String)object + "\"" : NameGenerator.instanceName(object);
    }

    public String toString() {
        Object object = this.getTarget();
        String string = this.getMethodName();
        Object[] objectArray = this.getArguments();
        StringBuffer stringBuffer = new StringBuffer(this.instanceName(object) + "." + string + "(");
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(this.instanceName(objectArray[i]));
            if (i == n - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(");");
        return stringBuffer.toString();
    }

    private static class Signature {
        Class targetClass;
        String methodName;
        Class[] argClasses;

        public Signature(Class clazz, String string, Class[] classArray) {
            this.targetClass = clazz;
            this.methodName = string;
            this.argClasses = classArray;
        }

        public boolean equals(Object object) {
            Signature signature = (Signature)object;
            if (this.targetClass != signature.targetClass) {
                return false;
            }
            if (!this.methodName.equals(signature.methodName)) {
                return false;
            }
            if (this.argClasses.length != signature.argClasses.length) {
                return false;
            }
            for (int i = 0; i < this.argClasses.length; ++i) {
                if (this.argClasses[i] == signature.argClasses[i]) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return this.targetClass.hashCode() * 35 + this.methodName.hashCode();
        }
    }
}

