/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nio.cs;

import com.ibm.nio.cs.IBMCharsetDecoder;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CoderResult;

class DirectDecoder
extends IBMCharsetDecoder {
    private final int maxCode;

    protected DirectDecoder(Charset charset, int n) {
        super(charset, 1.0f, 1.0f);
        this.maxCode = n;
    }

    private CoderResult decodeArrayLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        int n;
        byte[] byArray = byteBuffer.array();
        int n2 = byteBuffer.arrayOffset() + byteBuffer.limit();
        char[] cArray = charBuffer.array();
        int n3 = charBuffer.arrayOffset() + charBuffer.position();
        int n4 = charBuffer.arrayOffset() + charBuffer.limit();
        CoderResult coderResult = CoderResult.UNDERFLOW;
        for (n = byteBuffer.arrayOffset() + byteBuffer.position(); n < n2; ++n) {
            char c = (char)(byArray[n] & 0xFF);
            if (c > this.maxCode) {
                coderResult = CoderResult.unmappableForLength(1);
                break;
            }
            if (n4 - n3 < 1) {
                coderResult = CoderResult.OVERFLOW;
                break;
            }
            cArray[n3++] = c;
        }
        byteBuffer.position(n - byteBuffer.arrayOffset());
        charBuffer.position(n3 - charBuffer.arrayOffset());
        return coderResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoderResult decodeBufferLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        int n = byteBuffer.position();
        try {
            while (byteBuffer.hasRemaining()) {
                char c = (char)(byteBuffer.get() & 0xFF);
                if (c > this.maxCode) {
                    CoderResult coderResult = CoderResult.unmappableForLength(1);
                    return coderResult;
                }
                if (!charBuffer.hasRemaining()) {
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                ++n;
                charBuffer.put(c);
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            byteBuffer.position(n);
        }
    }

    protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        if (byteBuffer.hasArray() && charBuffer.hasArray() && !UseBuffer) {
            return this.decodeArrayLoop(byteBuffer, charBuffer);
        }
        return this.decodeBufferLoop(byteBuffer, charBuffer);
    }
}

