/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nio;

import java.security.AccessController;
import sun.security.action.GetPropertyAction;

public class Debug {
    private static String nioFlags;
    private static boolean threadRequired;
    private String prefix;

    public static void Options() {
        System.err.println();
        System.err.println("all        turn on all debugging");
        System.err.println("deregister print info about keys deregistered from a selector");
        System.err.println("pipe       info relating socket creation problems, platform specific");
        System.err.println("selectorchannelarray    enable consistency checks for selector channel ");
        System.err.println("                        arrays, platform specific");
        System.err.println("selectornative          print info about selector native code, platform ");
        System.err.println("                        specific");
        System.err.println("selectornoupdatedkeys   enable detection of consecutive no updated keys from");
        System.err.println("                        select() operations, platform specific");
        System.err.println("                        Set java.nio.debug.consecutiveNoUpdatedKeysThreshold");
        System.err.println("                        to the number of consecutive no updated keys that ");
        System.err.println("                        should occur (default 300) before debug info is output");
        System.err.println();
        System.err.println();
        System.err.println("The following can be appended to the above:");
        System.err.println(":thread    add thread id information");
        System.err.println();
        System.err.println("Note: Separate multiple flags with a ','");
        System.exit(0);
    }

    protected Debug(String string) {
        this.prefix = string;
    }

    public static boolean isOn(String string) {
        if (nioFlags == null) {
            return false;
        }
        if (nioFlags.indexOf("all") != -1) {
            return true;
        }
        return nioFlags.indexOf(string) != -1;
    }

    public static Debug getInstance(String string) {
        if (Debug.isOn(string)) {
            return new Debug(string);
        }
        return null;
    }

    public void println(String string) {
        if (threadRequired) {
            System.err.println(this.prefix + ": (" + Thread.currentThread() + ") " + string);
        } else {
            System.err.println(this.prefix + ": " + string);
        }
    }

    public void println() {
        if (threadRequired) {
            System.err.println(this.prefix + ": (" + Thread.currentThread() + ")");
        } else {
            System.err.println(this.prefix + ":");
        }
    }

    public void printStackTrace(Throwable throwable) {
        int n;
        Throwable throwable2;
        Throwable throwable3;
        if (throwable == null) {
            throwable3 = new Throwable("stack trace ...");
            throwable2 = null;
            n = 2;
        } else {
            throwable3 = throwable;
            throwable2 = throwable.getCause();
            n = 0;
        }
        StackTraceElement[] stackTraceElementArray = throwable3.getStackTrace();
        for (int i = n; i < stackTraceElementArray.length; ++i) {
            this.println("   " + stackTraceElementArray[i]);
        }
        if (throwable2 != null) {
            this.println();
            this.println("cause: " + throwable2);
            this.printStackTrace(throwable2);
        }
    }

    static {
        threadRequired = false;
        nioFlags = (String)AccessController.doPrivileged(new GetPropertyAction("java.nio.debug"));
        if (nioFlags != null) {
            boolean bl = threadRequired = nioFlags.indexOf(":thread") != -1;
        }
        if (nioFlags != null && (nioFlags = nioFlags.toLowerCase()).equals("help")) {
            Debug.Options();
        }
    }
}

