/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.oldformat;

import com.ibm.jvm.oldformat.Message;
import com.ibm.jvm.oldformat.MessageFile;
import com.ibm.jvm.oldformat.TraceEntryFactory;
import com.ibm.jvm.oldformat.TraceFormat;
import com.ibm.jvm.oldformat.Util;
import java.math.BigInteger;
import java.util.Hashtable;

public class TraceEntry
implements Comparable {
    protected static final StringBuffer BASE_INDENT = new StringBuffer();
    protected static final String TAB = " ";
    protected static final int INTERNAL = 0;
    protected static final int EXTERNAL = 1;
    protected static final int TRACEID_LENGTH = 3;
    protected static final int TRACEID_OFFSET = 1;
    protected static final int TIMESTAMP_OFFSET = 4;
    protected static Hashtable indentLevels = null;
    protected static long lastThread = 0L;
    protected static int maxTimeLength = 16;
    protected int nextLength;
    protected int traceID;
    protected long threadID;
    protected BigInteger timeStamp;
    protected int offset;
    protected int nextOffset;
    protected int length;
    protected byte[] buffer;
    private String padding = "0000000000000000";
    private String component;
    private int type;
    private Message message;

    protected TraceEntry(int n, long l, int n2) {
        this.nextOffset = n;
        this.threadID = l;
        this.length = n2;
    }

    protected final void init(byte[] byArray, int n, BigInteger bigInteger) {
        this.buffer = byArray;
        this.offset = n;
        this.nextLength = Util.constructUnsignedByte(byArray, n);
        this.traceID = Util.constructTraceID(byArray, n + 1);
        this.timeStamp = this.traceID == 256 && this.length == 8 ? TraceEntryFactory.getWrapTime() : bigInteger.shiftLeft(32).or(Util.constructUnsignedLong(byArray, n + 4, 4));
        this.message = MessageFile.getMessageFromID(this.traceID);
        if (this.message != null) {
            this.type = this.message.getType();
            this.component = this.message.getComponent();
        }
        if (Integer.valueOf(Util.getProperty("POINTER_SIZE")) == 4) {
            this.padding = "00000000";
        }
    }

    protected final long getNextLength() {
        return this.nextLength;
    }

    protected final int getTraceID() {
        return this.traceID;
    }

    protected final BigInteger getTimeStamp() {
        return this.timeStamp;
    }

    protected final long getNextOffset() {
        return this.nextOffset;
    }

    protected final long getThreadID() {
        return this.threadID;
    }

    protected final String getComponent() {
        return this.component;
    }

    protected String getType() {
        return TraceFormat.types[this.type];
    }

    public final int compareTo(Object object) {
        return this.timeStamp.compareTo(((TraceEntry)object).timeStamp);
    }

    protected final String format() {
        if (this.message != null) {
            boolean bl = Boolean.valueOf(Util.getProperty("INDENT"));
            String string = Util.getFormattedTime(this.timeStamp);
            String string2 = Long.toString(this.threadID, 16);
            boolean bl2 = this.threadID != lastThread;
            lastThread = this.threadID;
            StringBuffer stringBuffer = TraceEntry.getIndent(string2, bl);
            StringBuffer stringBuffer2 = new StringBuffer(string);
            String string3 = this.traceID == 256 ? this.message.getMessage(this.buffer, this.offset + 4, this.offset + 8) : this.message.getMessage(this.buffer, this.offset + 8, this.offset + this.length);
            stringBuffer2.ensureCapacity(100);
            String string4 = Integer.toHexString(this.traceID);
            string4 = "000000".substring(string4.length()) + string4;
            if ((double)TraceFormat.verMod >= 1.1) {
                stringBuffer2.append(bl2 ? "*" : TAB).append(this.padding.substring(string2.length()) + string2).append(TAB).append(string4).append((this.type & TraceFormat.EXCEPTION_TYPE) == TraceFormat.EXCEPTION_TYPE ? "*" : TAB).append(TraceFormat.types[this.type]);
            } else {
                stringBuffer2.append(bl2 ? "*" : TAB).append(this.padding.substring(string2.length()) + string2).append(TAB).append(string4).append(this.type == TraceFormat.EXCEPTION_TYPE ? TraceFormat.Chars[this.type] : TAB).append(TraceFormat.types[this.type]);
            }
            if (bl && (this.type == TraceFormat.EXIT_TYPE || this.type == TraceFormat.EXIT_EXCPT_TYPE)) {
                stringBuffer.delete(0, TAB.length());
                TraceEntry.setIndent(string2, stringBuffer);
            }
            stringBuffer2.append(BASE_INDENT.toString()).append(bl ? stringBuffer.toString() : "").append(TraceFormat.Chars[this.type]).append(TAB).append(string3);
            if (bl && (this.type == TraceFormat.ENTRY_TYPE || this.type == TraceFormat.ENTRY_EXCPT_TYPE)) {
                stringBuffer.append(TAB);
                TraceEntry.setIndent(string2, stringBuffer);
            }
            return stringBuffer2.toString();
        }
        return "";
    }

    protected static final StringBuffer getIndent(String string, boolean bl) {
        StringBuffer stringBuffer;
        if (!bl) {
            return BASE_INDENT;
        }
        if (indentLevels == null) {
            indentLevels = new Hashtable();
        }
        return (stringBuffer = (StringBuffer)indentLevels.get(string)) == null ? new StringBuffer() : stringBuffer;
    }

    protected static final void setIndent(String string, StringBuffer stringBuffer) {
        if (indentLevels == null) {
            indentLevels = new Hashtable();
        }
        indentLevels.remove(string);
        indentLevels.put(string, stringBuffer);
    }

    public String toString() {
        return "TraceEntry: traceID = 0x" + Integer.toHexString(this.traceID) + " timeStamp = 0x" + this.timeStamp.toString(16) + " entry length = " + this.buffer.length;
    }
}

