/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.linux;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class ProcStatus {
    private Hashtable status;
    private String pid;
    private StringBuffer data;

    public ProcStatus(String string) {
        this.pid = string;
        this.status = new Hashtable();
        this.data = new StringBuffer();
        this.read("/proc/" + string + "/status");
    }

    public void read(String string) {
        BufferedReader bufferedReader;
        try {
            bufferedReader = new BufferedReader(new FileReader(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.console("read() FileNotFound: " + fileNotFoundException);
            return;
        }
        try {
            String string2;
            while ((string2 = bufferedReader.readLine()) != null) {
                if ((string2 = string2.trim()).length() == 0) continue;
                this.data.append(string2);
                this.data.append("\n");
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ":");
                String string3 = stringTokenizer.nextToken();
                String string4 = "";
                if (string3.equals("User GPRS") || string3.equals("User ACRS")) {
                    int n = 4;
                    if (stringTokenizer.hasMoreTokens()) {
                        string4 = stringTokenizer.nextToken().trim();
                        n = 3;
                    }
                    for (int i = 0; i < n; ++i) {
                        string2 = bufferedReader.readLine().trim();
                        this.data.append(string2);
                        this.data.append("\n");
                        string4 = string4 + " " + string2;
                    }
                    string4.trim();
                } else if (stringTokenizer.hasMoreTokens()) {
                    string4 = stringTokenizer.nextToken().trim();
                }
                this.status.put(string3, string4);
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            this.console("read() IOException: " + iOException);
            return;
        }
    }

    public String get(String string) {
        return (String)this.status.get(string);
    }

    public String getData() {
        return this.data.toString();
    }

    private void console(String string) {
        System.err.println("ProcStatus(" + this.pid + ")" + string);
    }
}

