/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.linux;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class ProcStat {
    private Hashtable stat;
    private String pid;
    private String data;

    public ProcStat(String string) {
        this.pid = string;
        this.stat = new Hashtable();
        this.data = this.read("/proc/" + string + "/stat");
        this.process();
    }

    public String read(String string) {
        BufferedReader bufferedReader;
        try {
            bufferedReader = new BufferedReader(new FileReader(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.console("read() FileNotFound: " + fileNotFoundException);
            return null;
        }
        try {
            this.data = bufferedReader.readLine().trim();
            bufferedReader.close();
        }
        catch (IOException iOException) {
            this.console("read() IOException: " + iOException);
            return null;
        }
        return this.data;
    }

    private void process() {
        StringTokenizer stringTokenizer = new StringTokenizer(this.data, " ");
        this.pid = stringTokenizer.nextToken();
        this.stat.put("pid", this.pid);
        this.stat.put("comm", stringTokenizer.nextToken());
        this.stat.put("state", stringTokenizer.nextToken());
        this.stat.put("ppid", stringTokenizer.nextToken());
        this.stat.put("pgrp", stringTokenizer.nextToken());
        this.stat.put("session", stringTokenizer.nextToken());
        this.stat.put("tty", stringTokenizer.nextToken());
        this.stat.put("tpgid", stringTokenizer.nextToken());
        this.stat.put("flags", stringTokenizer.nextToken());
        this.stat.put("minflt", stringTokenizer.nextToken());
        this.stat.put("cminflt", stringTokenizer.nextToken());
        this.stat.put("majflt", stringTokenizer.nextToken());
        this.stat.put("cmajflt", stringTokenizer.nextToken());
        this.stat.put("utime", stringTokenizer.nextToken());
        this.stat.put("stime", stringTokenizer.nextToken());
        this.stat.put("cutime", stringTokenizer.nextToken());
        this.stat.put("cstime", stringTokenizer.nextToken());
        this.stat.put("counter", stringTokenizer.nextToken());
        this.stat.put("priority", stringTokenizer.nextToken());
        this.stat.put("timout", stringTokenizer.nextToken());
        this.stat.put("itrealvalue", stringTokenizer.nextToken());
        this.stat.put("statrtime", stringTokenizer.nextToken());
        this.stat.put("vsize", stringTokenizer.nextToken());
        this.stat.put("rss", stringTokenizer.nextToken());
        this.stat.put("rlim", stringTokenizer.nextToken());
        this.stat.put("startcode", stringTokenizer.nextToken());
        this.stat.put("endcode", stringTokenizer.nextToken());
        this.stat.put("startstack", stringTokenizer.nextToken());
        this.stat.put("kstkesp", stringTokenizer.nextToken());
        this.stat.put("kstkeip", stringTokenizer.nextToken());
        this.stat.put("signal", stringTokenizer.nextToken());
        this.stat.put("blocked", stringTokenizer.nextToken());
        this.stat.put("sigignore", stringTokenizer.nextToken());
        this.stat.put("sigcatch", stringTokenizer.nextToken());
        this.stat.put("wchan", stringTokenizer.nextToken());
    }

    public String get(String string) {
        return (String)this.stat.get(string);
    }

    private void console(String string) {
        System.err.println("ProcStat(" + this.pid + ")" + string);
    }
}

