/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.format;

import com.ibm.jvm.format.InvalidSpannedRecordException;
import com.ibm.jvm.format.TraceFile;
import com.ibm.jvm.format.TraceRecord;
import com.ibm.jvm.format.Util;
import java.io.IOException;

public final class TraceRecordExternal
extends TraceRecord {
    protected byte[] spannedEntrySoFar;
    protected byte[] spanEntry;
    private int spannedEntrySizeSoFar = 0;

    protected TraceRecordExternal(TraceFile traceFile, int n) throws IOException {
        super(traceFile, n);
    }

    protected void prime() throws IOException {
        this.buffer = new byte[this.bufferSize - this.headerSize + this.spannedEntrySizeSoFar];
        byte by = 0;
        int n = 0;
        int n2 = (int)(this.nextEntry - (long)this.headerSize + (long)this.spannedEntrySizeSoFar);
        if (this.spannedEntrySizeSoFar > 0) {
            System.arraycopy(this.spannedEntrySoFar, 0, this.buffer, 0, this.spannedEntrySizeSoFar);
        }
        this.traceFile.seek(this.start + this.headerSize);
        this.traceFile.read(this.buffer, this.spannedEntrySizeSoFar, this.bufferSize - this.headerSize);
        Util.Debug.println(" ");
        Util.Debug.println("TraceRecord: reading buffer size=:        " + this.bufferSize);
        Util.Debug.println("TraceRecord: nextEntry        :           " + (int)this.nextEntry);
        if (this.nextEntry < 0L) {
            Util.Debug.println("TraceRecord: entry spans entire record");
            this.copySpannedEntryForNextRecord(this.buffer, 0, this.bufferSize - this.headerSize + this.spannedEntrySizeSoFar);
            return;
        }
        Util.Debug.println("TraceRecord: buffer[nextEntry]:           " + this.buffer[n2]);
        this.copySpannedEntryForNextRecord(this.buffer, n2, this.bufferSize - this.headerSize + this.spannedEntrySizeSoFar);
        int n3 = Util.constructUnsignedByte(this.buffer, n2);
        while (n2 != 0) {
            if ((n2 -= n3) < 0) {
                Util.Debug.println("entry < 0 must be a partial entry in first record");
                Util.Debug.println("spannedEntrySizeSoFar " + this.spannedEntrySizeSoFar);
                if (this.spannedEntrySizeSoFar != 0) {
                    throw new InvalidSpannedRecordException("Invalid spanned trace record");
                }
                n2 += n3;
                break;
            }
            if (n3 == 8 && n2 != 0 && this.buffer[n2 + 3] == 0 && this.buffer[n2 + 2] == 0 && this.buffer[n2 + 1] == 0) {
                this.wrapTimes.push(this.upperWord);
                this.upperWord = Util.constructUnsignedLong(this.buffer, n2 + 4, 4);
                Util.Debug.println("TraceBuffer: timewrap entry =" + n2 + " upperWord=" + this.upperWord);
            }
            if (n3 == 4 && this.buffer[n2 + 2] == 0 && this.buffer[n2 + 1] == 0) {
                Util.Debug.println("Entry with data length > 256");
                by = this.buffer[n2 + 3];
                n = Util.constructUnsignedByte(this.buffer, n2);
                if (n2 - (n + by * 256) < 0) {
                    Util.Debug.println("entry < 0 must be a partial entry in first record");
                    Util.Debug.println("spannedEntrySizeSoFar " + this.spannedEntrySizeSoFar);
                    if (this.spannedEntrySizeSoFar != 0) {
                        throw new InvalidSpannedRecordException("Invalid spanned trace record");
                    }
                    n2 += n3;
                    break;
                }
                this.buffer[n2] = (byte)n3;
                this.longEntryTraceIDs.push(new Integer(Util.constructTraceID(this.buffer, (n2 -= n + by * 256) + 1)));
                this.buffer[n2 + 1] = 0;
                this.buffer[n2 + 2] = 0;
                this.buffer[n2 + 3] = by;
                n3 = n;
            }
            if (n3 == 0) {
                if (by == 0) {
                    Util.Debug.println("TraceRecord: Hit 0 length entry");
                    break;
                }
                Util.Debug.println("TraceRecord: 0 length entry (long record length is exact multiple of 256)");
            }
            int n4 = Util.constructUnsignedByte(this.buffer, n2);
            this.buffer[n2] = (byte)n3;
            n3 = n4;
        }
        if (this.buffer[n2] == 8 && this.buffer[n2 + 1] == 0 && this.buffer[n2 + 2] == 0 && this.buffer[n2 + 3] == 0) {
            n2 += 8;
            Util.Debug.println("TraceBuffer: ignoring time wrap at offset 0");
        }
        this.offset = n2;
        this.currentTimeStamp = this.upperWord.shiftLeft(32).or(Util.constructUnsignedLong(this.buffer, n2 + 4, 4));
        Util.Debug.println("TraceRecord: oldest offset for thread " + this.threadID + " = " + this.offset + " timeStamp = " + this.currentTimeStamp);
    }

    protected int getNextEntry() throws IOException {
        int n;
        if (this.notFormatted) {
            return 1;
        }
        this.notFormatted = true;
        do {
            if (this.nextEntry < 0L || (long)this.offset >= this.nextEntry - (long)this.headerSize + (long)this.spannedEntrySizeSoFar) {
                n = 0;
                continue;
            }
            n = this.processNextEntryHeader(this.buffer, this.offset);
            if (this.currentLength >= 256) {
                this.offset += 4;
            }
            this.offset += this.currentLength;
        } while (n == 2);
        return n;
    }

    protected final void spanStart(byte[] byArray, int n) {
        this.spannedEntrySoFar = byArray;
        this.spannedEntrySizeSoFar = n;
    }

    protected final void copySpannedEntryForNextRecord(byte[] byArray, int n, int n2) {
        TraceRecordExternal traceRecordExternal = (TraceRecordExternal)this.getNextRecord();
        if (traceRecordExternal == null) {
            return;
        }
        byte[] byArray2 = new byte[n2 - n];
        System.arraycopy(byArray, n, byArray2, 0, n2 - n);
        traceRecordExternal.spanStart(byArray2, n2 - n);
        if (n2 - n < 8) {
            byte[] byArray3 = new byte[9];
            System.arraycopy(byArray, n, byArray3, 0, n2 - n);
            System.arraycopy(traceRecordExternal.nextEight, 0, byArray3, n2 - n, 9 - (n2 - n));
            if (byArray3[8] == 8 && byArray3[1] == 0 && byArray3[2] == 0 && byArray3[3] == 0) {
                this.upperWord = Util.constructUnsignedLong(byArray3, 4, 4);
                Util.Debug.println("TraceBuffer: spanned timewrap entry=" + n + " upperWord=" + this.upperWord);
            }
        }
    }
}

