/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm;

import com.ibm.jvm.AllocationPolicy;
import com.ibm.jvm.ClassLoaderAlreadyRegisteredException;
import com.ibm.jvm.ClassLoaderParentMismatchException;
import com.ibm.jvm.NamespaceException;
import com.ibm.jvm.NamespaceInUseException;
import com.ibm.jvm.classloader.Shareable;
import java.io.ObjectStreamClass;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.jar.Attributes;
import sun.misc.Launcher;

public class ExtendedSystem {
    private static final int SCJVM_CLEAN = 0;
    private static final int SCJVM_MAX_EVENT = 65535;
    private static final int SCJVM_ALWAYS_DIRTY = 65536;
    private static final int SCJVM_STACK_TRACE_VALID = 131072;
    public static final int SCJVM_MODIFYING_STATIC = 131073;
    public static final int SCJVM_AWT = 196610;
    public static final int SCJVM_MODIFYING_SECURITY = 131075;
    public static final int SCJVM_SETTING_CLASSLOADER_OR_SECURITY_MANAGER = 131076;
    public static final int SCJVM_USING_REFLECTION = 131077;
    public static final int SCJVM_PROPERTIES = 131078;
    public static final int SCJVM_REDIRECTING_IO = 131079;
    public static final int SCJVM_CLOSING_IO = 131080;
    public static final int SCJVM_THREADS = 131081;
    public static final int SCJVM_JNI = 131082;
    public static final int SCJVM_CREATING_PROCESS = 131083;
    public static final int SCJVM_TIDYUP_FAILED = 65548;
    public static final int SCJVM_APPLICATION_OBJECT_REACHABLE_FROM_STATIC = 65549;
    public static final int SCJVM_REF_FROM_MW_TO_TH = 65550;
    public static final int SCJVM_MW_STATIC_VARIABLE_IN_TH = 65551;
    public static final int SCJVM_JNI_GLOBAL_REFERENCE_IN_TH = 65552;
    public static final int SCJVM_PINNED_OBJECT_FOUND_DURING_RESET = 65553;
    public static final int SCJVM_TRANSIENT_HEAP_TOO_SMALL = 65554;
    public static final int SCJVM_MIDDLEWARE_RETAINING_APPLICATION_CLASSLOADER = 65555;
    public static final int SCJVM_LOADING_UNCHECKED_EXTENSION = 65556;
    public static final int SCJVM_IN_DEBUG_MODE = 65557;
    public static final int SCJVM_MULTIPLE_THREADS_AT_RESET = 65558;
    public static final int SCJVM_REINITIALIZE_FAILED = 65559;
    public static final int SCJVM_JVM_INTERNAL_ERROR = 65560;
    public static final int SCJVM_REF_TO_SHAREABLE_APPLICATION_CLASS = 65561;
    public static final int SCJVM_REF_TO_NONSHAREABLE_APPLICATION_CLASS = 65562;
    public static final int SCJVM_SECURITYMANAGER_NOT_PRIMORDIAL_OR_MIDDLEWARE = 65563;
    public static final int SCJVM_PROMOTION_OUT_OF_MEMORY = 65564;
    public static final int SCJVM_OUTSTANDING_JAVA_EXCEPTION = 65565;
    public static final int SCJVM_TH_OR_ACSH_POINTER_FROM_LAUNCHER = 65566;
    public static final int SCJVM_TH_OR_ACSH_POINTER_IN_NON_LAUNCHER = 65567;
    public static final Attributes.Name EXTENSION_COMPATIBLE = new Attributes.Name("IBM-Reusable-JVM-Compatible");
    private static boolean doUnresettableEventsCheck = true;
    private static boolean checkedResettableMode = false;
    private static boolean resettableMode = false;
    private static Hashtable namespaces = new Hashtable();
    private static Field loaderInitialized = null;
    private static Field loaderDeleted = null;
    private static Field loaderNamespace = null;
    private static Field launcherExtLoader = null;
    private static Method loaderCopyFrom = null;
    private static Method loaderRegisterAllocationPolicy = null;
    private static final Method methodGetSerializationClass;
    private static final Method methodAllocateNewObject;
    private static Hashtable jarsToSkip;
    private static boolean checkedOldReflectionMode;
    private static boolean oldReflectionMode;

    private static native void registerNatives();

    public static native void getGlobalLock();

    public static native void releaseGlobalLock();

    public static boolean isOldReflectionMode() {
        if (!checkedOldReflectionMode) {
            oldReflectionMode = ExtendedSystem.isOldReflectionMode0();
            checkedOldReflectionMode = true;
        }
        return oldReflectionMode;
    }

    private static native boolean isOldReflectionMode0();

    public static void registerTrustedJars(URL[] uRLArray) {
        for (int i = 0; i < uRLArray.length; ++i) {
            String string = uRLArray[i].getFile();
            if (!string.endsWith(".jar")) continue;
            jarsToSkip.put(string, string);
        }
    }

    public static boolean isJarRegistered(String string) {
        Object object = jarsToSkip.get(string);
        return object != null;
    }

    public static void sortArray(Object[] objectArray, Comparator comparator) {
        Object[] objectArray2 = (Object[])objectArray.clone();
        ExtendedSystem.mergeSort(objectArray2, objectArray, 0, objectArray.length, comparator);
        Arrays.fill(objectArray2, null);
    }

    private static void mergeSort(Object[] objectArray, Object[] objectArray2, int n, int n2, Comparator comparator) {
        int n3 = n2 - n;
        if (n3 < 7) {
            for (int i = n; i < n2; ++i) {
                for (int j = i; j > n && comparator.compare(objectArray2[j - 1], objectArray2[j]) > 0; --j) {
                    ExtendedSystem.swap(objectArray2, j, j - 1);
                }
            }
            return;
        }
        int n4 = n + n2 >> 1;
        ExtendedSystem.mergeSort(objectArray2, objectArray, n, n4, comparator);
        ExtendedSystem.mergeSort(objectArray2, objectArray, n4, n2, comparator);
        if (comparator.compare(objectArray[n4 - 1], objectArray[n4]) <= 0) {
            System.arraycopy(objectArray, n, objectArray2, n, n3);
            return;
        }
        int n5 = n;
        int n6 = n4;
        for (int i = n; i < n2; ++i) {
            objectArray2[i] = n6 >= n2 || n5 < n4 && comparator.compare(objectArray[n5], objectArray[n6]) <= 0 ? objectArray[n5++] : objectArray[n6++];
        }
    }

    private static void swap(Object[] objectArray, int n, int n2) {
        Object object = objectArray[n];
        objectArray[n] = objectArray[n2];
        objectArray[n2] = object;
    }

    private static Object allocateNewObject(final Class clazz) throws PrivilegedActionException {
        Object object = AccessController.doPrivileged(new PrivilegedExceptionAction(){

            public Object run() throws IllegalAccessException, InstantiationException, InvocationTargetException {
                Class clazz2 = (Class)methodGetSerializationClass.invoke(null, new Object[]{clazz});
                return methodAllocateNewObject.invoke(null, new Object[]{clazz, clazz2});
            }
        });
        return object;
    }

    public static void registerAllocationPolicy(ClassLoader classLoader, AllocationPolicy allocationPolicy) {
        try {
            Class[] classArray = new Class[]{AllocationPolicy.class};
            Object[] objectArray = new Object[]{allocationPolicy};
            if (null == loaderRegisterAllocationPolicy) {
                loaderRegisterAllocationPolicy = ExtendedSystem.getPrivateMethod(ClassLoader.class, "registerAllocationPolicy", classArray);
            }
            loaderRegisterAllocationPolicy.invoke(classLoader, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            InternalError internalError = new InternalError();
            internalError.initCause(illegalAccessException);
            throw internalError;
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.getCause().printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerShareableClassLoader(Shareable shareable, String string) throws NamespaceException {
        try {
            ClassLoader classLoader = (ClassLoader)((Object)shareable);
            String string2 = (classLoader.getClass().getName() + (null == string ? "" : "." + string)).intern();
            Hashtable hashtable = namespaces;
            synchronized (hashtable) {
                if (ExtendedSystem.isDeleted(classLoader)) {
                    ExtendedSystem.setJVMUnresettableConditionally(65555, new String("Loader " + classLoader.toString() + " is no longer valid"));
                    throw new NamespaceException("Application class loader retained: " + classLoader);
                }
                if (ExtendedSystem.isInitialized(classLoader)) {
                    throw new ClassLoaderAlreadyRegisteredException(ExtendedSystem.getNamespace(classLoader));
                }
                ClassLoader classLoader2 = (ClassLoader)namespaces.get(string2);
                if (null != classLoader2) {
                    if (ExtendedSystem.isInitialized(classLoader2)) {
                        throw new NamespaceInUseException(string2);
                    }
                    ClassLoader classLoader3 = classLoader.getParent();
                    ClassLoader classLoader4 = classLoader2.getParent();
                    if (null == classLoader3 && null == classLoader4 || ExtendedSystem.getNamespace(classLoader3).equals(ExtendedSystem.getNamespace(classLoader4))) {
                        ClassLoader classLoader5 = classLoader;
                        synchronized (classLoader5) {
                            if (!ExtendedSystem.registerClassLoader0(classLoader, classLoader2)) {
                                throw new InternalError("Cannot register class loader: " + classLoader);
                            }
                            ExtendedSystem.copyFrom(classLoader, classLoader2);
                        }
                    } else {
                        throw new ClassLoaderParentMismatchException(ExtendedSystem.getNamespace(classLoader3) + ", " + ExtendedSystem.getNamespace(classLoader4));
                    }
                    namespaces.remove(string2);
                } else {
                    ClassLoader classLoader6 = classLoader;
                    synchronized (classLoader6) {
                        if (!ExtendedSystem.registerNewClassLoader0(classLoader, string2)) {
                            throw new InternalError("Cannot register class loader: " + classLoader);
                        }
                    }
                }
                ExtendedSystem.setNamespace(classLoader, string2);
                ExtendedSystem.setInitialized(classLoader, true);
                namespaces.put(string2, classLoader);
            }
        }
        catch (ClassCastException classCastException) {
            throw new NamespaceException(shareable.getClass().getName() + " not a ClassLoader");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new InternalError(illegalAccessException.toString());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InternalError(illegalArgumentException.toString());
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new InternalError(invocationTargetException.toString());
        }
        catch (SecurityException securityException) {
            throw new InternalError(securityException.toString());
        }
    }

    private static boolean isInitialized(ClassLoader classLoader) throws IllegalAccessException {
        if (null == loaderInitialized) {
            loaderInitialized = ExtendedSystem.getPrivateField(ClassLoader.class, "initialized");
        }
        return loaderInitialized.getBoolean(classLoader);
    }

    private static void setInitialized(ClassLoader classLoader, boolean bl) throws IllegalAccessException {
        if (null == loaderInitialized) {
            loaderInitialized = ExtendedSystem.getPrivateField(ClassLoader.class, "initialized");
        }
        loaderInitialized.setBoolean(classLoader, bl);
    }

    private static boolean isDeleted(ClassLoader classLoader) throws IllegalAccessException {
        if (null == loaderDeleted) {
            loaderDeleted = ExtendedSystem.getPrivateField(ClassLoader.class, "deleted");
        }
        return loaderDeleted.getBoolean(classLoader);
    }

    private static String getNamespace(ClassLoader classLoader) throws IllegalAccessException {
        if (null == classLoader) {
            return "";
        }
        if (null == loaderNamespace) {
            loaderNamespace = ExtendedSystem.getPrivateField(ClassLoader.class, "namespace");
        }
        return (String)loaderNamespace.get(classLoader);
    }

    private static void setNamespace(ClassLoader classLoader, String string) throws IllegalAccessException {
        if (null == loaderNamespace) {
            loaderNamespace = ExtendedSystem.getPrivateField(ClassLoader.class, "namespace");
        }
        loaderNamespace.set(classLoader, string);
    }

    private static void copyFrom(ClassLoader classLoader, ClassLoader classLoader2) throws IllegalAccessException, InvocationTargetException {
        Class[] classArray = new Class[]{ClassLoader.class};
        Object[] objectArray = new Object[]{classLoader2};
        if (null == loaderCopyFrom) {
            loaderCopyFrom = ExtendedSystem.getPrivateMethod(ClassLoader.class, "copyFrom", classArray);
        }
        loaderCopyFrom.invoke(classLoader, objectArray);
    }

    private static Field getPrivateField(final Class clazz, final String string) {
        Field field = (Field)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Field field = null;
                try {
                    field = clazz.getDeclaredField(string);
                    if (null != field) {
                        field.setAccessible(true);
                    }
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    throw new InternalError(noSuchFieldException.toString());
                }
                return field;
            }
        });
        return field;
    }

    private static Method getPrivateMethod(final Class clazz, final String string, final Class[] classArray) {
        Method method = (Method)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Method method = null;
                try {
                    method = clazz.getDeclaredMethod(string, classArray);
                    if (null != method) {
                        method.setAccessible(true);
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new InternalError(noSuchMethodException.toString());
                }
                return method;
            }
        });
        return method;
    }

    private static ClassLoader getExtClassLoader() throws IllegalAccessException {
        Launcher launcher = Launcher.getLauncher();
        if (null == launcherExtLoader) {
            launcherExtLoader = ExtendedSystem.getPrivateField(launcher.getClass(), "extLoader");
        }
        return (ClassLoader)launcherExtLoader.get(launcher);
    }

    private static native boolean registerClassLoader0(ClassLoader var0, ClassLoader var1);

    private static native boolean registerNewClassLoader0(ClassLoader var0, String var1);

    public static void setJVMUnresettableConditionally(int n) {
        if (doUnresettableEventsCheck) {
            doUnresettableEventsCheck = ExtendedSystem.setJVMUnresettableConditionally0(n, new String(""));
        }
    }

    public static void setJVMUnresettableConditionally(int n, String string) {
        if (doUnresettableEventsCheck) {
            doUnresettableEventsCheck = ExtendedSystem.setJVMUnresettableConditionally0(n, string);
        }
    }

    public static native boolean isJVMUnresettable();

    public static boolean isResettableJVM() {
        if (!checkedResettableMode) {
            resettableMode = ExtendedSystem.isResettableJVM0();
            checkedResettableMode = true;
            if (resettableMode) {
                oldReflectionMode = true;
                checkedOldReflectionMode = true;
            }
        }
        return resettableMode;
    }

    private static native boolean isResettableJVM0();

    public static boolean getDoUnresettableEventsCheck() {
        return doUnresettableEventsCheck;
    }

    private static native boolean setJVMUnresettableConditionally0(int var0, String var1);

    public static native Object resizeArray(int var0, Object var1, int var2, int var3);

    public static native Object newArray(Class var0, int var1, Object var2);

    static {
        jarsToSkip = new Hashtable(32);
        ExtendedSystem.registerNatives();
        methodGetSerializationClass = ExtendedSystem.getPrivateMethod(ObjectStreamClass.class, "getSerializationClass", new Class[]{Class.class});
        methodAllocateNewObject = ExtendedSystem.getPrivateMethod(ObjectStreamClass.class, "allocateNewObject", new Class[]{Class.class, Class.class});
        checkedOldReflectionMode = false;
        oldReflectionMode = false;
    }
}

