/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.component;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.channel.framework.ChainData;
import com.ibm.websphere.channel.framework.ChainGroupData;
import com.ibm.websphere.channel.framework.ChainStartMode;
import com.ibm.websphere.channel.framework.ChannelData;
import com.ibm.websphere.channel.framework.ChannelFactoryData;
import com.ibm.websphere.channel.framework.FlowType;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.websphere.models.config.channelservice.Chain;
import com.ibm.websphere.models.config.channelservice.TransportChannel;
import com.ibm.websphere.models.config.channelservice.TransportChannelFactory;
import com.ibm.websphere.models.config.channelservice.TransportChannelService;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.ws.channel.framework.ChannelTypeManager;
import com.ibm.ws.channel.framework.ctm.RuntimeChannelTypeManager;
import com.ibm.ws.channel.framework.ctm.ValidationChannelTypeManager;
import com.ibm.ws.channel.framework.impl.WSChannelFrameworkImpl;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.collaborator.DefaultRuntimeCollaborator;
import com.ibm.ws.runtime.component.ComponentImpl;
import com.ibm.ws.runtime.component.TransportChannelLoaderImpl;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.util.ThreadPool;
import com.ibm.wsspi.channel.framework.CFEndPoint;
import com.ibm.wsspi.channel.framework.CFEndPointCriteria;
import com.ibm.wsspi.channel.framework.ChainEventListener;
import com.ibm.wsspi.channel.framework.ChannelFrameworkFactory;
import com.ibm.wsspi.channel.framework.ChannelFrameworkService;
import com.ibm.wsspi.channel.framework.TransportChannelLoader;
import com.ibm.wsspi.channel.framework.VirtualConnectionFactory;
import com.ibm.wsspi.channel.framework.exception.ChainException;
import com.ibm.wsspi.channel.framework.exception.ChainGroupException;
import com.ibm.wsspi.channel.framework.exception.ChainNotInboundException;
import com.ibm.wsspi.channel.framework.exception.ChannelException;
import com.ibm.wsspi.channel.framework.exception.ChannelFactoryException;
import com.ibm.wsspi.channel.framework.exception.ChannelFrameworkException;
import com.ibm.wsspi.channel.framework.exception.DuplicatePoolException;
import com.ibm.wsspi.channel.framework.exception.InvalidChannelFactoryException;
import com.ibm.wsspi.channel.framework.exception.NoCFEndPointException;
import com.ibm.wsspi.channel.framework.exception.NullCFEndPointException;
import java.io.FileNotFoundException;
import java.lang.reflect.Constructor;
import java.util.Iterator;
import java.util.Map;
import javax.naming.Context;
import org.eclipse.emf.ecore.resource.Resource;

public class ChannelFrameworkServiceImpl
extends ComponentImpl
implements ChannelFrameworkService {
    private static final TraceComponent tc = Tr.register(ChannelFrameworkServiceImpl.class, "ChannelFrameworkService", "com.ibm.ws.channel.resources.channelframeworkservice");
    private Exception factoryException;
    protected Context _context;
    protected ChannelFrameworkService _delegate;
    protected boolean _started = false;
    protected String _configID;

    public ChannelFrameworkServiceImpl() {
        try {
            ChannelFrameworkFactory.setChannelFramework(this);
        }
        catch (Exception exception) {
            this.factoryException = exception;
        }
    }

    public ChannelFrameworkService getDelegateService() {
        return this._delegate;
    }

    public void initialize(Object object) throws ConfigurationWarning, ConfigurationError, ComponentDisabledException {
        Iterator iterator;
        Object object2;
        Object object3;
        this.checkFactoryExceptions();
        ConfigurationWarning configurationWarning = null;
        Repository repository = (Repository)this.getService(Repository.class);
        TransportChannelService transportChannelService = this.loadConfiguration(repository);
        if (transportChannelService != null && transportChannelService.isSetEnable() && !transportChannelService.isEnable()) {
            Tr.audit(tc, "framework.disabled");
            throw new ComponentDisabledException();
        }
        this._configID = transportChannelService != null ? this.getConfigId(transportChannelService) : this.getClass().getName();
        String string = null;
        String string2 = null;
        String string3 = null;
        if (transportChannelService != null) {
            object3 = null;
            object2 = null;
            iterator = transportChannelService.getProperties().iterator();
            while (iterator.hasNext()) {
                object3 = (Property)iterator.next();
                object2 = object3.getName();
                if (((String)object2).equals("ChainStartRetryInterval")) {
                    string2 = object3.getValue();
                    continue;
                }
                if (((String)object2).equals("ChainStartRetryAttempts")) {
                    string3 = object3.getValue();
                    continue;
                }
                if (!((String)object2).equals("ChannelJarLocation")) continue;
                string = object3.getValue();
            }
        }
        if (string == null) {
            string = System.getProperty("ChannelJarLocation");
        }
        object2 = (TransportChannelLoaderImpl)this.getService(TransportChannelLoader.class);
        try {
            object3 = new RuntimeChannelTypeManager(repository, string, (TransportChannelLoaderImpl)object2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            object3 = new ValidationChannelTypeManager();
            configurationWarning = new ConfigurationWarning("installed-channels.xml missing; defaulting to all channels", fileNotFoundException);
            FFDCFilter.processException(fileNotFoundException, "com.ibm.ws.runtime.component.ChannelFrameworkServiceImpl.initialize", "207", this, new Object[]{repository, string});
        }
        catch (Exception exception) {
            throw new ConfigurationError("could not initialize the ChannelTypeManager", exception);
        }
        finally {
            this.releaseService(repository);
        }
        if (AdminHelper.getPlatformHelper().isZOS()) {
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ChannelFrameworkServiceImpl.initialize", "Initializing XMemChannelFactoryImpl");
                }
                iterator = Class.forName("com.ibm.xmem.ws390.XMemChannelFrameworkImpl");
                Constructor constructor = ((Class)((Object)iterator)).getConstructor(TransportChannelService.class, ClassLoader.class, ChannelFrameworkServiceImpl.class, ChannelTypeManager.class);
                this._delegate = (ChannelFrameworkService)constructor.newInstance(transportChannelService, this.getClass().getClassLoader(), this, object3);
            }
            catch (Exception exception) {
                throw new ConfigurationError("could not initialize the ChannelFrameworkService", exception);
            }
        } else {
            this._delegate = new WSChannelFrameworkImpl(transportChannelService, this.getClass().getClassLoader(), this, (ChannelTypeManager)object3);
        }
        if (string3 != null) {
            try {
                ((WSChannelFrameworkImpl)this._delegate).setChainStartRetryAttempts(string3);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (string2 != null) {
            try {
                ((WSChannelFrameworkImpl)this._delegate).setChainStartRetryInterval(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (transportChannelService != null) {
            iterator = transportChannelService.getFactories().iterator();
            while (iterator.hasNext()) {
                try {
                    this.intializeChannelFactory((TransportChannelFactory)iterator.next());
                }
                catch (ChannelFrameworkException channelFrameworkException) {
                    Tr.error(tc, "factory.load.failure", channelFrameworkException);
                }
            }
            iterator = transportChannelService.getTransportChannels().listIterator();
            while (iterator.hasNext()) {
                try {
                    this.addChannel((TransportChannel)iterator.next());
                }
                catch (ChannelFrameworkException channelFrameworkException) {
                    Tr.error(tc, "channel.load.failure", channelFrameworkException);
                }
            }
            iterator = transportChannelService.getChains().listIterator();
            while (iterator.hasNext()) {
                try {
                    this.addChain((Chain)iterator.next());
                }
                catch (ChannelFrameworkException channelFrameworkException) {
                    Tr.error(tc, "chain.load.failure", channelFrameworkException);
                }
            }
        }
        this.addService(ChannelFrameworkService.class);
        if (configurationWarning != null) {
            throw configurationWarning;
        }
    }

    public void start() throws RuntimeError, RuntimeWarning {
        block4: {
            if (!this._started) {
                try {
                    this._started = true;
                    this.registerMBean("TransportChannelService", (RuntimeCollaborator)new DefaultRuntimeCollaborator(this), "TransportChannelService", this._configID, null);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "ChannelFrameworkService MBean successfully registered");
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.runtime.component.ChannelFrameworkServiceImpl.start", "242", this);
                    if (!tc.isDebugEnabled()) break block4;
                    Tr.debug(tc, "ChannelFrameworkService MBean registration failed");
                }
            }
        }
    }

    public void stop() {
        this.deregisterMBean(this._configID);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ChannelFrameworkService MBean successfully deregistered");
        }
        this._started = false;
    }

    public void destroy() {
        try {
            this._delegate.destroy();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.runtime.component.ChannelFrameworkServiceImpl.destroy", "279", this);
        }
    }

    public Object getService(Class clazz) {
        return super.getService(clazz);
    }

    public void releaseService(Object object) {
        super.releaseService(object);
    }

    public VirtualConnectionFactory getOutboundVCFactory(String string) throws ChannelException, ChainException {
        return this._delegate.getOutboundVCFactory(string);
    }

    public VirtualConnectionFactory getInboundVCFactory() {
        return this._delegate.getInboundVCFactory();
    }

    public ChannelFactoryData updateAllChannelFactoryProperties(Class clazz, Map map) throws ChannelFactoryException {
        return this._delegate.updateAllChannelFactoryProperties(clazz, map);
    }

    public ChannelFactoryData updateChannelFactoryProperty(Class clazz, Object object, Object object2) throws ChannelFactoryException {
        return this._delegate.updateChannelFactoryProperty(clazz, object, object2);
    }

    public ChannelFactoryData getChannelFactory(Class clazz) throws ChannelFactoryException {
        return this._delegate.getChannelFactory(clazz);
    }

    public ChannelData addChannel(String string, Class clazz, Map map, int n) throws ChannelException {
        return this._delegate.addChannel(string, clazz, map, n);
    }

    public ChannelData addChannel(String string, Class clazz, Map map) throws ChannelException {
        return this._delegate.addChannel(string, clazz, map);
    }

    public ChannelData removeChannel(String string) throws ChannelException, ChainException {
        return this._delegate.removeChannel(string);
    }

    public ChannelData updateChannelWeight(String string, int n) throws ChannelException {
        return this._delegate.updateChannelWeight(string, n);
    }

    public ChannelData updateChannelProperty(String string, Object object, Object object2) throws ChannelException {
        return this._delegate.updateChannelProperty(string, object, object2);
    }

    public ChannelData updateAllChannelProperties(String string, Map map) throws ChannelException {
        return this._delegate.updateAllChannelProperties(string, map);
    }

    public ChannelData getChannel(String string) {
        return this._delegate.getChannel(string);
    }

    public ChannelData[] getAllChannels() {
        return this._delegate.getAllChannels();
    }

    public ChannelData[] getRunningChannels() {
        return this._delegate.getRunningChannels();
    }

    public ChainData addChain(String string, FlowType flowType, String[] stringArray) throws ChannelException, ChainException {
        return this._delegate.addChain(string, flowType, stringArray);
    }

    public ChainData addChain(String string, FlowType flowType, String[] stringArray, String string2) throws ChannelException, ChainException, ChainGroupException {
        return this._delegate.addChain(string, flowType, stringArray, string2);
    }

    public ChainData removeChain(String string) throws ChainException {
        return this._delegate.removeChain(string);
    }

    public ChainData updateChain(String string, String[] stringArray) throws ChannelException, ChainException {
        return this._delegate.updateChain(string, stringArray);
    }

    public ChainData getChain(String string) {
        return this._delegate.getChain(string);
    }

    public ChainData[] getAllChains() {
        return this._delegate.getAllChains();
    }

    public ChainData[] getAllChains(String string) throws ChannelException {
        return this._delegate.getAllChains(string);
    }

    public ChainData[] getAllChains(Class clazz) throws InvalidChannelFactoryException {
        return this._delegate.getAllChains(clazz);
    }

    public ChainData[] getRunningChains() {
        return this._delegate.getRunningChains();
    }

    public ChainData[] getRunningChains(String string) throws ChannelException {
        return this._delegate.getRunningChains(string);
    }

    public ChainData[] getInternalRunningChains(String string) throws ChannelException {
        return this._delegate.getRunningChains(string);
    }

    public ChainData[] getRunningChains(Class clazz) throws InvalidChannelFactoryException {
        return this._delegate.getRunningChains(clazz);
    }

    public void initChain(String string) throws ChannelException, ChainException {
        this._delegate.initChain(string);
    }

    public void startChain(String string) throws ChannelException, ChainException {
        this._delegate.startChain(string);
    }

    public void stopChain(String string, long l) throws ChannelException, ChainException {
        this._delegate.stopChain(string, l);
    }

    public void destroyChain(String string) throws ChannelException, ChainException {
        this._delegate.destroyChain(string);
    }

    public void addChainEventListener(ChainEventListener chainEventListener, String string) throws ChainException {
        this._delegate.addChainEventListener(chainEventListener, string);
    }

    public void removeChainEventListener(ChainEventListener chainEventListener, String string) throws ChainException {
        this._delegate.removeChainEventListener(chainEventListener, string);
    }

    public void addGroupEventListener(ChainEventListener chainEventListener, String string) throws ChainGroupException {
        this._delegate.addGroupEventListener(chainEventListener, string);
    }

    public void removeGroupEventListener(ChainEventListener chainEventListener, String string) throws ChainGroupException {
        this._delegate.removeGroupEventListener(chainEventListener, string);
    }

    public ChainGroupData addChainGroup(String string, String[] stringArray) throws ChainException, ChainGroupException {
        return this._delegate.addChainGroup(string, stringArray);
    }

    public ChainGroupData removeChainGroup(String string) throws ChainGroupException {
        return this._delegate.removeChainGroup(string);
    }

    public ChainGroupData updateChainGroup(String string, String[] stringArray) throws ChainException, ChainGroupException {
        return this._delegate.updateChainGroup(string, stringArray);
    }

    public ChainGroupData getChainGroup(String string) {
        return this._delegate.getChainGroup(string);
    }

    public ChainGroupData addChainToGroup(String string, String string2) throws ChainGroupException, ChainException {
        return this._delegate.addChainToGroup(string, string2);
    }

    public ChainGroupData removeChainFromGroup(String string, String string2) throws ChainGroupException, ChainException {
        return this._delegate.removeChainFromGroup(string, string2);
    }

    public ChainGroupData[] getAllChainGroups() {
        return this._delegate.getAllChainGroups();
    }

    public ChainGroupData[] getAllChainGroups(String string) throws ChainException {
        return this._delegate.getAllChainGroups(string);
    }

    public ChainData[] initChainGroup(String string) throws ChannelException, ChainException, ChainGroupException {
        return this._delegate.initChainGroup(string);
    }

    public ChainData[] startChainGroup(String string) throws ChannelException, ChainException, ChainGroupException {
        return this._delegate.startChainGroup(string);
    }

    public ChainData[] startChainGroup(String string, ChainStartMode chainStartMode) throws ChannelException, ChainException, ChainGroupException {
        return ((WSChannelFrameworkImpl)this._delegate).startChainGroup(string, chainStartMode);
    }

    public ChainData[] stopChainGroup(String string, long l) throws ChannelException, ChainException, ChainGroupException {
        return this._delegate.stopChainGroup(string, l);
    }

    public ChainData[] destroyChainGroup(String string) throws ChannelException, ChainException, ChainGroupException {
        return this._delegate.destroyChainGroup(string);
    }

    public ChainData addChain(Chain chain) throws ChannelException, ChainException, ChainGroupException {
        return this._delegate.addChain(chain);
    }

    public ChannelData addChannel(TransportChannel transportChannel) throws ChannelException, ConfigurationError {
        return this._delegate.addChannel(transportChannel);
    }

    public void intializeChannelFactory(TransportChannelFactory transportChannelFactory) throws ChannelFactoryException, ConfigurationError {
        this._delegate.intializeChannelFactory(transportChannelFactory);
    }

    public void startChainsByAcceptorID(String string) throws ChannelException, ChainException, ChainGroupException {
        this._delegate.startChainsByAcceptorID(string);
    }

    public void startChainsByAcceptorID(String string, ChainStartMode chainStartMode) throws ChannelException, ChainException, ChainGroupException {
        this._delegate.startChainsByAcceptorID(string, chainStartMode);
    }

    public void stopChainsByAcceptorID(String string, long l) throws ChannelException, ChainException, ChainGroupException {
        this._delegate.stopChainsByAcceptorID(string, l);
    }

    public CFEndPoint determineBestEndPoint(CFEndPoint[] cFEndPointArray, CFEndPointCriteria cFEndPointCriteria) {
        return this._delegate.determineBestEndPoint(cFEndPointArray, cFEndPointCriteria);
    }

    public CFEndPoint[] getEndPoints(CFEndPoint[] cFEndPointArray, CFEndPointCriteria cFEndPointCriteria) {
        return this._delegate.getEndPoints(cFEndPointArray, cFEndPointCriteria);
    }

    public CFEndPoint getEndPoint(String string) throws ChainNotInboundException, NoCFEndPointException, NullCFEndPointException {
        return this._delegate.getEndPoint(string);
    }

    public CFEndPoint[] getEndPointsByAcceptorID(String string) {
        return this._delegate.getEndPointsByAcceptorID(string);
    }

    public void prepareEndPoint(CFEndPoint cFEndPoint) throws ChannelException, ChainException {
        this._delegate.prepareEndPoint(cFEndPoint);
    }

    public void setDefaultThreadPool(int n, int n2) throws IllegalStateException {
        this._delegate.setDefaultThreadPool(n, n2);
    }

    public ThreadPool addThreadPool(String string, int n, int n2) throws DuplicatePoolException {
        return this._delegate.addThreadPool(string, n, n2);
    }

    public ThreadPool getThreadPool(String string) {
        return this._delegate.getThreadPool(string);
    }

    public ThreadPool getDefaultThreadPool() {
        return this._delegate.getDefaultThreadPool();
    }

    public void registerService(Class clazz, Object object) {
        this._delegate.registerService(clazz, object);
    }

    public Object deregisterService(Class clazz) {
        return this._delegate.deregisterService(clazz);
    }

    public Object lookupService(Class clazz) {
        return this._delegate.lookupService(clazz);
    }

    protected void checkFactoryExceptions() throws ComponentDisabledException {
        if (this.factoryException != null) {
            Tr.debug(tc, "Multiple ChannelFrameworks existed in the runtime and this should not be allowed.");
            Tr.audit(tc, "framework.disabled");
            throw new ComponentDisabledException(this.factoryException);
        }
    }

    protected void configureThreadPool(com.ibm.websphere.models.config.process.ThreadPool threadPool, ThreadPool threadPool2) {
        if (threadPool.isSetInactivityTimeout()) {
            threadPool2.setKeepAliveTime(threadPool.getInactivityTimeout());
        }
        if (threadPool.isSetIsGrowable()) {
            threadPool2.setGrowAsNeeded(threadPool.isIsGrowable());
        }
    }

    protected TransportChannelService loadConfiguration(Repository repository) {
        try {
            if (repository != null) {
                Resource resource = repository.getConfigRoot().getResource(4, "server.xml");
                Iterator iterator = resource.getContents().iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    if (!(e instanceof Server)) continue;
                    Server server = (Server)e;
                    Iterator iterator2 = server.getServices().iterator();
                    while (iterator2.hasNext()) {
                        e = iterator2.next();
                        if (!(e instanceof TransportChannelService)) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "TransportChannelService configuration discovered");
                        }
                        return (TransportChannelService)e;
                    }
                }
            }
        }
        catch (Exception exception) {
            Tr.error(tc, "config.load.error", exception);
        }
        Tr.audit(tc, "boot.no.config");
        return null;
    }
}

