/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.channel.framework.internals.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.channel.framework.impl.ChannelFrameworkImpl;
import com.ibm.ws.ffdc.DiagnosticModule;
import com.ibm.ws.ffdc.FFDC;
import com.ibm.ws.ffdc.IncidentStream;

public class ChannelFrameworkFFDC
extends DiagnosticModule {
    private static final TraceComponent tc = Tr.register(ChannelFrameworkFFDC.class, "ChannelFramework", "com.ibm.ws.channel.resources.channelframeworkservice");
    private ChannelFrameworkImpl framework;

    public ChannelFrameworkFFDC(ChannelFrameworkImpl channelFrameworkImpl) {
        this.framework = channelFrameworkImpl;
    }

    public void register() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "register");
        }
        int n = FFDC.registerDiagnosticModule(this, "com.ibm.ws.channel.ws");
        switch (n) {
            case 0: {
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, "Successfully registered diagnostic module");
                break;
            }
            case 1: {
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, "Unable to register as another diagnostic module has already been registered with the package name");
                break;
            }
            case 2: {
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, "Unable to register as it does not support the minimum diagnostic module interface");
                break;
            }
            case 3: {
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, "Unable to register due to an unknown failure.");
                break;
            }
            default: {
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, "Registration resulted in an unexpected return code.");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "register");
        }
    }

    public void ffdcDumpDefaultChFw(Throwable throwable, IncidentStream incidentStream, Object object, Object[] objectArray, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ffdcDumpDefaultChFw");
        }
        if (object != null) {
            incidentStream.introspectAndWriteLine("Introspection of callerThis", object);
            incidentStream.writeLine("Dump of callerThis", object.toString());
        }
        incidentStream.writeLine("Dump of ChannelFramework", this.framework.toString());
        if (objectArray.length > 0) {
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] == null) continue;
                incidentStream.introspectAndWriteLine("Introspection of object[" + i + "]; ", objectArray[i]);
                incidentStream.writeLine("Dump of object[" + i + "]: ", objectArray[i].toString());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ffdcDumpDefaultChFw");
        }
    }
}

