/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.channel.framework.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.channel.framework.ChainData;
import com.ibm.websphere.channel.framework.ChannelData;
import com.ibm.websphere.channel.framework.FlowType;
import com.ibm.ws.channel.framework.chains.impl.InboundChainImpl;
import com.ibm.ws.channel.framework.chains.impl.OutboundChainImpl;
import com.ibm.ws.channel.framework.impl.ChannelFrameworkImpl;
import com.ibm.ws.channel.framework.impl.ChildChannelDataImpl;
import com.ibm.wsspi.channel.framework.ChainEventListener;
import com.ibm.wsspi.channel.framework.RetryableChainEventListener;
import com.ibm.wsspi.channel.framework.exception.IncoherentChainException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ChainDataImpl
implements ChainData {
    private static final long serialVersionUID = 4499898682104370008L;
    private static final TraceComponent tc = Tr.register(ChainDataImpl.class, "ChannelFramework", "com.ibm.ws.channel.resources.channelframeworkservice");
    private String name = null;
    private FlowType type = null;
    private ChannelData[] channelDataArray = null;
    private transient List chainEventListeners = null;
    protected transient ChannelFrameworkImpl framework = null;
    private int channelFactoryHash = 0;
    private Map properties = null;

    public ChainDataImpl(String string, FlowType flowType, ChannelData[] channelDataArray, ChannelFrameworkImpl channelFrameworkImpl, Map map) throws IncoherentChainException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "constructor");
        }
        this.name = string;
        this.type = flowType;
        this.channelDataArray = channelDataArray;
        this.chainEventListeners = new ArrayList(0);
        this.framework = channelFrameworkImpl;
        this.properties = map;
        if (flowType == FlowType.INBOUND) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "verify inbound chain coherency");
            }
            InboundChainImpl.verifyChainCoherency(this, channelFrameworkImpl);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "verify outbound chain coherency");
            }
            OutboundChainImpl.verifyChainCoherency(this, channelFrameworkImpl);
        }
        for (int i = 0; i < this.channelDataArray.length; ++i) {
            this.channelFactoryHash += this.channelDataArray[i].getFactoryType().hashCode();
        }
        if (tc.isDebugEnabled()) {
            if (this.properties == null) {
                Tr.debug(tc, "Properties are null");
            } else {
                Tr.debug(tc, "Properties: " + this.properties.size());
                Iterator iterator = this.properties.keySet().iterator();
                Object var7_8 = null;
                Object var8_9 = null;
                while (iterator.hasNext()) {
                    var7_8 = iterator.next();
                    var8_9 = this.properties.get(var7_8);
                    Tr.debug(tc, "\tkey=" + var7_8 + ", value=" + var8_9);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "constructor");
        }
    }

    public ChainDataImpl(ChainDataImpl chainDataImpl, ChannelData[] channelDataArray, ChannelFrameworkImpl channelFrameworkImpl) throws IncoherentChainException {
        this(chainDataImpl.getName(), chainDataImpl.getType(), channelDataArray, channelFrameworkImpl, chainDataImpl.getPropertyBag());
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "constructor 2");
        }
        this.chainEventListeners = chainDataImpl.getChainEventListeners();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "constructor 2");
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public FlowType getType() {
        return this.type;
    }

    public ChannelData[] getChannelList() {
        return this.channelDataArray;
    }

    public int getNumChainEventListeners() {
        return this.chainEventListeners.size();
    }

    public List getChainEventListeners() {
        return this.chainEventListeners;
    }

    public int getChannelFactoryHash() {
        return this.channelFactoryHash;
    }

    public void setChannelFactoryHash(int n) {
        this.channelFactoryHash = n;
    }

    public Map getPropertyBag() {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        return this.properties;
    }

    public void setPropertyBag(Map map) {
        this.properties = map;
    }

    public boolean containsChannel(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "containsChannel");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "channelName:" + string);
        }
        boolean bl = false;
        for (int i = 0; i < this.channelDataArray.length; ++i) {
            if (!this.channelDataArray[i].getName().equals(string)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "found channel, " + string);
            }
            bl = true;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "containsChannel");
        }
        return bl;
    }

    public ChainDataImpl getExternalChainData() {
        ChainDataImpl chainDataImpl;
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getExternalChainData");
            }
            ChannelData[] channelDataArray = new ChannelData[this.channelDataArray.length];
            for (int i = 0; i < channelDataArray.length; ++i) {
                channelDataArray[i] = ((ChildChannelDataImpl)this.channelDataArray[i]).getParent();
            }
            chainDataImpl = null;
            try {
                chainDataImpl = new ChainDataImpl(this.name, this.type, channelDataArray, this.framework, null);
            }
            catch (IncoherentChainException incoherentChainException) {
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug(tc, "Unable to build external version of chain data, " + this.name);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getExternalChainData");
        }
        return chainDataImpl;
    }

    public final void addChainEventListener(ChainEventListener chainEventListener) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addChainEventListener");
        }
        if (null != chainEventListener && !this.chainEventListeners.contains(chainEventListener)) {
            this.chainEventListeners.add(chainEventListener);
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Cannot add null chain listener");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addChainEventListener");
        }
    }

    public final void removeChainEventListener(ChainEventListener chainEventListener) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeChainEventListener");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "listener:" + chainEventListener);
            Tr.debug(tc, "numListeners:" + this.chainEventListeners.size());
            Tr.debug(tc, "list:" + this.chainEventListeners);
        }
        if (null != chainEventListener) {
            if (!this.chainEventListeners.remove(chainEventListener) && tc.isDebugEnabled()) {
                Tr.debug(tc, "Cannot find listener to be removed, " + chainEventListener);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Cannot remove null chain listener");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeChainEventListener");
        }
    }

    public List removeAllChainEventListeners() {
        List list = (List)((ArrayList)this.chainEventListeners).clone();
        this.chainEventListeners.clear();
        return list;
    }

    public void setChainEventListeners(List list) {
        this.chainEventListeners = list;
    }

    public boolean containsChainEventListener(ChainEventListener chainEventListener) {
        return this.chainEventListeners.contains(chainEventListener);
    }

    public final void chainInitialized() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "chainInitialized");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "chainInitialized, chain: " + this.name);
        }
        Iterator iterator = ((ArrayList)((ArrayList)this.chainEventListeners).clone()).iterator();
        ChainEventListener chainEventListener = null;
        while (iterator.hasNext()) {
            chainEventListener = (ChainEventListener)iterator.next();
            chainEventListener.chainInitialized(this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "chainInitialized");
        }
    }

    public final void chainStarted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "chainStarted");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "chainStarted, chain: " + this.name);
        }
        Iterator iterator = ((ArrayList)((ArrayList)this.chainEventListeners).clone()).iterator();
        ChainEventListener chainEventListener = null;
        while (iterator.hasNext()) {
            chainEventListener = (ChainEventListener)iterator.next();
            chainEventListener.chainStarted(this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "chainStarted");
        }
    }

    public final void chainStartFailed(int n, int n2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "chainStartFailed");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "chainStartFailed, chain: " + this.name);
        }
        Iterator iterator = ((ArrayList)((ArrayList)this.chainEventListeners).clone()).iterator();
        Object var4_4 = null;
        while (iterator.hasNext()) {
            var4_4 = iterator.next();
            if (!(var4_4 instanceof RetryableChainEventListener)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Calling chain retryable chain event listener");
            }
            ((RetryableChainEventListener)var4_4).chainStartFailed(this, n, n2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "chainStartFailed");
        }
    }

    public final void chainStopped() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "chainStopped");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "chainStopped, chain: " + this.name);
        }
        Iterator iterator = ((ArrayList)((ArrayList)this.chainEventListeners).clone()).iterator();
        ChainEventListener chainEventListener = null;
        while (iterator.hasNext()) {
            chainEventListener = (ChainEventListener)iterator.next();
            chainEventListener.chainStopped(this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "chainStopped");
        }
    }

    public final void chainDestroyed() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "chainDestroyed");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "chainDestroyed, chain: " + this.name);
        }
        Iterator iterator = ((ArrayList)((ArrayList)this.chainEventListeners).clone()).iterator();
        ChainEventListener chainEventListener = null;
        while (iterator.hasNext()) {
            chainEventListener = (ChainEventListener)iterator.next();
            chainEventListener.chainDestroyed(this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "chainDestroyed");
        }
    }

    protected void chainUpdated() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "chainUpdated");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "chainUpdated, chain: " + this.name);
        }
        Iterator iterator = ((ArrayList)((ArrayList)this.chainEventListeners).clone()).iterator();
        ChainEventListener chainEventListener = null;
        while (iterator.hasNext()) {
            chainEventListener = (ChainEventListener)iterator.next();
            chainEventListener.chainUpdated(this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "chainUpdated");
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ChainData:\r\n\tname = ");
        stringBuffer.append(this.name);
        stringBuffer.append("\r\n\ttype = ");
        stringBuffer.append(this.type.getOrdinal());
        stringBuffer.append("\r\n\tchannelconfigs:");
        for (int i = 0; i < this.channelDataArray.length; ++i) {
            stringBuffer.append("\r\n\t\t");
            stringBuffer.append(this.channelDataArray[i].getName());
        }
        stringBuffer.append("\r\n\tchain event listeners:");
        if (this.chainEventListeners != null) {
            Iterator iterator = this.chainEventListeners.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append("\r\n\t\t");
                stringBuffer.append(iterator.next().getClass());
            }
        } else {
            stringBuffer.append(" null");
        }
        return stringBuffer.toString();
    }
}

