/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.channel.framework.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.wsspi.channel.framework.CFEndPoint;
import com.ibm.wsspi.channel.framework.OutboundChannelDefinition;
import java.io.NotSerializableException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.CharBuffer;
import java.util.Iterator;
import java.util.Map;

public class CFEndPointSerializer {
    private static final TraceComponent tc = Tr.register(CFEndPointSerializer.class, "ChannelFrameworkService", "com.ibm.ws.channel.resources.channelframeworkservice");

    private CFEndPointSerializer() {
    }

    private static StringBuffer determineType(String string, Object object) throws NotSerializableException {
        String string2 = null;
        if (!(object instanceof String || object instanceof StringBuffer || object instanceof CharBuffer || object instanceof Integer || object instanceof Long || object instanceof Byte || object instanceof Double || object instanceof Float || object instanceof Short || object instanceof BigInteger || object instanceof BigDecimal)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Skipping class: " + object.getClass());
            }
            return null;
        }
        string2 = object.toString();
        StringBuffer stringBuffer = new StringBuffer(48);
        stringBuffer.append(string);
        stringBuffer.append("type=\"");
        if (object instanceof CharBuffer) {
            stringBuffer.append("java.nio.CharBuffer");
        } else {
            stringBuffer.append(object.getClass().getName());
        }
        stringBuffer.append("\" ");
        stringBuffer.append(string);
        stringBuffer.append("=\"");
        stringBuffer.append(string2);
        stringBuffer.append("\"");
        return stringBuffer;
    }

    private static StringBuffer serializeChannel(StringBuffer stringBuffer, OutboundChannelDefinition outboundChannelDefinition, int n) throws NotSerializableException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Serializing channel: " + n + " " + outboundChannelDefinition.getOutboundFactory().getName());
        }
        stringBuffer.append("   <channel order=\"");
        stringBuffer.append(n);
        stringBuffer.append("\" factory=\"");
        stringBuffer.append(outboundChannelDefinition.getOutboundFactory().getName());
        stringBuffer.append("\">\n");
        Map map = outboundChannelDefinition.getOutboundChannelProperties();
        if (null != map) {
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                StringBuffer stringBuffer2;
                Object k = iterator.next();
                Object v = map.get(k);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Checking channel prop: [" + k + "]");
                }
                if (null == v) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Property value [" + k + "] is null, " + outboundChannelDefinition.toString());
                    }
                    throw new NotSerializableException("Property value for [" + k + "] is null");
                }
                StringBuffer stringBuffer3 = CFEndPointSerializer.determineType("key", k);
                if (null == stringBuffer3 || null == (stringBuffer2 = CFEndPointSerializer.determineType("value", v))) continue;
                stringBuffer.append("      <property ");
                stringBuffer.append(stringBuffer3);
                stringBuffer.append(" ");
                stringBuffer.append(stringBuffer2);
                stringBuffer.append("/>\n");
            }
        }
        stringBuffer.append("   </channel>\n");
        return stringBuffer;
    }

    public static String serialize(CFEndPoint cFEndPoint) throws NotSerializableException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "serialize");
        }
        if (null == cFEndPoint) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Null CFEndPoint input for serialization");
            }
            throw new NotSerializableException("Null input");
        }
        StringBuffer stringBuffer = new StringBuffer(512);
        stringBuffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Serializing endpoint: " + cFEndPoint.getName());
        }
        stringBuffer.append("<cfendpoint name=\"");
        stringBuffer.append(cFEndPoint.getName());
        stringBuffer.append("\" host=\"");
        stringBuffer.append(cFEndPoint.getAddress().getCanonicalHostName());
        stringBuffer.append("\" port=\"");
        stringBuffer.append(cFEndPoint.getPort());
        stringBuffer.append("\" local=\"");
        stringBuffer.append(cFEndPoint.isLocal());
        stringBuffer.append("\" ssl=\"");
        stringBuffer.append(cFEndPoint.isSSLEnabled());
        stringBuffer.append("\">\n");
        OutboundChannelDefinition[] outboundChannelDefinitionArray = cFEndPoint.getOutboundChannelDefs();
        for (int i = 0; i < outboundChannelDefinitionArray.length; ++i) {
            stringBuffer = CFEndPointSerializer.serializeChannel(stringBuffer, outboundChannelDefinitionArray[i], i);
        }
        stringBuffer.append("</cfendpoint>");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Serialized string: \n" + stringBuffer.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "serialize");
        }
        return stringBuffer.toString();
    }
}

