/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.channel.framework.chains.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.channel.framework.ChainData;
import com.ibm.websphere.channel.framework.ChannelData;
import com.ibm.ws.channel.framework.chains.OutboundChain;
import com.ibm.ws.channel.framework.chains.impl.ChainImpl;
import com.ibm.ws.channel.framework.impl.ChannelFactoryDataImpl;
import com.ibm.ws.channel.framework.impl.ChannelFrameworkImpl;
import com.ibm.ws.channel.framework.impl.ChildChannelDataImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.channel.ChannelFactory;
import com.ibm.wsspi.channel.OutboundChannel;
import com.ibm.wsspi.channel.framework.exception.ChannelException;
import com.ibm.wsspi.channel.framework.exception.ChannelFactoryException;
import com.ibm.wsspi.channel.framework.exception.IncoherentChainException;
import com.ibm.wsspi.channel.framework.exception.InvalidChannelNameException;

public class OutboundChainImpl
extends ChainImpl
implements OutboundChain {
    private static final TraceComponent tc = Tr.register(OutboundChainImpl.class, "ChannelFramework", "com.ibm.ws.channel.resources.channelframeworkservice");

    public OutboundChainImpl(ChainData chainData, ChannelFrameworkImpl channelFrameworkImpl) throws ChannelException, IncoherentChainException {
        super(chainData);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "constructor");
        }
        ChannelFactory channelFactory = null;
        OutboundChannel outboundChannel = null;
        this.channels = new OutboundChannel[this.channelDataArray.length];
        for (int i = this.channelDataArray.length - 1; i >= 0; --i) {
            channelFactory = channelFrameworkImpl.getChannelFactoryInternal(this.channelDataArray[i].getFactoryType(), true);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Create channel, " + this.channelDataArray[i].getName());
            }
            if (i != this.channelDataArray.length - 1) {
                ((ChildChannelDataImpl)this.channelDataArray[i]).setDeviceInterface(this.channels[i + 1].getApplicationInterface());
            }
            ((ChildChannelDataImpl)this.channelDataArray[i]).setIsInbound(false);
            this.channels[i] = (OutboundChannel)channelFactory.findOrCreateChannel(this.channelDataArray[i]);
            if (null == this.channels[i]) {
                InvalidChannelNameException invalidChannelNameException = new InvalidChannelNameException("Chain cannot be created because of channel, " + this.channelDataArray[i].getName());
                FFDCFilter.processException(invalidChannelNameException, "com.ibm.ws.channel.framework.chains.impl.OutboundChainImpl.constructor", "79", this, new Object[]{this.channelDataArray[i]});
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "constructor");
                }
                throw invalidChannelNameException;
            }
            if (null != outboundChannel) {
                int n;
                int n2 = outboundChannel.getApplicationAddress().length;
                String string = ((OutboundChannel)this.channels[i]).getDeviceAddress().toString();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "DevAddress: " + string);
                    for (n = 0; n < n2; ++n) {
                        Tr.debug(tc, "AppAddress[" + n + "]: " + outboundChannel.getApplicationAddress()[n].toString());
                    }
                }
                n = 0;
                String string2 = null;
                for (int j = 0; j < n2; ++j) {
                    string2 = outboundChannel.getApplicationAddress()[j].toString();
                    if (!string.equals(string2)) continue;
                    n = 1;
                    break;
                }
                if (n == 0) {
                    IncoherentChainException incoherentChainException = new IncoherentChainException("Unmatching addresses between channels: " + outboundChannel.getName() + ", " + this.channels[i].getName());
                    FFDCFilter.processException((Throwable)incoherentChainException, "com.ibm.ws.channel.framework.chains.impl.OutboundChainImpl.constructor", "109", this);
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "constructor");
                    }
                    throw incoherentChainException;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "prev.AppInterface: " + outboundChannel.getApplicationInterface());
                    Tr.debug(tc, "next.DevInterface: " + this.channels[i].getDeviceInterface());
                }
                if (outboundChannel.getApplicationInterface() != this.channels[i].getDeviceInterface()) {
                    IncoherentChainException incoherentChainException = new IncoherentChainException("Unmatching channels: " + outboundChannel.getName() + ", " + this.channels[i].getName());
                    FFDCFilter.processException(incoherentChainException, "com.ibm.ws.channel.framework.chains.impl.OutboundChainImpl.constructor", "124", this, new Object[]{outboundChannel, this.channels[i]});
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "constructor");
                    }
                    throw incoherentChainException;
                }
            }
            outboundChannel = (OutboundChannel)this.channels[i];
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "constructor");
        }
    }

    public static void verifyChainCoherency(ChainData chainData, ChannelFrameworkImpl channelFrameworkImpl) throws IncoherentChainException {
        ChannelData[] channelDataArray;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "verifyChainCoherency");
        }
        if ((channelDataArray = chainData.getChannelList()).length > 1) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found channel list greater than 1");
            }
            ChannelFactoryDataImpl channelFactoryDataImpl = null;
            ChannelFactoryDataImpl channelFactoryDataImpl2 = null;
            Class[] classArray = null;
            Class clazz = null;
            try {
                channelFactoryDataImpl = channelFrameworkImpl.findOrCreateChannelFactoryData(channelDataArray[0].getFactoryType());
            }
            catch (ChannelFactoryException channelFactoryException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found invalid channel factory of type " + channelDataArray[0].getFactoryType().getName());
                }
                throw new IncoherentChainException("Invalid channel factory");
            }
            for (int i = 1; i < channelDataArray.length; ++i) {
                classArray = channelFactoryDataImpl.getDeviceInterface();
                try {
                    channelFactoryDataImpl2 = channelFrameworkImpl.findOrCreateChannelFactoryData(channelDataArray[i].getFactoryType());
                }
                catch (ChannelFactoryException channelFactoryException) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found invalid channel factory of type " + channelDataArray[i].getFactoryType().getName());
                    }
                    throw new IncoherentChainException("Invalid channel factory");
                }
                clazz = channelFactoryDataImpl2.getApplicationInterface();
                if (null == classArray || null == clazz) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found null interface classes between two channel factories: " + channelFactoryDataImpl.getFactory().getName() + ", " + channelFactoryDataImpl2.getFactory().getName());
                    }
                    throw new IncoherentChainException("Found null interface classes between two channel factories: " + channelFactoryDataImpl.getFactory().getName() + ", " + channelFactoryDataImpl2.getFactory().getName());
                }
                boolean bl = false;
                for (int j = 0; j < classArray.length; ++j) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "App class: " + clazz);
                        Tr.debug(tc, "Dev class: " + classArray[j]);
                    }
                    if (clazz.isAssignableFrom(classArray[j])) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Found compatible class");
                        }
                        bl = true;
                        break;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Found incompatible, but keep looking through list");
                }
                if (!bl) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found incoherency between two channel factories: " + channelFactoryDataImpl.getFactory().getName() + ", " + channelFactoryDataImpl2.getFactory().getName());
                    }
                    throw new IncoherentChainException("Found incoherency between two channel factories: " + channelFactoryDataImpl.getFactory().getName() + ", " + channelFactoryDataImpl2.getFactory().getName());
                }
                channelFactoryDataImpl = channelFactoryDataImpl2;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "verifyChainCoherency");
        }
    }
}

