/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.channel.framework.chains.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.channel.framework.ChainData;
import com.ibm.websphere.channel.framework.ChannelData;
import com.ibm.ws.channel.framework.chains.InboundChain;
import com.ibm.ws.channel.framework.chains.impl.ChainImpl;
import com.ibm.ws.channel.framework.impl.ChannelFactoryDataImpl;
import com.ibm.ws.channel.framework.impl.ChannelFrameworkImpl;
import com.ibm.ws.channel.framework.impl.ChildChannelDataImpl;
import com.ibm.ws.channel.framework.impl.RuntimeState;
import com.ibm.ws.channel.framework.internals.DiscriminationGroup;
import com.ibm.ws.channel.framework.internals.impl.DiscriminationProcessImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.channel.Channel;
import com.ibm.wsspi.channel.ChannelFactory;
import com.ibm.wsspi.channel.Discriminator;
import com.ibm.wsspi.channel.InboundChannel;
import com.ibm.wsspi.channel.framework.DiscriminationProcess;
import com.ibm.wsspi.channel.framework.exception.ChainException;
import com.ibm.wsspi.channel.framework.exception.ChannelException;
import com.ibm.wsspi.channel.framework.exception.ChannelFactoryException;
import com.ibm.wsspi.channel.framework.exception.DiscriminationProcessException;
import com.ibm.wsspi.channel.framework.exception.IncoherentChainException;
import com.ibm.wsspi.channel.framework.exception.InvalidChannelNameException;

public class InboundChainImpl
extends ChainImpl
implements InboundChain {
    private static final TraceComponent tc = Tr.register(InboundChainImpl.class, "ChannelFramework", "com.ibm.ws.channel.resources.channelframeworkservice");
    public static final String CLASS_NAME = "com.ibm.ws.channel.framework.chains.impl.InboundChainImpl";

    public InboundChainImpl(ChainData chainData, ChannelFrameworkImpl channelFrameworkImpl) throws ChannelException, IncoherentChainException {
        super(chainData);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "constructor");
        }
        ChannelFactory channelFactory = null;
        this.channels = new InboundChannel[this.channelDataArray.length];
        Channel channel = null;
        for (int i = 0; i < this.channelDataArray.length; ++i) {
            Class clazz;
            Object object;
            channelFactory = channelFrameworkImpl.getChannelFactoryInternal(this.channelDataArray[i].getFactoryType(), true);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "factory: " + channelFactory);
                Tr.debug(tc, "findOrCreateChannel: " + this.channelDataArray[i].getName());
            }
            if (i != 0) {
                ((ChildChannelDataImpl)this.channelDataArray[i]).setDeviceInterface(this.channels[i - 1].getApplicationInterface());
            }
            ((ChildChannelDataImpl)this.channelDataArray[i]).setIsInbound(true);
            this.channels[i] = (InboundChannel)channelFactory.findOrCreateChannel(this.channelDataArray[i]);
            if (null == this.channels[i]) {
                object = new InvalidChannelNameException("Chain cannot be created because of channel, " + this.channelDataArray[i].getName());
                FFDCFilter.processException((Throwable)object, "com.ibm.ws.channel.framework.chains.impl.InboundChainImpl.constructor", "89", this, new Object[]{this.channelDataArray[i]});
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "constructor");
                }
                throw object;
            }
            if (null != channel) {
                object = ((InboundChannel)channel).getDiscriminatoryType();
                clazz = ((InboundChannel)this.channels[i]).getDiscriminator().getDiscriminatoryDataType();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "prev.AppSideClass: " + channel.getApplicationInterface());
                    Tr.debug(tc, "this.DevSideClass: " + this.channels[i].getDeviceInterface());
                    Tr.debug(tc, "prev.DiscType: " + object);
                    Tr.debug(tc, "this.DiscType: " + clazz);
                }
                if (object != clazz) {
                    String string = "Unmatching channel disc types: " + channel.getName() + ", " + object + " " + this.channels[i].getName() + ", " + clazz;
                    IncoherentChainException incoherentChainException = new IncoherentChainException(string);
                    FFDCFilter.processException((Throwable)incoherentChainException, "com.ibm.ws.channel.framework.chains.impl.InboundChainImpl.constructor", "122", this);
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "constructor");
                    }
                    throw incoherentChainException;
                }
                if (channel.getApplicationInterface() != this.channels[i].getDeviceInterface()) {
                    IncoherentChainException incoherentChainException = new IncoherentChainException("Unmatching channel interfaces: " + channel.getName() + ", " + this.channels[i].getName());
                    FFDCFilter.processException((Throwable)incoherentChainException, "com.ibm.ws.channel.framework.chains.impl.InboundChainImpl.constructor", "136", this);
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "constructor");
                    }
                    throw incoherentChainException;
                }
            }
            if (this.channelDataArray.length != i + 1 && null == (object = ((InboundChannel)this.channels[i]).getDiscriminationProcess())) {
                clazz = ((InboundChannel)this.channels[i]).getDiscriminatoryType();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "discriminatoryType: " + clazz);
                }
                object = new DiscriminationProcessImpl(clazz, this.channelDataArray[i].getName());
                ((InboundChannel)this.channels[i]).setDiscriminationProcess((DiscriminationProcess)object);
            }
            channel = this.channels[i];
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "constructor");
        }
    }

    public void setupDiscProcess() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setupDiscProcess");
        }
        ChannelData[] channelDataArray = this.chainData.getChannelList();
        Class clazz = null;
        DiscriminationProcessImpl discriminationProcessImpl = null;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Get the channels started");
        }
        for (int i = 0; i < channelDataArray.length; ++i) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Set up disc process for channel, " + channelDataArray[i].getName());
            }
            if (channelDataArray.length != i + 1) {
                discriminationProcessImpl = (DiscriminationProcessImpl)((InboundChannel)this.channels[i]).getDiscriminationProcess();
                if (discriminationProcessImpl == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Create a discrimination process for channel, " + this.channels[i].getName());
                    }
                    clazz = ((InboundChannel)this.channels[i]).getDiscriminatoryType();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Discriminatory type: " + clazz);
                    }
                    discriminationProcessImpl = new DiscriminationProcessImpl(clazz, channelDataArray[i].getName());
                    ((InboundChannel)this.channels[i]).setDiscriminationProcess(discriminationProcessImpl);
                    continue;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Found DP: " + discriminationProcessImpl);
                continue;
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "Last channel in chain, " + channelDataArray[i].getName());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setupDiscProcess");
        }
    }

    public void startDiscProcessBetweenChannels(InboundChannel inboundChannel, InboundChannel inboundChannel2, int n) throws ChainException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "startDiscProcessBetweenChannels");
        }
        Discriminator discriminator = null;
        boolean bl = false;
        Exception exception = null;
        try {
            discriminator = inboundChannel.getDiscriminator();
            if (discriminator == null) {
                bl = true;
                exception = new Exception("Null discriminator extracted from channel " + inboundChannel.getName());
            }
        }
        catch (Exception exception2) {
            bl = true;
            exception = exception2;
        }
        if (bl) {
            FFDCFilter.processException(exception, "com.ibm.ws.channel.framework.chains.impl.InboundChainImpl.startDiscProcessBetweenChannels", "234", this, new Object[]{inboundChannel, inboundChannel2, new Integer(n)});
            throw new ChainException("Unable to get Discriminator from channel " + inboundChannel.getName() + " due to exception " + exception.getMessage());
        }
        DiscriminationGroup discriminationGroup = (DiscriminationGroup)inboundChannel2.getDiscriminationProcess();
        if (!((DiscriminationProcessImpl)discriminationGroup).containsDiscriminator(discriminator)) {
            if (!discriminationGroup.getDiscriminators().isEmpty()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Create new dp for channel, " + inboundChannel2.getName());
                }
                DiscriminationProcessImpl discriminationProcessImpl = new DiscriminationProcessImpl(inboundChannel2.getDiscriminatoryType(), discriminationGroup);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Add in discriminator from channel, " + inboundChannel.getName());
                }
                discriminationProcessImpl.addDiscriminator(discriminator, n);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Set dp into channel, " + inboundChannel2.getName());
                }
                discriminationProcessImpl.start();
                inboundChannel2.setDiscriminationProcess(discriminationProcessImpl);
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Add in disc from channel, " + inboundChannel.getName() + " into dp of channel, " + inboundChannel2.getName());
                }
                discriminationGroup.addDiscriminator(discriminator, n);
                discriminationGroup.start();
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Found discriminator in dp, " + discriminator.getChannel().getName());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "startDiscProcessBetweenChannels");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableChannel(Channel channel) throws InvalidChannelNameException, DiscriminationProcessException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "disableChannel");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "inputChannel:" + channel.getName());
        }
        RuntimeState runtimeState = this.state;
        synchronized (runtimeState) {
            if (RuntimeState.STARTED == this.state || RuntimeState.QUIESCED == this.state) {
                DiscriminationGroup discriminationGroup = null;
                int n = -1;
                InboundChannel inboundChannel = null;
                for (int i = 0; i < this.channels.length; ++i) {
                    if (this.channels[i].getName().equals(channel.getName())) {
                        n = i;
                        break;
                    }
                    discriminationGroup = (DiscriminationGroup)((InboundChannel)this.channels[i]).getDiscriminationProcess();
                    inboundChannel = (InboundChannel)this.channels[i];
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Index of channel, " + n);
                }
                if (n == -1) {
                    InvalidChannelNameException invalidChannelNameException = new InvalidChannelNameException("ERROR: can't unlink unknown channel, " + channel.getName());
                    FFDCFilter.processException(invalidChannelNameException, "com.ibm.ws.channel.framework.chains.impl.InboundChainImpl.disableChannel", "319", this, new Object[]{channel});
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "disableChannel");
                    }
                    throw invalidChannelNameException;
                }
                if (n > 0) {
                    if (this.state == RuntimeState.STARTED || this.state == RuntimeState.QUIESCED) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Previous channel, " + inboundChannel.getName());
                        }
                        Class clazz = inboundChannel.getDiscriminatoryType();
                        DiscriminationProcessImpl discriminationProcessImpl = new DiscriminationProcessImpl(clazz, discriminationGroup);
                        discriminationProcessImpl.removeDiscriminator(((InboundChannel)channel).getDiscriminator());
                        inboundChannel.setDiscriminationProcess(discriminationProcessImpl);
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Unable to disable channel: " + channel.getName() + ", chain state: " + this.state);
                    }
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "RuntimeState invalid to disable channel: " + channel.getName() + ", chain state: " + this.state.ordinal);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "disableChannel");
        }
    }

    public static void verifyChainCoherency(ChainData chainData, ChannelFrameworkImpl channelFrameworkImpl) throws IncoherentChainException {
        ChannelData[] channelDataArray;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "verifyChainCoherency");
        }
        if ((channelDataArray = chainData.getChannelList()).length > 1) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found channel list greater than 1");
            }
            ChannelFactoryDataImpl channelFactoryDataImpl = null;
            ChannelFactoryDataImpl channelFactoryDataImpl2 = null;
            Class clazz = null;
            Class[] classArray = null;
            try {
                channelFactoryDataImpl = channelFrameworkImpl.findOrCreateChannelFactoryData(channelDataArray[0].getFactoryType());
            }
            catch (ChannelFactoryException channelFactoryException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found invalid channel factory of type " + channelDataArray[0].getFactoryType().getName());
                }
                throw new IncoherentChainException("Invalid channel factory");
            }
            for (int i = 1; i < channelDataArray.length; ++i) {
                clazz = channelFactoryDataImpl.getApplicationInterface();
                try {
                    channelFactoryDataImpl2 = channelFrameworkImpl.findOrCreateChannelFactoryData(channelDataArray[i].getFactoryType());
                }
                catch (ChannelFactoryException channelFactoryException) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found invalid channel factory of type " + channelDataArray[i].getFactoryType().getName());
                    }
                    throw new IncoherentChainException("Invalid channel factory");
                }
                classArray = channelFactoryDataImpl2.getDeviceInterface();
                if (null == clazz || null == classArray) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found null interface classes between two channel factories: " + channelFactoryDataImpl.getFactory().getName() + ", " + channelFactoryDataImpl2.getFactory().getName());
                    }
                    throw new IncoherentChainException("Found null interface classes between two channel factories: " + channelFactoryDataImpl.getFactory().getName() + ", " + channelFactoryDataImpl2.getFactory().getName());
                }
                boolean bl = false;
                for (int j = 0; j < classArray.length; ++j) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "App class: " + clazz);
                        Tr.debug(tc, "Dev class: " + classArray[j]);
                    }
                    if (clazz.isAssignableFrom(classArray[j])) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Found compatible class");
                        }
                        bl = true;
                        break;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Found incompatible, but keep looking through list");
                }
                if (!bl) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found incoherency between two channel factories: " + channelFactoryDataImpl + ", " + channelFactoryDataImpl2);
                    }
                    throw new IncoherentChainException("Found incoherency between two channel factories: " + channelFactoryDataImpl + ", " + channelFactoryDataImpl2);
                }
                channelFactoryDataImpl = channelFactoryDataImpl2;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "verifyChainCoherency");
        }
    }
}

