/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.channel.framework;

import com.ibm.websphere.models.config.channelservice.channels.GenericChannelData;
import com.ibm.websphere.models.descriptor.channel.ChannelFactoryType;
import com.ibm.websphere.models.descriptor.channel.ChannelKind;
import com.ibm.websphere.models.descriptor.channel.ChannelType;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public interface ChannelTypeManager {
    public ChannelMetaData getChannelType(Object var1);

    public ChannelFactoryMetaData getChannelFactoryType(Object var1);

    public String createFullyQualifiedGenericID(GenericChannelData var1);

    public static class ChannelFactoryMetaData {
        protected String _jarFile;
        protected String _typeID;
        protected String _shortName;
        protected String _configurationClass;
        protected String _runtimeClass;
        protected String _validatorClass;
        protected String _string;
        protected String _hash;

        public ChannelFactoryMetaData(File file, ChannelFactoryType channelFactoryType) {
            this._shortName = channelFactoryType.getConfigurationClass();
            this._configurationClass = channelFactoryType.getConfigurationClass();
            this._runtimeClass = channelFactoryType.getRuntimeClass();
            this._validatorClass = channelFactoryType.getValidatorClass();
            this._jarFile = file.getName();
            this._typeID = channelFactoryType.eResource().getURIFragment(channelFactoryType);
            this._hash = this._jarFile + '#' + this._typeID;
            if (this._shortName != null) {
                this._shortName = this._shortName.substring(this._shortName.lastIndexOf(46) + 1);
            }
        }

        public int hashCode() {
            return this._hash.hashCode();
        }

        public String toString() {
            if (this._string == null) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(this._shortName);
                stringBuffer.append(" (jarFile=");
                stringBuffer.append(this._jarFile);
                stringBuffer.append(", typeID=");
                stringBuffer.append(this._typeID);
                stringBuffer.append(") (configClass=");
                stringBuffer.append(this._configurationClass);
                stringBuffer.append(", runtimeClass=");
                stringBuffer.append(this._runtimeClass);
                if (this._validatorClass != null) {
                    stringBuffer.append(", validator=");
                    stringBuffer.append(this._validatorClass);
                }
                stringBuffer.append(')');
                this._string = stringBuffer.toString();
            }
            return this._string;
        }

        public String getConfigurationClass() {
            return this._configurationClass;
        }

        public String getRuntimeClass() {
            return this._runtimeClass;
        }

        public String getValidatorClass() {
            return this._validatorClass;
        }

        public String getJARFile() {
            return this._jarFile;
        }

        public String getTypeID() {
            return this._typeID;
        }
    }

    public static class ChannelMetaData {
        protected String _jarFile;
        protected String _typeID;
        protected String _shortName;
        protected String _runtimeClass;
        protected String _configurationClass;
        protected String _validatorClass;
        protected int _defaultWeight;
        protected boolean _setDefaultWeight;
        protected String _appInterface;
        protected List _deviceInterface;
        protected ChannelKind _kind;
        protected String _string;
        protected String _hash;

        public ChannelMetaData(File file, ChannelType channelType) {
            this._shortName = channelType.getConfigurationClass();
            this._configurationClass = channelType.getConfigurationClass();
            this._runtimeClass = channelType.getRuntimeClass();
            this._validatorClass = channelType.getValidatorClass();
            this._defaultWeight = channelType.getDefaultWeight();
            this._setDefaultWeight = channelType.isSetDefaultWeight();
            this._kind = channelType.getKind();
            this._appInterface = channelType.getApplicationInterface();
            this._deviceInterface = new ArrayList(channelType.getDeviceInterface());
            this._jarFile = file.getName();
            this._typeID = channelType.eResource().getURIFragment(channelType);
            this._hash = this._jarFile + '#' + this._typeID;
            Collections.sort(this._deviceInterface);
            if (this._shortName != null) {
                this._shortName = this._shortName.substring(this._shortName.lastIndexOf(46) + 1);
            }
        }

        public int hashCode() {
            return this._hash.hashCode();
        }

        public String toString() {
            if (this._string == null) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(this._shortName);
                stringBuffer.append(" (jarFile=");
                stringBuffer.append(this._jarFile);
                stringBuffer.append(", typeID=");
                stringBuffer.append(this._typeID);
                stringBuffer.append(") (kind=");
                stringBuffer.append(this._kind);
                stringBuffer.append(", configChannel=");
                stringBuffer.append(this._configurationClass);
                stringBuffer.append(", runtimeFactory=");
                stringBuffer.append(this._runtimeClass);
                if (this._validatorClass != null) {
                    stringBuffer.append(", validator=");
                    stringBuffer.append(this._validatorClass);
                }
                if (this._setDefaultWeight) {
                    stringBuffer.append(", weight=");
                    stringBuffer.append(this._defaultWeight);
                }
                if (this._deviceInterface != null && !this._deviceInterface.isEmpty()) {
                    stringBuffer.append(", deviceInterface=[");
                    Iterator iterator = this._deviceInterface.iterator();
                    while (iterator.hasNext()) {
                        stringBuffer.append(iterator.next());
                        if (!iterator.hasNext()) continue;
                        stringBuffer.append(' ');
                    }
                    stringBuffer.append(']');
                }
                stringBuffer.append(')');
                this._string = stringBuffer.toString();
            }
            return this._string;
        }

        public String getApplicationInterface() {
            return this._appInterface;
        }

        public String getConfigurationClass() {
            return this._configurationClass;
        }

        public int getDefaultWeight() {
            return this._defaultWeight;
        }

        public List getDeviceInterface() {
            return this._deviceInterface;
        }

        public ChannelKind getKind() {
            return this._kind;
        }

        public String getRuntimeClass() {
            return this._runtimeClass;
        }

        public String getValidatorClass() {
            return this._validatorClass;
        }

        public boolean isSetDefaultWeight() {
            return this._setDefaultWeight;
        }

        public String getJARFile() {
            return this._jarFile;
        }

        public String getTypeID() {
            return this._typeID;
        }
    }
}

