/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.management.commands.server;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.management.commands.server.ServerCommandBase;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class CreateServer
extends ServerCommandBase {
    private static TraceComponent tc = Tr.register((Class)CreateServer.class, (String)"CreateServer", (String)"com.ibm.wsspi.management.commands.server");
    private ObjectName matchTemplate = null;

    public CreateServer(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
    }

    public CreateServer(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    protected void taskCommandExecuted(boolean bl) {
        if (!bl) {
            ConfigService configService = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            try {
                ObjectName objectName = (ObjectName)this.getCommandResult().getResult();
                if (objectName != null) {
                    configService.deleteConfigData(session, objectName);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.wsspi.management.commands.server.CreateServer.taskCommandExecuted", (String)"190");
            }
        }
    }

    public void beforeStepsExecuted() {
        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.getTaskCommandResult();
        try {
            ConfigService configService = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            String string = (String)this.getTargetObject();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Node Name: " + string));
            }
            String string2 = (String)this.getParameter("name");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Server Name: " + string2));
            }
            String string3 = this.getServerType(string);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Server Type: " + string3));
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(" use Template:" + this.matchTemplate));
            }
            Boolean bl = (Boolean)this.getParameter("genUniquePorts");
            boolean bl2 = true;
            if (bl != null) {
                bl2 = bl;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Generate Unique Ports: " + bl2));
            }
            ObjectName[] objectNameArray = configService.resolve(session, "Node=" + string);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Result from ConfigService: " + objectNameArray));
            }
            if (objectNameArray.length == 0) {
                String string4 = TraceNLS.getFormattedMessage((String)"com.ibm.ws.management.resources.configservice", (String)"ADMG0250E", (Object[])new Object[]{string}, null);
                throw new ConfigServiceException(string4);
            }
            ObjectName objectName = null;
            try {
                Method method = this.implClass.getMethod("createServer", Session.class, ObjectName.class, String.class, ObjectName.class, Boolean.TYPE);
                objectName = (ObjectName)method.invoke(null, this.getConfigSession(), objectNameArray[0], string2, this.matchTemplate, bl2 ? Boolean.TRUE : Boolean.FALSE);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw invocationTargetException.getTargetException();
            }
            taskCommandResultImpl.setResult(objectName);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"server created", (Object)objectName);
            }
        }
        catch (Throwable throwable) {
            taskCommandResultImpl.setException(throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"beforeStepsExecuted");
        }
    }

    private String getServerType(String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getServerType");
        }
        String string2 = null;
        CommandMgr commandMgr = CommandMgr.getCommandMgr();
        AdminCommand adminCommand = commandMgr.createCommand("listServerTypes");
        adminCommand.setConfigSession(this.getConfigSession());
        adminCommand.setTargetObject(string);
        adminCommand.execute();
        List list = (List)adminCommand.getCommandResult().getResult();
        String string3 = this.getCommandMetadata().getName();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"commandName", (Object)string3);
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string4 = (String)iterator.next();
            AdminCommand adminCommand2 = commandMgr.createCommand("showServerTypeInfo");
            adminCommand2.setConfigSession(this.getConfigSession());
            adminCommand2.setTargetObject(string4);
            adminCommand2.execute();
            AttributeList attributeList = (AttributeList)adminCommand2.getCommandResult().getResult();
            Object object = ConfigServiceHelper.getAttributeValue(attributeList, "createCommand");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"createCommandName", (Object)object);
            }
            if (!string3.equals(object)) continue;
            string2 = string4;
            break;
        }
        if (string2 == null) {
            FFDCFilter.processException((Throwable)new Exception(), (String)"com.ibm.ws.management.commands.server.CreateServer.getServerType", (String)"204");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getServerType", string2);
        }
        return string2;
    }

    protected List getTemplates(boolean bl) {
        List list;
        block11: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)("getTemplate, " + bl));
            }
            list = Collections.EMPTY_LIST;
            try {
                ConfigService configService = ConfigServiceFactory.getConfigService();
                Session session = this.getConfigSession();
                String string = (String)this.getTargetObject();
                String string2 = (String)this.getParameter("templateName");
                String string3 = this.getServerType(string);
                String[] stringArray = null;
                stringArray = !bl ? new String[3] : new String[2];
                boolean bl2 = this.metadataHelper.isNodeZOS(string);
                if (bl2) {
                    stringArray[0] = "com.ibm.websphere.nodeOperatingSystem=os390";
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"ZOS Platform Query", (Object)stringArray);
                    }
                } else {
                    stringArray[0] = "com.ibm.websphere.nodeOperatingSystem!=os390";
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Distributed Platform Query", (Object)stringArray);
                    }
                }
                if (!bl) {
                    stringArray[1] = string2 == null || string2.equals("") ? "isDefaultTemplate=true" : "name=" + string2;
                }
                String string4 = this.metadataHelper.getNodeMajorVersion(string);
                if (!bl) {
                    stringArray[2] = "com.ibm.websphere.baseProductMajorVersion=" + string4;
                } else {
                    stringArray[1] = "com.ibm.websphere.baseProductMajorVersion=" + string4;
                }
                list = this.listServerTemplates(string3, stringArray);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.wsspi.management.commands.server.CreateServer.taskCommandExecuted", (String)"242");
                if (!tc.isDebugEnabled()) break block11;
                Tr.debug((TraceComponent)tc, (String)"Exception occured during getChoices", (Object)throwable);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getTemplate", (Object)list);
        }
        return list;
    }

    public Object[] getChoices(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getChoices", (Object)string);
        }
        String[] stringArray = null;
        if (string.equals("templateName")) {
            List list = this.getTemplates(true);
            stringArray = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                ObjectName objectName = (ObjectName)list.get(i);
                stringArray[i] = ConfigServiceHelper.getDisplayName(objectName);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getChoices", stringArray);
        }
        return stringArray;
    }

    public void validate() throws CommandValidationException {
        Object object;
        Object object2;
        String string;
        Object object3;
        Object object4;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"validate, ");
        }
        super.validate();
        ConfigService configService = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName[] objectNameArray = null;
        ObjectName objectName = ConfigServiceHelper.createObjectName(null, "CellManager");
        try {
            objectNameArray = configService.queryConfigObjects(session, null, objectName, null);
        }
        catch (ConfigServiceException configServiceException) {
        }
        catch (ConnectorException connectorException) {
            // empty catch block
        }
        if (objectNameArray != null && objectNameArray.length > 0 && (object4 = ((Properties)(object3 = ConfigServiceHelper.getObjectLocation(objectNameArray[0]))).getProperty("node")) != null && (string = (String)this.getTargetObject()) != null && ((String)object4).equals(string)) {
            String string2 = TraceNLS.getFormattedMessage((String)"com.ibm.ws.management.resources.configservice", (String)"ADMG0250E", (Object[])new Object[]{object4}, null);
            throw new CommandValidationException(string2);
        }
        object3 = (String)this.getTargetObject();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Node Name: " + (String)object3));
        }
        try {
            object4 = configService.resolve(session, "Node=" + (String)object3);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Result from ConfigService: " + object4));
            }
            if (((ObjectName[])object4).length == 0) {
                string = TraceNLS.getFormattedMessage((String)"com.ibm.ws.management.resources.configservice", (String)"ADMG0250E", (Object[])new Object[]{object3}, null);
                throw new CommandValidationException(string);
            }
        }
        catch (ConfigServiceException configServiceException) {
            string = TraceNLS.getFormattedMessage((String)"com.ibm.ws.management.resources.configservice", (String)"ADMG0254E", (Object[])new Object[]{configServiceException}, null);
            throw new CommandValidationException((Throwable)((Object)configServiceException), string);
        }
        catch (ConnectorException connectorException) {
            string = TraceNLS.getFormattedMessage((String)"com.ibm.ws.management.resources.configservice", (String)"ADMG0254E", (Object[])new Object[]{connectorException}, null);
            throw new CommandValidationException((Throwable)((Object)connectorException), string);
        }
        object4 = (String)this.getParameter("name");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Server Name: " + (String)object4));
        }
        if (((String)object4).length() == 0) {
            string = TraceNLS.getFormattedMessage((String)"com.ibm.ws.management.resources.configservice", (String)"ADMG0247E", (Object[])new Object[]{object4}, null);
            throw new CommandValidationException(string);
        }
        boolean bl = ConfigServiceHelper.checkIfNameValid((String)object4);
        if (!bl) {
            String string3 = TraceNLS.getFormattedMessage((String)"com.ibm.ws.management.resources.configservice", (String)"ADMG0249E", (Object[])new Object[]{object4}, null);
            throw new CommandValidationException(string3);
        }
        try {
            object2 = configService.resolve(session, "Node=" + (String)object3 + ":Server=" + (String)object4);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Result from ConfigService: " + object2));
            }
            if (((ObjectName[])object2).length != 0) {
                String string4 = TraceNLS.getFormattedMessage((String)"com.ibm.ws.management.resources.configservice", (String)"ADMG0248E", (Object[])new Object[]{object4, object3}, null);
                throw new CommandValidationException(string4);
            }
        }
        catch (ConfigServiceException configServiceException) {
            String string5 = TraceNLS.getFormattedMessage((String)"com.ibm.ws.management.resources.configservice", (String)"ADMG0254E", (Object[])new Object[]{configServiceException}, null);
            throw new CommandValidationException((Throwable)((Object)configServiceException), string5);
        }
        catch (ConnectorException connectorException) {
            String string6 = TraceNLS.getFormattedMessage((String)"com.ibm.ws.management.resources.configservice", (String)"ADMG0254E", (Object[])new Object[]{connectorException}, null);
            throw new CommandValidationException((Throwable)((Object)connectorException), string6);
        }
        object2 = null;
        String string7 = (String)this.getParameter("templateName");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Template Name: " + string7));
        }
        this.matchTemplate = null;
        ObjectName objectName2 = (ObjectName)this.getParameter("templateLocation");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"templateLocation", (Object)objectName2);
        }
        if ((object2 = objectName2 != null ? this.getTemplate(objectName2, string7) : this.getTemplates(false)) == null || object2.size() == 0) {
            String string8 = TraceNLS.getFormattedMessage((String)"com.ibm.ws.management.resources.configservice", (String)"ADMG0253E", (Object[])new Object[]{string7}, null);
            throw new CommandValidationException(string8);
        }
        this.matchTemplate = (ObjectName)object2.get(0);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)" matchTemplate", (Object)this.matchTemplate);
        }
        if ((object = this.getParameter("genUniquePorts")) != null && object instanceof Boolean) {
            boolean bl2 = true;
            if (object != null) {
                bl2 = (Boolean)object;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Generate Unique Ports: " + bl2));
            }
        }
    }
}

