/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.configarchive;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.configarchive.ConfigArchiveCommand;
import com.ibm.wsspi.configarchive.ConfigArchiveException;
import com.ibm.wsspi.configarchive.FileAccessor;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public abstract class ExportCommand
extends ConfigArchiveCommand {
    private static TraceComponent tc = Tr.register((Class)ExportCommand.class, (String)"configarchive", (String)"com.ibm.ws.management.resources.configarchive");

    public ExportCommand(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public ExportCommand(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
    }

    private void createArchiveSession() throws ConfigArchiveException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createArchiveWorkspace");
        }
        try {
            File file = this.getArchiveLocation();
            Method method = this.composerCls.getMethod("createConfigArchiveSession", String.class, FileAccessor.class);
            Session session = (Session)method.invoke(null, file.getName(), null);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"archiveSession", (Object)session);
            }
            this.setConfigArchiveSession(session);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createArchiveSession");
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof ConfigArchiveException) {
                FFDCFilter.processException((Throwable)invocationTargetException, (String)"com.ibm.wsspi.configarchive.ExportCommand.createArchiveSession", (String)"88");
                throw (ConfigArchiveException)((Object)throwable);
            }
            FFDCFilter.processException((Throwable)invocationTargetException, (String)"com.ibm.wsspi.configarchive.ExportCommand.createArchiveSession", (String)"91");
            throw new ConfigArchiveException(throwable, "unexpected exception");
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.wsspi.configarchive.ExportCommand.createArchiveSession", (String)"95");
            throw new ConfigArchiveException(throwable, "unexpected exception");
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"beforeStepsExecuted");
        }
        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.getTaskCommandResult();
        try {
            this.createArchiveSession();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.wsspi.configarchive.ExportCommand.beforeStepsExecuted", (String)"99");
            taskCommandResultImpl.setException((Throwable)((Object)new ConfigArchiveException(throwable, "exportCommand command failed")));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"beforeStepsExecuted");
        }
    }

    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"afterStepsExecuted");
        }
        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.getTaskCommandResult();
        try {
            if (taskCommandResultImpl.isSuccessful()) {
                Session session = this.getConfigArchiveSession();
                Method method = this.composerCls.getMethod("saveConfigArchive", String.class, File.class);
                method.invoke(null, session.toString(), this.getArchiveLocation());
            }
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            if (throwable instanceof InvocationTargetException) {
                throwable2 = ((InvocationTargetException)throwable).getTargetException();
            }
            FFDCFilter.processException((Throwable)throwable2, (String)"com.ibm.wsspi.configarchive.ExportCommand.afterStepsExecuted", (String)"99");
            taskCommandResultImpl.setException((Throwable)((Object)new ConfigArchiveException(throwable2, this.getName() + " command failed")));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"afterStepsExecuted");
        }
    }
}

