/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.configarchive;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.configarchive.ConfigArchiveException;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public abstract class ConfigArchiveCommand
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register((Class)ConfigArchiveCommand.class, (String)"configarchive", (String)"com.ibm.ws.management.resources.configarchive");
    protected Class composerCls = null;
    private boolean unload = true;
    private Session configArchiveSession = null;

    public ConfigArchiveCommand(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
        this.init();
    }

    public ConfigArchiveCommand(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
        this.init();
    }

    private void init() {
        try {
            this.composerCls = Class.forName("com.ibm.ws.management.configarchive.ConfigArchiveComposer");
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"unexpected exception", (Object)throwable);
            }
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.wsspi.configarchive.ConfigArchiveCommand.initImpl", (String)"56");
        }
    }

    public Session getConfigArchiveSession() throws ConfigArchiveException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getConfigArchiveSession");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getConfigArchiveSession", (Object)this.configArchiveSession);
        }
        return this.configArchiveSession;
    }

    public void setConfigArchiveSession(Session session) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setConfigArchiveSession", (Object)session);
        }
        this.configArchiveSession = session;
        try {
            if (this.getParameter("archive") == null) {
                this.setParameter("archive", "");
                this.unload = false;
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"fail to set archive parameter", (Object)exception);
            }
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.wsspi.configarchive.ConfigArchiveCommand.setArchiveWorkspace", (String)"62");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setConfigArchiveSession");
        }
    }

    protected final void unload() throws Exception {
        if (this.unload) {
            Method method = this.composerCls.getMethod("unloadConfigArchive", String.class);
            method.invoke(null, this.configArchiveSession.toString());
        }
    }

    protected void taskCommandExecuted(boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("taskCommandExecuted," + bl));
        }
        try {
            this.unload();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.wsspi.configarchive.ConfigArchiveCommandBase.taskCommandExecuted", (String)"86");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"taskCommandExecuted");
        }
    }

    protected File getArchiveLocation() {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getArchiveLocation");
        }
        String string = null;
        try {
            object = this.getParameter("archive");
            string = object == null ? null : object.toString();
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"unexpected exception", (Object)exception);
            }
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.wsspi.configarchive.ConfigArchiveCommand.getArchiveLocation", (String)"73");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"archivePath", (Object)string);
        }
        object = new File(string);
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getArchiveLocation", (Object)object);
        }
        return object;
    }

    private ManagedObjectMetadataHelper getMetadataHelper(Session session) throws ConfigArchiveException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getMetadataHelper", (Object)session);
        }
        ManagedObjectMetadataHelper managedObjectMetadataHelper = null;
        try {
            Method method = this.composerCls.getMethod("getMetadataHelper", Session.class);
            managedObjectMetadataHelper = (ManagedObjectMetadataHelper)method.invoke(null, session);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof ConfigArchiveException) {
                throw (ConfigArchiveException)((Object)throwable);
            }
            throw new ConfigArchiveException(throwable, "failed to get ManagedObjectMetadataHelper for session " + session);
        }
        catch (Throwable throwable) {
            throw new ConfigArchiveException(throwable, "failed to get ManagedObjectMetadataHelper for session " + session);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getMetadataHelper", (Object)managedObjectMetadataHelper);
        }
        return managedObjectMetadataHelper;
    }

    public ManagedObjectMetadataHelper getConfigArchiveMetadataHelper() throws ConfigArchiveException {
        return this.getMetadataHelper(this.getConfigArchiveSession());
    }

    public ManagedObjectMetadataHelper getMetadataHelper() throws ConfigArchiveException {
        return this.getMetadataHelper(this.getConfigSession());
    }
}

