/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.repository;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.repository.RepositoryLock;
import java.lang.reflect.Method;

public class RepositoryLockFactory {
    private static RepositoryLock repositoryLock = null;
    private static boolean initialized = false;
    private static TraceComponent tc = Tr.register((Class)RepositoryLockFactory.class, (String)"RepositoryLock", (String)"com.ibm.ws.management.resources.repository");

    public static synchronized RepositoryLock createRepositoryLock() throws AdminException {
        if (initialized) {
            throw new AdminException("RepositoryLock is already created.");
        }
        RepositoryLockFactory.initialize();
        initialized = true;
        return repositoryLock;
    }

    private static void initialize() throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initialize");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Load XDRepositoryLock");
        }
        try {
            Class<?> clazz = Class.forName("com.ibm.ws.management.repository.XDRepositoryLock");
            Method method = clazz.getMethod("getRepositoryLock", null);
            repositoryLock = (RepositoryLock)method.invoke(null, null);
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Load DefaultRepositoryLock");
            }
            try {
                Class<?> clazz = Class.forName("com.ibm.ws.management.repository.DefaultRepositoryLock");
                Method method = clazz.getMethod("getRepositoryLock", null);
                repositoryLock = (RepositoryLock)method.invoke(null, null);
            }
            catch (Exception exception2) {
                FFDCFilter.processException((Throwable)exception2, (String)"com.ibm.ws.management.repository.RepositoryLockFactory.initialize", (String)"2");
                throw new AdminException(exception2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initialize");
        }
    }

    public static RepositoryLock getRepositoryLock() {
        return repositoryLock;
    }
}

