/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.cmdframework.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.application.AppManagement;
import com.ibm.websphere.management.application.AppManagementProxy;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.CommandProviderHelper;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.cmdframework.impl.CommandMetadataMgr;
import com.ibm.ws.management.cmdframework.impl.CommandMgrImpl;
import java.util.Properties;

public class LocalCommandMgr
extends CommandMgrImpl {
    private static TraceComponent tc = Tr.register((Class)LocalCommandMgr.class, (String)"LocalCommandMgr", (String)"com.ibm.websphere.management.resources.cmdframework");

    public LocalCommandMgr() {
        cmdMgr = this;
        this.helper = new CommandProviderHelper(){

            public ConfigService getConfigService() {
                ConfigService configService = ConfigServiceFactory.getConfigService();
                try {
                    if (configService == null) {
                        Properties properties = new Properties();
                        properties.setProperty("location", "local");
                        configService = ConfigServiceFactory.createConfigService(true, properties);
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.cmdframework.impl.LocalCommandMgr.getConfigService", (String)"42", (Object)this);
                    exception.printStackTrace();
                }
                return configService;
            }

            public AdminClient getAdminClient() {
                return null;
            }

            public AdminService getAdminService() {
                return AdminServiceFactory.getAdminService();
            }

            public AppManagement getAppManagement() {
                AppManagement appManagement = null;
                try {
                    appManagement = AppManagementProxy.getLocalProxy();
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.cmdframework.impl.LocalCommandMgr.getAppManagement", (String)"59", (Object)this);
                    exception.printStackTrace();
                }
                return appManagement;
            }
        };
    }

    public CommandProviderHelper getCommandProviderHelper() {
        return this.helper;
    }

    public AdminCommand createCommand(String string) throws ConnectorException, CommandException {
        CommandMetadata commandMetadata;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createCommand", (Object)string);
        }
        if ((commandMetadata = CommandMetadataMgr.getInstance().getCommandMetadata(string)) != null && commandMetadata.isSupportLocalMode()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createCommand");
            }
            return super.createCommand(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createCommand - with exception");
        }
        throw new CommandException("Command " + string + " does not support localmode");
    }
}

