/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.cmdframework.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandDataFactory;
import com.ibm.websphere.management.cmdframework.commanddata.CommandDataPackage;
import com.ibm.websphere.management.cmdframework.commandmetadata.BaseMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandGroupExtension;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandGroupMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadataFactory;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadataPackage;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandProviderMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandStepMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.Metadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.ParameterMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandExtension;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.CommandProvider;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.cmdframework.impl.CommandUtility;
import com.ibm.ws.management.cmdframework.impl.ParameterTypeTable;
import com.ibm.ws.management.cmdframework.impl.TaskCommandExtComparator;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.xmi.impl.XMLMapImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;

public class CommandMetadataMgr {
    private static TraceComponent tc = Tr.register((Class)CommandMetadataMgr.class, (String)"CommandMetadataMgr", (String)"com.ibm.ws.management.resources.cmdframework");
    private static CommandMetadataMgr commandMetadataMgr = new CommandMetadataMgr();
    private HashMap cmdGroupMetadataTable;
    private HashMap cmdGroupCommandTable;
    private HashMap cmdProviderInstanceTable;
    private HashMap cmdCommandProviderTable;
    private HashMap cmdGroupResBundleTable;
    private HashMap cmdMetadataTable;
    private Map loadOptions;
    private ArrayList cmdTaskExtsList;
    private ArrayList cmdNewTaskExtsList;
    private ArrayList cmdGrpExtList;
    private EcoreFactory fac;
    private EcorePackage pkg;
    static EFactory eFactory;
    static EPackage cmddataPackage;
    static CommandMetadataFactory cmdMetadataFactory;

    private CommandMetadataMgr() {
        block5: {
            this.cmdGroupMetadataTable = new HashMap();
            this.cmdGroupCommandTable = new HashMap();
            this.cmdProviderInstanceTable = new HashMap();
            this.cmdCommandProviderTable = new HashMap();
            this.cmdGroupResBundleTable = new HashMap();
            this.cmdMetadataTable = new HashMap();
            this.loadOptions = new HashMap(1);
            this.cmdTaskExtsList = new ArrayList();
            this.cmdNewTaskExtsList = new ArrayList();
            this.cmdGrpExtList = new ArrayList();
            this.fac = EcoreFactory.eINSTANCE;
            this.pkg = EcorePackage.eINSTANCE;
            this.initialize();
            try {
                Enumeration<URL> enumeration = this.getClass().getClassLoader().getResources("META-INF/admin-command-def.xml");
                while (enumeration.hasMoreElements()) {
                    try {
                        URL uRL = enumeration.nextElement();
                        Metadata metadata = this.getMetadata(uRL);
                        this.registerMetadata(metadata);
                    }
                    catch (Throwable throwable) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)"Exception caught ", (Object)throwable);
                    }
                }
                this.registerCommandGroupExtensions();
                this.registerNewTaskExtensions();
                this.registerTaskExtensions();
                this.cleanup();
            }
            catch (Throwable throwable) {
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug((TraceComponent)tc, (String)"Exception caught ", (Object)throwable);
            }
        }
    }

    protected Metadata getMetadata(URL uRL) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("get Metadata " + uRL.getFile()));
        }
        XMLResourceImpl xMLResourceImpl = new XMLResourceImpl();
        try {
            xMLResourceImpl.setURI(URI.createURI((String)uRL.toString()));
            xMLResourceImpl.load(uRL.openStream(), this.loadOptions);
        }
        catch (Exception exception) {
            EList eList = xMLResourceImpl.getErrors();
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                Exception exception2 = (Exception)iterator.next();
                FFDCFilter.processException((Throwable)exception2, (String)"com.ibm.ws.management.cmdframework.impl.CommandMetadataMgr", (String)"59", (Object)this);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("Exception caught " + exception2.getMessage()));
            }
        }
        return (Metadata)xMLResourceImpl.getContents().get(0);
    }

    protected void registerMetadata(Metadata metadata) {
        block3: {
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Register commands");
                }
                this.registerCommandProviderMetadata(metadata);
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block3;
                Tr.debug((TraceComponent)tc, (String)"Exception thrown during metadata", (Object)exception);
            }
        }
    }

    protected void registerCommandProviderMetadata(Metadata metadata) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"get Command Provider Metadata");
        }
        EList eList = metadata.getCommandProvider();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("provider metadata list size is " + eList.size()));
        }
        if (eList != null && !eList.isEmpty()) {
            for (int i = 0; i < eList.size(); ++i) {
                CommandProviderMetadata commandProviderMetadata = (CommandProviderMetadata)eList.get(i);
                this.translate(commandProviderMetadata);
                try {
                    Class<?> clazz = Class.forName(commandProviderMetadata.getImplClass());
                    CommandProvider commandProvider = (CommandProvider)clazz.newInstance();
                    this.cmdProviderInstanceTable.put(commandProviderMetadata.getImplClass(), commandProvider);
                    this.registerCommandGroupMetadata((List)commandProviderMetadata.getCommandGroups());
                    this.registerCommandMetadata(commandProvider.initCommandMetadata((List)commandProviderMetadata.getCommands()));
                    this.registerTaskCommandMetadata(commandProvider.initCommandMetadata((List)commandProviderMetadata.getTaskCommands()));
                    this.addCommandGroupExtensions((List)commandProviderMetadata.getCommandGroupExts());
                    this.addTaskCommandExtensions((List)commandProviderMetadata.getTaskCommandExts());
                    continue;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)"Command Provider class not found.", (Object)classNotFoundException);
                    continue;
                }
                catch (InstantiationException instantiationException) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)"Command Provider class not be instantiated.", (Object)instantiationException);
                    continue;
                }
                catch (IllegalAccessException illegalAccessException) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)"Command Provider class instantiated illegal access exception..", (Object)illegalAccessException);
                    continue;
                }
                catch (Throwable throwable) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("Command Provider class: " + commandProviderMetadata.getImplClass() + " cannot be invocated"), (Object)throwable);
                }
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"No Command Provider is defined");
        }
    }

    private void translate(CommandProviderMetadata commandProviderMetadata) {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"translate", (Object)commandProviderMetadata);
        }
        if ((string = commandProviderMetadata.getResourceBundle()) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"resourceBundle", (Object)string);
            }
            Object var3_3 = null;
            Object var4_4 = null;
            TreeIterator treeIterator = commandProviderMetadata.eAllContents();
            while (treeIterator.hasNext()) {
                BaseMetadata baseMetadata;
                Object e = treeIterator.next();
                if (e instanceof BaseMetadata) {
                    baseMetadata = (BaseMetadata)e;
                    this.translate(baseMetadata, string, Locale.getDefault());
                }
                if (!(e instanceof CommandMetadata)) continue;
                baseMetadata = (CommandMetadata)e;
                this.translate((CommandMetadata)baseMetadata, string, Locale.getDefault());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"translate");
        }
    }

    protected void translate(BaseMetadata baseMetadata, String string, Locale locale) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"translate", (Object)new Object[]{baseMetadata, string, locale});
        }
        if ((string == null || string.equals("")) && baseMetadata instanceof CommandGroupMetadata) {
            string = (String)this.cmdGroupResBundleTable.get(baseMetadata.getName());
        }
        String string2 = null;
        String string3 = null;
        if (string != null) {
            string3 = baseMetadata.getDescriptionKey();
            if (string3 != null) {
                string2 = TraceNLS.getStringFromBundle((String)string, (String)string3, (Locale)locale);
                baseMetadata.setDescription(string2);
            }
            if ((string3 = baseMetadata.getTitleKey()) != null) {
                string2 = TraceNLS.getStringFromBundle((String)string, (String)string3, (Locale)locale);
                baseMetadata.setTitle(string2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"translate");
        }
    }

    protected void translate(CommandMetadata commandMetadata, String string, Locale locale) {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"translate", (Object)commandMetadata);
        }
        if (string == null || string.equals("")) {
            object = (ProviderTableEntry)this.cmdCommandProviderTable.get(commandMetadata.getName());
            if (object != null) {
                string = ((ProviderTableEntry)object).getResouceBundle();
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"cannot find command provider");
            }
        }
        object = null;
        String string2 = null;
        if (string != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"resourceBundle", (Object)string);
            }
            if ((string2 = commandMetadata.getTargetObjectDescriptionKey()) != null) {
                object = TraceNLS.getStringFromBundle((String)string, (String)string2, (Locale)locale);
                commandMetadata.setTargetObjectDescription((String)object);
            }
            if ((string2 = commandMetadata.getTargetObjectTitleKey()) != null) {
                object = TraceNLS.getStringFromBundle((String)string, (String)string2, (Locale)locale);
                commandMetadata.setTargetObjectTitle((String)object);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"translate");
        }
    }

    protected void registerCommandGroupMetadata(List list) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"registerCommandGroupMetadata");
        }
        ArrayList arrayList = null;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("group metadata list size is " + list.size()));
        }
        if (list != null && !list.isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                CommandGroupMetadata commandGroupMetadata = (CommandGroupMetadata)list.get(i);
                String string = commandGroupMetadata.getName();
                if (!this.cmdGroupMetadataTable.containsKey(string)) {
                    this.cmdGroupMetadataTable.put(string, commandGroupMetadata);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Command Group already exist in the group, possibly Command Group name conflict");
                }
                if (!this.cmdGroupCommandTable.containsKey(string)) {
                    this.cmdGroupCommandTable.put(string, new ArrayList());
                } else if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Command Group already exist in the command group, possibly Command Group name conflict");
                }
                EList eList = commandGroupMetadata.getCommands();
                for (int j = 0; j < eList.size(); ++j) {
                    String string2 = (String)eList.get(j);
                    if (string2 != null && string2.length() != 0) {
                        arrayList = (ArrayList)this.cmdGroupCommandTable.get(string);
                        if (!arrayList.contains(string2)) {
                            arrayList.add(string2);
                            continue;
                        }
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)("Command already exist in this group " + string + ", possibly command name conflict"));
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)"No command specified for this group");
                }
                String string3 = ((CommandProviderMetadata)commandGroupMetadata.eContainer()).getResourceBundle();
                if (string3 == null || string3.equals("")) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("resouce bundle is " + string));
                }
                this.cmdGroupResBundleTable.put(string, string3);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"No Command Group is defined");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"registerCommandGroupMetadata, ");
        }
    }

    protected void registerCommandGroupExtensions() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"registerCommandGroupExtension");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("group extension metadata list size is " + this.cmdGrpExtList.size()));
        }
        ArrayList arrayList = null;
        if (this.cmdGrpExtList != null && !this.cmdGrpExtList.isEmpty()) {
            for (int i = 0; i < this.cmdGrpExtList.size(); ++i) {
                CommandGroupExtension commandGroupExtension = (CommandGroupExtension)this.cmdGrpExtList.get(i);
                String string = commandGroupExtension.getName();
                if (this.cmdGroupMetadataTable.containsKey(string)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("group to add extension is " + string));
                    }
                    try {
                        CommandGroupMetadata commandGroupMetadata = this.getCommandGroupMetadata(string);
                        EList eList = commandGroupMetadata.getCommands();
                        EList eList2 = commandGroupExtension.getCommands();
                        for (int j = 0; j < eList2.size(); ++j) {
                            String string2 = (String)eList2.get(j);
                            if (string2 != null && string2.length() != 0) {
                                arrayList = (ArrayList)this.cmdGroupCommandTable.get(string);
                                if (!arrayList.contains(string2)) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)tc, (String)("add command " + string2));
                                    }
                                    arrayList.add(string2);
                                } else if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)("Command already exist in this group " + string + ", possibly command name conflict"));
                                }
                                eList.add((Object)string2);
                                continue;
                            }
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug((TraceComponent)tc, (String)"No command specified for this extension");
                        }
                        continue;
                    }
                    catch (CommandNotFoundException commandNotFoundException) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)("Command Group " + string + " does not exist"));
                        continue;
                    }
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("Command Group " + string + " does not exist"));
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"No Command Group Extension defined");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"registerCommandGroupExtension");
        }
    }

    protected void addCommandGroupExtensions(List list) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addCommandGroupExtension");
        }
        if (list != null && !list.isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                this.cmdGrpExtList.add(list.get(i));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addCommandGroupExtension");
        }
    }

    protected void registerTaskCommandMetadata(List list) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"register Task Command Metadata");
        }
        ArrayList<TaskCommandMetadata> arrayList = new ArrayList<TaskCommandMetadata>();
        for (int i = 0; i < list.size(); ++i) {
            TaskCommandMetadata taskCommandMetadata = (TaskCommandMetadata)list.get(i);
            if (!this.validateTaskCommand(taskCommandMetadata)) continue;
            arrayList.add(taskCommandMetadata);
        }
        this.registerCommandMetadata(arrayList);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"registerTaskCommandMetadata");
        }
    }

    protected void registerNewTaskExtensions() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"registerNewTaskExtensions");
        }
        if (this.cmdNewTaskExtsList != null && !this.cmdNewTaskExtsList.isEmpty()) {
            for (int i = 0; i < this.cmdNewTaskExtsList.size(); ++i) {
                TaskCommandExtension taskCommandExtension = (TaskCommandExtension)this.cmdNewTaskExtsList.get(i);
                try {
                    String string = taskCommandExtension.getName();
                    if (this.cmdMetadataTable.containsKey(string)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Task command " + string + " extension base exists.  Add to cmdTaskExtsList"));
                        }
                        this.cmdTaskExtsList.add(taskCommandExtension);
                        continue;
                    }
                    String string2 = taskCommandExtension.getBaseTaskCommand();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("New task command extension to add is  " + string + " Task base command name is " + string2));
                    }
                    if (string2 != null && !string2.equals("")) {
                        TaskCommandMetadata taskCommandMetadata = (TaskCommandMetadata)this.getCommandMetadata(taskCommandExtension.getBaseTaskCommand());
                        TaskCommandMetadata taskCommandMetadata2 = (TaskCommandMetadata)CommandUtility.clone(taskCommandMetadata);
                        taskCommandMetadata2.setName(string);
                        taskCommandMetadata2.setPrivate(taskCommandExtension.isPrivate());
                        CommandProviderMetadata commandProviderMetadata = (CommandProviderMetadata)taskCommandExtension.eContainer();
                        this.cmdCommandProviderTable.put(string, new ProviderTableEntry(commandProviderMetadata.getImplClass(), commandProviderMetadata.getResourceBundle()));
                        this.addTaskExtStepProvider(taskCommandExtension);
                        ArrayList<TaskCommandMetadata> arrayList = new ArrayList<TaskCommandMetadata>();
                        arrayList.add(taskCommandMetadata2);
                        this.registerCommandMetadata(arrayList);
                        this.updateTaskExtStep(taskCommandMetadata2, taskCommandExtension);
                        continue;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Base Task command not found " + string2 + ".  Add to exist list for further processing"));
                    }
                    this.cmdTaskExtsList.add(taskCommandExtension);
                    continue;
                }
                catch (CommandNotFoundException commandNotFoundException) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("Command " + taskCommandExtension.getName() + " not found."));
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"registerTaskExtensions");
        }
    }

    protected void registerTaskExtensions() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"registerTaskExtensions");
        }
        if (this.cmdTaskExtsList != null && !this.cmdTaskExtsList.isEmpty()) {
            Collections.sort(this.cmdTaskExtsList, new TaskCommandExtComparator());
            for (int i = 0; i < this.cmdTaskExtsList.size(); ++i) {
                TaskCommandExtension taskCommandExtension = (TaskCommandExtension)this.cmdTaskExtsList.get(i);
                String string = taskCommandExtension.getName();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Task command extension to add is  " + string));
                }
                try {
                    TaskCommandMetadata taskCommandMetadata = (TaskCommandMetadata)this.getCommandMetadata(string);
                    this.addTaskExtStepProvider(taskCommandExtension);
                    this.updateTaskExtStep(taskCommandMetadata, taskCommandExtension);
                    continue;
                }
                catch (CommandNotFoundException commandNotFoundException) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("task Command not found " + string + ".  Proceed to add new task cmd"));
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"registerTaskExtensions");
        }
    }

    private void addTaskExtStepProvider(TaskCommandExtension taskCommandExtension) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addTaskExtStepProvider", (Object)taskCommandExtension.getName());
        }
        String string = taskCommandExtension.getName();
        CommandProviderMetadata commandProviderMetadata = (CommandProviderMetadata)taskCommandExtension.eContainer();
        EList eList = taskCommandExtension.getSteps();
        for (int i = 0; i < eList.size(); ++i) {
            CommandStepMetadata commandStepMetadata = (CommandStepMetadata)eList.get(i);
            String string2 = commandStepMetadata.getName();
            String string3 = this.getStepEClassName(string, string2);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Step name to add to provider table is " + string3));
            }
            this.cmdCommandProviderTable.put(string3, new ProviderTableEntry(commandProviderMetadata.getImplClass(), commandProviderMetadata.getResourceBundle()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addTaskExtStepProvider");
        }
    }

    private void updateTaskExtStep(TaskCommandMetadata taskCommandMetadata, TaskCommandExtension taskCommandExtension) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"updateTaskExtStep", (Object)taskCommandMetadata.getName());
        }
        EList eList = taskCommandMetadata.getSteps();
        EList eList2 = taskCommandExtension.getSteps();
        ArrayList arrayList = new ArrayList(eList2);
        for (int i = 0; i < arrayList.size(); ++i) {
            CommandStepMetadata commandStepMetadata = (CommandStepMetadata)arrayList.get(i);
            int n = this.getStepIndexFromTask((List)eList, commandStepMetadata);
            if (n >= 0) {
                CommandStepMetadata commandStepMetadata2 = (CommandStepMetadata)eList.get(n);
                if (Integer.valueOf(commandStepMetadata.getPriority()) <= Integer.valueOf(commandStepMetadata2.getPriority())) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Update step " + commandStepMetadata.getName() + " at index " + n));
                    }
                    eList.remove(n);
                    eList.add(n, commandStepMetadata);
                    continue;
                }
                String string = this.getStepEClassName(taskCommandExtension.getName(), commandStepMetadata.getName());
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("remove stepname " + string + " in provider table"));
                }
                this.cmdCommandProviderTable.remove(string);
                continue;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("add new step " + commandStepMetadata.getName() + " to " + taskCommandMetadata.getName()));
            }
            eList.add(commandStepMetadata);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"updateTaskExtStep");
        }
    }

    private int getStepIndexFromTask(List list, CommandStepMetadata commandStepMetadata) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getStepIndexFromTask");
        }
        int n = -1;
        for (int i = 0; i < list.size(); ++i) {
            CommandStepMetadata commandStepMetadata2 = (CommandStepMetadata)list.get(i);
            if (!commandStepMetadata2.getName().equals(commandStepMetadata.getName())) continue;
            n = i;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getStepIndexFromTask " + n));
        }
        return n;
    }

    protected void addTaskCommandExtensions(List list) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addTaskCommandExtensions");
        }
        if (list != null && !list.isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                TaskCommandExtension taskCommandExtension = (TaskCommandExtension)list.get(i);
                if (!this.validateTaskCommand(taskCommandExtension)) continue;
                this.cmdNewTaskExtsList.add(taskCommandExtension);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addTaskCommandExtensions");
        }
    }

    protected void registerCommandMetadataRemote(List list) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"registerCommandMetadataRemote");
        }
        Object var2_2 = null;
        if (list != null && !list.isEmpty()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Size of meta list is " + list.size()));
            }
            for (int i = 0; i < list.size(); ++i) {
                CommandMetadata commandMetadata = (CommandMetadata)list.get(i);
                if (!this.validateCmdMetadata(commandMetadata)) continue;
                String string = commandMetadata.getName();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Command registering is " + string));
                }
                this.cmdMetadataTable.put(string, commandMetadata);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"registerCommandMetadataRemote");
        }
    }

    protected void registerCommandMetadata(List list) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"registerCommandMetadata");
        }
        ArrayList arrayList = null;
        if (list != null && !list.isEmpty()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Size of meta list is " + list.size()));
            }
            for (int i = 0; i < list.size(); ++i) {
                Object object;
                CommandMetadata commandMetadata = (CommandMetadata)list.get(i);
                if (!this.validateCmdMetadata(commandMetadata)) continue;
                String string = commandMetadata.getName();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Command registering is " + string));
                }
                if (commandMetadata.isSupportLocalMode()) {
                    arrayList = (ArrayList)this.cmdGroupCommandTable.get("LocalModeGroup");
                    if (!arrayList.contains(string)) {
                        arrayList.add(string);
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Command already exist in Local Mode Group, possibly command name conflict");
                    }
                }
                if (!this.cmdMetadataTable.containsKey(string)) {
                    this.cmdMetadataTable.put(string, commandMetadata);
                    if (this.cmdCommandProviderTable.containsKey(string)) continue;
                    object = (CommandProviderMetadata)commandMetadata.eContainer();
                    this.cmdCommandProviderTable.put(string, new ProviderTableEntry(object.getImplClass(), object.getResourceBundle()));
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Command name conflict, Prioirty will be used");
                }
                object = commandMetadata.getPriority();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Command priority is " + (String)object));
                }
                if (object == null || object == "") continue;
                CommandMetadata commandMetadata2 = (CommandMetadata)this.cmdMetadataTable.get(string);
                String string2 = commandMetadata2.getPriority();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Original command priority is " + string2));
                }
                if (string2 == null || string2 == "" || Integer.valueOf((String)object) >= Integer.valueOf(string2)) continue;
                this.cmdMetadataTable.put(string, commandMetadata);
                if (this.cmdCommandProviderTable.containsKey(string)) continue;
                CommandProviderMetadata commandProviderMetadata = (CommandProviderMetadata)commandMetadata.eContainer();
                this.cmdCommandProviderTable.put(string, new ProviderTableEntry(commandProviderMetadata.getImplClass(), commandProviderMetadata.getResourceBundle()));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"registerCommandMetadata");
        }
    }

    public EClass getParamDataEClass(String string) throws CommandNotFoundException {
        EClass eClass;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getParamDataEClass", (Object)string);
        }
        if ((eClass = (EClass)cmddataPackage.getEClassifier(string)) == null) {
            CommandMetadata commandMetadata = this.getCommandMetadata(string);
            eClass = this.createParamDataEClass(string, (List)commandMetadata.getParameters());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getParamDataEClass");
        }
        return eClass;
    }

    public EClass createParamDataEClass(String string, List list) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createParamDataEClass", (Object)string);
        }
        EClass eClass = this.fac.createEClass();
        eClass.setName(string);
        if (list != null && !list.isEmpty()) {
            EList eList = eClass.getEStructuralFeatures();
            for (int i = 0; i < list.size(); ++i) {
                EReference eReference;
                String string2;
                ParameterMetadata parameterMetadata = (ParameterMetadata)list.get(i);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Attribute Name " + i + " is " + parameterMetadata.getName()));
                }
                if ((string2 = parameterMetadata.getType()).equals("GenericObject") || string2.equals("javax.management.ObjectName") || !ParameterTypeTable.isPrimitive(string2)) {
                    eReference = this.fac.createEReference();
                    eReference.setContainment(true);
                } else {
                    eReference = this.fac.createEAttribute();
                }
                eReference.setName(parameterMetadata.getName());
                eReference.setEType(ParameterTypeTable.getParamEClassifierType(parameterMetadata.getType()));
                if (parameterMetadata.getDefaultValue() != null) {
                    eReference.setDefaultValue((Object)parameterMetadata.getDefaultValue());
                }
                eList.add(eReference);
            }
        }
        cmddataPackage.getEClassifiers().add((Object)eClass);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createParamDataEClass");
        }
        return eClass;
    }

    public EObject createParamDataEObject(String string) throws CommandNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createParamDataEObject", (Object)string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createParamDataEObject");
        }
        return eFactory.create(this.getParamDataEClass(string));
    }

    public EObject createParamDataEObject(String string, String string2) throws CommandNotFoundException {
        String string3;
        EClass eClass;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createParamDataEObject", (Object)new Object[]{string, string2});
        }
        if ((eClass = (EClass)cmddataPackage.getEClassifier(string3 = this.getStepEClassName(string, string2))) == null) {
            CommandMetadata commandMetadata = this.getCommandMetadata(string);
            CommandMetadata commandMetadata2 = null;
            EList eList = ((TaskCommandMetadata)commandMetadata).getSteps();
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                CommandStepMetadata commandStepMetadata = (CommandStepMetadata)iterator.next();
                if (!commandStepMetadata.getName().equals(string2)) continue;
                commandMetadata2 = commandStepMetadata;
                break;
            }
            if (commandMetadata2 == null) {
                throw new CommandNotFoundException(string, string2);
            }
            eClass = this.createParamDataEClass(this.getStepEClassName(string, string2), (List)commandMetadata2.getParameters());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createParamDataEObject", (Object)eClass.getName());
        }
        return eFactory.create(eClass);
    }

    public Collection listCommandGroups() {
        return Collections.unmodifiableCollection(this.cmdGroupCommandTable.keySet());
    }

    public Collection listCommands(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"listCommands", (Object)string);
        }
        if (this.cmdGroupCommandTable.containsKey(string)) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"listCommands");
            }
            return Collections.unmodifiableCollection(this.filterCommandsList((Collection)this.cmdGroupCommandTable.get(string)));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"listCommands");
        }
        return Collections.EMPTY_SET;
    }

    public Collection listCommands() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"listCommands");
        }
        Collection collection = this.filterCommandsList(this.cmdMetadataTable.keySet());
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"listCommands");
        }
        return Collections.unmodifiableCollection(collection);
    }

    private Collection filterCommandsList(Collection collection) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"filterCommandsList", (Object)collection);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            try {
                CommandMetadata commandMetadata = this.getCommandMetadata((String)iterator.next());
                if (commandMetadata.isPrivate()) continue;
                arrayList.add(commandMetadata.getName());
            }
            catch (Throwable throwable) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)"Exception caught while filtering commands", (Object)throwable);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"filterCommandsList", arrayList);
        }
        return arrayList;
    }

    public CommandProvider getCommandProvider(String string) throws CommandNotFoundException {
        ProviderTableEntry providerTableEntry;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getCommandProvider", (Object)string);
        }
        if ((providerTableEntry = (ProviderTableEntry)this.cmdCommandProviderTable.get(string)) != null) {
            String string2 = providerTableEntry.getImplClass();
            CommandProvider commandProvider = (CommandProvider)this.cmdProviderInstanceTable.get(string2);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getCommandProvider", (Object)commandProvider);
            }
            return commandProvider;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getCommandProvider");
        }
        throw new CommandNotFoundException(string);
    }

    public CommandProvider getCommandProvider(String string, String string2) throws CommandNotFoundException {
        String string3;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getCommandProvider", (Object)new Object[]{string, string2});
        }
        if (!this.cmdCommandProviderTable.containsKey(string3 = this.getStepEClassName(string, string2))) {
            string3 = string;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getCommandProvider", (Object)string3);
        }
        return this.getCommandProvider(string3);
    }

    public CommandMetadata getCommandMetadata(String string) throws CommandNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getCommandMetadata", (Object)string);
        }
        if (!this.cmdMetadataTable.containsKey(string)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("CommandName " + string + " does not exist"));
            }
            throw new CommandNotFoundException(string);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Command Provider got is " + (CommandProviderMetadata)((CommandMetadata)this.cmdMetadataTable.get(string)).eContainer()));
        }
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getCommandMetadata" + (CommandMetadata)this.cmdMetadataTable.get(string)));
        }
        return (CommandMetadata)this.cmdMetadataTable.get(string);
    }

    public CommandGroupMetadata getCommandGroupMetadata(String string) throws CommandNotFoundException {
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getCommandGroupMetadata", (Object)string);
        }
        if (!this.cmdGroupMetadataTable.containsKey(string)) {
            throw new CommandNotFoundException(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getCommandGroupMetadata");
        }
        return (CommandGroupMetadata)this.cmdGroupMetadataTable.get(string);
    }

    private boolean validateCmdMetadata(CommandMetadata commandMetadata) {
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"validateCmdMetadata", (Object)commandMetadata);
        }
        boolean bl = true;
        if (commandMetadata.isTargetObjectAllowed() && (commandMetadata.getTargetObjectType() == null || commandMetadata.getTargetObjectType().equals(""))) {
            Tr.warning((TraceComponent)tc, (String)"ADMF0001W", (Object)new Object[]{commandMetadata.getName()});
            bl = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("validateCmdMetadata," + bl));
        }
        return bl;
    }

    private boolean validateTaskCommand(EObject eObject) {
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"validateTaskCommand", (Object)eObject);
        }
        EList eList = null;
        String string = "";
        boolean bl = true;
        if (eObject instanceof TaskCommandMetadata) {
            eList = ((TaskCommandMetadata)eObject).getSteps();
            string = ((TaskCommandMetadata)eObject).getName();
        } else if (eObject instanceof TaskCommandExtension) {
            eList = ((TaskCommandExtension)eObject).getSteps();
            string = ((TaskCommandExtension)eObject).getName();
        }
        for (int i = 0; i < eList.size(); ++i) {
            CommandStepMetadata commandStepMetadata = (CommandStepMetadata)eList.get(i);
            if (!commandStepMetadata.isTable()) continue;
            EList eList2 = commandStepMetadata.getParameters();
            boolean bl2 = false;
            for (int j = 0; j < eList2.size(); ++j) {
                ParameterMetadata parameterMetadata = (ParameterMetadata)eList2.get(j);
                if (!parameterMetadata.isKeyField()) continue;
                bl2 = true;
                break;
            }
            if (bl2) continue;
            if (tc.isDebugEnabled()) {
                Tr.warning((TraceComponent)tc, (String)"ADMF0002W", (Object)new Object[]{string});
            }
            bl = false;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"validateTaskCommand", (Object)new Boolean(bl));
        }
        return bl;
    }

    private void initialize() {
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initialize");
        }
        CommandMetadataPackage commandMetadataPackage = CommandMetadataPackage.eINSTANCE;
        cmddataPackage = CommandDataPackage.eINSTANCE;
        cmdMetadataFactory = CommandMetadataFactory.eINSTANCE;
        eFactory = CommandDataFactory.eINSTANCE;
        XMLMapImpl xMLMapImpl = new XMLMapImpl();
        this.loadOptions.put("XML_MAP", xMLMapImpl);
        this.cmdGroupCommandTable.put("LocalModeGroup", new ArrayList());
        this.cmdGroupMetadataTable.put("LocalModeGroup", cmdMetadataFactory.createCommandGroupMetadata());
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initialize");
        }
    }

    public String getStepEClassName(String string, String string2) {
        return string + '+' + string2;
    }

    public String[] getTaskStepName(String string) {
        String[] stringArray = new String[2];
        StringTokenizer stringTokenizer = new StringTokenizer(string, "+");
        stringArray[0] = stringTokenizer.nextToken();
        stringArray[1] = stringTokenizer.nextToken();
        return stringArray;
    }

    private String[] resolveStep(String string) {
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"resolveStep", (Object)string);
        }
        String[] stringArray = new String[2];
        int n = string.indexOf(43);
        if (n == -1) {
            stringArray[0] = string;
            stringArray[1] = null;
        } else {
            stringArray[0] = string.substring(0, n);
            stringArray[1] = string.substring(n + 1);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"resolveStep");
        }
        return stringArray;
    }

    private String getShortTypeName(String string) {
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getShortTypeName", (Object)string);
        }
        String string2 = "";
        int n = string.lastIndexOf(46);
        string2 = n != -1 ? string.substring(n + 1) : string;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"resolveStep", (Object)string2);
        }
        return string2;
    }

    private void cleanup() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"cleanup");
        }
        this.cmdTaskExtsList.clear();
        this.cmdNewTaskExtsList.clear();
        this.cmdGrpExtList.clear();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"cleanup");
        }
    }

    private static boolean isComposite(EStructuralFeature eStructuralFeature) {
        boolean bl = true;
        if (eStructuralFeature instanceof EReference) {
            bl = ((EReference)eStructuralFeature).isContainment();
        }
        return bl;
    }

    public static CommandMetadataMgr getInstance() {
        return commandMetadataMgr;
    }

    private class ProviderTableEntry {
        private String implClass;
        private String resouceBundle;

        public ProviderTableEntry(String string, String string2) {
            this.implClass = string;
            this.resouceBundle = string2;
        }

        public String getImplClass() {
            return this.implClass;
        }

        public String getResouceBundle() {
            return this.resouceBundle;
        }

        public void setImplClass(String string) {
            this.implClass = string;
        }

        public void setResouceBundle(String string) {
            this.resouceBundle = string;
        }
    }
}

