/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.repository;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import java.lang.reflect.Method;

public class ConfigRepositoryFactory {
    private static ConfigRepository repository = null;
    private static TraceComponent tc = Tr.register((Class)ConfigRepositoryFactory.class, (String)"ConfigRepositoryFactory", (String)"com.ibm.ws.management.resources.repository");
    private static boolean initialized = false;

    public static synchronized ConfigRepository createConfigRepository(boolean bl) throws AdminException {
        if (initialized) {
            throw new AdminException("The ConfigurationRepository is already created");
        }
        if (bl) {
            ConfigRepositoryFactory.initialize();
            initialized = true;
        }
        return repository;
    }

    private static void initialize() throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initialize");
        }
        if (AdminHelper.getPlatformHelper().isServantJvm()) {
            Class<?> clazz = null;
            try {
                try {
                    clazz = Class.forName("com.ibm.ws.management.repository.XDServantFileRepository");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"'XDServantFileRepository' NOT Found.");
                    }
                    clazz = Class.forName("com.ibm.ws.management.repository.ServantFileRepository");
                }
                Method method = clazz.getMethod("getRepository", null);
                repository = (ConfigRepository)method.invoke(null, null);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.websphere.management.repository.ConfigRepositoryFactory.initialize", (String)"71");
                throw new AdminException(exception);
            }
        }
        try {
            String string = "com.ibm.ws.management.repository.FileRepository";
            Class<?> clazz = Class.forName(string);
            Method method = clazz.getMethod("getRepository", null);
            repository = (ConfigRepository)method.invoke(null, null);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.websphere.management.repository.ConfigRepositoryFactory.initialize", (String)"92");
            throw new AdminException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initialize");
        }
    }

    public static ConfigRepository getConfigRepository() {
        return repository;
    }
}

