/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.configservice;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.configservice.ValidationResult;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.ffdc.FFDCFilter;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;

public class ConfigServiceProxy
implements ConfigService {
    private static TraceComponent tc = Tr.register((Class)ConfigServiceProxy.class, (String)"management", (String)"com.ibm.ws.management.resources.configservice");
    private AdminClient client;
    private ObjectName configServiceMBean;

    public ConfigServiceProxy(AdminClient adminClient) throws InstanceNotFoundException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"ConfigServiceProxy", (Object)adminClient);
        }
        this.client = adminClient;
        ObjectName objectName = null;
        ObjectName objectName2 = this.client.getServerMBean();
        if (objectName2 == null) {
            throw new InstanceNotFoundException(objectName.getCanonicalName());
        }
        String string = objectName2.getKeyProperty("process");
        String string2 = "WebSphere:type=ConfigService,process=" + string + ",*";
        try {
            objectName = new ObjectName(string2);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            FFDCFilter.processException((Throwable)malformedObjectNameException, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.ConfigServiceProxy", (String)"39", (Object)this);
            Tr.error((TraceComponent)tc, (String)"ADMG0011E", (Object)malformedObjectNameException);
        }
        Set set = this.client.queryNames(objectName, null);
        if (set.size() == 0) {
            throw new InstanceNotFoundException(objectName.getCanonicalName());
        }
        this.configServiceMBean = (ObjectName)set.iterator().next();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"ConfigServiceProxy", (Object)this.configServiceMBean);
        }
    }

    public AdminClient getAdminClient() {
        return this.client;
    }

    public void setProperties(Session session, HashMap hashMap) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setProperties", (Object)new Object[]{session, hashMap});
        }
        try {
            this.client.invoke(this.configServiceMBean, "setProperties", new Object[]{session, hashMap}, new String[]{"com.ibm.websphere.management.Session", "java.util.HashMap"});
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            FFDCFilter.processException((Throwable)instanceNotFoundException, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.setProperties", (String)"58", (Object)this);
            Tr.error((TraceComponent)tc, (String)"ADMG0011E", (Object)instanceNotFoundException);
        }
        catch (ReflectionException reflectionException) {
            FFDCFilter.processException((Throwable)reflectionException, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.setProperties", (String)"61", (Object)this);
            Tr.error((TraceComponent)tc, (String)"ADMG0011E", (Object)reflectionException);
        }
        catch (MBeanException mBeanException) {
            FFDCFilter.processException((Throwable)mBeanException, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.setProperties", (String)"64", (Object)this);
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof ConfigServiceException) {
                throw (ConfigServiceException)((Object)exception);
            }
            throw new ConfigServiceException(exception);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.setAttributes", (String)"400", (Object)this);
            throw new ConfigServiceException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setProperties");
        }
    }

    public ValidationResult validate(Session session, ObjectName objectName) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"validate", (Object)new Object[]{session, objectName});
        }
        ValidationResult validationResult = null;
        try {
            validationResult = (ValidationResult)this.client.invoke(this.configServiceMBean, "validate", new Object[]{session, objectName}, new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName"});
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            FFDCFilter.processException((Throwable)instanceNotFoundException, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.validate", (String)"87", (Object)this);
            Tr.error((TraceComponent)tc, (String)"ADMG0011E", (Object)instanceNotFoundException);
        }
        catch (ReflectionException reflectionException) {
            FFDCFilter.processException((Throwable)reflectionException, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.validate", (String)"90", (Object)this);
            Tr.error((TraceComponent)tc, (String)"ADMG0011E", (Object)reflectionException);
        }
        catch (MBeanException mBeanException) {
            FFDCFilter.processException((Throwable)mBeanException, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.validate", (String)"93", (Object)this);
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof ConfigServiceException) {
                throw (ConfigServiceException)((Object)exception);
            }
            throw new ConfigServiceException(exception);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.validate", (String)"101", (Object)this);
            throw new ConfigServiceException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"validate", validationResult);
        }
        return validationResult;
    }

    public void save(Session session, boolean bl) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"save", (Object)new Object[]{session, new Boolean(bl)});
        }
        try {
            this.client.invoke(this.configServiceMBean, "save", new Object[]{session, new Boolean(bl)}, new String[]{"com.ibm.websphere.management.Session", "boolean"});
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            FFDCFilter.processException((Throwable)instanceNotFoundException, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.save", (String)"55", (Object)this);
            Tr.error((TraceComponent)tc, (String)"ADMG0011E", (Object)instanceNotFoundException);
        }
        catch (ReflectionException reflectionException) {
            FFDCFilter.processException((Throwable)reflectionException, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.save", (String)"58", (Object)this);
            Tr.error((TraceComponent)tc, (String)"ADMG0011E", (Object)reflectionException);
        }
        catch (MBeanException mBeanException) {
            FFDCFilter.processException((Throwable)mBeanException, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.save", (String)"61", (Object)this);
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof ConfigServiceException) {
                throw (ConfigServiceException)((Object)exception);
            }
            throw new ConfigServiceException(exception);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.save", (String)"69", (Object)this);
            throw new ConfigServiceException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"save", (Object)session);
        }
    }

    public void discard(Session session) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"discard", (Object)session);
        }
        try {
            this.client.invoke(this.configServiceMBean, "discard", new Object[]{session}, new String[]{"com.ibm.websphere.management.Session"});
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            FFDCFilter.processException((Throwable)instanceNotFoundException, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.discard", (String)"80", (Object)this);
            Tr.error((TraceComponent)tc, (String)"ADMG0011E", (Object)instanceNotFoundException);
        }
        catch (ReflectionException reflectionException) {
            FFDCFilter.processException((Throwable)reflectionException, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.discard", (String)"83", (Object)this);
            Tr.error((TraceComponent)tc, (String)"ADMG0011E", (Object)reflectionException);
        }
        catch (MBeanException mBeanException) {
            FFDCFilter.processException((Throwable)mBeanException, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.discard", (String)"86", (Object)this);
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof ConfigServiceException) {
                throw (ConfigServiceException)((Object)exception);
            }
            throw new ConfigServiceException(exception);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.discard", (String)"94", (Object)this);
            throw new ConfigServiceException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"discard", (Object)session);
        }
    }

    public String[] getUnsavedChanges(Session session) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getUnsavedChanges", (Object)session);
        }
        String[] stringArray = null;
        try {
            stringArray = (String[])this.client.invoke(this.configServiceMBean, "getUnsavedChanges", new Object[]{session}, new String[]{"com.ibm.websphere.management.Session"});
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            FFDCFilter.processException((Throwable)instanceNotFoundException, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.getUnsavedChanges", (String)"106", (Object)this);
            Tr.error((TraceComponent)tc, (String)"ADMG0011E", (Object)instanceNotFoundException);
        }
        catch (ReflectionException reflectionException) {
            FFDCFilter.processException((Throwable)reflectionException, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.getUnsavedChanges", (String)"109", (Object)this);
            Tr.error((TraceComponent)tc, (String)"ADMG0011E", (Object)reflectionException);
        }
        catch (MBeanException mBeanException) {
            FFDCFilter.processException((Throwable)mBeanException, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.getUnsavedChanges", (String)"112", (Object)this);
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof ConfigServiceException) {
                throw (ConfigServiceException)((Object)exception);
            }
            throw new ConfigServiceException(exception);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.getUnsavedChanges", (String)"120", (Object)this);
            throw new ConfigServiceException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getUnsavedChanges", stringArray);
        }
        return stringArray;
    }

    public Map getConflictDocuments(Session session) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getConflictDocuments", (Object)session);
        }
        Map map = null;
        try {
            map = (Map)this.client.invoke(this.configServiceMBean, "getConflictDocuments", new Object[]{session}, new String[]{"com.ibm.websphere.management.Session"});
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            FFDCFilter.processException((Throwable)instanceNotFoundException, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.getConflictDocuments", (String)"133", (Object)this);
            Tr.error((TraceComponent)tc, (String)"ADMG0011E", (Object)instanceNotFoundException);
        }
        catch (ReflectionException reflectionException) {
            FFDCFilter.processException((Throwable)reflectionException, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.getConflictDocuments", (String)"136", (Object)this);
            Tr.error((TraceComponent)tc, (String)"ADMG0011E", (Object)reflectionException);
        }
        catch (MBeanException mBeanException) {
            FFDCFilter.processException((Throwable)mBeanException, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.getConflictDocuments", (String)"139", (Object)this);
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof ConfigServiceException) {
                throw (ConfigServiceException)((Object)exception);
            }
            throw new ConfigServiceException(exception);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.getConflictDocuments", (String)"147", (Object)this);
            throw new ConfigServiceException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getConflictDocuments", map);
        }
        return map;
    }

    public String[] getSupportedConfigObjectTypes() throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getSupportedConfigObjectTypes");
        }
        String[] stringArray = null;
        try {
            stringArray = (String[])this.client.invoke(this.configServiceMBean, "getSupportedConfigObjectTypes", null, null);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            FFDCFilter.processException((Throwable)instanceNotFoundException, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.getSupportedConfigObjectTypes", (String)"163", (Object)this);
            Tr.error((TraceComponent)tc, (String)"ADMG0011E", (Object)instanceNotFoundException);
        }
        catch (ReflectionException reflectionException) {
            FFDCFilter.processException((Throwable)reflectionException, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.getSupportedConfigObjectTypes", (String)"166", (Object)this);
            Tr.error((TraceComponent)tc, (String)"ADMG0011E", (Object)reflectionException);
        }
        catch (MBeanException mBeanException) {
            FFDCFilter.processException((Throwable)mBeanException, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.getSupportedConfigObjectTypes", (String)"169", (Object)this);
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof ConfigServiceException) {
                throw (ConfigServiceException)((Object)exception);
            }
            throw new ConfigServiceException(exception);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.getSupportedConfigObjectTypes", (String)"177", (Object)this);
            throw new ConfigServiceException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getSupportedConfigObjectTypes", (Object)stringArray);
        }
        return stringArray;
    }

    public AttributeList getAttributesMetaInfo(String string) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getAttributesMetaInfo", (Object)string);
        }
        AttributeList attributeList = null;
        try {
            attributeList = (AttributeList)this.client.invoke(this.configServiceMBean, "getAttributesMetaInfo", new Object[]{string}, new String[]{"java.lang.String"});
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            FFDCFilter.processException((Throwable)instanceNotFoundException, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.getAttributesMetaInfo", (String)"191", (Object)this);
            Tr.error((TraceComponent)tc, (String)"ADMG0011E", (Object)instanceNotFoundException);
        }
        catch (ReflectionException reflectionException) {
            FFDCFilter.processException((Throwable)reflectionException, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.getAttributesMetaInfo", (String)"194", (Object)this);
            Tr.error((TraceComponent)tc, (String)"ADMG0011E", (Object)reflectionException);
        }
        catch (MBeanException mBeanException) {
            FFDCFilter.processException((Throwable)mBeanException, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.getAttributesMetaInfo", (String)"197", (Object)this);
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof ConfigServiceException) {
                throw (ConfigServiceException)((Object)exception);
            }
            throw new ConfigServiceException(exception);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.getAttributesMetaInfo", (String)"205", (Object)this);
            throw new ConfigServiceException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getAttributesMetaInfo", attributeList);
        }
        return attributeList;
    }

    public AttributeList getRelationshipsMetaInfo(String string) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getRelationshipsMetaInfo", (Object)string);
        }
        AttributeList attributeList = null;
        try {
            attributeList = (AttributeList)this.client.invoke(this.configServiceMBean, "getRelationshipsMetaInfo", new Object[]{string}, new String[]{"java.lang.String"});
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            FFDCFilter.processException((Throwable)instanceNotFoundException, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.getRelationshipsMetaInfo", (String)"219", (Object)this);
            Tr.error((TraceComponent)tc, (String)"ADMG0011E", (Object)instanceNotFoundException);
        }
        catch (ReflectionException reflectionException) {
            FFDCFilter.processException((Throwable)reflectionException, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.getRelationshipsMetaInfo", (String)"222", (Object)this);
            Tr.error((TraceComponent)tc, (String)"ADMG0011E", (Object)reflectionException);
        }
        catch (MBeanException mBeanException) {
            FFDCFilter.processException((Throwable)mBeanException, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.getRelationshipsMetaInfo", (String)"225", (Object)this);
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof ConfigServiceException) {
                throw (ConfigServiceException)((Object)exception);
            }
            throw new ConfigServiceException(exception);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.getRelationshipsMetaInfo", (String)"233", (Object)this);
            throw new ConfigServiceException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getRelationshipsMetaInfo", attributeList);
        }
        return attributeList;
    }

    public ObjectName[] queryConfigObjects(Session session, ObjectName objectName, ObjectName objectName2, QueryExp queryExp) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"queryConfigObjects", (Object)new Object[]{session, objectName, objectName2, queryExp});
        }
        ObjectName[] objectNameArray = null;
        try {
            objectNameArray = (ObjectName[])this.client.invoke(this.configServiceMBean, "queryConfigObjects", new Object[]{session, objectName, objectName2, queryExp}, new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName", "javax.management.ObjectName", "javax.management.QueryExp"});
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            FFDCFilter.processException((Throwable)instanceNotFoundException, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.queryConfigObjects", (String)"253", (Object)this);
            Tr.error((TraceComponent)tc, (String)"ADMG0011E", (Object)instanceNotFoundException);
        }
        catch (ReflectionException reflectionException) {
            FFDCFilter.processException((Throwable)reflectionException, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.queryConfigObjects", (String)"256", (Object)this);
            Tr.error((TraceComponent)tc, (String)"ADMG0011E", (Object)reflectionException);
        }
        catch (MBeanException mBeanException) {
            FFDCFilter.processException((Throwable)mBeanException, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.queryConfigObjects", (String)"259", (Object)this);
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof ConfigServiceException) {
                throw (ConfigServiceException)((Object)exception);
            }
            throw new ConfigServiceException(exception);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.queryConfigObjects", (String)"267", (Object)this);
            throw new ConfigServiceException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"queryConfigObjects", objectNameArray);
        }
        return objectNameArray;
    }

    public ObjectName[] queryTemplates(Session session, String string) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"queryTemplates", (Object)new Object[]{session, string});
        }
        ObjectName[] objectNameArray = null;
        try {
            objectNameArray = (ObjectName[])this.client.invoke(this.configServiceMBean, "queryTemplates", new Object[]{session, string}, new String[]{"com.ibm.websphere.management.Session", "java.lang.String"});
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            FFDCFilter.processException((Throwable)instanceNotFoundException, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.queryConfigObjects", (String)"342", (Object)this);
            Tr.error((TraceComponent)tc, (String)"ADMG0011E", (Object)instanceNotFoundException);
        }
        catch (ReflectionException reflectionException) {
            FFDCFilter.processException((Throwable)reflectionException, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.queryConfigObjects", (String)"345", (Object)this);
            Tr.error((TraceComponent)tc, (String)"ADMG0011E", (Object)reflectionException);
        }
        catch (MBeanException mBeanException) {
            FFDCFilter.processException((Throwable)mBeanException, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.queryConfigObjects", (String)"348", (Object)this);
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof ConfigServiceException) {
                throw (ConfigServiceException)((Object)exception);
            }
            throw new ConfigServiceException(exception);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.queryConfigObjects", (String)"267", (Object)this);
            throw new ConfigServiceException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"queryTemplates", objectNameArray);
        }
        return objectNameArray;
    }

    public ObjectName[] resolve(Session session, String string) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"resolve", (Object)new Object[]{session, string});
        }
        ObjectName[] objectNameArray = null;
        try {
            objectNameArray = (ObjectName[])this.client.invoke(this.configServiceMBean, "resolve", new Object[]{session, string}, new String[]{"com.ibm.websphere.management.Session", "java.lang.String"});
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            FFDCFilter.processException((Throwable)instanceNotFoundException, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.resolve", (String)"283", (Object)this);
            Tr.error((TraceComponent)tc, (String)"ADMG0011E", (Object)instanceNotFoundException);
        }
        catch (ReflectionException reflectionException) {
            FFDCFilter.processException((Throwable)reflectionException, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.resolve", (String)"286", (Object)this);
            Tr.error((TraceComponent)tc, (String)"ADMG0011E", (Object)reflectionException);
        }
        catch (MBeanException mBeanException) {
            FFDCFilter.processException((Throwable)mBeanException, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.resolve", (String)"289", (Object)this);
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof ConfigServiceException) {
                throw (ConfigServiceException)((Object)exception);
            }
            throw new ConfigServiceException(exception);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.resolve", (String)"297", (Object)this);
            throw new ConfigServiceException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"resolve", objectNameArray);
        }
        return objectNameArray;
    }

    public ObjectName[] resolve(Session session, ObjectName objectName, String string) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"resolve", (Object)new Object[]{session, string});
        }
        ObjectName[] objectNameArray = null;
        try {
            objectNameArray = (ObjectName[])this.client.invoke(this.configServiceMBean, "resolve", new Object[]{session, objectName, string}, new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName", "java.lang.String"});
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            FFDCFilter.processException((Throwable)instanceNotFoundException, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.resolve", (String)"283", (Object)this);
            Tr.error((TraceComponent)tc, (String)"ADMG0011E", (Object)instanceNotFoundException);
        }
        catch (ReflectionException reflectionException) {
            FFDCFilter.processException((Throwable)reflectionException, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.resolve", (String)"286", (Object)this);
            Tr.error((TraceComponent)tc, (String)"ADMG0011E", (Object)reflectionException);
        }
        catch (MBeanException mBeanException) {
            FFDCFilter.processException((Throwable)mBeanException, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.resolve", (String)"289", (Object)this);
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof ConfigServiceException) {
                throw (ConfigServiceException)((Object)exception);
            }
            throw new ConfigServiceException(exception);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.resolve", (String)"297", (Object)this);
            throw new ConfigServiceException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"resolve", objectNameArray);
        }
        return objectNameArray;
    }

    public ObjectName createConfigDataByTemplate(Session session, ObjectName objectName, String string, AttributeList attributeList, ObjectName objectName2) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createConfigDataByTemplate", (Object)new Object[]{session, objectName, string, attributeList, objectName2});
        }
        ObjectName objectName3 = null;
        try {
            objectName3 = (ObjectName)this.client.invoke(this.configServiceMBean, "createConfigDataByTemplate", new Object[]{session, objectName, string, attributeList, objectName2}, new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName", "java.lang.String", "javax.management.AttributeList", "javax.management.ObjectName"});
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            FFDCFilter.processException((Throwable)instanceNotFoundException, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.createConfigDataByTemplate", (String)"318", (Object)this);
            Tr.error((TraceComponent)tc, (String)"ADMG0011E", (Object)instanceNotFoundException);
        }
        catch (ReflectionException reflectionException) {
            FFDCFilter.processException((Throwable)reflectionException, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.createConfigDataByTemplate", (String)"321", (Object)this);
            Tr.error((TraceComponent)tc, (String)"ADMG0011E", (Object)reflectionException);
        }
        catch (MBeanException mBeanException) {
            FFDCFilter.processException((Throwable)mBeanException, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.createConfigDataByTemplate", (String)"324", (Object)this);
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof ConfigServiceException) {
                throw (ConfigServiceException)((Object)exception);
            }
            throw new ConfigServiceException(exception);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.createConfigDataByTemplate", (String)"332", (Object)this);
            throw new ConfigServiceException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createConfigDataByTemplate", objectName3);
        }
        return objectName3;
    }

    public ObjectName createConfigData(Session session, ObjectName objectName, String string, String string2, AttributeList attributeList) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createConfigData", (Object)new Object[]{session, objectName, string, string2, attributeList});
        }
        ObjectName objectName2 = null;
        try {
            objectName2 = (ObjectName)this.client.invoke(this.configServiceMBean, "createConfigData", new Object[]{session, objectName, string, string2, attributeList}, new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName", "java.lang.String", "java.lang.String", "javax.management.AttributeList"});
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            FFDCFilter.processException((Throwable)instanceNotFoundException, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.createConfigData", (String)"354", (Object)this);
            Tr.error((TraceComponent)tc, (String)"ADMG0011E", (Object)instanceNotFoundException);
        }
        catch (ReflectionException reflectionException) {
            FFDCFilter.processException((Throwable)reflectionException, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.createConfigData", (String)"357", (Object)this);
            Tr.error((TraceComponent)tc, (String)"ADMG0011E", (Object)reflectionException);
        }
        catch (MBeanException mBeanException) {
            FFDCFilter.processException((Throwable)mBeanException, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.createConfigData", (String)"360", (Object)this);
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof ConfigServiceException) {
                throw (ConfigServiceException)((Object)exception);
            }
            throw new ConfigServiceException(exception);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.createConfigData", (String)"368", (Object)this);
            throw new ConfigServiceException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createConfigData", objectName2);
        }
        return objectName2;
    }

    public void setAttributes(Session session, ObjectName objectName, AttributeList attributeList) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setAttributes", (Object)new Object[]{session, objectName, attributeList});
        }
        try {
            this.client.invoke(this.configServiceMBean, "setAttributes", new Object[]{session, objectName, attributeList}, new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName", "javax.management.AttributeList"});
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            FFDCFilter.processException((Throwable)instanceNotFoundException, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.setAttributes", (String)"386", (Object)this);
            Tr.error((TraceComponent)tc, (String)"ADMG0011E", (Object)instanceNotFoundException);
        }
        catch (ReflectionException reflectionException) {
            FFDCFilter.processException((Throwable)reflectionException, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.setAttributes", (String)"389", (Object)this);
            Tr.error((TraceComponent)tc, (String)"ADMG0011E", (Object)reflectionException);
        }
        catch (MBeanException mBeanException) {
            FFDCFilter.processException((Throwable)mBeanException, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.setAttributes", (String)"392", (Object)this);
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof ConfigServiceException) {
                throw (ConfigServiceException)((Object)exception);
            }
            throw new ConfigServiceException(exception);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.setAttributes", (String)"400", (Object)this);
            throw new ConfigServiceException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setAttributes");
        }
    }

    public void addElement(Session session, ObjectName objectName, String string, Object object, int n) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addElement", (Object)new Object[]{session, objectName, string, object, new Integer(n)});
        }
        try {
            this.client.invoke(this.configServiceMBean, "addElement", new Object[]{session, objectName, string, object, new Integer(n)}, new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName", "java.lang.String", "java.lang.Object", "int"});
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            FFDCFilter.processException((Throwable)instanceNotFoundException, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.addElement", (String)"420", (Object)this);
            Tr.error((TraceComponent)tc, (String)"ADMG0011E", (Object)instanceNotFoundException);
        }
        catch (ReflectionException reflectionException) {
            FFDCFilter.processException((Throwable)reflectionException, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.addElement", (String)"423", (Object)this);
            Tr.error((TraceComponent)tc, (String)"ADMG0011E", (Object)reflectionException);
        }
        catch (MBeanException mBeanException) {
            FFDCFilter.processException((Throwable)mBeanException, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.addElement", (String)"426", (Object)this);
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof ConfigServiceException) {
                throw (ConfigServiceException)((Object)exception);
            }
            throw new ConfigServiceException(exception);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.addElement", (String)"434", (Object)this);
            throw new ConfigServiceException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addElement");
        }
    }

    public void removeElement(Session session, ObjectName objectName, String string, Object object) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeElement", (Object)new Object[]{session, objectName, string, object});
        }
        try {
            this.client.invoke(this.configServiceMBean, "removeElement", new Object[]{session, objectName, string, object}, new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName", "java.lang.String", "java.lang.Object"});
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            FFDCFilter.processException((Throwable)instanceNotFoundException, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.removeElement", (String)"452", (Object)this);
            Tr.error((TraceComponent)tc, (String)"ADMG0011E", (Object)instanceNotFoundException);
        }
        catch (ReflectionException reflectionException) {
            FFDCFilter.processException((Throwable)reflectionException, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.removeElement", (String)"455", (Object)this);
            Tr.error((TraceComponent)tc, (String)"ADMG0011E", (Object)reflectionException);
        }
        catch (MBeanException mBeanException) {
            FFDCFilter.processException((Throwable)mBeanException, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.removeElement", (String)"458", (Object)this);
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof ConfigServiceException) {
                throw (ConfigServiceException)((Object)exception);
            }
            throw new ConfigServiceException(exception);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.removeElement", (String)"466", (Object)this);
            throw new ConfigServiceException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeElement");
        }
    }

    public void unsetAttributes(Session session, ObjectName objectName, String[] stringArray) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"unsetAttributes", (Object)new Object[]{session, objectName, stringArray});
        }
        try {
            this.client.invoke(this.configServiceMBean, "unsetAttributes", new Object[]{session, objectName, stringArray}, new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName", "[Ljava.lang.String;"});
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            FFDCFilter.processException((Throwable)instanceNotFoundException, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.unsetAttributes", (String)"483", (Object)this);
            Tr.error((TraceComponent)tc, (String)"ADMG0011E", (Object)instanceNotFoundException);
        }
        catch (ReflectionException reflectionException) {
            FFDCFilter.processException((Throwable)reflectionException, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.unsetAttributes", (String)"486", (Object)this);
            Tr.error((TraceComponent)tc, (String)"ADMG0011E", (Object)reflectionException);
        }
        catch (MBeanException mBeanException) {
            FFDCFilter.processException((Throwable)mBeanException, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.unsetAttributes", (String)"489", (Object)this);
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof ConfigServiceException) {
                throw (ConfigServiceException)((Object)exception);
            }
            throw new ConfigServiceException(exception);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.unsetAttributes", (String)"497", (Object)this);
            throw new ConfigServiceException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"unsetAttributes");
        }
    }

    public void resetAttributes(Session session, ObjectName objectName, AttributeList attributeList) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"resetAttributes", (Object)new Object[]{session, objectName, attributeList});
        }
        try {
            this.client.invoke(this.configServiceMBean, "resetAttributes", new Object[]{session, objectName, attributeList}, new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName", "javax.management.AttributeList"});
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            FFDCFilter.processException((Throwable)instanceNotFoundException, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.resetAttributes", (String)"514", (Object)this);
            Tr.error((TraceComponent)tc, (String)"ADMG0011E", (Object)instanceNotFoundException);
        }
        catch (ReflectionException reflectionException) {
            FFDCFilter.processException((Throwable)reflectionException, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.resetAttributes", (String)"517", (Object)this);
            Tr.error((TraceComponent)tc, (String)"ADMG0011E", (Object)reflectionException);
        }
        catch (MBeanException mBeanException) {
            FFDCFilter.processException((Throwable)mBeanException, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.resetAttributes", (String)"520", (Object)this);
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof ConfigServiceException) {
                throw (ConfigServiceException)((Object)exception);
            }
            throw new ConfigServiceException(exception);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.resetAttributes", (String)"528", (Object)this);
            throw new ConfigServiceException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"resetAttributes");
        }
    }

    public AttributeList getAttributes(Session session, ObjectName objectName, String[] stringArray, boolean bl) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getAttributes", (Object)new Object[]{session, objectName, stringArray, new Boolean(bl)});
        }
        AttributeList attributeList = null;
        try {
            attributeList = (AttributeList)this.client.invoke(this.configServiceMBean, "getAttributes", new Object[]{session, objectName, stringArray, new Boolean(bl)}, new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName", "[Ljava.lang.String;", "boolean"});
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            FFDCFilter.processException((Throwable)instanceNotFoundException, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.getAttributes", (String)"547", (Object)this);
            Tr.error((TraceComponent)tc, (String)"ADMG0011E", (Object)instanceNotFoundException);
        }
        catch (ReflectionException reflectionException) {
            FFDCFilter.processException((Throwable)reflectionException, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.getAttributes", (String)"550", (Object)this);
            Tr.error((TraceComponent)tc, (String)"ADMG0011E", (Object)reflectionException);
        }
        catch (MBeanException mBeanException) {
            FFDCFilter.processException((Throwable)mBeanException, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.getAttributes", (String)"553", (Object)this);
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof ConfigServiceException) {
                throw (ConfigServiceException)((Object)exception);
            }
            throw new ConfigServiceException(exception);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.getAttributes", (String)"561", (Object)this);
            throw new ConfigServiceException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getAttributes", attributeList);
        }
        return attributeList;
    }

    public Object getAttribute(Session session, ObjectName objectName, String string) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getAttribute", (Object)new Object[]{session, objectName, string});
        }
        Object object = null;
        try {
            object = this.client.invoke(this.configServiceMBean, "getAttribute", new Object[]{session, objectName, string}, new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName", "java.lang.String"});
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            FFDCFilter.processException((Throwable)instanceNotFoundException, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.getAttribute", (String)"580", (Object)this);
            Tr.error((TraceComponent)tc, (String)"ADMG0011E", (Object)instanceNotFoundException);
        }
        catch (ReflectionException reflectionException) {
            FFDCFilter.processException((Throwable)reflectionException, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.getAttribute", (String)"583", (Object)this);
            Tr.error((TraceComponent)tc, (String)"ADMG0011E", (Object)reflectionException);
        }
        catch (MBeanException mBeanException) {
            FFDCFilter.processException((Throwable)mBeanException, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.getAttribute", (String)"586", (Object)this);
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof ConfigServiceException) {
                throw (ConfigServiceException)((Object)exception);
            }
            throw new ConfigServiceException(exception);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.getAttribute", (String)"594", (Object)this);
            throw new ConfigServiceException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getAttribute", object);
        }
        return object;
    }

    public Object getAttribute(Session session, ObjectName objectName, String string, boolean bl) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"Enter - ConfigureServiceProxy.getAttribute", (Object)new Object[]{session, objectName, string, new Boolean(bl)});
        }
        if (bl) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"Exit - ConfigureServiceProxy.getAttribute");
            }
            return this.getAttribute(session, objectName, string);
        }
        AttributeList attributeList = this.getAttributes(session, objectName, new String[]{string}, false);
        Object object = null;
        try {
            object = ConfigServiceHelper.getAttributeValue(attributeList, string);
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            FFDCFilter.processException((Throwable)attributeNotFoundException, (String)"com.ibm.websphere.management.configservice.ConfigServiceHelper.getConfigDataId", (String)"39");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"Exit - ConfigureServiceProxy.getAttribute");
        }
        return object;
    }

    public void deleteConfigData(Session session, ObjectName objectName) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"deleteConfigData", (Object)new Object[]{session, objectName});
        }
        try {
            this.client.invoke(this.configServiceMBean, "deleteConfigData", new Object[]{session, objectName}, new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName"});
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            FFDCFilter.processException((Throwable)instanceNotFoundException, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.deleteConfigData", (String)"611", (Object)this);
            Tr.error((TraceComponent)tc, (String)"ADMG0011E", (Object)instanceNotFoundException);
        }
        catch (ReflectionException reflectionException) {
            FFDCFilter.processException((Throwable)reflectionException, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.deleteConfigData", (String)"614", (Object)this);
            Tr.error((TraceComponent)tc, (String)"ADMG0011E", (Object)reflectionException);
        }
        catch (MBeanException mBeanException) {
            FFDCFilter.processException((Throwable)mBeanException, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.deleteConfigData", (String)"617", (Object)this);
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof ConfigServiceException) {
                throw (ConfigServiceException)((Object)exception);
            }
            throw new ConfigServiceException(exception);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.deleteConfigData", (String)"625", (Object)this);
            throw new ConfigServiceException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"deleteConfigData");
        }
    }

    public AttributeList getRelationships(Session session, ObjectName objectName, String[] stringArray) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getRelationships", (Object)new Object[]{session, objectName, stringArray});
        }
        AttributeList attributeList = null;
        try {
            attributeList = (AttributeList)this.client.invoke(this.configServiceMBean, "getRelationships", new Object[]{session, objectName, stringArray}, new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName", "[Ljava.lang.String;"});
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            FFDCFilter.processException((Throwable)instanceNotFoundException, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.getRelationships", (String)"642", (Object)this);
            Tr.error((TraceComponent)tc, (String)"ADMG0011E", (Object)instanceNotFoundException);
        }
        catch (ReflectionException reflectionException) {
            FFDCFilter.processException((Throwable)reflectionException, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.getRelationships", (String)"645", (Object)this);
            Tr.error((TraceComponent)tc, (String)"ADMG0011E", (Object)reflectionException);
        }
        catch (MBeanException mBeanException) {
            FFDCFilter.processException((Throwable)mBeanException, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.getRelationships", (String)"648", (Object)this);
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof ConfigServiceException) {
                throw (ConfigServiceException)((Object)exception);
            }
            throw new ConfigServiceException(exception);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.getRelationships", (String)"656", (Object)this);
            throw new ConfigServiceException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getRelationships", attributeList);
        }
        return attributeList;
    }

    public ObjectName[] getRelationship(Session session, ObjectName objectName, String string) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getRelationship", (Object)new Object[]{session, objectName, string});
        }
        ObjectName[] objectNameArray = null;
        try {
            objectNameArray = (ObjectName[])this.client.invoke(this.configServiceMBean, "getRelationship", new Object[]{session, objectName, string}, new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName", "java.lang.String"});
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            FFDCFilter.processException((Throwable)instanceNotFoundException, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.getRelationship", (String)"675", (Object)this);
            Tr.error((TraceComponent)tc, (String)"ADMG0011E", (Object)instanceNotFoundException);
        }
        catch (ReflectionException reflectionException) {
            FFDCFilter.processException((Throwable)reflectionException, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.getRelationship", (String)"678", (Object)this);
            Tr.error((TraceComponent)tc, (String)"ADMG0011E", (Object)reflectionException);
        }
        catch (MBeanException mBeanException) {
            FFDCFilter.processException((Throwable)mBeanException, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.getRelationship", (String)"681", (Object)this);
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof ConfigServiceException) {
                throw (ConfigServiceException)((Object)exception);
            }
            throw new ConfigServiceException(exception);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.websphere.management.configservice.ConfigServiceProxy.getRelationship", (String)"689", (Object)this);
            throw new ConfigServiceException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getRelationship", objectNameArray);
        }
        return objectNameArray;
    }
}

