/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.configservice;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.ws.ffdc.FFDCFilter;
import java.lang.reflect.Constructor;
import java.security.Permission;
import java.util.Properties;

public class ConfigServiceFactory {
    private static ConfigService configService = null;
    private static ConfigService serverProxy = null;
    private static boolean initialized = false;
    private static boolean local = false;
    private static TraceComponent tc = Tr.register((Class)ConfigServiceFactory.class, (String)"management", (String)"com.ibm.ws.management.resources.configservice");
    private static WebSphereRuntimePermission adminPermission = new WebSphereRuntimePermission("AdminPermission");

    public static ConfigService createConfigService(boolean bl, Properties properties) throws AdminException {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createConfigService");
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission((Permission)adminPermission);
        }
        if (initialized) {
            throw new AdminException("Config service is initialized already");
        }
        if (bl) {
            try {
                String string = "com.ibm.ws.management.configservice.ConfigServiceImpl";
                Class<?> clazz = Class.forName(string);
                Constructor<?> constructor = clazz.getConstructor(Properties.class);
                configService = (ConfigService)constructor.newInstance(properties);
                initialized = true;
                if (properties != null && "local".equals(properties.get("location")) || AdminServiceFactory.getAdminService() == null) {
                    local = true;
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.websphere.management.configservice.ConfigServiceFactory.initialize", (String)"44");
                throw new AdminException(exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createConfigService", (Object)configService);
        }
        return configService;
    }

    public static synchronized ConfigService getConfigService() {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getConfigService");
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission((Permission)adminPermission);
        }
        if (!initialized) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getConfigService - call createConfigService first");
            }
            return null;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("local mode: " + local));
        }
        if (local) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getConfigService", (Object)configService);
            }
            return configService;
        }
        if (serverProxy == null) {
            try {
                String string = "com.ibm.ws.management.configservice.ConfigServiceServerProxy";
                Class<?> clazz = Class.forName(string);
                Constructor<?> constructor = clazz.getConstructor(ConfigService.class);
                serverProxy = (ConfigService)constructor.newInstance(configService);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.websphere.management.configservice.ConfigServiceFactory.initialize", (String)"44");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getConfigService", (Object)serverProxy);
        }
        return serverProxy;
    }
}

