/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.application;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.application.AppManagement;
import com.ibm.websphere.management.application.AppManagementProxy;
import com.ibm.websphere.management.application.EditionInfo;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;

public class EditionHelper {
    private static TraceComponent tc = Tr.register((Class)EditionHelper.class, (String)"AppEditions", (String)"com.ibm.websphere.management.applications");
    public static final String ED = "-edition";
    public static final String EDITION_PROP_FILE = "ibm-edition-metadata.props";
    public static final String EDITION_PROP_DELIM = "-";
    public static final String BASE_EDITION = "BASE";
    public static final String DEFAULT_EDITION = "DEFAULT";
    public static final String ACTIVE_EDITION_PROP = "config.active";
    public static final String DEFAULT_EDITION_PROP = "config.default";
    public static final String STATE_EDITION_PROP = "config.state";
    public static final String Edition_INACTIVE = "INACTIVE";
    public static final String Edition_ACTIVE = "ACTIVE";
    public static final String Edition_VALIDATE = "VALIDATE";
    public static final String EDITION_PROP_HEADER = "File contains metadata for all editions of the application";

    public static String[] getAppAndEdition(String string) {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getAppAndEdition", (Object)string);
        }
        if ((n = string.indexOf(ED)) == -1) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getAppAndEdition", (Object)new Object[]{string, ""});
            }
            return new String[]{string, ""};
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + ED.length());
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getAppAndEdition", (Object)new Object[]{string2, string3});
        }
        return new String[]{string2, string3};
    }

    public static String[] getAppAndEdition(String string, Hashtable hashtable) {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getAppAndEdition", (Object)new Object[]{string, hashtable});
        }
        if ((n = string.indexOf(ED)) == -1) {
            String string2;
            String string3 = string2 = hashtable != null ? (String)hashtable.get("edition") : "";
            if (string2 == null) {
                string2 = "";
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getAppAndEdition", (Object)new String[]{string, string2});
            }
            return new String[]{string, string2};
        }
        String string4 = string.substring(0, n);
        String string5 = string.substring(n + ED.length());
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getAppAndEdition", (Object)new String[]{string4, string5});
        }
        return new String[]{string4, string5};
    }

    public static String getCompositeName(String string, String string2) {
        if (EditionHelper.isEmpty(string2)) {
            return string;
        }
        if (string2.equalsIgnoreCase(BASE_EDITION)) {
            return string;
        }
        if (string.indexOf(ED) != -1) {
            return string;
        }
        return string + ED + string2;
    }

    public static String getCompositeName(String string, Hashtable hashtable) {
        if (hashtable == null) {
            return string;
        }
        if (string.indexOf(ED) != -1) {
            return string;
        }
        return EditionHelper.getCompositeName(string, (String)hashtable.get("edition"));
    }

    public static String getAppEarName(String string, String string2) {
        String string3 = string;
        String string4 = string2;
        if (string.indexOf(ED) != -1) {
            String[] stringArray = EditionHelper.getAppAndEdition(string);
            string3 = stringArray[0];
            string4 = stringArray[1];
        }
        return string3 + (EditionHelper.isEmpty(string4) ? "" : ED + string4) + ".ear";
    }

    public static String getAppEarName(String string, Hashtable hashtable) {
        if (string.indexOf(ED) != -1) {
            return EditionHelper.getAppEarName(string, (String)null);
        }
        return EditionHelper.getAppEarName(string, (String)hashtable.get("edition"));
    }

    public static String getEditionDescPropName(String string) {
        String[] stringArray = EditionHelper.getAppAndEdition(string);
        if (EditionHelper.isEmpty(stringArray[1])) {
            stringArray[1] = BASE_EDITION;
        }
        return EditionHelper.getCompositeName("edition.desc", stringArray[1]);
    }

    public static String getActiveEditionPropName(String string) {
        String[] stringArray = EditionHelper.getAppAndEdition(string);
        if (EditionHelper.isEmpty(stringArray[1])) {
            stringArray[1] = BASE_EDITION;
        }
        return EditionHelper.getCompositeName(ACTIVE_EDITION_PROP, stringArray[1]);
    }

    public static String getDefaultEditionPropName(String string) {
        String[] stringArray = EditionHelper.getAppAndEdition(string);
        if (EditionHelper.isEmpty(stringArray[1])) {
            stringArray[1] = BASE_EDITION;
        }
        return EditionHelper.getCompositeName(DEFAULT_EDITION_PROP, stringArray[1]);
    }

    public static String getEditionPropSuffix(String string) {
        String[] stringArray = EditionHelper.getAppAndEdition(string);
        if (EditionHelper.isEmpty(stringArray[1])) {
            stringArray[1] = BASE_EDITION;
        }
        return EditionHelper.getCompositeName("", stringArray[1]);
    }

    private static boolean isEmpty(String string) {
        return string == null || string.equals("");
    }

    public static boolean isEditionSupportEnabled() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isEditionSupportEnabled");
        }
        boolean bl = false;
        boolean bl2 = EditionHelper.isXDInstalled();
        if (bl2) {
            bl = true;
        } else {
            String string = System.getProperty("edition.enable");
            if (string != null && string.equals("true")) {
                bl = true;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isEditionSupportEnabled", (Object)new Boolean(bl));
        }
        return bl;
    }

    public static boolean isXDInstalled() {
        boolean bl = false;
        Object var1_1 = null;
        boolean bl2 = false;
        Object var3_3 = null;
        try {
            Class<?> clazz = Class.forName("com.ibm.ws.xd.appeditionmgr.XDInstalledMarker");
            if (clazz != null) {
                bl = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public static boolean checkIfEditionValid(String string) {
        boolean bl = true;
        if (string == null || string.trim().length() == 0) {
            bl = true;
        } else if (string.indexOf("]]>") != -1) {
            bl = false;
        } else if (string.endsWith(" ") || string.startsWith(" ")) {
            bl = false;
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\\/,:;\"*?<>|=+&%'");
            if (stringTokenizer.hasMoreTokens() && !stringTokenizer.nextToken().equals(string)) {
                bl = false;
            }
        }
        return bl;
    }

    public static EditionInfo[] getApplicationEditions(String string) throws Exception {
        AppManagement appManagement = null;
        appManagement = AppManagementProxy.getLocalProxy();
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getApplicationEditions");
        }
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("appName = " + string));
        }
        EditionInfo[] editionInfoArray = EditionHelper.getApplicationEditions(string, appManagement);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getApplicationEditions");
        }
        return editionInfoArray;
    }

    public static EditionInfo[] getApplicationEditions(String string, AppManagement appManagement) throws Exception {
        int n;
        EditionInfo[] editionInfoArray = null;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getApplicationEditions(appName, appManagement)");
        }
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("appName = " + string));
        }
        Hashtable hashtable = new Hashtable();
        Vector<EditionInfo> vector = new Vector<EditionInfo>();
        Vector vector2 = appManagement.listApplications(hashtable, null);
        for (n = 0; n < vector2.size(); ++n) {
            String string2 = (String)vector2.get(n);
            String[] stringArray = EditionHelper.getAppAndEdition(string2);
            if (!stringArray[0].equalsIgnoreCase(string)) continue;
            EditionInfo editionInfo = appManagement.getEditionInfo(stringArray[0], stringArray[1], null, null)[0];
            vector.add(editionInfo);
        }
        editionInfoArray = new EditionInfo[vector.size()];
        for (n = 0; n < vector.size(); ++n) {
            editionInfoArray[n] = (EditionInfo)vector.get(n);
            if (!tc.isDebugEnabled()) continue;
            Tr.entry((TraceComponent)tc, (String)("editionInfo[" + n + "].getEdition=" + editionInfoArray[n].getEdition()));
            Tr.entry((TraceComponent)tc, (String)("editionInfo[" + n + "].getDescription=" + editionInfoArray[n].getDescription()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getApplicationEditions(appName, appManagement)");
        }
        return editionInfoArray;
    }

    public static String getActiveEditionOnServer(String string, List list) {
        String string2 = "";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getActiveEditionOnServer");
            Tr.debug((TraceComponent)tc, (String)("appName " + string + " List " + list));
        }
        try {
            String string3 = null;
            EditionInfo[] editionInfoArray = EditionHelper.getApplicationEditions(string);
            for (int i = 0; i < editionInfoArray.length; ++i) {
                String string4 = editionInfoArray[i].getEditionState();
                if (string4.equalsIgnoreCase(Edition_ACTIVE)) {
                    String string5 = EditionHelper.getCompositeName(editionInfoArray[i].getAppName(), editionInfoArray[i].getEdition());
                    for (int j = 0; j < list.size(); ++j) {
                        String string6 = (String)list.get(j);
                        if (!string6.endsWith(string5)) continue;
                        string3 = editionInfoArray[i].getEdition();
                        break;
                    }
                }
                if (string3 != null) break;
            }
            if (string3 != null) {
                string2 = string3;
            }
        }
        catch (Exception exception) {
            System.out.println("In getActiveEditionOnServer " + exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getActiveEditionOnServer -> active Edition " + string2));
        }
        return string2;
    }

    public static String getEditionStatePropName(String string) {
        String[] stringArray = EditionHelper.getAppAndEdition(string);
        if (EditionHelper.isEmpty(stringArray[1])) {
            stringArray[1] = BASE_EDITION;
        }
        return EditionHelper.getCompositeName(STATE_EDITION_PROP, stringArray[1]);
    }

    public static boolean isAppActive(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("isEditionActive " + string));
        }
        boolean bl = false;
        String[] stringArray = EditionHelper.getAppAndEdition(string);
        try {
            String string2 = EditionHelper.getEditionState(string);
            bl = string2.equalsIgnoreCase(Edition_ACTIVE) || string2.equalsIgnoreCase(Edition_VALIDATE);
        }
        catch (Exception exception) {
            bl = false;
        }
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("isEditionActive(" + string + ")=" + bl));
        }
        return bl;
    }

    public static String getEditionState(String string) throws Exception {
        String string2 = Edition_INACTIVE;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getEditionState");
        }
        String[] stringArray = EditionHelper.getAppAndEdition(string);
        AppManagement appManagement = null;
        appManagement = AppManagementProxy.getLocalProxy();
        EditionInfo editionInfo = appManagement.getEditionInfo(stringArray[0], stringArray[1], null, null)[0];
        string2 = editionInfo.getEditionState();
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getEditionState(" + string + ")=" + string2));
        }
        return string2;
    }
}

