/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management;

import com.ibm.ISecurityUtilityImpl.RealmSecurityName;
import com.ibm.ISecurityUtilityImpl.StringBytesConversion;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.management.exception.InvalidAdminClientTypeException;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.websphere.security.auth.callback.WSGUICallbackHandlerImpl;
import com.ibm.websphere.security.auth.callback.WSStdinCallbackHandlerImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminDataHolder;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.SecurityContext;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.security.util.InvalidPasswordDecodingException;
import com.ibm.ws.security.util.PasswordUtil;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

public abstract class AdminClientFactory {
    private static final String bundleName = "com.ibm.ws.management.resources.connector";
    private static TraceComponent tc = Tr.register((Class)AdminClientFactory.class, (String)"Admin", (String)"com.ibm.ws.management.resources.connector");
    private static final TraceNLS connectorNLS = TraceNLS.getTraceNLS((String)"com.ibm.ws.management.resources.connector");
    private static final String SOAP_PROXY_CLASS = "com.ibm.ws.management.connector.soap.SOAPConnectorClient";
    private static final String RMI_PROXY_CLASS = "com.ibm.ws.management.connector.rmi.RMIConnectorClient";
    private static final String ADMIN_CLIENT_IMPL_CLASS = "com.ibm.ws.management.AdminClientImpl";
    private static final String ADMIN_SERVICE_PROXY_CLASS = "com.ibm.ws.management.connector.AdminServiceProxy";
    private static WebSphereRuntimePermission adminPermission = new WebSphereRuntimePermission("AdminPermission");
    private static Hashtable cachedClients = new Hashtable();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static AdminClient createAdminClient(Properties var0) throws ConnectorException {
        if (AdminClientFactory.tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)AdminClientFactory.tc, (String)"createAdminClient");
        }
        var1_1 = null;
        if (SecurityContext.isServerProcess() && (var2_2 = System.getSecurityManager()) != null) {
            var2_2.checkPermission((Permission)AdminClientFactory.adminPermission);
        }
        if ((var2_2 = (String)var0.get("type")) == null) {
            if (AdminClientFactory.tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)AdminClientFactory.tc, (String)"createAdminClient");
            }
            throw new InvalidAdminClientTypeException();
        }
        var3_3 = null;
        if (AdminClientFactory.tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)AdminClientFactory.tc, (String)"Checking for cache Key");
        }
        var4_4 = AdminClientFactory.getCacheKey((String)var2_2, (Properties)var0);
        var5_5 = AdminClientFactory.cachedClients;
        synchronized (var5_5) {
            var1_1 = (AdminClient)AdminClientFactory.cachedClients.get(var4_4);
        }
        if (var1_1 != null) {
            if (AdminClientFactory.tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)AdminClientFactory.tc, (String)"Cached admin client found");
            }
            try {
                var5_5 = (String)var0.get("username");
                var6_9 = (String)var0.get("password");
                if (!SecurityContext.isServerProcess() && "RMI".equalsIgnoreCase((String)var2_2) && SecurityContext.getContextManager().getInvocationSubject() == null && var5_5 != null && var5_5.trim().length() > 0 && var6_9 != null && var6_9.trim().length() > 0) {
                    var7_12 = SubjectHelper.createBasicAuthSubject(null, (String)var5_5, (String)var6_9);
                    SecurityContext.getContextManager().setInvocationSubject(var7_12);
                }
                var1_1.isAlive();
                if (AdminClientFactory.tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)AdminClientFactory.tc, (String)"createAdminClient - in cache");
                }
                return var1_1;
            }
            catch (Exception var5_6) {
                if (AdminClientFactory.tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)AdminClientFactory.tc, (String)"invalid cached client, try to recreate", (Object)var5_6);
                }
                var6_10 = AdminClientFactory.cachedClients;
                synchronized (var6_10) {
                    AdminClientFactory.cachedClients.remove(var4_4);
                }
                var1_1 = null;
            }
        }
        if (AdminClientFactory.tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)AdminClientFactory.tc, (String)"Cached admin client found");
        }
        if (var2_2.equalsIgnoreCase("SOAP")) {
            var6_10 = null;
            if (!new Boolean(var0.getProperty("isInternal")).booleanValue()) {
                var7_13 = var0.getProperty("com.ibm.SOAP.ConfigURL");
                if (var7_13 == null) {
                    var7_13 = System.getProperty("com.ibm.SOAP.ConfigURL");
                }
                if (var7_13 == null) {
                    var8_17 = System.getProperty("user.install.root");
                    if (var8_17 == null) {
                        var8_17 = System.getProperty("was.install.root");
                    }
                    var7_13 = "file:" + (String)var8_17 + "/properties/soap.client.props";
                }
                if (var7_13 != null) {
                    var8_17 = var7_13;
                    var6_10 = (Properties)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction((String)var8_17){
                        private final /* synthetic */ String val$url;
                        {
                            this.val$url = string;
                        }

                        public Object run() {
                            Properties properties = AdminClientFactory.loadPropertiesFromFile(this.val$url);
                            return properties;
                        }
                    });
                }
            }
            if ((var7_13 = var0.getProperty("securityEnabled")) == null && var6_10 != null) {
                var7_13 = var6_10.getProperty("securityEnabled");
            }
            if (var6_10 != null) {
                var6_10.putAll((Map<?, ?>)var0);
                var0 = var6_10;
            }
            var8_17 = (Properties)var0.clone();
            var5_7 = new Boolean((String)var7_13);
            if (var5_7) {
                var8_17.remove("securityEnabled");
            } else {
                var8_17.setProperty("securityEnabled", "true");
            }
            try {
                var9_19 = Class.forName("com.ibm.ws.management.connector.soap.SOAPConnectorClient");
                var10_23 = Class.forName("com.ibm.ws.management.AdminClientImpl");
                var11_25 = new Class[]{Properties.class};
                var12_27 = var9_19.getConstructor(var11_25);
                try {
                    if (AdminClientFactory.tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)AdminClientFactory.tc, (String)"Before 1st attempt to new up com.ibm.ws.management.connector.soap.SOAPConnectorClient");
                    }
                    AdminClientFactory.showDebugInfo((Properties)var0);
                    var13_30 = (InvocationHandler)var12_27.newInstance(new Object[]{var0});
                }
                catch (Exception var14_31) {
                    if (AdminClientFactory.tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)AdminClientFactory.tc, (String)"Try to new up the com.ibm.ws.management.connector.soap.SOAPConnectorClient instance again using alternative Properties after the 1st attempt failed with", (Object)var14_31);
                    }
                    var3_3 = var14_31;
                    AdminClientFactory.showDebugInfo((Properties)var8_17);
                    var13_30 = (InvocationHandler)var12_27.newInstance(new Object[]{var8_17});
                    v0 = var5_7 = var5_7 == false;
                }
                if (!SecurityContext.isServerProcess() && var5_7) {
                    var14_32 = (String)var0.get("username");
                    var15_33 = (String)var0.get("password");
                    var16_34 = (String)var0.get("loginsource");
                    if (AdminClientFactory.tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)AdminClientFactory.tc, (String)("User: " + (String)var14_32));
                    }
                    if (var14_32 != null && var14_32.length() > 0 && var15_33 != null && var15_33.length() > 0) {
                        var17_35 = SubjectHelper.createBasicAuthSubject(null, (String)var14_32, (String)var15_33);
                        AdminDataHolder.setData("wsSubject", var17_35);
                        if (AdminClientFactory.tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)AdminClientFactory.tc, (String)("Saving the Subject for Soap connector. ValueNull:" + (var17_35 == null)));
                        }
                    } else if (var16_34 != null && (var16_34.equals("stdin") || var16_34.equals("prompt"))) {
                        block77: {
                            if (AdminClientFactory.tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)AdminClientFactory.tc, (String)"About to login using JAAS");
                            }
                            var17_36 = null;
                            var18_37 = null;
                            try {
                                var17_36 = AdminClientFactory.jaas_login(var16_34);
                                if (var17_36 == null) break block77;
                                AdminDataHolder.setData("wsSubject", var17_36);
                                var18_37 = SubjectHelper.getWSCredentialFromSubject((Subject)var17_36);
                                var14_32 = var18_37.getSecurityName();
                                if (var14_32.startsWith(ContextManagerFactory.getInstance().getDefaultRealm())) {
                                    var14_32 = RealmSecurityName.getSecurityName((String)var14_32);
                                    if (AdminClientFactory.tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)AdminClientFactory.tc, (String)("New username: " + (String)var14_32));
                                    }
                                }
                                var15_33 = StringBytesConversion.getConvertedString((byte[])var18_37.getCredentialToken());
                                var0.put("username", var14_32);
                                var0.put("password", var15_33);
                                var8_17.put("username", var14_32);
                                var8_17.put("password", var15_33);
                                var19_38 = var9_19.getDeclaredMethod("setUserAndPwd", new Class[]{String.class, String.class});
                                var19_38.invoke((Object)var13_30, new Object[]{var14_32, var15_33});
                            }
                            catch (WSLoginFailedException var19_40) {
                                if (AdminClientFactory.tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)AdminClientFactory.tc, (String)"WSLoginFailedException occurred: ", (Object)new Object[]{var19_40});
                                }
                                FFDCFilter.processException((Throwable)var19_40, (String)"com.ibm.websphere.management.AdminClientFactory.createAdminClient", (String)"330");
                            }
                            catch (Exception var19_41) {
                                if (AdminClientFactory.tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)AdminClientFactory.tc, (String)"Exception occurred during JAAS login: ", (Object)new Object[]{var19_41});
                                }
                                FFDCFilter.processException((Throwable)var19_41, (String)"com.ibm.websphere.management.AdminClientFactory.createAdminClient", (String)"336");
                            }
                        }
                        if (AdminClientFactory.tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)AdminClientFactory.tc, (String)("Saving the wscredential for Soap connector. ValueNull:" + (var18_37 == null)));
                        }
                    }
                }
                var11_25[0] = InvocationHandler.class;
                var14_32 = var10_23.getConstructor(var11_25);
                var1_1 = (AdminClient)var14_32.newInstance(new Object[]{var13_30});
                if (!AdminClientFactory.tc.isDebugEnabled()) ** GOTO lbl205
                Tr.debug((TraceComponent)AdminClientFactory.tc, (String)"SOAPConnectorClient is created");
            }
            catch (Exception var9_20) {
                FFDCFilter.processException((Throwable)var9_20, (String)"com.ibm.websphere.management.AdminClientFactory.createAdminClient", (String)"215");
                if (AdminClientFactory.tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)AdminClientFactory.tc, (String)"createAdminClient - failed", (Object)var9_20);
                }
                if (var3_3 != null) {
                    var9_21 = var3_3;
                }
                if (var5_7) {
                    throw new ConnectorException(AdminClientFactory.connectorNLS.getFormattedMessage("ADMC0053E", new Object[]{var0.getProperty("host"), var0.getProperty("port")}, "Could not create SOAP Connector to connect to host {0} at port {1} with SOAP Connector security enabled"), var9_21);
                }
                throw new ConnectorException(AdminClientFactory.connectorNLS.getFormattedMessage("ADMC0016E", new Object[]{var0.getProperty("host"), var0.getProperty("port")}, "Could not create SOAP Connector to connect to host {0} at port {1}"), var9_21);
            }
        } else if (var2_2.equalsIgnoreCase("RMI")) {
            var5_7 = new Boolean(var0.getProperty("securityEnabled"));
            var6_10 = (Properties)var0.clone();
            if (var5_7) {
                var6_10.remove("securityEnabled");
            } else {
                var6_10.setProperty("securityEnabled", "true");
            }
            try {
                var7_13 = Class.forName("com.ibm.ws.management.connector.rmi.RMIConnectorClient");
                var8_18 = Class.forName("com.ibm.ws.management.AdminClientImpl");
                var9_22 = new Class[]{Properties.class};
                var10_24 = var7_13.getConstructor(var9_22);
                try {
                    AdminClientFactory.showDebugInfo((Properties)var0);
                    var11_26 = var10_24.newInstance(new Object[]{var0});
                }
                catch (Exception var12_28) {
                    if (AdminClientFactory.tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)AdminClientFactory.tc, (String)"try alternative connector properties after receiving the following exception", (Object)var12_28);
                    }
                    var3_3 = var12_28;
                    AdminClientFactory.showDebugInfo((Properties)var6_10);
                    var11_26 = var10_24.newInstance(new Object[]{var6_10});
                    var5_7 = var5_7 == false;
                }
                var9_22[0] = Class.forName("com.ibm.ws.management.connector.AdminServiceProxy");
                var12_29 = var8_18.getConstructor(var9_22);
                var1_1 = (AdminClient)var12_29.newInstance(new Object[]{var11_26});
                if (!AdminClientFactory.tc.isDebugEnabled()) ** GOTO lbl205
                Tr.debug((TraceComponent)AdminClientFactory.tc, (String)"RMIConnectorClient is created");
            }
            catch (Exception var7_14) {
                FFDCFilter.processException((Throwable)var7_14, (String)"com.ibm.websphere.management.AdminClientFactory.createAdminClient", (String)"267");
                if (AdminClientFactory.tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)AdminClientFactory.tc, (String)"createAdminClient - failed", (Object)var7_14);
                }
                if (var3_3 != null) {
                    var7_15 = var3_3;
                }
                throw new ConnectorException(AdminClientFactory.connectorNLS.getFormattedMessage("ADMC0017E", new Object[]{var0.getProperty("host"), var0.getProperty("port")}, "Could not create RMI Connector to connect to host {0} at port {1}"), var7_15);
            }
        } else {
            if (AdminClientFactory.tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)AdminClientFactory.tc, (String)"createAdminClient");
            }
            throw new InvalidAdminClientTypeException();
        }
lbl205:
        // 4 sources

        if (AdminClientFactory.tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)AdminClientFactory.tc, (String)"Getting Cache Disabled property");
        }
        var6_11 = new Boolean(var0.getProperty("cacheDisabled"));
        if (var1_1 != null) {
            if (var6_11) {
                if (AdminClientFactory.tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)AdminClientFactory.tc, (String)"Caching disabled for this admin client");
                }
            } else {
                var4_4.setProperty("securityEnabled", var5_7 != false ? "true" : "false");
                AdminClientFactory.showDebugInfo(var4_4);
                var7_13 = AdminClientFactory.cachedClients;
                synchronized (var7_13) {
                    AdminClientFactory.cachedClients.put(var4_4, var1_1);
                }
            }
        }
        if (AdminClientFactory.tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)AdminClientFactory.tc, (String)"createAdminClient");
        }
        return var1_1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private static Properties loadPropertiesFromFile(String var0) {
        block39: {
            if (AdminClientFactory.tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)AdminClientFactory.tc, (String)"loadPropertiesFromFile", (Object)var0);
            }
            var1_1 = null;
            var2_2 = new Properties();
            try {
                var3_3 = new URL(var0);
                var1_1 = var3_3.openStream();
                var2_2.load(var1_1);
                var5_5 = null;
                ** if (var1_1 == null) goto lbl-1000
            }
            catch (Throwable var4_9) {
                var5_6 = null;
                if (var1_1 != null) {
                    try {
                        var1_1.close();
                    }
                    catch (IOException var6_8) {
                        FFDCFilter.processException((Throwable)var6_8, (String)"com.ibm.websphere.management.AdminClientFactory.loadPropertiesFromFile", (String)"322");
                    }
                }
                throw var4_9;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    var1_1.close();
                }
                catch (IOException var6_7) {
                    FFDCFilter.processException((Throwable)var6_7, (String)"com.ibm.websphere.management.AdminClientFactory.loadPropertiesFromFile", (String)"322");
                }
            }
lbl-1000:
            // 2 sources

            {
                break block39;
                catch (IOException var3_4) {
                    FFDCFilter.processException((Throwable)var3_4, (String)"com.ibm.websphere.management.AdminClientFactory.loadPropertiesFromFile", (String)"313");
                    Tr.warning((TraceComponent)AdminClientFactory.tc, (String)"ADMC0046W", (Object)new Object[]{var0});
                    var5_5 = null;
                    if (var1_1 != null) {
                        try {
                            var1_1.close();
                        }
                        catch (IOException var6_7) {
                            FFDCFilter.processException((Throwable)var6_7, (String)"com.ibm.websphere.management.AdminClientFactory.loadPropertiesFromFile", (String)"322");
                        }
                    }
                }
            }
        }
        if (!var2_2.isEmpty()) {
            block42: {
                block41: {
                    block40: {
                        var3_3 = (String)var2_2.remove("com.ibm.SOAP.loginUserid");
                        var4_10 = (String)var2_2.remove("com.ibm.SOAP.loginPassword");
                        var5_5 = (String)var2_2.remove("com.ibm.SOAP.loginSource");
                        var6_7 = (String)var2_2.remove("com.ibm.SOAP.securityEnabled");
                        var7_11 = (String)var2_2.remove("com.ibm.ssl.keyStore");
                        var8_12 = null;
                        var9_13 = (String)var2_2.remove("com.ibm.ssl.keyStorePassword");
                        var10_14 = (String)var2_2.remove("com.ibm.ssl.trustStore");
                        var11_15 = null;
                        var12_16 = (String)var2_2.remove("com.ibm.ssl.trustStorePassword");
                        var13_17 = (String)var2_2.remove("ssl.SocketFactory.provider");
                        var14_18 = (String)var2_2.remove("com.ibm.ssl.contextProvider");
                        if (AdminHelper.getPlatformHelper().isZOS()) {
                            var8_12 = (String)var2_2.remove("com.ibm.ssl.keyStoreType");
                            var11_15 = (String)var2_2.remove("com.ibm.ssl.trustStoreType");
                        }
                        var15_19 = null;
                        var16_20 = null;
                        var17_21 = null;
                        try {
                            if (var4_10 != null) {
                                var15_19 = PasswordUtil.decode((String)var4_10);
                            }
                        }
                        catch (InvalidPasswordDecodingException var18_22) {
                            FFDCFilter.processException((Throwable)var18_22, (String)"com.ibm.websphere.management.AdminClientFactory.loadPropertisFromFile", (String)"300");
                            var15_19 = var4_10;
                        }
                        catch (Exception var18_23) {
                            FFDCFilter.processException((Throwable)var18_23, (String)"com.ibm.websphere.management.AdminClientFactory.loadPropertisFromFile", (String)"305");
                            if (!AdminClientFactory.tc.isDebugEnabled()) break block40;
                            Tr.debug((TraceComponent)AdminClientFactory.tc, (String)"decoding user password", (Object)var18_23);
                        }
                    }
                    try {
                        if (var9_13 != null) {
                            var16_20 = PasswordUtil.decode((String)var9_13);
                        }
                    }
                    catch (InvalidPasswordDecodingException var18_25) {
                        FFDCFilter.processException((Throwable)var18_25, (String)"com.ibm.websphere.management.AdminClientFactory.loadPropertisFromFile", (String)"315");
                        var16_20 = var9_13;
                    }
                    catch (Exception var18_26) {
                        if (!AdminClientFactory.tc.isDebugEnabled()) break block41;
                        Tr.debug((TraceComponent)AdminClientFactory.tc, (String)"decoding ketStore password", (Object)var18_26);
                    }
                }
                try {
                    if (var12_16 != null) {
                        var17_21 = PasswordUtil.decode((String)var12_16);
                    }
                }
                catch (InvalidPasswordDecodingException var18_27) {
                    FFDCFilter.processException((Throwable)var18_27, (String)"com.ibm.websphere.management.AdminClientFactory.loadPropertisFromFile", (String)"328");
                    var17_21 = var12_16;
                }
                catch (Exception var18_28) {
                    if (!AdminClientFactory.tc.isDebugEnabled()) break block42;
                    Tr.debug((TraceComponent)AdminClientFactory.tc, (String)"decoding trustStore password", (Object)var18_28);
                }
            }
            if (var5_5 != null && var5_5.length() > 0) {
                var2_2.setProperty("loginsource", var5_5);
            }
            if (var3_3 != null) {
                var2_2.setProperty("username", (String)var3_3);
            }
            if (var15_19 != null) {
                var2_2.setProperty("password", var15_19);
            }
            if (var6_7 != null) {
                var2_2.setProperty("securityEnabled", (String)var6_7);
            }
            if (var10_14 != null) {
                var2_2.setProperty("javax.net.ssl.trustStore", var10_14);
            }
            if (var11_15 != null) {
                var2_2.setProperty("javax.net.ssl.trustStoreType", var11_15);
            }
            if (var7_11 != null) {
                var2_2.setProperty("javax.net.ssl.keyStore", var7_11);
            }
            if (var8_12 != null) {
                var2_2.setProperty("javax.net.ssl.keyStoreType", var8_12);
            }
            if (var17_21 != null) {
                var2_2.setProperty("javax.net.ssl.trustStorePassword", var17_21);
            }
            if (var16_20 != null) {
                var2_2.setProperty("javax.net.ssl.keyStorePassword", var16_20);
            }
            if (var13_17 != null) {
                var2_2.setProperty("ssl.SocketFactory.provider", var13_17);
            }
            if (var14_18 != null) {
                var2_2.setProperty("com.ibm.ssl.contextProvider", var14_18);
            }
        }
        if (AdminClientFactory.tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)AdminClientFactory.tc, (String)"loadPropertisFromFile");
        }
        return var2_2;
    }

    private static void showDebugInfo(Properties properties) {
        if (tc.isDebugEnabled()) {
            Set<Map.Entry<Object, Object>> set = properties.entrySet();
            Iterator<Map.Entry<Object, Object>> iterator = set.iterator();
            while (iterator.hasNext()) {
                Map.Entry<Object, Object> entry = iterator.next();
                String string = (String)entry.getKey();
                Object object = entry.getValue();
                if (string.equals("password") || string.endsWith("Password")) {
                    Tr.debug((TraceComponent)tc, (String)"[key, value]", (Object)new Object[]{string, "********"});
                    continue;
                }
                Tr.debug((TraceComponent)tc, (String)"[key, value]", (Object)new Object[]{string, object});
            }
        }
    }

    private static Properties getCacheKey(String string, Properties properties) throws ConnectorException {
        Properties properties2 = new Properties();
        String string2 = properties.getProperty("host");
        String string3 = properties.getProperty("port");
        String string4 = properties.getProperty("loginsource");
        String string5 = properties.getProperty("securityEnabled");
        String string6 = properties.getProperty("username");
        if (string6 != null && string6.startsWith(ContextManagerFactory.getInstance().getDefaultRealm())) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"In getCacheKey, stripping realm from username.");
            }
            string6 = RealmSecurityName.getSecurityName((String)string6);
            properties.setProperty("username", string6);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("In getCacheKey, new username: " + string6));
            }
        }
        String string7 = properties.getProperty("password");
        if (string2 == null) {
            throw new ConnectorException(connectorNLS.getString("ADMC0041E"));
        }
        String string8 = string2;
        try {
            string2 = InetAddress.getByName(string2).getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            FFDCFilter.processException((Throwable)unknownHostException, (String)"com.ibm.websphere.management.AdminClientFactory.getCacheKey", (String)"432");
            string2 = string8;
        }
        if (string3 == null) {
            throw new ConnectorException(connectorNLS.getString("ADMC0042E"));
        }
        string3 = string3.trim();
        properties2.setProperty("type", string.toUpperCase());
        properties2.setProperty("host", string2);
        properties2.setProperty("port", string3);
        if (string5 != null) {
            properties2.setProperty("securityEnabled", string5);
        } else {
            properties2.setProperty("securityEnabled", "false");
        }
        if (string6 != null && string7 != null) {
            properties2.setProperty("username", string6);
            properties2.setProperty("password", string7);
        }
        if (string4 != null) {
            properties2.setProperty("loginsource", string4);
        }
        return properties2;
    }

    protected static Subject jaas_login(String string) throws WSLoginFailedException {
        LoginContext loginContext;
        Subject subject;
        block14: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"jaas_login(loginSource)");
            }
            subject = null;
            loginContext = null;
            try {
                if (string != null && string.equalsIgnoreCase("prompt")) {
                    try {
                        loginContext = new LoginContext("WSAdminClientLogin", (CallbackHandler)new WSGUICallbackHandlerImpl());
                        break block14;
                    }
                    catch (WSLoginFailedException wSLoginFailedException) {
                        throw wSLoginFailedException;
                    }
                    catch (Throwable throwable) {
                        loginContext = new LoginContext("WSAdminClientLogin", (CallbackHandler)new WSStdinCallbackHandlerImpl());
                        break block14;
                    }
                }
                loginContext = new LoginContext("WSAdminClientLogin", (CallbackHandler)new WSStdinCallbackHandlerImpl());
            }
            catch (LoginException loginException) {
                FFDCFilter.processException((Throwable)loginException, (String)"com.ibm.websphere.management.AdminClientFactory.jaas_login", (String)"152");
                if (loginException instanceof WSLoginFailedException) {
                    throw (WSLoginFailedException)((Object)loginException);
                }
                throw new WSLoginFailedException(loginException.getMessage(), (Throwable)loginException);
            }
            catch (SecurityException securityException) {
                FFDCFilter.processException((Throwable)securityException, (String)"com.ibm.websphere.management.AdminClientFactory.jaas_login", (String)"162");
                throw new WSLoginFailedException(securityException.getMessage(), (Throwable)securityException);
            }
        }
        try {
            loginContext.login();
        }
        catch (LoginException loginException) {
            FFDCFilter.processException((Throwable)loginException, (String)"com.ibm.websphere.management.AdminClientFactory.jaas_login", (String)"173");
            if (loginException instanceof WSLoginFailedException) {
                throw (WSLoginFailedException)((Object)loginException);
            }
            throw new WSLoginFailedException(loginException.getMessage(), (Throwable)loginException);
        }
        subject = loginContext.getSubject();
        if (subject == null) {
            Tr.debug((TraceComponent)tc, (String)"Subject is null.", (Object)new Object[]{string});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"jaas_login(loginSource)");
        }
        return subject;
    }
}

