/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DirectColorModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import sun.awt.X11GraphicsConfig;
import sun.awt.X11SurfaceData;
import sun.awt.image.BufImgSurfaceData;
import sun.awt.image.DataBufferNative;
import sun.awt.image.WritableRasterNative;
import sun.awt.motif.MComponentPeer;
import sun.awt.motif.X11OffScreenImage;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;
import sun.java2d.loops.CompositeType;
import sun.java2d.pipe.DrawImage;

public class X11RemoteOffScreenImage
extends X11OffScreenImage {
    int bufImageTypeSw = this.getType();
    SurfaceData bisd;

    private static native void initIDs();

    public X11RemoteOffScreenImage(Component component, ColorModel colorModel, WritableRaster writableRaster, boolean bl) {
        super(component, colorModel, writableRaster, bl, false);
        if (!accelerationEnabled) {
            return;
        }
        X11GraphicsConfig x11GraphicsConfig = X11SurfaceData.getGC(component == null ? null : (MComponentPeer)component.getPeer());
        this.initAcceleratedBackground(x11GraphicsConfig, this.getWidth(), this.getHeight());
        if (this.surfaceDataHw != null) {
            this.setCurrentSurfaceData(this.surfaceDataHw);
            this.surfaceDataSw = this.surfaceDataHw;
            this.initContents();
            this.createNativeRaster();
        }
    }

    private native void setSurfaceDataNative(SurfaceData var1);

    private native void setRasterNative(WritableRaster var1);

    private void setCurrentSurfaceData(SurfaceData surfaceData) {
        if (surfaceData != this.surfaceData) {
            this.surfaceData = surfaceData;
            this.setSurfaceDataNative(surfaceData);
        }
    }

    public void initContents() {
        Graphics2D graphics2D = this.createGraphics();
        graphics2D.clearRect(0, 0, this.getWidth(), this.getHeight());
        graphics2D.dispose();
    }

    public SurfaceData getSourceSurfaceData(SurfaceData surfaceData, CompositeType compositeType, Color color) {
        if (accelerationEnabled && surfaceData != this.surfaceDataHw && this.destSurfaceAccelerated(surfaceData)) {
            this.validate(surfaceData.getDeviceConfiguration());
            if (this.surfaceDataHw != null) {
                return this.surfaceDataHw;
            }
        }
        return this.surfaceDataSw;
    }

    private void createNativeRaster() {
        Object object;
        ColorModel colorModel = this.getColorModel();
        SampleModel sampleModel = null;
        int n = 0;
        int n2 = this.getWidth();
        switch (colorModel.getPixelSize()) {
            case 8: {
                n = 0;
                object = new int[]{0};
                sampleModel = new PixelInterleavedSampleModel(n, this.getWidth(), this.getHeight(), 1, n2, (int[])object);
                break;
            }
            case 15: 
            case 16: {
                n = 1;
                int[] nArray = new int[3];
                DirectColorModel directColorModel = (DirectColorModel)colorModel;
                nArray[0] = directColorModel.getRedMask();
                nArray[1] = directColorModel.getGreenMask();
                nArray[2] = directColorModel.getBlueMask();
                sampleModel = new SinglePixelPackedSampleModel(n, this.getWidth(), this.getHeight(), n2, nArray);
                break;
            }
            case 24: 
            case 32: {
                n = 3;
                int[] nArray = new int[3];
                DirectColorModel directColorModel = (DirectColorModel)colorModel;
                nArray[0] = directColorModel.getRedMask();
                nArray[1] = directColorModel.getGreenMask();
                nArray[2] = directColorModel.getBlueMask();
                sampleModel = new SinglePixelPackedSampleModel(n, this.getWidth(), this.getHeight(), n2, nArray);
            }
        }
        object = new DataBufferNative(this.surfaceDataHw, n, this.getWidth(), this.getHeight());
        this.setRasterNative(WritableRasterNative.createNativeRaster(sampleModel, (DataBuffer)object));
    }

    public BufferedImage getSnapshot() {
        BufferedImage bufferedImage = new BufferedImage(this.getWidth(), this.getHeight(), this.bufImageTypeSw);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage((Image)this, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    protected void copyBackupToAccelerated() {
        if (this.surfaceDataSw != null && this.surfaceDataHw != null && this.surfaceDataSw != this.surfaceDataHw) {
            Object object;
            Font font = new Font("Dialog", 0, 12);
            if (this.bisd == null) {
                object = new BufferedImage(this.getWidth(), this.getHeight(), this.bufImageTypeSw);
                this.bisd = BufImgSurfaceData.createData((BufferedImage)object);
            }
            object = new SunGraphics2D(this.bisd, Color.black, Color.white, font);
            DrawImage.renderSurfaceData((SunGraphics2D)object, this.surfaceDataSw, null, 0, 0, 0, 0, this.getWidth(), this.getHeight());
            ((SunGraphics2D)object).dispose();
            SunGraphics2D sunGraphics2D = new SunGraphics2D(this.surfaceDataHw, Color.black, Color.white, font);
            DrawImage.renderSurfaceData(sunGraphics2D, this.bisd, null, 0, 0, 0, 0, this.getWidth(), this.getHeight());
            sunGraphics2D.dispose();
        }
    }

    static {
        X11RemoteOffScreenImage.initIDs();
    }
}

