/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.AWTEvent;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Window;
import java.awt.event.InputMethodEvent;
import java.awt.font.TextAttribute;
import java.awt.font.TextHitInfo;
import java.awt.im.InputMethodHighlight;
import java.awt.im.spi.InputMethodContext;
import java.lang.constant.Constable;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import sun.awt.im.InputMethodAdapter;
import sun.awt.motif.MComponentPeer;
import sun.awt.motif.MInputMethodControl;
import sun.awt.motif.MToolkit;
import sun.awt.motif.X11InputMethodDescriptor;

public class X11InputMethod
extends InputMethodAdapter {
    private static final int XIMReverse = 1;
    private static final int XIMUnderline = 2;
    private static final int XIMHighlight = 4;
    private static final int XIMPrimary = 32;
    private static final int XIMSecondary = 64;
    private static final int XIMTertiary = 128;
    private static final int XIMVisibleToForward = 256;
    private static final int XIMVisibleToBackward = 512;
    private static final int XIMVisibleCenter = 1024;
    private static final int XIMVisibleMask = 1792;
    private Locale locale;
    private static boolean isXIMOpened = false;
    private Container clientComponentWindow = null;
    private boolean createXICFailed = false;
    private Component awtFocussedComponent = null;
    private Component xicFocussedComponent = null;
    private boolean isActive = false;
    private boolean isActiveClient = false;
    private static Map[] highlightStyles;
    private boolean disposed = false;
    private boolean needResetXIC = false;
    private Component needResetXICClient = null;
    private boolean compositionEnableSupported = true;
    private boolean needCompositionEnable = false;
    private String committedText = null;
    private StringBuffer composedText = null;
    private IntBuffer rawFeedbacks;
    private transient long pData = 0L;
    private transient Object textDataLock = new Object();
    private static final int INITIAL_SIZE = 64;

    private static native void initIDs();

    public X11InputMethod() throws AWTException {
        this.locale = X11InputMethodDescriptor.getSupportedLocale();
        if (!this.initXIM()) {
            throw new AWTException("cannot open X Input Method");
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    private synchronized boolean initXIM() {
        if (!isXIMOpened) {
            isXIMOpened = this.openXIM();
        }
        return isXIMOpened;
    }

    public void setInputMethodContext(InputMethodContext inputMethodContext) {
    }

    public boolean setLocale(Locale locale) {
        if (locale.equals(this.locale)) {
            return true;
        }
        return this.locale.equals(Locale.JAPAN) && locale.equals(Locale.JAPANESE) || this.locale.equals(Locale.KOREA) && locale.equals(Locale.KOREAN);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setCharacterSubsets(Character.Subset[] subsetArray) {
    }

    public void dispatchEvent(AWTEvent aWTEvent) {
    }

    private final void resetXICifneeded() {
        if (this.needResetXIC) {
            if (this.getClientComponent() != this.needResetXICClient) {
                this.resetXIC();
            }
            this.needResetXICClient = null;
            this.needResetXIC = false;
        }
    }

    private final void enableCompositionifneeded() {
        if (this.needCompositionEnable && this.haveActiveClient()) {
            if (this.pData != 0L && this.compositionEnableSupported && this.needCompositionEnable) {
                try {
                    this.setCompositionEnabled(true);
                    this.setXICFocus(this.getPeer(this.awtFocussedComponent), true, this.haveActiveClient());
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    this.compositionEnableSupported = false;
                }
            }
            this.needCompositionEnable = false;
        }
    }

    public synchronized void activate() {
        MComponentPeer mComponentPeer;
        if (this.createXICFailed) {
            return;
        }
        this.resetXICifneeded();
        this.clientComponentWindow = this.getClientComponentWindow();
        if (this.clientComponentWindow == null) {
            return;
        }
        if (this.xicFocussedComponent != null) {
            if (this.xicFocussedComponent != this.awtFocussedComponent) {
                this.setXICFocus(this.getPeer(this.xicFocussedComponent), false, this.isActiveClient);
            }
            this.xicFocussedComponent = null;
        }
        if (this.pData == 0L) {
            mComponentPeer = this.getPeer(this.clientComponentWindow);
            if (mComponentPeer == null) {
                return;
            }
            MComponentPeer mComponentPeer2 = null;
            if (mComponentPeer instanceof MInputMethodControl) {
                mComponentPeer2 = ((MInputMethodControl)((Object)mComponentPeer)).getTextComponent();
            }
            if (!this.createXICNative(mComponentPeer, mComponentPeer2)) {
                this.createXICFailed = true;
                return;
            }
            this.disposed = false;
            if (mComponentPeer instanceof MInputMethodControl) {
                ((MInputMethodControl)((Object)mComponentPeer)).addInputMethod(this);
            }
        }
        this.setStatusAreaVisible(true, this.pData);
        if (this.awtFocussedComponent != null) {
            mComponentPeer = this.getPeer(this.awtFocussedComponent);
            if (mComponentPeer == null) {
                return;
            }
            this.setXICFocus(mComponentPeer, true, this.haveActiveClient());
            this.isActive = true;
            this.enableCompositionifneeded();
        }
    }

    public synchronized void deactivate(boolean bl) {
        boolean bl2 = this.haveActiveClient();
        if (bl) {
            this.xicFocussedComponent = this.awtFocussedComponent;
            this.isActiveClient = bl2;
            this.turnoffStatusWindow();
        } else {
            if (this.awtFocussedComponent != null) {
                this.setXICFocus(this.getPeer(this.awtFocussedComponent), false, bl2);
            }
            this.xicFocussedComponent = null;
        }
        this.isActive = false;
        this.setStatusAreaVisible(false, this.pData);
    }

    public void hideWindows() {
        if (this.pData != 0L) {
            this.setStatusAreaVisible(false, this.pData);
            this.turnoffStatusWindow();
        }
    }

    static Map mapInputMethodHighlight(InputMethodHighlight inputMethodHighlight) {
        int n;
        int n2 = inputMethodHighlight.getState();
        if (n2 == 0) {
            n = 0;
        } else if (n2 == 1) {
            n = 2;
        } else {
            return null;
        }
        if (inputMethodHighlight.isSelected()) {
            ++n;
        }
        return highlightStyles[n];
    }

    protected void setAWTFocussedComponent(Component component) {
        if (component == null) {
            return;
        }
        if (this.isActive) {
            boolean bl = this.haveActiveClient();
            this.setXICFocus(this.getPeer(this.awtFocussedComponent), false, bl);
            this.setXICFocus(this.getPeer(component), true, bl);
        }
        this.awtFocussedComponent = component;
    }

    protected void stopListening() {
        this.endComposition();
        if (this.needResetXIC) {
            this.resetXIC();
            this.needResetXICClient = null;
            this.needResetXIC = false;
        }
    }

    private Window getClientComponentWindow() {
        Component component = this.getClientComponent();
        Container container = component instanceof Container ? (Container)component : MComponentPeer.getParent_NoClientCode(component);
        while (container != null && !(container instanceof Window)) {
            container = MComponentPeer.getParent_NoClientCode(container);
        }
        return (Window)container;
    }

    private MComponentPeer getPeer(Component component) {
        MComponentPeer mComponentPeer = (MComponentPeer)MToolkit.targetToPeer(component);
        if (mComponentPeer != null) {
            return mComponentPeer;
        }
        Container container = MToolkit.getNativeContainer(component);
        mComponentPeer = (MComponentPeer)MToolkit.targetToPeer(container);
        return mComponentPeer;
    }

    void configureStatus() {
        if (this.disposed) {
            return;
        }
        MComponentPeer mComponentPeer = this.getPeer((Window)this.clientComponentWindow);
        MComponentPeer mComponentPeer2 = ((MInputMethodControl)((Object)mComponentPeer)).getTextComponent();
        if (mComponentPeer2 != null) {
            this.configureStatusAreaNative(mComponentPeer2);
        }
    }

    private void postInputMethodEvent(int n, AttributedCharacterIterator attributedCharacterIterator, int n2, TextHitInfo textHitInfo, TextHitInfo textHitInfo2, long l) {
        Component component = this.getClientComponent();
        if (component != null) {
            InputMethodEvent inputMethodEvent = new InputMethodEvent(component, n, l, attributedCharacterIterator, n2, textHitInfo, textHitInfo2);
            MToolkit.postEvent(MToolkit.targetToAppContext(component), inputMethodEvent);
        }
    }

    private void postInputMethodEvent(int n, AttributedCharacterIterator attributedCharacterIterator, int n2, TextHitInfo textHitInfo, TextHitInfo textHitInfo2) {
        this.postInputMethodEvent(n, attributedCharacterIterator, n2, textHitInfo, textHitInfo2, EventQueue.getMostRecentEventTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispatchCommittedText(String string, long l) {
        if (string == null) {
            return;
        }
        Object object = this.textDataLock;
        synchronized (object) {
            if (this.composedText == null) {
                AttributedString attributedString = new AttributedString(string);
                this.postInputMethodEvent(1100, attributedString.getIterator(), string.length(), null, null, l);
            } else {
                this.committedText = string;
            }
        }
    }

    private void dispatchCommittedText(String string) {
        this.dispatchCommittedText(string, EventQueue.getMostRecentEventTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispatchComposedText(String string, int[] nArray, int n, int n2, int n3, long l) {
        Object object;
        if (this.disposed) {
            return;
        }
        if (string == null && nArray == null && n == 0 && n2 == 0 && n3 == 0 && this.composedText == null && this.committedText == null) {
            return;
        }
        if (string != null) {
            object = new StringBuffer();
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (Character.isISOControl(c)) {
                    c = '\u25a1';
                }
                ((StringBuffer)object).append(c);
            }
            string = new String((StringBuffer)object);
        }
        object = this.textDataLock;
        synchronized (object) {
            int n4;
            int n5;
            AttributedString attributedString;
            int n6;
            if (this.composedText == null) {
                this.composedText = new StringBuffer(64);
                this.rawFeedbacks = new IntBuffer(64);
            }
            if (n2 > 0) {
                if (string == null && nArray != null) {
                    this.rawFeedbacks.replace(n, nArray);
                } else if (n2 == this.composedText.length() && n == 0) {
                    this.composedText = new StringBuffer(64);
                    this.rawFeedbacks = new IntBuffer(64);
                } else if (this.composedText.length() > 0) {
                    if (n + n2 < this.composedText.length()) {
                        String string2 = this.composedText.toString().substring(n + n2, this.composedText.length());
                        this.composedText.setLength(n);
                        this.composedText.append(string2);
                    } else {
                        this.composedText.setLength(n);
                    }
                    this.rawFeedbacks.remove(n, n2);
                }
            }
            if (string != null) {
                this.composedText.insert(n, string);
                if (nArray != null) {
                    this.rawFeedbacks.insert(n, nArray);
                }
            } else if (nArray != null) {
                this.rawFeedbacks.replace(n, nArray);
            }
            if (this.composedText.length() == 0) {
                this.composedText = null;
                this.rawFeedbacks = null;
                if (this.committedText != null) {
                    this.dispatchCommittedText(this.committedText, l);
                    this.committedText = null;
                    return;
                }
                this.postInputMethodEvent(1100, null, 0, null, null, l);
                return;
            }
            if (this.committedText != null) {
                n6 = this.committedText.length();
                attributedString = new AttributedString(this.committedText + this.composedText);
                this.committedText = null;
            } else {
                n6 = 0;
                attributedString = new AttributedString(this.composedText.toString());
            }
            int n7 = 0;
            int n8 = 0;
            TextHitInfo textHitInfo = null;
            this.rawFeedbacks.rewind();
            int n9 = this.rawFeedbacks.getNext();
            this.rawFeedbacks.unget();
            while ((n5 = this.rawFeedbacks.getNext()) != -1) {
                if (n8 == 0 && (n8 = n5 & 0x700) != 0) {
                    int n10 = this.rawFeedbacks.getOffset() - 1;
                    textHitInfo = n8 == 512 ? TextHitInfo.leading(n10) : TextHitInfo.trailing(n10);
                }
                if (n9 == (n5 &= 0xFFFFF8FF)) continue;
                this.rawFeedbacks.unget();
                n4 = this.rawFeedbacks.getOffset();
                attributedString.addAttribute(TextAttribute.INPUT_METHOD_HIGHLIGHT, this.convertVisualFeedbackToHighlight(n9), n6 + n7, n6 + n4);
                n7 = n4;
                n9 = n5;
            }
            n4 = this.rawFeedbacks.getOffset();
            if (n4 >= 0) {
                attributedString.addAttribute(TextAttribute.INPUT_METHOD_HIGHLIGHT, this.convertVisualFeedbackToHighlight(n9), n6 + n7, n6 + n4);
            }
            this.postInputMethodEvent(1100, attributedString.getIterator(), n6, TextHitInfo.leading(n3), textHitInfo, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destroyComposedText() {
        if (this.pData == 0L) {
            return;
        }
        if (this.composedText == null) {
            return;
        }
        X11InputMethod x11InputMethod = this;
        synchronized (x11InputMethod) {
            this.composedText = null;
            this.rawFeedbacks = null;
            if (this.committedText != null) {
                this.dispatchCommittedText(this.committedText);
                this.committedText = null;
                return;
            }
            this.postInputMethodEvent(1100, null, 0, null, null);
            return;
        }
    }

    protected synchronized void disposeImpl() {
        if (this.clientComponentWindow != null) {
            MComponentPeer mComponentPeer = this.getPeer(this.clientComponentWindow);
            if (mComponentPeer instanceof MInputMethodControl) {
                ((MInputMethodControl)((Object)mComponentPeer)).removeInputMethod(this);
            }
            this.clientComponentWindow = null;
        }
        this.disposeXIC();
        this.composedText = null;
        this.committedText = null;
        this.rawFeedbacks = null;
        this.awtFocussedComponent = null;
        this.xicFocussedComponent = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dispose() {
        boolean bl = false;
        if (!this.disposed) {
            X11InputMethod x11InputMethod = this;
            synchronized (x11InputMethod) {
                if (!this.disposed) {
                    bl = true;
                    this.disposed = true;
                }
            }
        }
        if (bl) {
            this.disposeImpl();
        }
    }

    public Object getControlObject() {
        return null;
    }

    public synchronized void removeNotify() {
        if (MToolkit.targetToPeer(this.getClientComponent()) != null || !this.haveActiveClient()) {
            this.resetXIC();
            this.dispose();
        } else {
            this.resetXIC();
        }
    }

    public void setCompositionEnabled(boolean bl) {
        boolean bl2 = true;
        boolean bl3 = true;
        try {
            bl3 = this.isCompositionEnabled();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.setCompositionEnabledNative(bl);
        try {
            bl2 = this.isCompositionEnabled();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        if (bl3 != bl2 && bl2 == bl) {
            if (!bl) {
                this.destroyComposedText();
            }
            if (null != this.awtFocussedComponent && this.isActive) {
                this.setXICFocus(this.getPeer(this.awtFocussedComponent), true, this.haveActiveClient());
            }
        }
    }

    public boolean isCompositionEnabled() {
        return this.isCompositionEnabledNative();
    }

    public void endComposition() {
        if (this.disposed) {
            return;
        }
        boolean bl = false;
        if (this.compositionEnableSupported) {
            try {
                bl = this.isCompositionEnabled();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                this.compositionEnableSupported = false;
            }
        }
        if (this.haveActiveClient() && this.composedText == null && this.committedText == null) {
            this.needResetXIC = true;
            this.needResetXICClient = this.getClientComponent();
            this.needCompositionEnable = bl;
            return;
        }
        String string = this.resetXIC();
        this.needResetXIC = false;
        this.composedText = null;
        this.postInputMethodEvent(1100, null, 0, null, null);
        if (string != null && string.length() > 0) {
            this.dispatchCommittedText(string);
        }
        if (this.haveActiveClient() && this.compositionEnableSupported && bl) {
            try {
                this.setCompositionEnabled(true);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                this.compositionEnableSupported = false;
            }
        }
    }

    synchronized void reconfigureXIC(MInputMethodControl mInputMethodControl) {
        if (!this.disposed) {
            this.endComposition();
            this.resetXICifneeded();
            this.reconfigureXICNative((MComponentPeer)((Object)mInputMethodControl), mInputMethodControl.getTextComponent());
        }
    }

    private InputMethodHighlight convertVisualFeedbackToHighlight(int n) {
        InputMethodHighlight inputMethodHighlight;
        switch (n) {
            case 2: {
                inputMethodHighlight = InputMethodHighlight.UNSELECTED_CONVERTED_TEXT_HIGHLIGHT;
                break;
            }
            case 1: {
                inputMethodHighlight = InputMethodHighlight.SELECTED_CONVERTED_TEXT_HIGHLIGHT;
                break;
            }
            case 4: {
                inputMethodHighlight = InputMethodHighlight.SELECTED_RAW_TEXT_HIGHLIGHT;
                break;
            }
            case 0: 
            case 32: {
                inputMethodHighlight = InputMethodHighlight.UNSELECTED_CONVERTED_TEXT_HIGHLIGHT;
                break;
            }
            case 64: {
                inputMethodHighlight = InputMethodHighlight.SELECTED_CONVERTED_TEXT_HIGHLIGHT;
                break;
            }
            case 128: {
                inputMethodHighlight = InputMethodHighlight.SELECTED_RAW_TEXT_HIGHLIGHT;
                break;
            }
            default: {
                inputMethodHighlight = InputMethodHighlight.SELECTED_RAW_TEXT_HIGHLIGHT;
            }
        }
        return inputMethodHighlight;
    }

    private native boolean openXIM();

    private native boolean createXICNative(MComponentPeer var1, MComponentPeer var2);

    private native void reconfigureXICNative(MComponentPeer var1, MComponentPeer var2);

    private native void setXICFocus(MComponentPeer var1, boolean var2, boolean var3);

    private native String resetXIC();

    private native void disposeXIC();

    private native void closeXIM();

    private native void configureStatusAreaNative(MComponentPeer var1);

    private native void setCompositionEnabledNative(boolean var1);

    private native boolean isCompositionEnabledNative();

    private native void setStatusAreaVisible(boolean var1, long var2);

    private native void turnoffStatusWindow();

    static {
        Map[] mapArray = new Map[4];
        HashMap<TextAttribute, Constable> hashMap = new HashMap<TextAttribute, Constable>(1);
        hashMap.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        mapArray[0] = Collections.unmodifiableMap(hashMap);
        hashMap = new HashMap(1);
        hashMap.put(TextAttribute.SWAP_COLORS, TextAttribute.SWAP_COLORS_ON);
        mapArray[1] = Collections.unmodifiableMap(hashMap);
        hashMap = new HashMap(1);
        hashMap.put(TextAttribute.INPUT_METHOD_UNDERLINE, TextAttribute.UNDERLINE_LOW_ONE_PIXEL);
        mapArray[2] = Collections.unmodifiableMap(hashMap);
        hashMap = new HashMap(1);
        hashMap.put(TextAttribute.SWAP_COLORS, TextAttribute.SWAP_COLORS_ON);
        mapArray[3] = Collections.unmodifiableMap(hashMap);
        highlightStyles = mapArray;
        X11InputMethod.initIDs();
    }

    private final class IntBuffer {
        private int[] intArray;
        private int size;
        private int index;

        IntBuffer(int n) {
            this.intArray = new int[n];
            this.size = 0;
            this.index = 0;
        }

        void insert(int n, int[] nArray) {
            int n2 = this.size + nArray.length;
            if (this.intArray.length < n2) {
                int[] nArray2 = new int[n2 * 2];
                System.arraycopy(this.intArray, 0, nArray2, 0, this.size);
                this.intArray = nArray2;
            }
            System.arraycopy(this.intArray, n, this.intArray, n + nArray.length, this.size - n);
            System.arraycopy(nArray, 0, this.intArray, n, nArray.length);
            this.size += nArray.length;
            if (this.index > n) {
                this.index = n;
            }
        }

        void remove(int n, int n2) {
            if (n + n2 > this.size) {
                n2 = this.size - n;
            }
            if (n2 < 0) {
                n2 = 0;
            }
            if (n + n2 != this.size) {
                System.arraycopy(this.intArray, n + n2, this.intArray, n, this.size - n - n2);
            }
            this.size -= n2;
            if (this.index > n) {
                this.index = n;
            }
        }

        void replace(int n, int[] nArray) {
            System.arraycopy(nArray, 0, this.intArray, n, nArray.length);
        }

        void removeAll() {
            this.size = 0;
            this.index = 0;
        }

        void rewind() {
            this.index = 0;
        }

        int getNext() {
            if (this.index == this.size) {
                return -1;
            }
            return this.intArray[this.index++];
        }

        void unget() {
            if (this.index != 0) {
                --this.index;
            }
        }

        int getOffset() {
            return this.index;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < this.size) {
                stringBuffer.append(this.intArray[n++]);
                if (n >= this.size) continue;
                stringBuffer.append(",");
            }
            return stringBuffer.toString();
        }
    }
}

