/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.AWTEvent;
import java.awt.AWTException;
import java.awt.BufferCapabilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.ScrollPane;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.dnd.DropTarget;
import java.awt.dnd.peer.DropTargetPeer;
import java.awt.event.InputEvent;
import java.awt.event.PaintEvent;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.VolatileImage;
import java.awt.image.WritableRaster;
import java.awt.peer.ComponentPeer;
import java.awt.peer.ContainerPeer;
import java.awt.peer.LightweightPeer;
import sun.awt.DebugHelper;
import sun.awt.Graphics2Delegate;
import sun.awt.RepaintArea;
import sun.awt.X11GraphicsConfig;
import sun.awt.X11GraphicsDevice;
import sun.awt.X11SurfaceData;
import sun.awt.image.OffScreenImage;
import sun.awt.motif.MGlobalCursorManager;
import sun.awt.motif.MInputMethodControl;
import sun.awt.motif.MScrollPanePeer;
import sun.awt.motif.MToolkit;
import sun.awt.motif.MWindowAttributes;
import sun.awt.motif.MWindowPeer;
import sun.awt.motif.X11FontMetrics;
import sun.awt.motif.X11Image;
import sun.awt.motif.X11RemoteOffScreenImage;
import sun.awt.motif.X11VolatileImage;
import sun.java2d.SunGraphics2D;

public abstract class MComponentPeer
implements ComponentPeer,
DropTargetPeer {
    private static final DebugHelper dbg = DebugHelper.create(MComponentPeer.class);
    Component target;
    long pData;
    long jniGlobalRef;
    protected X11GraphicsConfig graphicsConfig;
    public boolean IBMshownOnDisplay = true;
    X11SurfaceData surfaceData;
    int oldWidth = -1;
    int oldHeight = -1;
    private RepaintArea paintArea;
    boolean isLayouting = false;
    boolean paintPending = false;
    private boolean disposed = false;
    private static int JAWT_LOCK_ERROR = 1;
    private static int JAWT_LOCK_CLIP_CHANGED = 2;
    private static int JAWT_LOCK_BOUNDS_CHANGED = 4;
    private static int JAWT_LOCK_SURFACE_CHANGED = 8;
    private int drawState = JAWT_LOCK_CLIP_CHANGED | JAWT_LOCK_BOUNDS_CHANGED | JAWT_LOCK_SURFACE_CHANGED;
    static final int MOTIF_NA = 0;
    static final int MOTIF_V1 = 1;
    static final int MOTIF_V2 = 2;
    private Font font;
    private long backBuffer = 0L;
    private X11VolatileImage xBackBuffer = null;
    private static boolean pmoffscreen = false;
    static final Font defaultFont;
    public int serialNum = 0;

    private static native void initIDs();

    public boolean isObscured() {
        MWindowPeer mWindowPeer;
        Container container;
        Container container2;
        Container container3 = container2 = this.target instanceof Container ? (Container)this.target : this.target.getParent();
        if (container2 == null) {
            return true;
        }
        while ((container = container2.getParent()) != null) {
            container2 = container;
        }
        if (container2 instanceof Window && (mWindowPeer = (MWindowPeer)container2.getPeer()) != null) {
            return mWindowPeer.winAttr.visibilityState != MWindowAttributes.AWT_UNOBSCURED;
        }
        return true;
    }

    public boolean canDetermineObscurity() {
        return true;
    }

    abstract void create(MComponentPeer var1);

    void create(MComponentPeer mComponentPeer, Object object) {
        this.create(mComponentPeer);
    }

    void EFcreate(MComponentPeer mComponentPeer, int n) {
    }

    native void pInitialize();

    native void pShow();

    native void pHide();

    native void pEnable();

    native void pDisable();

    native void pReshape(int var1, int var2, int var3, int var4);

    native void pDispose();

    native void pMakeCursorVisible();

    native Point pGetLocationOnScreen();

    native void pSetForeground(Color var1);

    native void pSetBackground(Color var1);

    private native void pSetFont(Font var1);

    native int getNativeColor(Color var1, GraphicsConfiguration var2);

    static native Container getParent_NoClientCode(Component var0);

    static native Component[] getComponents_NoClientCode(Container var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initialize() {
        Font font;
        if (!this.target.isVisible()) {
            this.hide();
        }
        Object object = this.target.getTreeLock();
        synchronized (object) {
            this.pInitialize();
        }
        Color color = this.target.getForeground();
        if (color != null) {
            this.setForeground(color);
        }
        if ((color = this.target.getBackground()) != null) {
            this.setBackground(color);
        }
        if ((font = this.target.getFont()) != null) {
            this.setFont(font);
        }
        this.pSetCursor(this.target.getCursor());
        if (!this.target.isEnabled()) {
            this.disable();
        }
        object = this.target.getBounds();
        this.reshape(((Rectangle)object).x, ((Rectangle)object).y, ((Rectangle)object).width, ((Rectangle)object).height);
        if (this.target.isVisible()) {
            this.show();
        }
        this.surfaceData = X11SurfaceData.createData(this);
    }

    public void init(Component component, Object object) {
        this.target = component;
        this.paintArea = new RepaintArea();
        Container container = MToolkit.getNativeContainer(component);
        MComponentPeer mComponentPeer = (MComponentPeer)MToolkit.targetToPeer(container);
        this.create(mComponentPeer, object);
        this.initialize();
    }

    MComponentPeer(Component component, Object object) {
        this.init(component, object);
    }

    MComponentPeer() {
    }

    public void init(Component component) {
        this.target = component;
        this.paintArea = new RepaintArea();
        Container container = MToolkit.getNativeContainer(component);
        MComponentPeer mComponentPeer = (MComponentPeer)MToolkit.targetToPeer(container);
        this.create(mComponentPeer);
        if (container != null && container instanceof ScrollPane) {
            MScrollPanePeer mScrollPanePeer = (MScrollPanePeer)mComponentPeer;
            mScrollPanePeer.setScrollChild(this);
        }
        this.initialize();
    }

    MComponentPeer(Component component) {
        this.init(component);
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    public void setForeground(Color color) {
        this.pSetForeground(color);
    }

    public void setBackground(Color color) {
        this.pSetBackground(color);
    }

    public void updateCursorImmediately() {
        MGlobalCursorManager.getCursorManager().updateCursorImmediately();
    }

    public void setFont(Font font) {
        if (font == null) {
            font = defaultFont;
        }
        this.pSetFont(font);
        if (this.target instanceof Container) {
            Container container = (Container)this.target;
            int n = container.getComponentCount();
            Component[] componentArray = container.getComponents();
            for (int i = 0; i < n; ++i) {
                ComponentPeer componentPeer;
                if (componentArray[i] == null || (componentPeer = componentArray[i].getPeer()) == null) continue;
                Font font2 = componentArray[i].getFont();
                if (!font.equals(font2)) {
                    componentPeer.setFont(font2);
                    continue;
                }
                if (!(componentArray[i] instanceof Container)) continue;
                componentPeer.setFont(font);
            }
        }
        this.font = font;
    }

    public native void setTargetBackground(Color var1);

    public native void pSetCursor(Cursor var1);

    public native void pSetScrollbarBackground(Color var1);

    public native void pSetInnerForeground(Color var1);

    public boolean isFocusable() {
        return false;
    }

    public X11SurfaceData getSurfaceData() {
        return this.surfaceData;
    }

    public ColorModel getColorModel() {
        return this.graphicsConfig.getColorModel();
    }

    public ColorModel getColorModel(int n) {
        return this.graphicsConfig.getColorModel(n);
    }

    public int updatePriority() {
        return 5;
    }

    public void repaint(long l, int n, int n2, int n3, int n4) {
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.target.getSize();
        if (graphics instanceof Graphics2D || graphics instanceof Graphics2Delegate) {
            graphics.clearRect(0, 0, dimension.width, dimension.height);
        } else {
            graphics.setColor(this.target.getBackground());
            graphics.fillRect(0, 0, dimension.width, dimension.height);
            graphics.setColor(this.target.getForeground());
        }
    }

    public void print(Graphics graphics) {
        Dimension dimension = this.target.getSize();
        if (graphics instanceof Graphics2D || graphics instanceof Graphics2Delegate) {
            graphics.clearRect(0, 0, dimension.width, dimension.height);
        } else {
            graphics.setColor(this.target.getBackground());
            graphics.fillRect(0, 0, dimension.width, dimension.height);
            graphics.setColor(this.target.getForeground());
        }
        this.target.print(graphics);
    }

    public void coalescePaintEvent(PaintEvent paintEvent) {
        Rectangle rectangle = paintEvent.getUpdateRect();
        this.paintArea.add(rectangle, paintEvent.getID());
    }

    native void nativeHandleEvent(AWTEvent var1);

    protected boolean shouldFocusOnClick() {
        return this.isFocusable();
    }

    static boolean canBeFocusedByClick(Component component) {
        if (component == null) {
            return false;
        }
        return component.isDisplayable() && component.isVisible() && component.isEnabled() && component.isFocusable();
    }

    public void handleEvent(AWTEvent aWTEvent) {
        int n = aWTEvent.getID();
        switch (n) {
            case 800: {
                if (!this.IBMshownOnDisplay) {
                    return;
                }
                this.paintPending = false;
            }
            case 801: {
                if (!this.IBMshownOnDisplay) {
                    return;
                }
                if (!this.isLayouting && !this.paintPending) {
                    this.paintArea.paint(this.target, false);
                }
                return;
            }
            case 501: {
                if (this.target != aWTEvent.getSource() || ((InputEvent)aWTEvent).isConsumed() || !this.shouldFocusOnClick() || this.target.isFocusOwner() || !MComponentPeer.canBeFocusedByClick(this.target)) break;
                this.target.requestFocusInWindow();
                break;
            }
        }
        this.nativeHandleEvent(aWTEvent);
    }

    public Dimension getMinimumSize() {
        return this.target.getSize();
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public Rectangle getBounds() {
        return this.target.getBounds();
    }

    public Toolkit getToolkit() {
        return Toolkit.getDefaultToolkit();
    }

    public synchronized Graphics getGraphics() {
        if (!this.disposed) {
            Font font;
            Color color;
            Component component = this.target;
            Color color2 = component.getBackground();
            if (color2 == null) {
                color2 = SystemColor.window;
            }
            if ((color = component.getForeground()) == null) {
                color = SystemColor.windowText;
            }
            if ((font = component.getFont()) == null) {
                font = defaultFont;
            }
            return new SunGraphics2D(this.surfaceData, color, color2, font);
        }
        return null;
    }

    public Image createImage(ImageProducer imageProducer) {
        return new X11Image(imageProducer);
    }

    public Image createImage(int n, int n2) {
        ColorModel colorModel = this.getColorModel(1);
        WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(n, n2);
        if (X11SurfaceData.isAccelerationEnabled()) {
            return new X11RemoteOffScreenImage(this.target, colorModel, writableRaster, colorModel.isAlphaPremultiplied());
        }
        return new OffScreenImage(this.target, colorModel, writableRaster, colorModel.isAlphaPremultiplied());
    }

    public VolatileImage createVolatileImage(int n, int n2) {
        return new X11VolatileImage(this.target, n, n2);
    }

    public boolean prepareImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return MToolkit.prepareScrImage(image, n, n2, imageObserver);
    }

    public int checkImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return MToolkit.checkScrImage(image, n, n2, imageObserver);
    }

    public FontMetrics getFontMetrics(Font font) {
        return X11FontMetrics.getFontMetrics(font);
    }

    protected void disposeImpl() {
        X11SurfaceData x11SurfaceData = this.surfaceData;
        this.surfaceData = null;
        x11SurfaceData.invalidate();
        MToolkit.targetDisposedPeer(this.target, this);
        this.pDispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dispose() {
        boolean bl = false;
        if (!this.disposed) {
            MComponentPeer mComponentPeer = this;
            synchronized (mComponentPeer) {
                if (!this.disposed) {
                    bl = true;
                    this.disposed = true;
                }
            }
        }
        if (bl) {
            this.disposeImpl();
        }
    }

    static native boolean processSynchronousLightweightTransfer(Component var0, Component var1, boolean var2, boolean var3, long var4);

    public boolean requestFocus(Component component, boolean bl, boolean bl2, long l) {
        Window window;
        Container container;
        if (MComponentPeer.processSynchronousLightweightTransfer(this.target, component, bl, bl2, l)) {
            return true;
        }
        Container container2 = container = this.target instanceof Container ? (Container)this.target : this.target.getParent();
        while (container != null && !(container instanceof Window)) {
            container = MComponentPeer.getParent_NoClientCode(container);
        }
        if (container != null && !(window = (Window)container).isFocused() && MComponentPeer.getNativeFocusedWindow() == window) {
            return true;
        }
        return this._requestFocus(component, bl, bl2, l);
    }

    native boolean _requestFocus(Component var1, boolean var2, boolean var3, long var4);

    static native Window getNativeFocusedWindow();

    void postEvent(AWTEvent aWTEvent) {
        MToolkit.postEvent(MToolkit.targetToAppContext(this.target), aWTEvent);
    }

    void handleExpose(int n, int n2, int n3, int n4) {
        if (!this.target.getIgnoreRepaint()) {
            this.postEvent(new PaintEvent(this.target, 800, new Rectangle(n, n2, n3, n4)));
        }
    }

    void handleRepaint(int n, int n2, int n3, int n4) {
        this.IBMshownOnDisplay = true;
        if (!this.target.getIgnoreRepaint()) {
            this.postEvent(new PaintEvent(this.target, 801, new Rectangle(n, n2, n3, n4)));
        }
    }

    void handleNodraw(int n, int n2, int n3, int n4) {
        this.IBMshownOnDisplay = false;
    }

    public int getZOrderPosition_NoClientCode() {
        Container container = MComponentPeer.getParent_NoClientCode(this.target);
        if (container != null) {
            Component[] componentArray = MComponentPeer.getComponents_NoClientCode(container);
            int n = 0;
            for (int i = 0; i < componentArray.length; ++i) {
                if (componentArray[i] == this.target) {
                    return n;
                }
                Object object = MToolkit.targetToPeer(componentArray[i]);
                if (object == null || object instanceof LightweightPeer) continue;
                ++n;
            }
        }
        return -1;
    }

    void draw3DOval(Graphics graphics, Color color, int n, int n2, int n3, int n4, boolean bl) {
        Color color2 = graphics.getColor();
        Color color3 = color.darker();
        Color color4 = color.brighter();
        graphics.setColor(bl ? color4 : color3);
        graphics.drawArc(n, n2, n3, n4, 45, 180);
        graphics.setColor(bl ? color3 : color4);
        graphics.drawArc(n, n2, n3, n4, 225, 180);
        graphics.setColor(color2);
    }

    void draw3DRect(Graphics graphics, Color color, int n, int n2, int n3, int n4, boolean bl) {
        Color color2 = graphics.getColor();
        Color color3 = color.darker();
        Color color4 = color.brighter();
        graphics.setColor(bl ? color4 : color3);
        graphics.drawLine(n, n2, n, n2 + n4);
        graphics.drawLine(n + 1, n2, n + n3 - 1, n2);
        graphics.setColor(bl ? color3 : color4);
        graphics.drawLine(n + 1, n2 + n4, n + n3, n2 + n4);
        graphics.drawLine(n + n3, n2, n + n3, n2 + n4 - 1);
        graphics.setColor(color2);
    }

    void drawScrollbar(Graphics graphics, Color color, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        Color color2 = graphics.getColor();
        double d = (double)(n2 - 2 * (n - 1)) / (double)Math.max(1, n4 - n3 + n6);
        int n7 = n + (int)(d * (double)(n5 - n3));
        int n8 = (int)(d * (double)n6);
        int n9 = n - 4;
        int[] nArray = new int[3];
        int[] nArray2 = new int[3];
        if (n2 < 3 * n9) {
            n8 = 0;
            n7 = 0;
            if (n2 < 2 * n9 + 2) {
                n9 = (n2 - 2) / 2;
            }
        } else if (n8 < 7) {
            n7 = Math.max(0, n7 - (7 - n8 >> 1));
            n8 = 7;
        }
        int n10 = n / 2;
        int n11 = n10 - n9 / 2;
        int n12 = n10 + n9 / 2;
        Color color3 = new Color((int)((double)color.getRed() * 0.85), (int)((double)color.getGreen() * 0.85), (int)((double)color.getBlue() * 0.85));
        graphics.setColor(color3);
        if (bl) {
            graphics.fillRect(0, 0, n2, n);
        } else {
            graphics.fillRect(0, 0, n, n2);
        }
        graphics.setColor(color);
        if (n7 > 0) {
            if (bl) {
                graphics.fillRect(n7, 3, n8, n - 3);
            } else {
                graphics.fillRect(3, n7, n - 3, n8);
            }
        }
        nArray[0] = n10;
        nArray2[0] = 2;
        nArray[1] = n11;
        nArray2[1] = n9;
        nArray[2] = n12;
        nArray2[2] = n9;
        if (bl) {
            graphics.fillPolygon(nArray2, nArray, 3);
        } else {
            graphics.fillPolygon(nArray, nArray2, 3);
        }
        nArray2[0] = n2 - 2;
        nArray2[1] = n2 - n9;
        nArray2[2] = n2 - n9;
        if (bl) {
            graphics.fillPolygon(nArray2, nArray, 3);
        } else {
            graphics.fillPolygon(nArray, nArray2, 3);
        }
        color3 = color.brighter();
        graphics.setColor(color3);
        if (bl) {
            graphics.drawLine(1, n, n2 - 1, n);
            graphics.drawLine(n2 - 1, 1, n2 - 1, n);
            graphics.drawLine(1, n10, n9, n11);
            graphics.drawLine(n2 - n9, n11, n2 - n9, n12);
            graphics.drawLine(n2 - n9, n11, n2 - 2, n10);
        } else {
            graphics.drawLine(n, 1, n, n2 - 1);
            graphics.drawLine(1, n2 - 1, n, n2 - 1);
            graphics.drawLine(n10, 1, n11, n9);
            graphics.drawLine(n11, n2 - n9, n12, n2 - n9);
            graphics.drawLine(n11, n2 - n9, n10, n2 - 2);
        }
        if (n7 > 0) {
            if (bl) {
                graphics.drawLine(n7, 2, n7 + n8, 2);
                graphics.drawLine(n7, 2, n7, n - 3);
            } else {
                graphics.drawLine(2, n7, 2, n7 + n8);
                graphics.drawLine(2, n7, n - 3, n7);
            }
        }
        Color color4 = color.darker();
        graphics.setColor(color4);
        if (bl) {
            graphics.drawLine(0, 0, 0, n);
            graphics.drawLine(0, 0, n2 - 1, 0);
            graphics.drawLine(n9, n11, n9, n12);
            graphics.drawLine(n9, n12, 1, n10);
            graphics.drawLine(n2 - 2, n10, n2 - n9, n12);
        } else {
            graphics.drawLine(0, 0, n, 0);
            graphics.drawLine(0, 0, 0, n2 - 1);
            graphics.drawLine(n11, n9, n12, n9);
            graphics.drawLine(n12, n9, n10, 1);
            graphics.drawLine(n10, n2 - 2, n12, n2 - n9);
        }
        if (n7 > 0) {
            if (bl) {
                graphics.drawLine(n7 + n8, 2, n7 + n8, n - 2);
                graphics.drawLine(n7, n - 2, n7 + n8, n - 2);
            } else {
                graphics.drawLine(2, n7 + n8, n - 2, n7 + n8);
                graphics.drawLine(n - 2, n7, n - 2, n7 + n8);
            }
        }
        graphics.setColor(color2);
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.target + "]";
    }

    public void setVisible(boolean bl) {
        if (bl) {
            Dimension dimension = this.target.getSize();
            this.oldWidth = dimension.width;
            this.oldHeight = dimension.height;
            this.pShow();
        } else {
            this.pHide();
        }
    }

    public void setEnabled(boolean bl) {
        if (bl) {
            this.pEnable();
        } else {
            this.pDisable();
        }
    }

    public Point getLocationOnScreen() {
        Point point = this.pGetLocationOnScreen();
        Point point2 = this.target.getLocation();
        for (Container container = this.target.getParent(); container != null && container.getPeer() instanceof LightweightPeer; container = container.getParent()) {
            point2.translate(container.getLocation().x, container.getLocation().y);
        }
        if (!point.equals(point2) && this instanceof ContainerPeer) {
            int n = ((ContainerPeer)((Object)this)).getInsets().left;
            int n2 = ((ContainerPeer)((Object)this)).getInsets().top;
            Point point3 = new Point(point);
            point3.translate(n, n2);
            if (point3.equals(point2)) {
                point = point3;
            }
        }
        return point;
    }

    public boolean checkNativePaintOnSetBounds(int n, int n2) {
        return n != this.oldWidth || n2 != this.oldHeight;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        Object object;
        if (this.disposed) {
            return;
        }
        Container container = MComponentPeer.getParent_NoClientCode(this.target);
        if (container != null && container instanceof ScrollPane) {
            object = (MScrollPanePeer)container.getPeer();
            if (!((MScrollPanePeer)object).ignore) {
                this.pReshape(n, n2, n3, n4);
            }
        } else {
            this.pReshape(n, n2, n3, n4);
        }
        this.paintPending = false;
        if (container != null && container instanceof ScrollPane) {
            object = (MScrollPanePeer)container.getPeer();
            if (!((MScrollPanePeer)object).ignore) {
                this.pReshape(n, n2, n3, n4);
                ((MScrollPanePeer)object).childResized(n3, n4);
            }
        } else {
            this.pReshape(n, n2, n3, n4);
        }
        if (n3 != this.oldWidth || n4 != this.oldHeight) {
            object = this.surfaceData;
            if (object != null) {
                this.surfaceData = X11SurfaceData.createData(this);
                ((X11SurfaceData)object).invalidate();
            }
            this.oldWidth = n3;
            this.oldHeight = n4;
        }
        ++this.serialNum;
    }

    public void beginValidate() {
    }

    native void restoreFocus();

    public void endValidate() {
        this.restoreFocus();
    }

    public void beginLayout() {
        this.isLayouting = true;
    }

    public void endLayout() {
        if (!(this.paintPending || this.paintArea.isEmpty() || this.target.getIgnoreRepaint())) {
            this.postEvent(new PaintEvent(this.target, 800, new Rectangle()));
        }
        this.isLayouting = false;
    }

    public void show() {
        this.setVisible(true);
    }

    public void hide() {
        this.setVisible(false);
    }

    public void enable() {
        this.setEnabled(true);
    }

    public void disable() {
        this.setEnabled(false);
    }

    public void reshape(int n, int n2, int n3, int n4) {
        this.setBounds(n, n2, n3, n4);
    }

    public Dimension minimumSize() {
        return this.getMinimumSize();
    }

    public Dimension preferredSize() {
        return this.getPreferredSize();
    }

    public void addDropTarget(DropTarget dropTarget) {
        this.addNativeDropTarget(dropTarget);
    }

    public void removeDropTarget(DropTarget dropTarget) {
        this.removeNativeDropTarget(dropTarget);
    }

    public void notifyTextComponentChange(boolean bl) {
        Container container = MComponentPeer.getParent_NoClientCode(this.target);
        while (container != null && !(container instanceof Frame) && !(container instanceof Dialog)) {
            container = MComponentPeer.getParent_NoClientCode(container);
        }
        if (container instanceof Frame || container instanceof Dialog) {
            if (bl) {
                ((MInputMethodControl)((Object)container.getPeer())).addTextComponent(this);
            } else {
                ((MInputMethodControl)((Object)container.getPeer())).removeTextComponent(this);
            }
        }
    }

    native void addNativeDropTarget(DropTarget var1);

    native void removeNativeDropTarget(DropTarget var1);

    public GraphicsConfiguration getGraphicsConfiguration() {
        GraphicsConfiguration graphicsConfiguration = this.graphicsConfig;
        if (graphicsConfiguration == null) {
            graphicsConfiguration = this.target.getGraphicsConfiguration();
        }
        return graphicsConfiguration;
    }

    public boolean isPaintPending() {
        return this.paintPending && this.isLayouting;
    }

    public boolean handlesWheelScrolling() {
        return false;
    }

    private native long getWindow(long var1);

    private native long createBackBuffer(long var1, int var3);

    private native void destroyBackBuffer(long var1);

    private native void swapBuffers(long var1, int var3);

    public void createBuffers(int n, BufferCapabilities bufferCapabilities) throws AWTException {
        if (!X11GraphicsDevice.isDBESupported()) {
            throw new AWTException("Page flipping is not supported");
        }
        if (n > 2) {
            throw new AWTException("Only double or single buffering is supported");
        }
        BufferCapabilities bufferCapabilities2 = this.graphicsConfig.getBufferCapabilities();
        if (!bufferCapabilities2.isPageFlipping()) {
            throw new AWTException("Page flipping is not supported");
        }
        long l = this.getWindow(this.pData);
        int n2 = MComponentPeer.getSwapAction(bufferCapabilities.getFlipContents());
        this.backBuffer = this.createBackBuffer(l, n2);
        this.xBackBuffer = new X11VolatileImage(this.target, this.target.getWidth(), this.target.getHeight(), this.backBuffer);
    }

    public void flip(BufferCapabilities.FlipContents flipContents) {
        if (this.backBuffer == 0L) {
            throw new IllegalStateException("Buffers have not been created");
        }
        long l = this.getWindow(this.pData);
        int n = MComponentPeer.getSwapAction(flipContents);
        this.swapBuffers(l, n);
    }

    public Image getBackBuffer() {
        if (this.backBuffer == 0L) {
            throw new IllegalStateException("Buffers have not been created");
        }
        return this.xBackBuffer;
    }

    public void destroyBuffers() {
        this.destroyBackBuffer(this.backBuffer);
        this.backBuffer = 0L;
        this.xBackBuffer = null;
    }

    private static int getSwapAction(BufferCapabilities.FlipContents flipContents) {
        if (flipContents == BufferCapabilities.FlipContents.BACKGROUND) {
            return 1;
        }
        if (flipContents == BufferCapabilities.FlipContents.PRIOR) {
            return 2;
        }
        if (flipContents == BufferCapabilities.FlipContents.COPIED) {
            return 3;
        }
        return 0;
    }

    static {
        MComponentPeer.initIDs();
        defaultFont = new Font("Dialog", 0, 12);
    }
}

